/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage.index;

import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.shapes.GHPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class SnapTest {
    SnapTest() {
    }

    @Test
    void snapToCloseTower() {
        BaseGraph graph = new BaseGraph.Builder(1).create();
        EdgeIteratorState edge = graph.edge(0, 1);
        NodeAccess na = graph.getNodeAccess();
        na.setNode(0, 40.0, 6.0);
        na.setNode(1, 40.0, 6.000101);
        double queryLat = 40.001;
        double queryLon = 6.0001009;
        Snap snap = new Snap(queryLat, queryLon);
        snap.setClosestEdge(edge);
        snap.setClosestNode(edge.getBaseNode());
        snap.setWayIndex(0);
        snap.setSnappedPosition(Snap.Position.EDGE);
        GHPoint crossingPoint = DistancePlaneProjection.DIST_PLANE.calcCrossingPointToEdge(queryLat, queryLon, na.getLat(edge.getBaseNode()), na.getLon(edge.getBaseNode()), na.getLat(edge.getAdjNode()), na.getLon(edge.getAdjNode()));
        double distCrossingTo0 = DistancePlaneProjection.DIST_PLANE.calcDist(crossingPoint.lat, crossingPoint.lon, na.getLat(edge.getBaseNode()), na.getLon(edge.getBaseNode()));
        double distCrossingTo1 = DistancePlaneProjection.DIST_PLANE.calcDist(crossingPoint.lat, crossingPoint.lon, na.getLat(edge.getAdjNode()), na.getLon(edge.getAdjNode()));
        Assertions.assertEquals((double)8.594, (double)distCrossingTo0, (double)0.001);
        Assertions.assertEquals((double)0.008, (double)distCrossingTo1, (double)0.001);
        snap.calcSnappedPoint((DistanceCalc)DistancePlaneProjection.DIST_PLANE);
        Assertions.assertEquals((double)na.getLat(snap.getClosestNode()), (double)snap.getSnappedPoint().getLat());
        Assertions.assertEquals((double)na.getLon(snap.getClosestNode()), (double)snap.getSnappedPoint().getLon());
        Assertions.assertEquals((int)edge.getAdjNode(), (int)snap.getClosestNode());
    }
}

