/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.AngleCalc;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AngleCalcTest {
    private final AngleCalc AC = AngleCalc.ANGLE_CALC;

    @Test
    public void testOrientationExact() {
        Assertions.assertEquals((double)90.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, 1.0, 0.0)), (double)0.01);
        Assertions.assertEquals((double)45.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, 1.0, 1.0)), (double)0.01);
        Assertions.assertEquals((double)0.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, 0.0, 1.0)), (double)0.01);
        Assertions.assertEquals((double)-45.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, -1.0, 1.0)), (double)0.01);
        Assertions.assertEquals((double)-135.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, -1.0, -1.0)), (double)0.01);
        Assertions.assertEquals((double)57.24, (double)Math.toDegrees(this.AC.calcOrientation(49.942, 11.58, 49.944, 11.582)), (double)0.01);
        Assertions.assertEquals((double)-122.75999999999999, (double)Math.toDegrees(this.AC.calcOrientation(49.944, 11.582, 49.942, 11.58)), (double)0.01);
    }

    @Test
    public void testOrientationFast() {
        Assertions.assertEquals((double)90.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, 1.0, 0.0, false)), (double)0.01);
        Assertions.assertEquals((double)45.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, 1.0, 1.0, false)), (double)0.01);
        Assertions.assertEquals((double)0.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, 0.0, 1.0, false)), (double)0.01);
        Assertions.assertEquals((double)-45.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, -1.0, 1.0, false)), (double)0.01);
        Assertions.assertEquals((double)-135.0, (double)Math.toDegrees(this.AC.calcOrientation(0.0, 0.0, -1.0, -1.0, false)), (double)0.01);
        Assertions.assertEquals((double)57.08, (double)Math.toDegrees(this.AC.calcOrientation(49.942, 11.58, 49.944, 11.582, false)), (double)0.01);
        Assertions.assertEquals((double)-122.92, (double)Math.toDegrees(this.AC.calcOrientation(49.944, 11.582, 49.942, 11.58, false)), (double)0.01);
    }

    @Test
    public void testAlignOrientation() {
        Assertions.assertEquals((double)90.0, (double)Math.toDegrees(this.AC.alignOrientation(Math.toRadians(90.0), Math.toRadians(90.0))), (double)0.001);
        Assertions.assertEquals((double)225.0, (double)Math.toDegrees(this.AC.alignOrientation(Math.toRadians(90.0), Math.toRadians(-135.0))), (double)0.001);
        Assertions.assertEquals((double)-45.0, (double)Math.toDegrees(this.AC.alignOrientation(Math.toRadians(-135.0), Math.toRadians(-45.0))), (double)0.001);
        Assertions.assertEquals((double)-270.0, (double)Math.toDegrees(this.AC.alignOrientation(Math.toRadians(-135.0), Math.toRadians(90.0))), (double)0.001);
    }

    @Test
    public void testCombined() {
        double orientation = this.AC.calcOrientation(52.414918, 13.244221, 52.415333, 13.243595);
        Assertions.assertEquals((double)132.7, (double)Math.toDegrees(this.AC.alignOrientation(0.0, orientation)), (double)1.0);
        orientation = this.AC.calcOrientation(52.414918, 13.244221, 52.414573, 13.243627);
        Assertions.assertEquals((double)-136.38, (double)Math.toDegrees(this.AC.alignOrientation(0.0, orientation)), (double)1.0);
    }

    @Test
    public void testCalcAzimuth() {
        Assertions.assertEquals((double)45.0, (double)this.AC.calcAzimuth(0.0, 0.0, 1.0, 1.0), (double)0.001);
        Assertions.assertEquals((double)90.0, (double)this.AC.calcAzimuth(0.0, 0.0, 0.0, 1.0), (double)0.001);
        Assertions.assertEquals((double)180.0, (double)this.AC.calcAzimuth(0.0, 0.0, -1.0, 0.0), (double)0.001);
        Assertions.assertEquals((double)270.0, (double)this.AC.calcAzimuth(0.0, 0.0, 0.0, -1.0), (double)0.001);
        Assertions.assertEquals((double)0.0, (double)this.AC.calcAzimuth(49.942, 11.58, 49.944, 11.58), (double)0.001);
    }

    @Test
    public void testAzimuthCompassPoint() {
        Assertions.assertEquals((Object)"S", (Object)this.AC.azimuth2compassPoint(199.0));
    }

    @Test
    public void testAtan2() {
        Assertions.assertEquals((double)45.0, (double)(AngleCalc.atan2((double)5.0, (double)5.0) * 180.0 / Math.PI), (double)0.01);
        Assertions.assertEquals((double)-45.0, (double)(AngleCalc.atan2((double)-5.0, (double)5.0) * 180.0 / Math.PI), (double)0.01);
        Assertions.assertEquals((double)11.14, (double)(AngleCalc.atan2((double)1.0, (double)5.0) * 180.0 / Math.PI), (double)1.0);
        Assertions.assertEquals((double)180.0, (double)(AngleCalc.atan2((double)0.0, (double)-5.0) * 180.0 / Math.PI), (double)0.01);
        Assertions.assertEquals((double)-90.0, (double)(AngleCalc.atan2((double)-5.0, (double)0.0) * 180.0 / Math.PI), (double)0.01);
        Assertions.assertEquals((double)90.0, (double)(Math.atan2(1.0, 0.0) * 180.0 / Math.PI), (double)0.01);
        Assertions.assertEquals((double)90.0, (double)(AngleCalc.atan2((double)1.0, (double)0.0) * 180.0 / Math.PI), (double)0.01);
    }

    @Test
    public void testConvertAzimuth2xAxisAngle() {
        Assertions.assertEquals((double)1.5707963267948966, (double)this.AC.convertAzimuth2xaxisAngle(0.0), (double)1.0E-6);
        Assertions.assertEquals((double)1.5707963267948966, (double)Math.abs(this.AC.convertAzimuth2xaxisAngle(360.0)), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)this.AC.convertAzimuth2xaxisAngle(90.0), (double)1.0E-6);
        Assertions.assertEquals((double)-1.5707963267948966, (double)this.AC.convertAzimuth2xaxisAngle(180.0), (double)1.0E-6);
        Assertions.assertEquals((double)Math.PI, (double)Math.abs(this.AC.convertAzimuth2xaxisAngle(270.0)), (double)1.0E-6);
        Assertions.assertEquals((double)-2.356194490192345, (double)this.AC.convertAzimuth2xaxisAngle(225.0), (double)1.0E-6);
        Assertions.assertEquals((double)2.356194490192345, (double)this.AC.convertAzimuth2xaxisAngle(315.0), (double)1.0E-6);
    }

    @Test
    public void checkAzimuthConsistency() {
        double azimuthDegree = this.AC.calcAzimuth(0.0, 0.0, 1.0, 1.0);
        double radianXY = this.AC.calcOrientation(0.0, 0.0, 1.0, 1.0);
        double radian2 = this.AC.convertAzimuth2xaxisAngle(azimuthDegree);
        Assertions.assertEquals((double)radianXY, (double)radian2, (double)0.001);
        azimuthDegree = this.AC.calcAzimuth(0.0, 4.0, 1.0, 3.0);
        radianXY = this.AC.calcOrientation(0.0, 4.0, 1.0, 3.0);
        radian2 = this.AC.convertAzimuth2xaxisAngle(azimuthDegree);
        Assertions.assertEquals((double)radianXY, (double)radian2, (double)0.001);
    }

    @Test
    public void testIsClockwise() {
        Coordinate a = new Coordinate(0.1, 1.0);
        Coordinate b = new Coordinate(0.2, 0.8);
        Coordinate c = new Coordinate(0.6, 0.3);
        Assertions.assertTrue((boolean)this.isClockwise(a, b, c));
        Assertions.assertTrue((boolean)this.isClockwise(b, c, a));
        Assertions.assertTrue((boolean)this.isClockwise(c, a, b));
        Assertions.assertFalse((boolean)this.isClockwise(c, b, a));
        Assertions.assertFalse((boolean)this.isClockwise(a, c, b));
        Assertions.assertFalse((boolean)this.isClockwise(b, a, c));
    }

    private boolean isClockwise(Coordinate a, Coordinate b, Coordinate c) {
        return this.AC.isClockwise(a.x, a.y, b.x, b.y, c.x, c.y);
    }

    private static class Coordinate {
        final double x;
        final double y;

        Coordinate(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

