/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.graphhopper.util.ArrayUtil;
import java.util.Arrays;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArrayUtilTest {
    ArrayUtilTest() {
    }

    @Test
    public void testConstant() {
        IntArrayList list = ArrayUtil.constant((int)10, (int)3);
        Assertions.assertEquals((int)10, (int)list.size());
        Assertions.assertEquals((int)3, (int)list.get(5));
        Assertions.assertEquals((int)3, (int)list.get(9));
        Assertions.assertEquals((int)10, (int)list.buffer.length);
    }

    @Test
    public void testIota() {
        IntArrayList list = ArrayUtil.iota((int)15);
        Assertions.assertEquals((int)15, (int)list.buffer.length);
        Assertions.assertEquals((int)15, (int)list.elementsCount);
        Assertions.assertEquals((double)105.0, (double)Arrays.stream(list.buffer).sum());
    }

    @Test
    public void testRange() {
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3, 4, 5, 6}), (Object)ArrayUtil.range((int)3, (int)7));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{-3, -2}), (Object)ArrayUtil.range((int)-3, (int)-1));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)ArrayUtil.range((int)5, (int)5));
    }

    @Test
    public void testRangeClosed() {
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3, 4, 5, 6, 7}), (Object)ArrayUtil.rangeClosed((int)3, (int)7));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{-3, -2, -1}), (Object)ArrayUtil.rangeClosed((int)-3, (int)-1));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5}), (Object)ArrayUtil.rangeClosed((int)5, (int)5));
    }

    @Test
    public void testPermutation() {
        IntArrayList list = ArrayUtil.permutation((int)15, (Random)new Random());
        Assertions.assertEquals((int)15, (int)list.buffer.length);
        Assertions.assertEquals((int)15, (int)list.elementsCount);
        Assertions.assertEquals((double)105.0, (double)Arrays.stream(list.buffer).sum());
        Assertions.assertTrue((boolean)ArrayUtil.isPermutation((IntArrayList)list));
    }

    @Test
    public void testIsPermutation() {
        Assertions.assertTrue((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[0])));
        Assertions.assertTrue((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[]{0})));
        Assertions.assertTrue((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[]{0, 1})));
        Assertions.assertTrue((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[]{6, 2, 4, 0, 1, 3, 5})));
        Assertions.assertFalse((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[]{1, 2})));
        Assertions.assertFalse((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[]{-1})));
        Assertions.assertFalse((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[]{1})));
        Assertions.assertFalse((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[]{3, 4, 0, 1})));
        Assertions.assertFalse((boolean)ArrayUtil.isPermutation((IntArrayList)IntArrayList.from((int[])new int[]{0, 1, 3, 3, 4, 4, 6})));
    }

    @Test
    public void testReverse() {
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)ArrayUtil.reverse((IntArrayList)IntArrayList.from((int[])new int[0])));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1}), (Object)ArrayUtil.reverse((IntArrayList)IntArrayList.from((int[])new int[]{1})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{9, 5}), (Object)ArrayUtil.reverse((IntArrayList)IntArrayList.from((int[])new int[]{5, 9})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{7, 1, 3}), (Object)ArrayUtil.reverse((IntArrayList)IntArrayList.from((int[])new int[]{3, 1, 7})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 3, 2, 1}), (Object)ArrayUtil.reverse((IntArrayList)IntArrayList.from((int[])new int[]{1, 2, 3, 4})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 4, 3, 2, 1}), (Object)ArrayUtil.reverse((IntArrayList)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5})));
    }

    @Test
    public void testShuffle() {
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 1, 3, 2}), (Object)ArrayUtil.shuffle((IntArrayList)IntArrayList.from((int[])new int[]{1, 2, 3, 4}), (Random)new Random(0L)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 3, 2, 1, 5}), (Object)ArrayUtil.shuffle((IntArrayList)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5}), (Random)new Random(1L)));
    }

    @Test
    public void removeConsecutiveDuplicates() {
        int[] arr = new int[]{3, 3, 4, 2, 1, -3, -3, 9, 3, 6, 6, 7, 7};
        Assertions.assertEquals((int)9, (int)ArrayUtil.removeConsecutiveDuplicates((int[])arr, (int)arr.length));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3, 4, 2, 1, -3, 9, 3, 6, 7, 6, 6, 7, 7}), (Object)IntArrayList.from((int[])arr));
        int[] brr = new int[]{4, 4, 3, 5, 3};
        Assertions.assertEquals((int)2, (int)ArrayUtil.removeConsecutiveDuplicates((int[])brr, (int)3));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 3, 3, 5, 3}), (Object)IntArrayList.from((int[])brr));
    }

    @Test
    public void removeConsecutiveDuplicates_empty() {
        int[] arr = new int[]{};
        Assertions.assertEquals((int)0, (int)ArrayUtil.removeConsecutiveDuplicates((int[])arr, (int)arr.length));
        arr = new int[]{3};
        Assertions.assertEquals((int)1, (int)ArrayUtil.removeConsecutiveDuplicates((int[])arr, (int)arr.length));
        Assertions.assertEquals((int)0, (int)ArrayUtil.removeConsecutiveDuplicates((int[])arr, (int)0));
    }

    @Test
    public void testWithoutConsecutiveDuplicates() {
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)ArrayUtil.withoutConsecutiveDuplicates((IntIndexedContainer)IntArrayList.from((int[])new int[0])));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1}), (Object)ArrayUtil.withoutConsecutiveDuplicates((IntIndexedContainer)IntArrayList.from((int[])new int[]{1})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1}), (Object)ArrayUtil.withoutConsecutiveDuplicates((IntIndexedContainer)IntArrayList.from((int[])new int[]{1, 1})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1}), (Object)ArrayUtil.withoutConsecutiveDuplicates((IntIndexedContainer)IntArrayList.from((int[])new int[]{1, 1, 1})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2}), (Object)ArrayUtil.withoutConsecutiveDuplicates((IntIndexedContainer)IntArrayList.from((int[])new int[]{1, 1, 2})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 1}), (Object)ArrayUtil.withoutConsecutiveDuplicates((IntIndexedContainer)IntArrayList.from((int[])new int[]{1, 2, 1})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 5, 8, 9, 11, 2, -1, 3}), (Object)ArrayUtil.withoutConsecutiveDuplicates((IntIndexedContainer)IntArrayList.from((int[])new int[]{5, 5, 5, 6, 6, 5, 5, 8, 9, 11, 11, 2, 2, -1, 3, 3})));
    }

    @Test
    public void testTransform() {
        IntArrayList arr = IntArrayList.from((int[])new int[]{7, 6, 2});
        ArrayUtil.transform((IntIndexedContainer)arr, (IntIndexedContainer)ArrayUtil.constant((int)8, (int)4));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 4, 4}), (Object)arr);
        IntArrayList brr = IntArrayList.from((int[])new int[]{3, 0, 1});
        ArrayUtil.transform((IntIndexedContainer)brr, (IntIndexedContainer)IntArrayList.from((int[])new int[]{6, 2, 1, 5}));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{5, 6, 2}), (Object)brr);
    }

    @Test
    public void testCalcSortOrder() {
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((IntArrayList)IntArrayList.from((int[])new int[0]), (IntArrayList)IntArrayList.from((int[])new int[0]))));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0}), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((IntArrayList)IntArrayList.from((int[])new int[]{3}), (IntArrayList)IntArrayList.from((int[])new int[]{4}))));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 2, 3, 1}), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((IntArrayList)IntArrayList.from((int[])new int[]{3, 6, 3, 4}), (IntArrayList)IntArrayList.from((int[])new int[]{0, -1, 2, -6}))));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 3, 1, 0}), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((IntArrayList)IntArrayList.from((int[])new int[]{3, 3, 0, 0}), (IntArrayList)IntArrayList.from((int[])new int[]{0, -1, 1, 2}))));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[0]), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((int[])new int[]{3, 3, 0, 0}, (int[])new int[]{0, -1, 1, 2}, (int)0)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0}), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((int[])new int[]{3, 3, 0, 0}, (int[])new int[]{0, -1, 1, 2}, (int)1)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 0}), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((int[])new int[]{3, 3, 0, 0}, (int[])new int[]{0, -1, 1, 2}, (int)2)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 1, 0}), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((int[])new int[]{3, 3, 0, 0}, (int[])new int[]{0, -1, 1, 2}, (int)3)));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 3, 1, 0}), (Object)IntArrayList.from((int[])ArrayUtil.calcSortOrder((int[])new int[]{3, 3, 0, 0}, (int[])new int[]{0, -1, 1, 2}, (int)4)));
    }

    @Test
    public void testApplyOrder() {
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{0, 6, 3, 1, 4}), (Object)IntArrayList.from((int[])ArrayUtil.applyOrder((int[])new int[]{3, 4, 6, 0, 1}, (int[])new int[]{3, 2, 0, 4, 1})));
    }

    @Test
    public void testInvert() {
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{-1, -1, -1, 3}), (Object)IntArrayList.from((int[])ArrayUtil.invert((int[])new int[]{3, 3, 3, 3})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3, 2, 0, 1}), (Object)IntArrayList.from((int[])ArrayUtil.invert((int[])new int[]{2, 3, 1, 0})));
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 3, 1, 0}), (Object)IntArrayList.from((int[])ArrayUtil.invert((int[])new int[]{3, 2, 0, 1})));
    }

    @Test
    public void testMerge() {
        Assertions.assertArrayEquals((int[])new int[0], (int[])ArrayUtil.merge((int[])new int[0], (int[])new int[0]));
        Assertions.assertArrayEquals((int[])new int[]{4, 5}, (int[])ArrayUtil.merge((int[])new int[0], (int[])new int[]{4, 5}));
        Assertions.assertArrayEquals((int[])new int[]{4, 5}, (int[])ArrayUtil.merge((int[])new int[]{4, 5}, (int[])new int[0]));
        Assertions.assertArrayEquals((int[])new int[]{3, 6, 9}, (int[])ArrayUtil.merge((int[])new int[]{6, 6, 6, 9}, (int[])new int[]{3, 9}));
        int[] a = new int[]{2, 6, 8, 12, 15};
        int[] b = new int[]{3, 7, 9, 10, 11, 12, 15, 20, 21, 26};
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{2, 3, 6, 7, 8, 9, 10, 11, 12, 15, 20, 21, 26}), (Object)IntArrayList.from((int[])ArrayUtil.merge((int[])a, (int[])b)));
    }
}

