/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.BitUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BitUtilTest {
    private static final BitUtil bitUtil = BitUtil.LITTLE;

    @Test
    public void testToBitString() {
        Assertions.assertEquals((Object)"0010101010101010101010101010101010101010101010101010101010101010", (Object)bitUtil.toBitString(0x2AAAAAAAAAAAAAAAL));
        Assertions.assertEquals((Object)"0111111111111111111111111111111111111111111111111111111111111111", (Object)bitUtil.toBitString(Long.MAX_VALUE));
        Assertions.assertEquals((Object)"00101010101010101010101010101010", (Object)bitUtil.toBitString(bitUtil.fromInt(0x2AAAAAAA)));
        Assertions.assertEquals((Object)"10000000000000000000000000000000", (Object)bitUtil.toBitString(Long.MIN_VALUE, 32));
        Assertions.assertEquals((Object)"00000000000000000000000000000001", (Object)bitUtil.toBitString(0x100000000L, 32));
    }

    @Test
    public void testFromBitString() {
        String str = "001110110";
        Assertions.assertEquals((Object)(str + "0000000"), (Object)bitUtil.toBitString(bitUtil.fromBitString(str)));
        str = "01011110010111000000111111000111";
        Assertions.assertEquals((Object)str, (Object)bitUtil.toBitString(bitUtil.fromBitString(str)));
        str = "0101111001011100000011111100011";
        Assertions.assertEquals((Object)(str + "0"), (Object)bitUtil.toBitString(bitUtil.fromBitString(str)));
    }

    @Test
    public void testCountBitValue() {
        Assertions.assertEquals((int)1, (int)BitUtil.countBitValue((int)1));
        Assertions.assertEquals((int)2, (int)BitUtil.countBitValue((int)2));
        Assertions.assertEquals((int)2, (int)BitUtil.countBitValue((int)3));
        Assertions.assertEquals((int)3, (int)BitUtil.countBitValue((int)4));
        Assertions.assertEquals((int)3, (int)BitUtil.countBitValue((int)7));
        Assertions.assertEquals((int)4, (int)BitUtil.countBitValue((int)8));
        Assertions.assertEquals((int)5, (int)BitUtil.countBitValue((int)20));
    }

    @Test
    public void testUnsignedConversions() {
        long l = Integer.toUnsignedLong(-1);
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)l);
        Assertions.assertEquals((int)-1, (int)BitUtil.toSignedInt((long)l));
        int intVal = Integer.MAX_VALUE;
        long maxInt = intVal;
        Assertions.assertEquals((int)intVal, (int)BitUtil.toSignedInt((long)maxInt));
        maxInt = Integer.toUnsignedLong(++intVal);
        Assertions.assertEquals((int)intVal, (int)BitUtil.toSignedInt((long)maxInt));
        maxInt = Integer.toUnsignedLong(++intVal);
        Assertions.assertEquals((int)intVal, (int)BitUtil.toSignedInt((long)maxInt));
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)0xFFFFFFFFL);
        Assertions.assertTrue((boolean)true);
    }

    @Test
    public void testToFloat() {
        byte[] bytes = bitUtil.fromFloat(Float.MAX_VALUE);
        Assertions.assertEquals((double)3.4028234663852886E38, (double)bitUtil.toFloat(bytes), (double)1.0E-9);
        bytes = bitUtil.fromFloat(1.1342745E38f);
        Assertions.assertEquals((double)1.1342744887950962E38, (double)bitUtil.toFloat(bytes), (double)1.0E-9);
    }

    @Test
    public void testToDouble() {
        byte[] bytes = bitUtil.fromDouble(Double.MAX_VALUE);
        Assertions.assertEquals((double)Double.MAX_VALUE, (double)bitUtil.toDouble(bytes), (double)1.0E-9);
        bytes = bitUtil.fromDouble(5.992310449541053E307);
        Assertions.assertEquals((double)5.992310449541053E307, (double)bitUtil.toDouble(bytes), (double)1.0E-9);
    }

    @Test
    public void testToInt() {
        byte[] bytes = bitUtil.fromInt(Integer.MAX_VALUE);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)bitUtil.toInt(bytes));
        bytes = bitUtil.fromInt(0x2AAAAAAA);
        Assertions.assertEquals((int)0x2AAAAAAA, (int)bitUtil.toInt(bytes));
    }

    @Test
    public void testToShort() {
        byte[] bytes = bitUtil.fromShort((short)Short.MAX_VALUE);
        Assertions.assertEquals((short)Short.MAX_VALUE, (short)bitUtil.toShort(bytes));
        bytes = bitUtil.fromShort((short)10922);
        Assertions.assertEquals((int)10922, (int)bitUtil.toShort(bytes));
        bytes = bitUtil.fromShort((short)-123);
        Assertions.assertEquals((int)-123, (int)bitUtil.toShort(bytes));
        bytes = bitUtil.fromShort((short)255);
        Assertions.assertEquals((int)255, (int)bitUtil.toShort(bytes));
    }

    @Test
    public void testToLong() {
        byte[] bytes = bitUtil.fromLong(Long.MAX_VALUE);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)bitUtil.toLong(bytes));
        bytes = bitUtil.fromLong(1317624576693539401L);
        Assertions.assertEquals((long)1317624576693539401L, (long)bitUtil.toLong(bytes));
    }

    @Test
    public void testIntsToLong() {
        int high = 2565;
        int low = 9421;
        long l = bitUtil.toLong(low, high);
        Assertions.assertEquals((int)high, (int)bitUtil.getIntHigh(l));
        Assertions.assertEquals((int)low, (int)bitUtil.getIntLow(l));
    }

    @Test
    public void testToLastBitString() {
        Assertions.assertEquals((Object)"1", (Object)bitUtil.toLastBitString(1L, 1));
        Assertions.assertEquals((Object)"01", (Object)bitUtil.toLastBitString(1L, 2));
        Assertions.assertEquals((Object)"001", (Object)bitUtil.toLastBitString(1L, 3));
        Assertions.assertEquals((Object)"010", (Object)bitUtil.toLastBitString(2L, 3));
        Assertions.assertEquals((Object)"011", (Object)bitUtil.toLastBitString(3L, 3));
    }

    @Test
    public void testUInt3() {
        byte[] bytes = new byte[3];
        bitUtil.fromUInt3(bytes, 12345678, 0);
        Assertions.assertEquals((int)12345678, (int)bitUtil.toUInt3(bytes, 0));
        bytes = new byte[3];
        bitUtil.fromUInt3(bytes, -12345678, 0);
        Assertions.assertEquals((int)4431538, (int)bitUtil.toUInt3(bytes, 0));
    }
}

