/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.coll.GHTBitSet;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.BreadthFirstSearch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BreadthFirstSearchTest {
    int counter;
    GHIntHashSet set = new GHIntHashSet();
    IntArrayList list = new IntArrayList();

    @BeforeEach
    public void setup() {
        this.counter = 0;
    }

    @Test
    public void testBFS() {
        BreadthFirstSearch bfs = new BreadthFirstSearch(){

            protected GHBitSet createBitSet() {
                return new GHTBitSet();
            }

            public boolean goFurther(int v) {
                ++BreadthFirstSearchTest.this.counter;
                Assertions.assertFalse((boolean)BreadthFirstSearchTest.this.set.contains(v), (String)("v " + v + " is already contained in set. iteration:" + BreadthFirstSearchTest.this.counter));
                BreadthFirstSearchTest.this.set.add(v);
                BreadthFirstSearchTest.this.list.add(v);
                return super.goFurther(v);
            }
        };
        BaseGraph g = new BaseGraph.Builder(1).create();
        g.edge(0, 1);
        g.edge(0, 2);
        g.edge(0, 3);
        g.edge(0, 5);
        g.edge(1, 6);
        g.edge(2, 7);
        g.edge(3, 8);
        g.edge(4, 8);
        g.edge(8, 10);
        g.edge(6, 9);
        g.edge(9, 10);
        g.edge(5, 10);
        bfs.start(g.createEdgeExplorer(), 0);
        Assertions.assertTrue((this.counter > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)g.getNodes(), (int)this.counter);
        Assertions.assertEquals((Object)"[0, 5, 3, 2, 1, 10, 8, 7, 6, 9, 4]", (Object)this.list.toString());
    }

    @Test
    public void testBFS2() {
        BreadthFirstSearch bfs = new BreadthFirstSearch(){

            protected GHBitSet createBitSet() {
                return new GHTBitSet();
            }

            public boolean goFurther(int v) {
                ++BreadthFirstSearchTest.this.counter;
                Assertions.assertFalse((boolean)BreadthFirstSearchTest.this.set.contains(v), (String)("v " + v + " is already contained in set. iteration:" + BreadthFirstSearchTest.this.counter));
                BreadthFirstSearchTest.this.set.add(v);
                BreadthFirstSearchTest.this.list.add(v);
                return super.goFurther(v);
            }
        };
        BaseGraph g = new BaseGraph.Builder(1).create();
        g.edge(1, 2);
        g.edge(2, 3);
        g.edge(3, 4);
        g.edge(1, 5);
        g.edge(5, 6);
        g.edge(6, 4);
        bfs.start(g.createEdgeExplorer(), 1);
        Assertions.assertTrue((this.counter > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"[1, 5, 2, 6, 3, 4]", (Object)this.list.toString());
    }
}

