/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.coll.GHBitSet;
import com.graphhopper.coll.GHBitSetImpl;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.DepthFirstSearch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DepthFirstSearchTest {
    int counter;
    GHIntHashSet set = new GHIntHashSet();
    IntArrayList list = new IntArrayList();

    @BeforeEach
    public void setup() {
        this.counter = 0;
    }

    @Test
    public void testDFS1() {
        DepthFirstSearch dfs = new DepthFirstSearch(){

            protected GHBitSet createBitSet() {
                return new GHBitSetImpl();
            }

            public boolean goFurther(int v) {
                ++DepthFirstSearchTest.this.counter;
                Assertions.assertTrue((!DepthFirstSearchTest.this.set.contains(v) ? 1 : 0) != 0, (String)("v " + v + " is already contained in set. iteration:" + DepthFirstSearchTest.this.counter));
                DepthFirstSearchTest.this.set.add(v);
                DepthFirstSearchTest.this.list.add(v);
                return super.goFurther(v);
            }
        };
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        EncodedValue.InitializerConfig evConf = new EncodedValue.InitializerConfig();
        accessEnc.init(evConf);
        BaseGraph g = new BaseGraph.Builder(evConf.getRequiredBytes()).create();
        g.edge(1, 2).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(1, 5).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(1, 4).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(2, 3).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(3, 4).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(5, 6).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(6, 4).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        dfs.start(g.createEdgeExplorer((EdgeFilter)AccessFilter.outEdges((BooleanEncodedValue)accessEnc)), 1);
        Assertions.assertTrue((this.counter > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)this.list.toString(), (Object)"[1, 2, 3, 4, 5, 6]");
    }

    @Test
    public void testDFS2() {
        DepthFirstSearch dfs = new DepthFirstSearch(){

            protected GHBitSet createBitSet() {
                return new GHBitSetImpl();
            }

            public boolean goFurther(int v) {
                ++DepthFirstSearchTest.this.counter;
                Assertions.assertTrue((!DepthFirstSearchTest.this.set.contains(v) ? 1 : 0) != 0, (String)("v " + v + " is already contained in set. iteration:" + DepthFirstSearchTest.this.counter));
                DepthFirstSearchTest.this.set.add(v);
                DepthFirstSearchTest.this.list.add(v);
                return super.goFurther(v);
            }
        };
        SimpleBooleanEncodedValue accessEnc = new SimpleBooleanEncodedValue("access", true);
        EncodedValue.InitializerConfig evConf = new EncodedValue.InitializerConfig();
        accessEnc.init(evConf);
        BaseGraph g = new BaseGraph.Builder(evConf.getRequiredBytes()).create();
        g.edge(1, 2).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(1, 4).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, true);
        g.edge(1, 3).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(2, 3).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, false);
        g.edge(4, 3).setDistance(1.0).set((BooleanEncodedValue)accessEnc, true, true);
        dfs.start(g.createEdgeExplorer((EdgeFilter)AccessFilter.outEdges((BooleanEncodedValue)accessEnc)), 1);
        Assertions.assertTrue((this.counter > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)this.list.toString(), (Object)"[1, 2, 3, 4]");
    }
}

