/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalc;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.shapes.GHPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DistanceCalcEarthTest {
    private DistanceCalc dc = new DistanceCalcEarth();

    @Test
    public void testCalcCircumference() {
        Assertions.assertEquals((double)4.003017359204114E7, (double)this.dc.calcCircumference(0.0), (double)1.0E-7);
    }

    @Test
    public void testDistance() {
        float lat = 24.235f;
        float lon = 47.234f;
        DistancePlaneProjection approxDist = new DistancePlaneProjection();
        double res = 15051.0;
        Assertions.assertEquals((double)res, (double)this.dc.calcDist((double)lat, (double)lon, (double)lat - 0.1, (double)lon + 0.1), (double)1.0);
        Assertions.assertEquals((double)this.dc.calcNormalizedDist(res), (double)this.dc.calcNormalizedDist((double)lat, (double)lon, (double)lat - 0.1, (double)lon + 0.1), (double)1.0);
        Assertions.assertEquals((double)res, (double)approxDist.calcDist((double)lat, (double)lon, (double)lat - 0.1, (double)lon + 0.1), (double)1.0);
        res = 15046.0;
        Assertions.assertEquals((double)res, (double)this.dc.calcDist((double)lat, (double)lon, (double)lat + 0.1, (double)lon - 0.1), (double)1.0);
        Assertions.assertEquals((double)this.dc.calcNormalizedDist(res), (double)this.dc.calcNormalizedDist((double)lat, (double)lon, (double)lat + 0.1, (double)lon - 0.1), (double)1.0);
        Assertions.assertEquals((double)res, (double)approxDist.calcDist((double)lat, (double)lon, (double)lat + 0.1, (double)lon - 0.1), (double)1.0);
        res = 150748.0;
        Assertions.assertEquals((double)res, (double)this.dc.calcDist((double)lat, (double)lon, (double)(lat - 1.0f), (double)(lon + 1.0f)), (double)1.0);
        Assertions.assertEquals((double)this.dc.calcNormalizedDist(res), (double)this.dc.calcNormalizedDist((double)lat, (double)lon, (double)(lat - 1.0f), (double)(lon + 1.0f)), (double)1.0);
        Assertions.assertEquals((double)res, (double)approxDist.calcDist((double)lat, (double)lon, (double)(lat - 1.0f), (double)(lon + 1.0f)), (double)10.0);
        res = 150211.0;
        Assertions.assertEquals((double)res, (double)this.dc.calcDist((double)lat, (double)lon, (double)(lat + 1.0f), (double)(lon - 1.0f)), (double)1.0);
        Assertions.assertEquals((double)this.dc.calcNormalizedDist(res), (double)this.dc.calcNormalizedDist((double)lat, (double)lon, (double)(lat + 1.0f), (double)(lon - 1.0f)), (double)1.0);
        Assertions.assertEquals((double)res, (double)approxDist.calcDist((double)lat, (double)lon, (double)(lat + 1.0f), (double)(lon - 1.0f)), (double)10.0);
        res = 1527919.0;
        Assertions.assertEquals((double)res, (double)this.dc.calcDist((double)lat, (double)lon, (double)(lat - 10.0f), (double)(lon + 10.0f)), (double)1.0);
        Assertions.assertEquals((double)this.dc.calcNormalizedDist(res), (double)this.dc.calcNormalizedDist((double)lat, (double)lon, (double)(lat - 10.0f), (double)(lon + 10.0f)), (double)1.0);
        Assertions.assertEquals((double)res, (double)approxDist.calcDist((double)lat, (double)lon, (double)(lat - 10.0f), (double)(lon + 10.0f)), (double)10000.0);
        res = 1474016.0;
        Assertions.assertEquals((double)res, (double)this.dc.calcDist((double)lat, (double)lon, (double)(lat + 10.0f), (double)(lon - 10.0f)), (double)1.0);
        Assertions.assertEquals((double)this.dc.calcNormalizedDist(res), (double)this.dc.calcNormalizedDist((double)lat, (double)lon, (double)(lat + 10.0f), (double)(lon - 10.0f)), (double)1.0);
        Assertions.assertEquals((double)res, (double)approxDist.calcDist((double)lat, (double)lon, (double)(lat + 10.0f), (double)(lon - 10.0f)), (double)10000.0);
        res = 1013735.28;
        Assertions.assertEquals((double)res, (double)this.dc.calcDist((double)lat, (double)lon, (double)lat, (double)(lon - 10.0f)), (double)1.0);
        Assertions.assertEquals((double)this.dc.calcNormalizedDist(res), (double)this.dc.calcNormalizedDist((double)lat, (double)lon, (double)lat, (double)(lon - 10.0f)), (double)1.0);
        Assertions.assertEquals((double)res, (double)approxDist.calcDist((double)lat, (double)lon, (double)lat, (double)(lon - 10.0f)), (double)1000.0);
        res = 1111949.3;
        Assertions.assertEquals((double)res, (double)this.dc.calcDist((double)lat, (double)lon, (double)(lat + 10.0f), (double)lon), (double)1.0);
        Assertions.assertEquals((double)this.dc.calcNormalizedDist(res), (double)this.dc.calcNormalizedDist((double)lat, (double)lon, (double)(lat + 10.0f), (double)lon), (double)1.0);
        Assertions.assertEquals((double)res, (double)approxDist.calcDist((double)lat, (double)lon, (double)(lat + 10.0f), (double)lon), (double)1.0);
    }

    @Test
    public void testEdgeDistance() {
        double dist = this.dc.calcNormalizedEdgeDistance(49.94241, 11.544356, 49.937964, 11.541824, 49.942272, 11.555643);
        double expectedDist = this.dc.calcNormalizedDist(49.94241, 11.544356, 49.9394, 11.54681);
        Assertions.assertEquals((double)expectedDist, (double)dist, (double)1.0E-4);
        dist = this.dc.calcNormalizedEdgeDistance(49.936299, 11.543992, 49.9357, 11.543047, 49.9357, 11.549227);
        expectedDist = this.dc.calcNormalizedDist(49.936299, 11.543992, 49.9357, 11.543992);
        Assertions.assertEquals((double)expectedDist, (double)dist, (double)1.0E-4);
    }

    @Test
    public void testEdgeDistance3d() {
        double dist = this.dc.calcNormalizedEdgeDistance3D(49.94241, 11.544356, 0.0, 49.937964, 11.541824, 0.0, 49.942272, 11.555643, 0.0);
        double expectedDist = this.dc.calcNormalizedDist(49.94241, 11.544356, 49.9394, 11.54681);
        Assertions.assertEquals((double)expectedDist, (double)dist, (double)1.0E-4);
        dist = this.dc.calcNormalizedEdgeDistance3D(49.936299, 11.543992, 0.0, 49.9357, 11.543047, 0.0, 49.9357, 11.549227, 0.0);
        expectedDist = this.dc.calcNormalizedDist(49.936299, 11.543992, 49.9357, 11.543992);
        Assertions.assertEquals((double)expectedDist, (double)dist, (double)1.0E-4);
    }

    @Test
    public void testEdgeDistance3dEarth() {
        double dist = this.dc.calcNormalizedEdgeDistance3D(0.0, 0.5, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        Assertions.assertEquals((double)10.0, (double)this.dc.calcDenormalizedDist(dist), (double)1.0E-4);
    }

    @Test
    public void testEdgeDistance3dEarthNaN() {
        double dist = this.dc.calcNormalizedEdgeDistance3D(0.0, 0.5, Double.NaN, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        Assertions.assertEquals((double)0.0, (double)this.dc.calcDenormalizedDist(dist), (double)1.0E-4);
    }

    @Test
    public void testEdgeDistance3dPlane() {
        DistancePlaneProjection calc = new DistancePlaneProjection();
        double dist = calc.calcNormalizedEdgeDistance3D(0.0, 0.5, 10.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
        Assertions.assertEquals((double)10.0, (double)calc.calcDenormalizedDist(dist), (double)1.0E-4);
    }

    @Test
    public void testEdgeDistanceStartEndSame() {
        DistancePlaneProjection calc = new DistancePlaneProjection();
        double dist = calc.calcNormalizedEdgeDistance3D(0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertEquals((double)10.0, (double)calc.calcDenormalizedDist(dist), (double)1.0E-4);
        dist = calc.calcNormalizedEdgeDistance3D(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertEquals((double)111194.92664455873, (double)calc.calcDenormalizedDist(dist), (double)1.0E-4);
        dist = calc.calcNormalizedEdgeDistance3D(0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertEquals((double)111194.92664455873, (double)calc.calcDenormalizedDist(dist), (double)1.0E-4);
    }

    @Test
    public void testEdgeDistanceStartEndDifferentElevation() {
        DistancePlaneProjection calc = new DistancePlaneProjection();
        double dist = calc.calcNormalizedEdgeDistance3D(0.0, 0.0, 10.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertEquals((double)0.0, (double)calc.calcDenormalizedDist(dist), (double)1.0E-4);
        dist = calc.calcNormalizedEdgeDistance3D(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertEquals((double)111194.92664455873, (double)calc.calcDenormalizedDist(dist), (double)1.0E-4);
        dist = calc.calcNormalizedEdgeDistance3D(0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0);
        Assertions.assertEquals((double)111194.92664455873, (double)calc.calcDenormalizedDist(dist), (double)1.0E-4);
    }

    @Test
    public void testValidEdgeDistance() {
        Assertions.assertTrue((boolean)this.dc.validEdgeDistance(49.94241, 11.544356, 49.937964, 11.541824, 49.942272, 11.555643));
        Assertions.assertTrue((boolean)this.dc.validEdgeDistance(49.936624, 11.547636, 49.937964, 11.541824, 49.942272, 11.555643));
        Assertions.assertTrue((boolean)this.dc.validEdgeDistance(49.940712, 11.556069, 49.937964, 11.541824, 49.942272, 11.555643));
        Assertions.assertFalse((boolean)this.dc.validEdgeDistance(49.935119, 11.541649, 49.937964, 11.541824, 49.942272, 11.555643));
        Assertions.assertFalse((boolean)this.dc.validEdgeDistance(49.939317, 11.539675, 49.937964, 11.541824, 49.942272, 11.555643));
        Assertions.assertFalse((boolean)this.dc.validEdgeDistance(49.944482, 11.555446, 49.937964, 11.541824, 49.942272, 11.555643));
        Assertions.assertFalse((boolean)this.dc.validEdgeDistance(49.94085, 11.557356, 49.937964, 11.541824, 49.942272, 11.555643));
    }

    @Test
    public void testPrecisionBug() {
        DistancePlaneProjection dist = new DistancePlaneProjection();
        double queryLat = 42.56819;
        double queryLon = 1.603231;
        double lat16 = 42.56674481705006;
        double lon16 = 1.6023790821964834;
        double lat17 = 42.56694505140808;
        double lon17 = 1.6020622462495173;
        double lat18 = 42.56715199128878;
        double lon18 = 1.601682266630581;
        Assertions.assertEquals((double)171.487, (double)dist.calcDist(queryLat, queryLon, lat18, lon18), (double)0.001);
        Assertions.assertEquals((double)168.298, (double)dist.calcDist(queryLat, queryLon, lat17, lon17), (double)0.001);
        Assertions.assertEquals((double)175.188, (double)dist.calcDist(queryLat, queryLon, lat16, lon16), (double)0.001);
        Assertions.assertEquals((double)167.385, (double)dist.calcDenormalizedDist(dist.calcNormalizedEdgeDistance(queryLat, queryLon, lat16, lon16, lat17, lon17)), (double)0.001);
        Assertions.assertEquals((double)168.213, (double)dist.calcDenormalizedDist(dist.calcNormalizedEdgeDistance(queryLat, queryLon, lat17, lon17, lat18, lon18)), (double)0.001);
        Assertions.assertEquals((Object)new GHPoint(42.567048, 1.6019), (Object)dist.calcCrossingPointToEdge(queryLat, queryLon, lat16, lon16, lat17, lon17));
    }

    @Test
    public void testPrecisionBug2() {
        DistancePlaneProjection distCalc = new DistancePlaneProjection();
        double queryLat = 55.818994;
        double queryLon = 37.595354;
        double tmpLat = 55.81777239183573;
        double tmpLon = 37.59598350366913;
        double wayLat = 55.818839128736535;
        double wayLon = 37.5942968784488;
        Assertions.assertEquals((double)68.25, (double)distCalc.calcDist(wayLat, wayLon, queryLat, queryLon), (double)0.1);
        Assertions.assertEquals((double)60.88, (double)distCalc.calcDenormalizedDist(distCalc.calcNormalizedEdgeDistance(queryLat, queryLon, tmpLat, tmpLon, wayLat, wayLon)), (double)0.1);
        Assertions.assertEquals((Object)new GHPoint(55.81863, 37.594626), (Object)distCalc.calcCrossingPointToEdge(queryLat, queryLon, tmpLat, tmpLon, wayLat, wayLon));
    }

    @Test
    public void testDistance3dEarth() {
        DistanceCalcEarth distCalc = new DistanceCalcEarth();
        Assertions.assertEquals((double)1.0, (double)distCalc.calcDist3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0), (double)1.0E-6);
    }

    @Test
    public void testDistance3dEarthNaN() {
        DistanceCalcEarth distCalc = new DistanceCalcEarth();
        Assertions.assertEquals((double)0.0, (double)distCalc.calcDist3D(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)distCalc.calcDist3D(0.0, 0.0, Double.NaN, 0.0, 0.0, 10.0), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)distCalc.calcDist3D(0.0, 0.0, Double.NaN, 0.0, 0.0, Double.NaN), (double)1.0E-6);
    }

    @Test
    public void testDistance3dPlane() {
        DistancePlaneProjection distCalc = new DistancePlaneProjection();
        Assertions.assertEquals((double)1.0, (double)distCalc.calcDist3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0), (double)1.0E-6);
        Assertions.assertEquals((double)10.0, (double)distCalc.calcDist3D(0.0, 0.0, 0.0, 0.0, 0.0, 10.0), (double)1.0E-6);
    }

    @Test
    public void testDistance3dPlaneNaN() {
        DistancePlaneProjection distCalc = new DistancePlaneProjection();
        Assertions.assertEquals((double)0.0, (double)distCalc.calcDist3D(0.0, 0.0, 0.0, 0.0, 0.0, Double.NaN), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)distCalc.calcDist3D(0.0, 0.0, Double.NaN, 0.0, 0.0, 10.0), (double)1.0E-6);
        Assertions.assertEquals((double)0.0, (double)distCalc.calcDist3D(0.0, 0.0, Double.NaN, 0.0, 0.0, Double.NaN), (double)1.0E-6);
    }

    @Test
    public void testIntermediatePoint() {
        DistanceCalcEarth distCalc = new DistanceCalcEarth();
        GHPoint point = distCalc.intermediatePoint(0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertEquals((double)0.0, (double)point.getLat(), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)point.getLon(), (double)1.0E-5);
        point = distCalc.intermediatePoint(0.5, 0.0, 0.0, 10.0, 0.0);
        Assertions.assertEquals((double)5.0, (double)point.getLat(), (double)1.0E-5);
        Assertions.assertEquals((double)0.0, (double)point.getLon(), (double)1.0E-5);
        point = distCalc.intermediatePoint(0.5, 0.0, 0.0, 0.0, 10.0);
        Assertions.assertEquals((double)0.0, (double)point.getLat(), (double)1.0E-5);
        Assertions.assertEquals((double)5.0, (double)point.getLon(), (double)1.0E-5);
        point = distCalc.intermediatePoint(0.5, 45.0, -179.0, 45.0, 177.0);
        Assertions.assertEquals((double)45.0, (double)point.getLat(), (double)1.0);
        Assertions.assertEquals((double)179.0, (double)point.getLon(), (double)1.0E-5);
        point = distCalc.intermediatePoint(0.5, 45.0, 179.0, 45.0, -177.0);
        Assertions.assertEquals((double)45.0, (double)point.getLat(), (double)1.0);
        Assertions.assertEquals((double)-179.0, (double)point.getLon(), (double)1.0E-5);
        point = distCalc.intermediatePoint(0.25, 45.0, -90.0, 45.0, 90.0);
        Assertions.assertEquals((double)67.5, (double)point.getLat(), (double)0.1);
        Assertions.assertEquals((double)-90.0, (double)point.getLon(), (double)1.0E-5);
        point = distCalc.intermediatePoint(0.75, 45.0, -90.0, 45.0, 90.0);
        Assertions.assertEquals((double)67.5, (double)point.getLat(), (double)0.1);
        Assertions.assertEquals((double)90.0, (double)point.getLon(), (double)1.0E-5);
    }
}

