/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalcEuclidean;
import com.graphhopper.util.shapes.GHPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DistanceCalcEuclideanTest {
    @Test
    public void testCrossingPointToEdge() {
        DistanceCalcEuclidean distanceCalc = new DistanceCalcEuclidean();
        GHPoint point = distanceCalc.calcCrossingPointToEdge(0.0, 10.0, 0.0, 0.0, 10.0, 10.0);
        Assertions.assertEquals((double)5.0, (double)point.getLat(), (double)0.0);
        Assertions.assertEquals((double)5.0, (double)point.getLon(), (double)0.0);
    }

    @Test
    public void testCalcNormalizedEdgeDistance() {
        DistanceCalcEuclidean distanceCalc = new DistanceCalcEuclidean();
        double distance = distanceCalc.calcNormalizedEdgeDistance(0.0, 10.0, 0.0, 0.0, 10.0, 10.0);
        Assertions.assertEquals((double)50.0, (double)distance, (double)0.0);
    }

    @Test
    public void testCalcNormalizedEdgeDistance3dStartEndSame() {
        DistanceCalcEuclidean distanceCalc = new DistanceCalcEuclidean();
        double distance = distanceCalc.calcNormalizedEdgeDistance3D(0.0, 3.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        Assertions.assertEquals((double)25.0, (double)distance, (double)0.0);
    }

    @Test
    public void testValidEdgeDistance() {
        DistanceCalcEuclidean distanceCalc = new DistanceCalcEuclidean();
        boolean validEdgeDistance = distanceCalc.validEdgeDistance(5.0, 15.0, 0.0, 0.0, 10.0, 10.0);
        Assertions.assertEquals((Object)false, (Object)validEdgeDistance);
        validEdgeDistance = distanceCalc.validEdgeDistance(15.0, 5.0, 0.0, 0.0, 10.0, 10.0);
        Assertions.assertEquals((Object)false, (Object)validEdgeDistance);
    }

    @Test
    public void testDistance3dEuclidean() {
        DistanceCalcEuclidean distCalc = new DistanceCalcEuclidean();
        Assertions.assertEquals((double)1.0, (double)distCalc.calcDist3D(0.0, 0.0, 0.0, 0.0, 0.0, 1.0), (double)1.0E-6);
        Assertions.assertEquals((double)10.0, (double)distCalc.calcDist3D(0.0, 0.0, 0.0, 0.0, 0.0, 10.0), (double)1.0E-6);
    }
}

