/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.carrotsearch.hppc.IntArrayList;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.InstructionsFromEdges;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.Lanes;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadClassLink;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.SimpleBooleanEncodedValue;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.Instructions;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.TranslationMapTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class InstructionListTest {
    private static final TranslationMap trMap = TranslationMapTest.SINGLETON;
    private static final Translation usTR = trMap.getWithFallBack(Locale.US);
    private final TraversalMode tMode = TraversalMode.NODE_BASED;
    private EncodingManager carManager;
    private DecimalEncodedValue speedEnc;

    @BeforeEach
    public void setUp() {
        this.speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, true);
        this.carManager = EncodingManager.start().add((EncodedValue)this.speedEnc).add((EncodedValue)Roundabout.create()).add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).build();
    }

    private static List<String> getTurnDescriptions(InstructionList instructionList) {
        return InstructionListTest.getTurnDescriptions(instructionList, usTR);
    }

    private static List<String> getTurnDescriptions(InstructionList instructionList, Translation tr) {
        ArrayList<String> list = new ArrayList<String>();
        for (Instruction instruction : instructionList) {
            list.add(instruction.getTurnDescription(tr));
        }
        return list;
    }

    Graph createTestGraph() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 1.2, 1.0);
        na.setNode(1, 1.2, 1.1);
        na.setNode(2, 1.2, 1.2);
        na.setNode(3, 1.1, 1.0);
        na.setNode(4, 1.1, 1.1);
        na.setNode(5, 1.1, 1.2);
        na.setNode(9, 1.1, 1.3);
        na.setNode(10, 1.1, 1.4);
        na.setNode(6, 1.0, 1.0);
        na.setNode(7, 1.0, 1.1);
        na.setNode(8, 1.0, 1.2);
        g.edge(0, 1).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"0-1")));
        g.edge(1, 2).setDistance(11000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"1-2")));
        g.edge(0, 3).setDistance(11000.0).set(this.speedEnc, 60.0, 60.0);
        g.edge(1, 4).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"1-4")));
        g.edge(2, 5).setDistance(11000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"5-2")));
        g.edge(3, 6).setDistance(11000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-6")));
        g.edge(4, 7).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-7")));
        g.edge(5, 8).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"5-8")));
        g.edge(6, 7).setDistance(11000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"6-7")));
        EdgeIteratorState iter = g.edge(7, 8).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0);
        PointList list = new PointList();
        list.add(1.0, 1.15);
        list.add(1.0, 1.16);
        iter.setWayGeometry(list);
        iter.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"7-8")));
        g.edge(9, 10).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0);
        EdgeIteratorState iter2 = g.edge(8, 9).setDistance(20000.0).set(this.speedEnc, 60.0, 60.0);
        list.clear();
        list.add(1.0, 1.3);
        iter2.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"8-9")));
        iter2.setWayGeometry(list);
        return g;
    }

    @Test
    public void testWayList() {
        Graph g = this.createTestGraph();
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        Path p = new Dijkstra(g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(0, 10);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto 0-1", "turn right onto 1-4", "turn left onto 7-8", "arrive at destination"), tmpList);
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)trMap.getWithFallBack(Locale.GERMAN));
        tmpList = InstructionListTest.getTurnDescriptions(wayList, trMap.getWithFallBack(Locale.GERMAN));
        Assertions.assertEquals(Arrays.asList("dem Stra\u00dfenverlauf von 0-1 folgen", "rechts abbiegen auf 1-4", "links abbiegen auf 7-8", "Ziel erreicht"), tmpList);
        Assertions.assertEquals((double)70000.0, (double)this.sumDistances(wayList), (double)0.1);
        PointList points = p.calcPoints();
        Assertions.assertEquals((int)10, (int)points.size());
        Assertions.assertEquals((double)1.0, (double)points.getLon(0), (double)1.0E-6);
        Assertions.assertEquals((double)1.4, (double)points.getLon(points.size() - 1), (double)1.0E-6);
        Assertions.assertEquals((double)1.15, (double)points.getLon(4), (double)1.0E-6);
        Assertions.assertEquals((double)1.16, (double)points.getLon(5), (double)1.0E-6);
        this.compare(Arrays.asList(this.asL(1.2, 1.0), this.asL(1.2, 1.1), this.asL(1.0, 1.1), this.asL(1.1, 1.4)), InstructionListTest.createStartPoints((List<Instruction>)wayList));
        p = new Dijkstra(g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(6, 2);
        Assertions.assertEquals((double)42000.0, (double)p.getDistance(), (double)0.01);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{6, 7, 8, 5, 2}), (Object)p.calcNodes());
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto 6-7", "turn left onto 5-8", "arrive at destination"), tmpList);
        this.compare(Arrays.asList(this.asL(1.0, 1.0), this.asL(1.0, 1.2), this.asL(1.2, 1.2)), InstructionListTest.createStartPoints((List<Instruction>)wayList));
        p = new Dijkstra(g, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(0, 0);
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        Assertions.assertEquals((int)1, (int)wayList.size());
        Assertions.assertEquals((Object)"arrive at destination", (Object)wayList.get(0).getTurnDescription(usTR));
    }

    @Test
    public void testWayList2() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(2, 10.3, 10.15);
        na.setNode(3, 10.0, 10.08);
        na.setNode(4, 10.1, 10.1);
        na.setNode(5, 10.2, 10.13);
        g.edge(3, 4).setDistance(100.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-4")));
        g.edge(4, 5).setDistance(100.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-5")));
        EdgeIteratorState iter = g.edge(2, 4).setDistance(100.0).set(this.speedEnc, 60.0, 60.0);
        iter.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"2-4")));
        PointList list = new PointList();
        list.add(10.2, 10.05);
        iter.setWayGeometry(list);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(2, 3);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto 2-4", "turn slight right onto 3-4", "arrive at destination"), tmpList);
        p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(3, 5);
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto 3-4", "keep right onto 4-5", "arrive at destination"), tmpList);
    }

    @Test
    public void testNoInstructionIfSameStreet() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(2, 10.3, 10.15);
        na.setNode(3, 10.0, 10.05);
        na.setNode(4, 10.1, 10.1);
        na.setNode(5, 10.2, 10.15);
        g.edge(3, 4).setDistance(100.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"street")));
        g.edge(4, 5).setDistance(100.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-5")));
        EdgeIteratorState iter = g.edge(2, 4).setDistance(100.0).set(this.speedEnc, 60.0, 60.0);
        iter.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"street")));
        PointList list = new PointList();
        list.add(10.2, 10.05);
        iter.setWayGeometry(list);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(2, 3);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto street", "turn right onto street", "arrive at destination"), tmpList);
    }

    @Test
    public void testNoInstructionIfSlightTurnAndAlternativeIsSharp() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 51.734514, 9.225571);
        na.setNode(2, 51.73458, 9.225442);
        na.setNode(3, 51.734643, 9.22541);
        na.setNode(4, 51.734451, 9.225436);
        g.edge(1, 2).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        g.edge(2, 3).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        g.edge(2, 4).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(1, 3);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue", "arrive at destination"), tmpList);
    }

    @Test
    public void testNoInstructionIfSlightTurnAndAlternativeIsSharp2() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 48.748493, 9.322455);
        na.setNode(2, 48.748577, 9.322152);
        na.setNode(3, 48.748776, 9.321889);
        na.setNode(4, 48.74847, 9.322299);
        g.edge(1, 2).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        g.edge(2, 3).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        g.edge(2, 4).setDistance(10.0).set(this.speedEnc, 60.0, 60.0);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(1, 3);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue", "arrive at destination"), tmpList);
    }

    @Test
    public void testNoInstructionIfSlightTurnAndAlternativeIsSharp3() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 4, 2.0, true);
        EncodingManager tmpEM = new EncodingManager.Builder().add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)MaxSpeed.create()).build();
        EnumEncodedValue rcEV = tmpEM.getEnumEncodedValue("road_class", RoadClass.class);
        BaseGraph g = new BaseGraph.Builder(tmpEM).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 48.411392, 15.599713);
        na.setNode(2, 48.411457, 15.60041);
        na.setNode(3, 48.41161, 15.600409);
        na.setNode(4, 48.411322, 15.600459);
        g.edge(1, 2).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 18.0, 18.0);
        g.edge(2, 3).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 18.0, 18.0);
        g.edge(2, 4).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 4.0, 4.0);
        g.edge(1, 2).set(rcEV, (Enum)RoadClass.RESIDENTIAL).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"pfarr")));
        g.edge(2, 3).set(rcEV, (Enum)RoadClass.RESIDENTIAL).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"pfarr")));
        g.edge(2, 4).set(rcEV, (Enum)RoadClass.PEDESTRIAN).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"markt")));
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(1, 3);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)tmpEM, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue", "turn left", "arrive at destination"), tmpList);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((double)20.0, (double)wayList.get(1).getDistance());
    }

    @Test
    public void testInstructionIfTurn() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 4, 2.0, true);
        EncodingManager tmpEM = new EncodingManager.Builder().add((EncodedValue)speedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)MaxSpeed.create()).build();
        EnumEncodedValue rcEV = tmpEM.getEnumEncodedValue("road_class", RoadClass.class);
        BaseGraph g = new BaseGraph.Builder(tmpEM).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 48.412169, 15.604888);
        na.setNode(2, 48.412411, 15.605189);
        na.setNode(3, 48.412614, 15.604872);
        na.setNode(4, 48.412148, 15.605543);
        g.edge(1, 2).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 18.0, 18.0).set(rcEV, (Enum)RoadClass.RESIDENTIAL);
        g.edge(2, 3).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 18.0, 18.0).set(rcEV, (Enum)RoadClass.SECONDARY);
        g.edge(2, 4).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 18.0, 18.0).set(rcEV, (Enum)RoadClass.SECONDARY);
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(1, 4);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)tmpEM, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue", "turn right", "arrive at destination"), tmpList);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((double)20.0, (double)wayList.get(1).getDistance());
    }

    @Test
    public void testInstructionIfSlightTurn() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 4, 1.0, false);
        EncodingManager tmpEM = new EncodingManager.Builder().add((EncodedValue)speedEnc).add((EncodedValue)Roundabout.create()).add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)MaxSpeed.create()).build();
        BaseGraph g = new BaseGraph.Builder(tmpEM).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 43.72977, 7.417209);
        na.setNode(2, 43.7297585, 7.4173079);
        na.setNode(3, 43.729821, 7.41725);
        na.setNode(4, 43.729476, 7.417633);
        g.edge(1, 2).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"myroad")));
        g.edge(2, 3).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"myroad")));
        PointList pointList = new PointList();
        pointList.add(43.729627, 7.41749);
        g.edge(2, 4).setDistance(20.0).set((DecimalEncodedValue)speedEnc, 5.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"myroad"))).setWayGeometry(pointList);
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(4, 3);
        Assertions.assertTrue((boolean)p.isFound());
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 2, 3}), (Object)p.calcNodes());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)tmpEM, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto myroad", "keep right onto myroad", "arrive at destination"), tmpList);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((double)20.0, (double)wayList.get(1).getDistance());
        p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(4, 1);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{4, 2, 1}), (Object)p.calcNodes());
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)tmpEM, (Translation)usTR);
        tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto myroad", "keep left onto myroad", "arrive at destination"), tmpList);
        Assertions.assertEquals((int)3, (int)wayList.size());
        Assertions.assertEquals((double)20.0, (double)wayList.get(1).getDistance());
    }

    @Test
    public void testInstructionWithHighlyCustomProfileWithRoadsBase() {
        SimpleBooleanEncodedValue roadsAccessEnc = new SimpleBooleanEncodedValue("access", true);
        DecimalEncodedValueImpl roadsSpeedEnc = new DecimalEncodedValueImpl("speed", 7, 2.0, true);
        EncodingManager tmpEM = EncodingManager.start().add((EncodedValue)roadsAccessEnc).add((EncodedValue)roadsSpeedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)VehicleAccess.create((String)"car")).build();
        EnumEncodedValue rcEV = tmpEM.getEnumEncodedValue("road_class", RoadClass.class);
        BaseGraph g = new BaseGraph.Builder(tmpEM).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 55.690951, 12.571127);
        na.setNode(2, 55.69109, 12.5708);
        na.setNode(3, 55.691214, 12.57065);
        na.setNode(4, 55.690849, 12.571004);
        na.setNode(5, 55.690864, 12.570886);
        g.edge(3, 2).setDistance(10.0).set((DecimalEncodedValue)roadsSpeedEnc, 50.0, 50.0).set((BooleanEncodedValue)roadsAccessEnc, true, true);
        g.edge(2, 4).setDistance(10.0).set((DecimalEncodedValue)roadsSpeedEnc, 40.0, 40.0).set((BooleanEncodedValue)roadsAccessEnc, true, true);
        g.edge(2, 1).setDistance(10.0).set((DecimalEncodedValue)roadsSpeedEnc, 40.0, 40.0).set((BooleanEncodedValue)roadsAccessEnc, true, true);
        g.edge(2, 5).setDistance(10.0).set((DecimalEncodedValue)roadsSpeedEnc, 10.0, 10.0).set((BooleanEncodedValue)roadsAccessEnc, true, true).set(rcEV, (Enum)RoadClass.PEDESTRIAN);
        CustomModel customModel = new CustomModel();
        customModel.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"speed"));
        customModel.addToPriority(Statement.If((String)"road_class == PEDESTRIAN", (Statement.Op)Statement.Op.MULTIPLY, (String)"0"));
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)tmpEM, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)customModel);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(3, 4);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{3, 2, 4}), (Object)p.calcNodes());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)tmpEM, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue", "keep right", "arrive at destination"), tmpList);
    }

    @Test
    public void testEmptyList() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        g.getNodeAccess().setNode(1, 0.0, 0.0);
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(0, 1);
        InstructionList il = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        Assertions.assertEquals((int)0, (int)il.size());
    }

    @Test
    public void testFind() {
        BaseGraph g = new BaseGraph.Builder(this.carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 15.0, 10.0);
        na.setNode(2, 15.1, 10.0);
        na.setNode(3, 15.1, 9.9);
        PointList waypoint = new PointList();
        waypoint.add(15.2, 9.9);
        na.setNode(4, 15.2, 10.0);
        na.setNode(5, 15.2, 10.1);
        na.setNode(6, 15.1, 10.1);
        na.setNode(7, 15.1, 9.8);
        g.edge(1, 2).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"1-2")));
        g.edge(2, 3).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"2-3")));
        g.edge(2, 6).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"2-6")));
        g.edge(3, 4).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-4"))).setWayGeometry(waypoint);
        g.edge(3, 7).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-7")));
        g.edge(4, 5).setDistance(10000.0).set(this.speedEnc, 60.0, 60.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-5")));
        SpeedWeighting weighting = new SpeedWeighting(this.speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(1, 5);
        Assertions.assertEquals((Object)IntArrayList.from((int[])new int[]{1, 2, 3, 4, 5}), (Object)p.calcNodes());
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)this.carManager, (Translation)usTR);
        Assertions.assertEquals((Object)"2-3", (Object)Instructions.find((InstructionList)wayList, (double)15.05, (double)10.0, (double)1000.0).getName());
        Assertions.assertEquals((Object)"2-3", (Object)Instructions.find((InstructionList)wayList, (double)15.05, (double)10.001, (double)1000.0).getName());
        Assertions.assertEquals((Object)"3-4", (Object)Instructions.find((InstructionList)wayList, (double)15.099, (double)9.9, (double)1000.0).getName());
        Assertions.assertNull((Object)Instructions.find((InstructionList)wayList, (double)50.8, (double)50.25, (double)1000.0));
    }

    @Test
    public void testSplitWays() {
        DecimalEncodedValueImpl roadsSpeedEnc = new DecimalEncodedValueImpl("speed", 7, 2.0, true);
        EncodingManager tmpEM = EncodingManager.start().add((EncodedValue)roadsSpeedEnc).add((EncodedValue)RoadClass.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Lanes.create()).add((EncodedValue)VehicleAccess.create((String)"car")).build();
        IntEncodedValue lanesEnc = tmpEM.getIntEncodedValue("lanes");
        BaseGraph g = new BaseGraph.Builder(tmpEM).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 43.626246, -79.71522);
        na.setNode(2, 43.625503, -79.714228);
        na.setNode(3, 43.626285, -79.714974);
        na.setNode(4, 43.625129, -79.713692);
        PointList list = new PointList();
        list.add(43.62549, -79.714292);
        g.edge(1, 2).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"main"))).setWayGeometry(list).setDistance(110.0).set((DecimalEncodedValue)roadsSpeedEnc, 50.0, 0.0).set(lanesEnc, 2);
        g.edge(2, 3).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"main"))).setDistance(110.0).set((DecimalEncodedValue)roadsSpeedEnc, 50.0, 0.0).set(lanesEnc, 3);
        g.edge(2, 4).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"main"))).setDistance(80.0).set((DecimalEncodedValue)roadsSpeedEnc, 50.0, 50.0).set(lanesEnc, 5);
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)roadsSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(1, 4);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)tmpEM, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto main", "arrive at destination"), tmpList);
        na.setNode(5, 43.625666, -79.714048);
        g.edge(2, 5).setDistance(80.0).set((DecimalEncodedValue)roadsSpeedEnc, 50.0, 50.0).set(lanesEnc, 5);
        p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(1, 4);
        wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)tmpEM, (Translation)usTR);
        tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto main", "arrive at destination"), tmpList);
    }

    @Test
    public void testNotSplitWays() {
        DecimalEncodedValueImpl roadsSpeedEnc = new DecimalEncodedValueImpl("speed", 7, 2.0, true);
        EncodingManager tmpEM = EncodingManager.start().add((EncodedValue)roadsSpeedEnc).add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)RoadClass.create()).add((EncodedValue)Roundabout.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)MaxSpeed.create()).add((EncodedValue)Lanes.create()).build();
        IntEncodedValue lanesEnc = tmpEM.getIntEncodedValue("lanes");
        BaseGraph g = new BaseGraph.Builder(tmpEM).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(1, 51.42523, 14.222864);
        na.setNode(2, 51.425256, 14.22325);
        na.setNode(3, 51.425397, 14.223266);
        na.setNode(4, 51.425273, 14.223427);
        g.edge(1, 2).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"dresdener"))).setDistance(110.0).set((DecimalEncodedValue)roadsSpeedEnc, 50.0, 50.0).set(lanesEnc, 2);
        g.edge(2, 3).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"dresdener"))).setDistance(110.0).set((DecimalEncodedValue)roadsSpeedEnc, 50.0, 50.0).set(lanesEnc, 3);
        g.edge(2, 4).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"main"))).setDistance(80.0).set((DecimalEncodedValue)roadsSpeedEnc, 50.0, 50.0).set(lanesEnc, 5);
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)roadsSpeedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(3, 1);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)tmpEM, (Translation)usTR);
        List<String> tmpList = InstructionListTest.getTurnDescriptions(wayList);
        Assertions.assertEquals(Arrays.asList("continue onto dresdener", "turn right onto dresdener", "arrive at destination"), tmpList);
    }

    private void compare(List<List<Double>> expected, List<List<Double>> actual) {
        for (int i = 0; i < expected.size(); ++i) {
            List<Double> e = expected.get(i);
            List<Double> wasE = actual.get(i);
            for (int j = 0; j < e.size(); ++j) {
                Assertions.assertEquals((double)e.get(j), (double)wasE.get(j), (double)1.0E-5, (String)("at index " + i + " value index " + j + " and value " + String.valueOf(e) + " vs " + String.valueOf(wasE) + "\nExpected: " + String.valueOf(expected) + "\nActual: " + String.valueOf(actual)));
            }
        }
    }

    private List<Double> asL(Double ... list) {
        return Arrays.asList(list);
    }

    private static List<List<Double>> createStartPoints(List<Instruction> instructions) {
        ArrayList<List<Double>> res = new ArrayList<List<Double>>(instructions.size());
        for (Instruction instruction : instructions) {
            res.add(Arrays.asList(instruction.getPoints().getLat(0), instruction.getPoints().getLon(0)));
        }
        return res;
    }

    private double sumDistances(InstructionList il) {
        double val = 0.0;
        for (Instruction i : il) {
            val += i.getDistance();
        }
        return val;
    }
}

