/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.ResponsePath;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.InstructionsFromEdges;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadClassLink;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.SpeedWeighting;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PathSimplification;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.RamerDouglasPeucker;
import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.TranslationMapTest;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import com.graphhopper.util.details.PathDetailsFromEdges;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PathSimplificationTest {
    private final TranslationMap trMap = TranslationMapTest.SINGLETON;
    private final Translation usTR = this.trMap.getWithFallBack(Locale.US);
    private final TraversalMode tMode = TraversalMode.NODE_BASED;

    @Test
    public void testScenario() {
        DecimalEncodedValueImpl speedEnc = new DecimalEncodedValueImpl("speed", 5, 5.0, false);
        EncodingManager carManager = EncodingManager.start().add((EncodedValue)speedEnc).add((EncodedValue)VehicleAccess.create((String)"car")).add((EncodedValue)Roundabout.create()).add((EncodedValue)RoadClass.create()).add((EncodedValue)RoadEnvironment.create()).add((EncodedValue)RoadClassLink.create()).add((EncodedValue)MaxSpeed.create()).build();
        BaseGraph g = new BaseGraph.Builder(carManager).create();
        NodeAccess na = g.getNodeAccess();
        na.setNode(0, 1.2, 1.0);
        na.setNode(1, 1.2, 1.1);
        na.setNode(2, 1.2, 1.2);
        na.setNode(3, 1.1, 1.0);
        na.setNode(4, 1.1, 1.1);
        na.setNode(5, 1.1, 1.2);
        na.setNode(9, 1.1, 1.3);
        na.setNode(10, 1.1, 1.4);
        na.setNode(6, 1.0, 1.0);
        na.setNode(7, 1.0, 1.1);
        na.setNode(8, 1.0, 1.2);
        g.edge(0, 1).set((DecimalEncodedValue)speedEnc, 9.0).setDistance(10000.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"0-1")));
        g.edge(1, 2).set((DecimalEncodedValue)speedEnc, 9.0).setDistance(11000.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"1-2")));
        g.edge(0, 3).set((DecimalEncodedValue)speedEnc, 18.0).setDistance(11000.0);
        g.edge(1, 4).set((DecimalEncodedValue)speedEnc, 18.0).setDistance(10000.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"1-4")));
        g.edge(2, 5).set((DecimalEncodedValue)speedEnc, 18.0).setDistance(11000.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"5-2")));
        g.edge(3, 6).set((DecimalEncodedValue)speedEnc, 27.0).setDistance(11000.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"3-6")));
        g.edge(4, 7).set((DecimalEncodedValue)speedEnc, 27.0).setDistance(10000.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"4-7")));
        g.edge(5, 8).set((DecimalEncodedValue)speedEnc, 27.0).setDistance(10000.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"5-8")));
        g.edge(6, 7).setDistance(11000.0).set((DecimalEncodedValue)speedEnc, 36.0).setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"6-7")));
        EdgeIteratorState tmpEdge = g.edge(7, 8).set((DecimalEncodedValue)speedEnc, 36.0).setDistance(10000.0);
        PointList list = new PointList();
        list.add(1.0, 1.15);
        list.add(1.0, 1.16);
        tmpEdge.setWayGeometry(list);
        tmpEdge.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"7-8")));
        g.edge(9, 10).set((DecimalEncodedValue)speedEnc, 45.0).setDistance(10000.0);
        tmpEdge = g.edge(8, 9).set((DecimalEncodedValue)speedEnc, 45.0).setDistance(20000.0);
        list.clear();
        list.add(1.0, 1.3);
        list.add(1.0, 1.3001);
        list.add(1.0, 1.3002);
        list.add(1.0, 1.3003);
        tmpEdge.setKeyValues(Map.of("street_name", new KVStorage.KValue((Object)"8-9")));
        tmpEdge.setWayGeometry(list);
        SpeedWeighting weighting = new SpeedWeighting((DecimalEncodedValue)speedEnc);
        Path p = new Dijkstra((Graph)g, (Weighting)weighting, this.tMode).calcPath(0, 10);
        InstructionList wayList = InstructionsFromEdges.calcInstructions((Path)p, (Graph)g, (Weighting)weighting, (EncodedValueLookup)carManager, (Translation)this.usTR);
        Map details = PathDetailsFromEdges.calcDetails((Path)p, (EncodedValueLookup)carManager, (Weighting)weighting, List.of("average_speed"), (PathDetailsBuilderFactory)new PathDetailsBuilderFactory(), (int)0, (Graph)g);
        PointList points = p.calcPoints();
        PointList waypoints = new PointList(2, g.getNodeAccess().is3D());
        waypoints.add((PointAccess)g.getNodeAccess(), 0);
        waypoints.add((PointAccess)g.getNodeAccess(), 10);
        List<Integer> waypointIndices = Arrays.asList(0, points.size() - 1);
        ResponsePath responsePath = new ResponsePath();
        responsePath.setInstructions(wayList);
        responsePath.addPathDetails(details);
        responsePath.setPoints(points);
        responsePath.setWaypoints(waypoints);
        responsePath.setWaypointIndices(waypointIndices);
        int numberOfPoints = points.size();
        RamerDouglasPeucker ramerDouglasPeucker = new RamerDouglasPeucker();
        ramerDouglasPeucker.setMaxDistance(0.0);
        PathSimplification.simplify((ResponsePath)responsePath, (RamerDouglasPeucker)ramerDouglasPeucker, (boolean)true);
        Assertions.assertEquals((int)numberOfPoints, (int)responsePath.getPoints().size());
        responsePath = new ResponsePath();
        responsePath.setInstructions(wayList);
        responsePath.addPathDetails(details);
        responsePath.setPoints(p.calcPoints());
        responsePath.setWaypoints(waypoints);
        responsePath.setWaypointIndices(waypointIndices);
        ramerDouglasPeucker.setMaxDistance(1.0E8);
        PathSimplification.simplify((ResponsePath)responsePath, (RamerDouglasPeucker)ramerDouglasPeucker, (boolean)true);
        Assertions.assertTrue((numberOfPoints > responsePath.getPoints().size() ? 1 : 0) != 0);
    }

    @Test
    public void testSinglePartition() {
        PointList points = new PointList();
        points.add(48.89107, 9.33161);
        points.add(48.89104, 9.33102);
        points.add(48.891, 9.33024);
        points.add(48.89099, 9.33002);
        points.add(48.89092, 9.32853);
        points.add(48.89101, 9.32854);
        points.add(48.89242, 9.32865);
        points.add(48.89343, 9.32878);
        PointList origPoints = points.clone(false);
        TestPartition partition = TestPartition.start().add(0, 3).add(3, 3).add(3, 3).add(3, 4).add(4, 4).add(4, 7).add(7, 7);
        ArrayList<TestPartition> partitions = new ArrayList<TestPartition>();
        partitions.add(partition);
        PathSimplification.simplify((PointList)points, partitions, (RamerDouglasPeucker)new RamerDouglasPeucker());
        Assertions.assertEquals((int)5, (int)points.size());
        origPoints.set(1, Double.NaN, Double.NaN, Double.NaN);
        origPoints.set(2, Double.NaN, Double.NaN, Double.NaN);
        origPoints.set(5, Double.NaN, Double.NaN, Double.NaN);
        RamerDouglasPeucker.removeNaN((PointList)origPoints);
        Assertions.assertEquals((Object)origPoints, (Object)points);
        TestPartition expected = TestPartition.start().add(0, 1).add(1, 1).add(1, 1).add(1, 2).add(2, 2).add(2, 4).add(4, 4);
        Assertions.assertEquals(expected.intervals, partition.intervals);
    }

    @Test
    public void testMultiplePartitions() {
        PointList points = new PointList(20, true);
        points.add(48.89089, 9.32538, 270.0);
        points.add(48.8909, 9.32527, 269.0);
        points.add(48.89091, 9.32439, 267.0);
        points.add(48.89091, 9.32403, 267.0);
        points.add(48.8909, 9.32324, 267.0);
        points.add(48.89088, 9.32296, 267.0);
        points.add(48.89088, 9.32288, 266.0);
        points.add(48.89081, 9.32208, 265.0);
        points.add(48.89056, 9.32217, 265.0);
        points.add(48.89047, 9.32218, 265.0);
        points.add(48.89037, 9.32215, 265.0);
        points.add(48.89026, 9.32157, 265.0);
        points.add(48.89023, 9.32101, 264.0);
        points.add(48.89027, 9.32038, 261.0);
        points.add(48.8903, 9.32006, 261.0);
        points.add(48.88989, 9.31965, 261.0);
        PointList origPoints = points.clone(false);
        TestPartition partition1 = TestPartition.start().add(0, 6).add(6, 6).add(6, 7).add(7, 10).add(10, 12).add(12, 12).add(12, 14).add(14, 15).add(15, 15);
        TestPartition partition2 = TestPartition.start().add(0, 3).add(3, 7).add(7, 15);
        TestPartition partition3 = TestPartition.start().add(0, 7).add(7, 14).add(14, 15);
        ArrayList<TestPartition> partitions = new ArrayList<TestPartition>();
        partitions.add(partition1);
        partitions.add(partition2);
        partitions.add(partition3);
        PathSimplification.simplify((PointList)points, partitions, (RamerDouglasPeucker)new RamerDouglasPeucker());
        Assertions.assertEquals((int)12, (int)points.size());
        origPoints.set(1, Double.NaN, Double.NaN, Double.NaN);
        origPoints.set(2, Double.NaN, Double.NaN, Double.NaN);
        origPoints.set(5, Double.NaN, Double.NaN, Double.NaN);
        origPoints.set(13, Double.NaN, Double.NaN, Double.NaN);
        RamerDouglasPeucker.removeNaN((PointList)origPoints);
        Assertions.assertEquals((Object)origPoints, (Object)points);
        TestPartition expected1 = TestPartition.start().add(0, 3).add(3, 3).add(3, 4).add(4, 7).add(7, 9).add(9, 9).add(9, 10).add(10, 11).add(11, 11);
        TestPartition expected2 = TestPartition.start().add(0, 1).add(1, 4).add(4, 11);
        TestPartition expected3 = TestPartition.start().add(0, 4).add(4, 10).add(10, 11);
        Assertions.assertEquals(expected1.intervals, partition1.intervals);
        Assertions.assertEquals(expected2.intervals, partition2.intervals);
        Assertions.assertEquals(expected3.intervals, partition3.intervals);
    }

    static class TestPartition
    implements PathSimplification.Partition {
        private List<Interval> intervals = new ArrayList<Interval>();

        TestPartition() {
        }

        static Interval interval(int start, int end) {
            return new Interval(start, end);
        }

        private static TestPartition start() {
            return new TestPartition();
        }

        private TestPartition add(int start, int end) {
            this.intervals.add(TestPartition.interval(start, end));
            return this;
        }

        public int size() {
            return this.intervals.size();
        }

        public int getIntervalLength(int index) {
            return this.intervals.get(index).length();
        }

        public void setInterval(int index, int start, int end) {
            this.intervals.get(index).set(start, end);
        }

        static class Interval {
            int start;
            int end;

            Interval(int start, int end) {
                this.start = start;
                this.end = end;
            }

            private int length() {
                return this.end - this.start;
            }

            private void set(int start, int end) {
                this.start = start;
                this.end = end;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Interval that = (Interval)o;
                return this.start == that.start && this.end == that.end;
            }

            public int hashCode() {
                return Objects.hash(this.start, this.end);
            }

            public String toString() {
                return "[" + this.start + ", " + this.end + "]";
            }
        }
    }
}

