/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PointListTest {
    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)Helper.createPointList((double[])new double[0]), (Object)PointList.EMPTY);
        PointList list1 = Helper.createPointList((double[])new double[]{38.5, -120.2, 43.252, -126.453, 40.7, -120.95, 50.3139, 10.612793, 50.04303, 9.497681});
        PointList list2 = Helper.createPointList((double[])new double[]{38.5, -120.2, 43.252, -126.453, 40.7, -120.95, 50.3139, 10.612793, 50.04303, 9.497681});
        Assertions.assertEquals((Object)list1, (Object)list2);
    }

    @Test
    public void testReverse() {
        PointList instance = new PointList();
        instance.add(1.0, 1.0);
        instance.reverse();
        Assertions.assertEquals((double)1.0, (double)instance.getLon(0), (double)1.0E-7);
        instance = new PointList();
        instance.add(1.0, 1.0);
        instance.add(2.0, 2.0);
        PointList clonedList = instance.clone(false);
        instance.reverse();
        Assertions.assertEquals((double)2.0, (double)instance.getLon(0), (double)1.0E-7);
        Assertions.assertEquals((double)1.0, (double)instance.getLon(1), (double)1.0E-7);
        Assertions.assertEquals((Object)clonedList, (Object)instance.clone(true));
    }

    @Test
    public void testAddPL() {
        PointList instance = new PointList();
        for (int i = 0; i < 7; ++i) {
            instance.add(0.0, 0.0);
        }
        Assertions.assertEquals((int)7, (int)instance.size());
        Assertions.assertEquals((int)10, (int)instance.getCapacity());
        PointList toAdd = new PointList();
        instance.add(toAdd);
        Assertions.assertEquals((int)7, (int)instance.size());
        Assertions.assertEquals((int)10, (int)instance.getCapacity());
        toAdd.add(1.0, 1.0);
        toAdd.add(2.0, 2.0);
        toAdd.add(3.0, 3.0);
        toAdd.add(4.0, 4.0);
        toAdd.add(5.0, 5.0);
        instance.add(toAdd);
        Assertions.assertEquals((int)12, (int)instance.size());
        Assertions.assertEquals((int)24, (int)instance.getCapacity());
        for (int i = 0; i < toAdd.size(); ++i) {
            Assertions.assertEquals((double)toAdd.getLat(i), (double)instance.getLat(7 + i), (double)0.1);
        }
    }

    @Test
    public void testIterable() {
        PointList toAdd = new PointList();
        toAdd.add(1.0, 1.0);
        toAdd.add(2.0, 2.0);
        toAdd.add(3.0, 3.0);
        int counter = 0;
        for (GHPoint point : toAdd) {
            Assertions.assertEquals((double)(++counter), (double)point.getLat(), (double)0.1);
        }
    }

    @Test
    public void testRemoveLast() {
        PointList list = new PointList(20, false);
        for (int i = 0; i < 10; ++i) {
            list.add(1.0, (double)i);
        }
        Assertions.assertEquals((int)10, (int)list.size());
        Assertions.assertEquals((double)9.0, (double)list.getLon(list.size() - 1), (double)0.1);
        list.removeLastPoint();
        Assertions.assertEquals((int)9, (int)list.size());
        Assertions.assertEquals((double)8.0, (double)list.getLon(list.size() - 1), (double)0.1);
        list = new PointList(20, false);
        list.add(1.0, 1.0);
        list.removeLastPoint();
        try {
            list.removeLastPoint();
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assertions.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void testCopy_issue1166() {
        PointList list = new PointList(20, false);
        for (int i = 0; i < 10; ++i) {
            list.add(1.0, (double)i);
        }
        Assertions.assertEquals((int)10, (int)list.size());
        Assertions.assertEquals((int)20, (int)list.getCapacity());
        PointList copy = list.copy(9, 10);
        Assertions.assertEquals((int)1, (int)copy.size());
        Assertions.assertEquals((int)1, (int)copy.getCapacity());
        Assertions.assertEquals((double)9.0, (double)copy.getLon(0), (double)0.1);
    }

    @Test
    public void testShallowCopy() {
        PointList pl1 = new PointList(100, true);
        for (int i = 0; i < 1000; ++i) {
            pl1.add((double)i, (double)i, 0.0);
        }
        PointList pl2 = pl1.shallowCopy(100, 600, false);
        Assertions.assertEquals((int)500, (int)pl2.size());
        for (int i = 0; i < pl2.size(); ++i) {
            Assertions.assertEquals((double)pl1.getLat(i + 100), (double)pl2.getLat(i), (double)0.01);
        }
        pl1.set(100, 0.0, 0.0, 0.0);
        Assertions.assertEquals((double)0.0, (double)pl2.getLat(0), (double)0.01);
        PointList pl3 = pl2.shallowCopy(0, 100, true);
        Assertions.assertTrue((boolean)pl1.isImmutable());
        Assertions.assertEquals((int)100, (int)pl3.size());
        for (int i = 0; i < pl3.size(); ++i) {
            Assertions.assertEquals((double)pl2.getLon(i), (double)pl3.getLon(i), (double)0.01);
        }
        PointList pl4 = pl1.shallowCopy(0, pl1.size(), false);
        Assertions.assertTrue((boolean)pl1.equals((Object)pl4));
        PointList pl5 = pl1.shallowCopy(100, 600, false);
        Assertions.assertTrue((boolean)pl2.equals((Object)pl5));
    }

    @Test
    public void testImmutable() {
        PointList pl = new PointList();
        pl.makeImmutable();
        Assertions.assertThrows(IllegalStateException.class, () -> pl.add(0.0, 0.0, 0.0));
    }

    @Test
    public void testToString() {
        PointList pl = new PointList(3, true);
        pl.add(0.0, 0.0, 0.0);
        pl.add(1.0, 1.0, 1.0);
        pl.add(2.0, 2.0, 2.0);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (1.0,1.0,1.0), (2.0,2.0,2.0)", (Object)pl.toString());
        Assertions.assertEquals((Object)"(1.0,1.0,1.0), (2.0,2.0,2.0)", (Object)pl.shallowCopy(1, 3, false).toString());
    }

    @Test
    public void testClone() {
        PointList pl = new PointList(3, true);
        pl.add(0.0, 0.0, 0.0);
        pl.add(1.0, 1.0, 1.0);
        pl.add(2.0, 2.0, 2.0);
        PointList shallowPl = pl.shallowCopy(1, 3, false);
        PointList clonedPl = shallowPl.clone(false);
        Assertions.assertEquals((Object)shallowPl, (Object)clonedPl);
        clonedPl.setNode(0, 5.0, 5.0, 5.0);
        Assertions.assertNotEquals((Object)shallowPl, (Object)clonedPl);
    }

    @Test
    public void testCopyOfShallowCopy() {
        PointList pl = new PointList(3, true);
        pl.add(0.0, 0.0, 0.0);
        pl.add(1.0, 1.0, 1.0);
        pl.add(2.0, 2.0, 2.0);
        PointList shallowPl = pl.shallowCopy(1, 3, false);
        PointList copiedPl = shallowPl.copy(0, 2);
        Assertions.assertEquals((Object)shallowPl, (Object)copiedPl);
        copiedPl.setNode(0, 5.0, 5.0, 5.0);
        Assertions.assertNotEquals((Object)shallowPl, (Object)copiedPl);
    }

    @Test
    public void testCalcDistanceOfShallowCopy() {
        PointList pl = new PointList(3, true);
        pl.add(0.0, 0.0, 0.0);
        pl.add(1.0, 1.0, 1.0);
        pl.add(2.0, 2.0, 2.0);
        PointList shallowPl = pl.shallowCopy(1, 3, false);
        PointList clonedPl = shallowPl.clone(false);
        Assertions.assertEquals((double)DistanceCalcEarth.DIST_EARTH.calcDistance(clonedPl), (double)DistanceCalcEarth.DIST_EARTH.calcDistance(shallowPl), (double)0.01);
    }

    @Test
    public void testToGeoJson() {
        PointList pl = new PointList(3, true);
        pl.add(0.0, 0.0, 0.0);
        pl.add(1.0, 1.0, 1.0);
        pl.add(2.0, 2.0, 2.0);
        Assertions.assertEquals((int)3, (int)pl.toLineString(true).getNumPoints());
        Assertions.assertEquals((int)2, (int)pl.shallowCopy(1, 3, false).toLineString(true).getNumPoints());
        Assertions.assertEquals((int)0, (int)PointList.EMPTY.toLineString(false).getNumPoints());
        PointList oneLength = new PointList(3, true);
        oneLength.add(0.0, 0.0, 0.0);
        Assertions.assertEquals((int)2, (int)oneLength.toLineString(false).getNumPoints());
    }
}

