/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.PointList;
import com.graphhopper.util.RamerDouglasPeucker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RamerDouglasPeuckerTest {
    private final String points1 = "[[11.571499218899739,49.945605917549265],[11.571664621792689,49.94570668665409],[11.571787742639804,49.94578156499077],[11.572065649302282,49.94590338198625],[11.572209445511016,49.94595944760649],[11.57229438213172,49.94598850487147],[11.573315297960832,49.946237913062525],[11.57367665112786,49.946338495902836],[11.573895511937787,49.94641784458796],[11.574013417378367,49.94646347939514],[11.574228180368875,49.94654916107392],[11.574703899950622,49.94677509993557],[11.575003599561832,49.946924670344394],[11.575434615658997,49.94711838544425],[11.575559971680342,49.94716010869652],[11.57563783024932,49.947186185729194],[11.57609697228887,49.94727875919518],[11.57656188852851,49.947290121330845],[11.576840167720023,49.94727782787258],[11.576961425921949,49.94725827009808],[11.577226852861648,49.947215242994176],[11.577394863457863,49.94717668623872],[11.577511092517772,49.94715005041249],[11.577635517216523,49.947112238715114],[11.577917149169382,49.94702655703634],[11.577969116970207,49.947010724552214],[11.578816061738493,49.94673523932849],[11.579533552666014,49.94648974269233],[11.580073719771365,49.946299007824784],[11.580253092503245,49.946237913062525],[11.580604946179799,49.94608871518274],[11.580740546749693,49.94603041438826]]";
    private final String points2 = "[[9.961074440801317,50.203764443183644],[9.96106605889796,50.20365789987872],[9.960999562464645,50.20318963087774],[9.96094144793469,50.202952888673984],[9.96223002587773,50.20267889356641],[9.962200968612752,50.20262022024289],[9.961859918278305,50.201853928011374],[9.961668810881722,50.20138565901039],[9.96216874485095,50.20128507617008],[9.961953795595925,50.20088553877664],[9.961899033827313,50.200686794534775],[9.961716680863127,50.20014066696481],[9.961588158344957,50.199798499043254]]";

    @Test
    public void testParse() {
        PointList pointList = new PointList();
        pointList.parse2DJSON("[[11.571499218899739,49.945605917549265],[11.571664621792689,49.94570668665409]]");
        Assertions.assertEquals((double)49.945605917549265, (double)pointList.getLat(0), (double)1.0E-6);
        Assertions.assertEquals((double)11.571499218899739, (double)pointList.getLon(0), (double)1.0E-6);
        Assertions.assertEquals((double)49.94570668665409, (double)pointList.getLat(1), (double)1.0E-6);
        Assertions.assertEquals((double)11.571664621792689, (double)pointList.getLon(1), (double)1.0E-6);
    }

    @Test
    public void testPathSimplify() {
        PointList pointList = new PointList();
        pointList.parse2DJSON("[[11.571499218899739,49.945605917549265],[11.571664621792689,49.94570668665409],[11.571787742639804,49.94578156499077],[11.572065649302282,49.94590338198625],[11.572209445511016,49.94595944760649],[11.57229438213172,49.94598850487147],[11.573315297960832,49.946237913062525],[11.57367665112786,49.946338495902836],[11.573895511937787,49.94641784458796],[11.574013417378367,49.94646347939514],[11.574228180368875,49.94654916107392],[11.574703899950622,49.94677509993557],[11.575003599561832,49.946924670344394],[11.575434615658997,49.94711838544425],[11.575559971680342,49.94716010869652],[11.57563783024932,49.947186185729194],[11.57609697228887,49.94727875919518],[11.57656188852851,49.947290121330845],[11.576840167720023,49.94727782787258],[11.576961425921949,49.94725827009808],[11.577226852861648,49.947215242994176],[11.577394863457863,49.94717668623872],[11.577511092517772,49.94715005041249],[11.577635517216523,49.947112238715114],[11.577917149169382,49.94702655703634],[11.577969116970207,49.947010724552214],[11.578816061738493,49.94673523932849],[11.579533552666014,49.94648974269233],[11.580073719771365,49.946299007824784],[11.580253092503245,49.946237913062525],[11.580604946179799,49.94608871518274],[11.580740546749693,49.94603041438826]]");
        Assertions.assertEquals((int)32, (int)pointList.size());
        new RamerDouglasPeucker().setMaxDistance(0.5).simplify(pointList);
        Assertions.assertEquals((int)20, (int)pointList.size());
    }

    @Test
    public void testSimplifyCheckPointCount() {
        PointList pointList = new PointList();
        pointList.parse2DJSON("[[11.571499218899739,49.945605917549265],[11.571664621792689,49.94570668665409],[11.571787742639804,49.94578156499077],[11.572065649302282,49.94590338198625],[11.572209445511016,49.94595944760649],[11.57229438213172,49.94598850487147],[11.573315297960832,49.946237913062525],[11.57367665112786,49.946338495902836],[11.573895511937787,49.94641784458796],[11.574013417378367,49.94646347939514],[11.574228180368875,49.94654916107392],[11.574703899950622,49.94677509993557],[11.575003599561832,49.946924670344394],[11.575434615658997,49.94711838544425],[11.575559971680342,49.94716010869652],[11.57563783024932,49.947186185729194],[11.57609697228887,49.94727875919518],[11.57656188852851,49.947290121330845],[11.576840167720023,49.94727782787258],[11.576961425921949,49.94725827009808],[11.577226852861648,49.947215242994176],[11.577394863457863,49.94717668623872],[11.577511092517772,49.94715005041249],[11.577635517216523,49.947112238715114],[11.577917149169382,49.94702655703634],[11.577969116970207,49.947010724552214],[11.578816061738493,49.94673523932849],[11.579533552666014,49.94648974269233],[11.580073719771365,49.946299007824784],[11.580253092503245,49.946237913062525],[11.580604946179799,49.94608871518274],[11.580740546749693,49.94603041438826]]");
        RamerDouglasPeucker dp = new RamerDouglasPeucker().setMaxDistance(0.5);
        Assertions.assertEquals((int)32, (int)pointList.size());
        dp.simplify(pointList);
        Assertions.assertEquals((int)20, (int)pointList.size());
        Assertions.assertFalse((boolean)pointList.toString().contains("NaN"), (String)pointList.toString());
        pointList.clear();
        pointList.parse2DJSON("[[11.571499218899739,49.945605917549265],[11.571664621792689,49.94570668665409],[11.571787742639804,49.94578156499077],[11.572065649302282,49.94590338198625],[11.572209445511016,49.94595944760649],[11.57229438213172,49.94598850487147],[11.573315297960832,49.946237913062525],[11.57367665112786,49.946338495902836],[11.573895511937787,49.94641784458796],[11.574013417378367,49.94646347939514],[11.574228180368875,49.94654916107392],[11.574703899950622,49.94677509993557],[11.575003599561832,49.946924670344394],[11.575434615658997,49.94711838544425],[11.575559971680342,49.94716010869652],[11.57563783024932,49.947186185729194],[11.57609697228887,49.94727875919518],[11.57656188852851,49.947290121330845],[11.576840167720023,49.94727782787258],[11.576961425921949,49.94725827009808],[11.577226852861648,49.947215242994176],[11.577394863457863,49.94717668623872],[11.577511092517772,49.94715005041249],[11.577635517216523,49.947112238715114],[11.577917149169382,49.94702655703634],[11.577969116970207,49.947010724552214],[11.578816061738493,49.94673523932849],[11.579533552666014,49.94648974269233],[11.580073719771365,49.946299007824784],[11.580253092503245,49.946237913062525],[11.580604946179799,49.94608871518274],[11.580740546749693,49.94603041438826]]");
        dp.simplify(pointList, 0, pointList.size() - 1);
        Assertions.assertEquals((int)20, (int)pointList.size());
        pointList.clear();
        pointList.parse2DJSON("[[11.571499218899739,49.945605917549265],[11.571664621792689,49.94570668665409],[11.571787742639804,49.94578156499077],[11.572065649302282,49.94590338198625],[11.572209445511016,49.94595944760649],[11.57229438213172,49.94598850487147],[11.573315297960832,49.946237913062525],[11.57367665112786,49.946338495902836],[11.573895511937787,49.94641784458796],[11.574013417378367,49.94646347939514],[11.574228180368875,49.94654916107392],[11.574703899950622,49.94677509993557],[11.575003599561832,49.946924670344394],[11.575434615658997,49.94711838544425],[11.575559971680342,49.94716010869652],[11.57563783024932,49.947186185729194],[11.57609697228887,49.94727875919518],[11.57656188852851,49.947290121330845],[11.576840167720023,49.94727782787258],[11.576961425921949,49.94725827009808],[11.577226852861648,49.947215242994176],[11.577394863457863,49.94717668623872],[11.577511092517772,49.94715005041249],[11.577635517216523,49.947112238715114],[11.577917149169382,49.94702655703634],[11.577969116970207,49.947010724552214],[11.578816061738493,49.94673523932849],[11.579533552666014,49.94648974269233],[11.580073719771365,49.946299007824784],[11.580253092503245,49.946237913062525],[11.580604946179799,49.94608871518274],[11.580740546749693,49.94603041438826]]");
        int removed1 = dp.simplify(pointList.copy(10, 20));
        pointList.clear();
        pointList.parse2DJSON("[[11.571499218899739,49.945605917549265],[11.571664621792689,49.94570668665409],[11.571787742639804,49.94578156499077],[11.572065649302282,49.94590338198625],[11.572209445511016,49.94595944760649],[11.57229438213172,49.94598850487147],[11.573315297960832,49.946237913062525],[11.57367665112786,49.946338495902836],[11.573895511937787,49.94641784458796],[11.574013417378367,49.94646347939514],[11.574228180368875,49.94654916107392],[11.574703899950622,49.94677509993557],[11.575003599561832,49.946924670344394],[11.575434615658997,49.94711838544425],[11.575559971680342,49.94716010869652],[11.57563783024932,49.947186185729194],[11.57609697228887,49.94727875919518],[11.57656188852851,49.947290121330845],[11.576840167720023,49.94727782787258],[11.576961425921949,49.94725827009808],[11.577226852861648,49.947215242994176],[11.577394863457863,49.94717668623872],[11.577511092517772,49.94715005041249],[11.577635517216523,49.947112238715114],[11.577917149169382,49.94702655703634],[11.577969116970207,49.947010724552214],[11.578816061738493,49.94673523932849],[11.579533552666014,49.94648974269233],[11.580073719771365,49.946299007824784],[11.580253092503245,49.946237913062525],[11.580604946179799,49.94608871518274],[11.580740546749693,49.94603041438826]]");
        int removed2 = dp.simplify(pointList, 10, 19);
        Assertions.assertEquals((int)removed1, (int)removed2);
    }

    @Test
    public void testSimplifyCheckPointOrder() {
        PointList pointList = new PointList();
        pointList.parse2DJSON("[[9.961074440801317,50.203764443183644],[9.96106605889796,50.20365789987872],[9.960999562464645,50.20318963087774],[9.96094144793469,50.202952888673984],[9.96223002587773,50.20267889356641],[9.962200968612752,50.20262022024289],[9.961859918278305,50.201853928011374],[9.961668810881722,50.20138565901039],[9.96216874485095,50.20128507617008],[9.961953795595925,50.20088553877664],[9.961899033827313,50.200686794534775],[9.961716680863127,50.20014066696481],[9.961588158344957,50.199798499043254]]");
        Assertions.assertEquals((int)13, (int)pointList.size());
        new RamerDouglasPeucker().setMaxDistance(0.5).simplify(pointList);
        Assertions.assertEquals((int)11, (int)pointList.size());
        Assertions.assertFalse((boolean)pointList.toString().contains("NaN"), (String)pointList.toString());
        Assertions.assertEquals((Object)"(50.203764443183644,9.961074440801317), (50.20318963087774,9.960999562464645), (50.202952888673984,9.96094144793469), (50.20267889356641,9.96223002587773), (50.201853928011374,9.961859918278305), (50.20138565901039,9.961668810881722), (50.20128507617008,9.96216874485095), (50.20088553877664,9.961953795595925), (50.200686794534775,9.961899033827313), (50.20014066696481,9.961716680863127), (50.199798499043254,9.961588158344957)", (Object)pointList.toString());
    }

    @Test
    public void testRemoveNaN() {
        PointList pl = new PointList(10, true);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(1.0, 1.0, 1.0);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(5.0, 5.0, 5.0);
        pl.add(6.0, 6.0, 6.0);
        pl.add(7.0, 7.0, 7.0);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(8.0, 8.0, 8.0);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(9.0, 9.0, 9.0);
        pl.add(10.0, 10.0, 10.0);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        pl.add(14.0, 14.0, 14.0);
        pl.add(Double.NaN, Double.NaN, Double.NaN);
        RamerDouglasPeucker.removeNaN((PointList)pl);
        RamerDouglasPeucker.removeNaN((PointList)pl);
        RamerDouglasPeucker.removeNaN((PointList)pl);
        Assertions.assertEquals((int)8, (int)pl.size());
        List<Integer> expected = Arrays.asList(1, 5, 6, 7, 8, 9, 10, 14);
        ArrayList<Integer> given = new ArrayList<Integer>();
        for (int i = 0; i < pl.size(); ++i) {
            Assertions.assertEquals((double)pl.getLat(i), (double)pl.getEle(i), (double)1.0E-6);
            Assertions.assertEquals((double)pl.getLon(i), (double)pl.getEle(i), (double)1.0E-6);
            given.add((int)pl.getLat(i));
        }
        Assertions.assertEquals(expected, given);
    }

    @Test
    public void test3dPathSimplify() {
        PointList pointList = new PointList(5, true);
        pointList.add(0.0, 0.0, 0.0);
        pointList.add(0.01, 0.0, 10.0);
        pointList.add(0.02, 0.0, 20.0);
        pointList.add(0.03, 0.0, 30.0);
        pointList.add(0.04, 0.0, 50.0);
        new RamerDouglasPeucker().setMaxDistance(1.0).setElevationMaxDistance(1.0).simplify(pointList);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (0.03,0.0,30.0), (0.04,0.0,50.0)", (Object)pointList.toString());
    }

    @Test
    public void test3dPathSimplifyElevationDisabled() {
        PointList pointList = new PointList(5, true);
        pointList.add(0.0, 0.0, 0.0);
        pointList.add(0.03, 0.0, 30.0);
        pointList.add(0.04, 0.0, 50.0);
        new RamerDouglasPeucker().setMaxDistance(1.0).setElevationMaxDistance(Double.MAX_VALUE).simplify(pointList);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (0.04,0.0,50.0)", (Object)pointList.toString());
    }

    @Test
    public void test3dPathSimplifyElevationMaxDistFive() {
        PointList pointList = new PointList(5, true);
        pointList.add(0.0, 0.0, 0.0);
        pointList.add(0.01, 0.0, 14.0);
        pointList.add(0.02, 0.0, 20.0);
        pointList.add(0.03, 0.0, 30.0);
        pointList.add(0.04, 0.0, 50.0);
        new RamerDouglasPeucker().setMaxDistance(1.0).setElevationMaxDistance(5.0).simplify(pointList);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (0.03,0.0,30.0), (0.04,0.0,50.0)", (Object)pointList.toString());
    }

    @Test
    public void test3dPathSimplifyWithMissingElevation() {
        PointList pointList = new PointList(5, true);
        pointList.add(0.0, 0.0, 0.0);
        pointList.add(0.0, 0.5, Double.NaN);
        pointList.add(0.0, 1.0, 14.0);
        pointList.add(1.0, 1.0, 20.0);
        new RamerDouglasPeucker().setMaxDistance(1.0).setElevationMaxDistance(1.0).simplify(pointList);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (0.0,1.0,14.0), (1.0,1.0,20.0)", (Object)pointList.toString());
    }

    @Test
    public void test3dSimplifyStartEndSame() {
        PointList pointList = new PointList(3, true);
        pointList.add(0.0, 0.0, 0.0);
        pointList.add(0.03, 0.0, 30.0);
        pointList.add(0.0, 0.0, 0.0);
        new RamerDouglasPeucker().setMaxDistance(1.0).setElevationMaxDistance(1.0).simplify(pointList);
        Assertions.assertEquals((Object)"(0.0,0.0,0.0), (0.03,0.0,30.0), (0.0,0.0,0.0)", (Object)pointList.toString());
    }

    @Test
    public void test2dSimplifyStartEndSame() {
        PointList pointList = new PointList(3, false);
        pointList.add(0.0, 0.0);
        pointList.add(0.03, 0.0);
        pointList.add(0.0, 0.0);
        new RamerDouglasPeucker().setMaxDistance(1.0).setElevationMaxDistance(1.0).simplify(pointList);
        Assertions.assertEquals((Object)"(0.0,0.0), (0.03,0.0), (0.0,0.0)", (Object)pointList.toString());
    }
}

