/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.SimpleIntDeque;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleIntDequeTest {
    @Test
    public void testSmall() {
        SimpleIntDeque deque = new SimpleIntDeque(8, 2.0f);
        Assertions.assertTrue((boolean)deque.isEmpty());
        Assertions.assertEquals((int)0, (int)deque.getSize());
    }

    @Test
    public void testEmpty() {
        SimpleIntDeque deque = new SimpleIntDeque(1, 2.0f);
        deque.push(1);
        Assertions.assertEquals((int)1, (int)deque.getSize());
        deque.pop();
        Assertions.assertEquals((int)0, (int)deque.getSize());
        deque.push(2);
        Assertions.assertEquals((int)1, (int)deque.getSize());
    }

    @Test
    public void testPush() {
        int i;
        SimpleIntDeque deque = new SimpleIntDeque(8, 2.0f);
        for (i = 0; i < 60; ++i) {
            deque.push(i);
            Assertions.assertEquals((int)(i + 1), (int)deque.getSize());
        }
        Assertions.assertEquals((int)60, (int)deque.getSize());
        Assertions.assertEquals((int)0, (int)deque.pop());
        Assertions.assertEquals((int)59, (int)deque.getSize());
        Assertions.assertEquals((int)1, (int)deque.pop());
        Assertions.assertEquals((int)58, (int)deque.getSize());
        deque.push(2);
        Assertions.assertEquals((int)59, (int)deque.getSize());
        deque.push(3);
        Assertions.assertEquals((int)60, (int)deque.getSize());
        for (i = 0; i < 50; ++i) {
            Assertions.assertEquals((int)(i + 2), (int)deque.pop());
        }
        Assertions.assertEquals((int)10, (int)deque.getSize());
        Assertions.assertEquals((int)39, (int)deque.getCapacity());
        deque.push(123);
        Assertions.assertEquals((int)11, (int)deque.getSize());
        Assertions.assertEquals((int)52, (int)deque.pop());
        Assertions.assertEquals((int)10, (int)deque.getSize());
    }
}

