/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.util.Translation;
import com.graphhopper.util.TranslationMap;
import java.util.Arrays;
import java.util.Locale;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TranslationMapTest {
    public static final TranslationMap SINGLETON = new TranslationMap().doImport();

    @Test
    public void testToString() {
        Translation enMap = SINGLETON.getWithFallBack(Locale.UK);
        Assertions.assertEquals((Object)"continue onto blp street", (Object)enMap.tr("continue_onto", new Object[]{"blp street"}));
        Translation trMap = SINGLETON.getWithFallBack(Locale.GERMANY);
        Assertions.assertEquals((Object)"Zu Fu\u00df", (Object)trMap.tr("web.FOOT", new Object[0]));
        Translation ruMap = SINGLETON.getWithFallBack(new Locale("ru"));
        Assertions.assertEquals((Object)"\u041f\u0435\u0448\u043a\u043e\u043c", (Object)ruMap.tr("web.FOOT", new Object[0]));
        Translation zhMap = SINGLETON.getWithFallBack(new Locale("vi", "VI"));
        Assertions.assertEquals((Object)"\u0110i b\u1ed9", (Object)zhMap.tr("web.FOOT", new Object[0]));
        trMap = SINGLETON.get("de_DE");
        Assertions.assertEquals((Object)"Zu Fu\u00df", (Object)trMap.tr("web.FOOT", new Object[0]));
        trMap = SINGLETON.get("de");
        Assertions.assertEquals((Object)"Zu Fu\u00df", (Object)trMap.tr("web.FOOT", new Object[0]));
        trMap = SINGLETON.get("de_AT");
        Assertions.assertEquals((Object)"Zu Fu\u00df", (Object)trMap.tr("web.FOOT", new Object[0]));
        trMap = SINGLETON.get("he");
        Assertions.assertEquals((Object)"\u05e8\u05d2\u05dc", (Object)trMap.tr("web.FOOT", new Object[0]));
        trMap = SINGLETON.get("iw");
        Assertions.assertEquals((Object)"\u05e8\u05d2\u05dc", (Object)trMap.tr("web.FOOT", new Object[0]));
        String lang = SINGLETON.get("id").getLanguage();
        Assertions.assertTrue((boolean)Arrays.asList("id", "in").contains(lang));
        Assertions.assertEquals((Object)lang, (Object)SINGLETON.get("in").getLanguage());
        Assertions.assertEquals((Object)lang, (Object)SINGLETON.get("in_ID").getLanguage());
        Assertions.assertEquals((Object)"vi", (Object)SINGLETON.get("vi").getLanguage());
        Assertions.assertEquals((Object)"vi", (Object)SINGLETON.get("vi_VN").getLanguage());
    }

    @Test
    public void testToRoundaboutString() {
        Translation ptMap = SINGLETON.get("pt");
        Assertions.assertTrue((boolean)ptMap.tr("roundabout_exit_onto", new Object[]{"1", "somestreet"}).contains("somestreet"));
    }
}

