/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BBoxTest {
    @Test
    public void testCreate() {
        DistanceCalcEarth c = new DistanceCalcEarth();
        BBox b = c.createBBox(52.0, 10.0, 100000.0);
        Assertions.assertEquals((double)52.8993, (double)b.maxLat, (double)1.0E-4);
        Assertions.assertEquals((double)8.5393, (double)b.minLon, (double)1.0E-4);
        Assertions.assertEquals((double)51.1007, (double)b.minLat, (double)1.0E-4);
        Assertions.assertEquals((double)11.4607, (double)b.maxLon, (double)1.0E-4);
    }

    @Test
    public void testContains() {
        Assertions.assertTrue((boolean)new BBox(1.0, 2.0, 0.0, 1.0).contains(new BBox(1.0, 2.0, 0.0, 1.0)));
        Assertions.assertTrue((boolean)new BBox(1.0, 2.0, 0.0, 1.0).contains(new BBox(1.5, 2.0, 0.5, 1.0)));
        Assertions.assertFalse((boolean)new BBox(1.0, 2.0, 0.0, 0.5).contains(new BBox(1.5, 2.0, 0.5, 1.0)));
    }

    @Test
    public void testIntersect() {
        Assertions.assertTrue((boolean)new BBox(12.0, 15.0, 12.0, 15.0).intersects(new BBox(13.0, 14.0, 11.0, 16.0)));
        Assertions.assertTrue((boolean)new BBox(2.0, 6.0, 6.0, 11.0).intersects(new BBox(3.0, 5.0, 5.0, 12.0)));
        Assertions.assertTrue((boolean)new BBox(6.0, 11.0, 6.0, 11.0).intersects(new BBox(7.0, 10.0, 5.0, 12.0)));
    }

    @Test
    public void testPointListIntersect() {
        BBox bbox = new BBox(-0.5, 1.0, 1.0, 2.0);
        PointList pointList = new PointList();
        pointList.add(5.0, 5.0);
        pointList.add(5.0, 0.0);
        Assertions.assertFalse((boolean)bbox.intersects(pointList));
        pointList.add(-5.0, 0.0);
        Assertions.assertTrue((boolean)bbox.intersects(pointList));
        pointList = new PointList();
        pointList.add(5.0, 1.0);
        pointList.add(-1.0, 0.0);
        Assertions.assertTrue((boolean)bbox.intersects(pointList));
        pointList = new PointList();
        pointList.add(5.0, 0.0);
        pointList.add(-1.0, 3.0);
        Assertions.assertFalse((boolean)bbox.intersects(pointList));
        pointList = new PointList();
        pointList.add(5.0, 0.0);
        pointList.add(-1.0, 2.0);
        Assertions.assertTrue((boolean)bbox.intersects(pointList));
        pointList = new PointList();
        pointList.add(1.5, -2.0);
        pointList.add(1.5, 2.0);
        Assertions.assertTrue((boolean)bbox.intersects(pointList));
    }

    @Test
    public void testCalculateIntersection() {
        BBox b1 = new BBox(0.0, 2.0, 0.0, 1.0);
        BBox b2 = new BBox(-1.0, 1.0, -1.0, 2.0);
        BBox expected = new BBox(0.0, 1.0, 0.0, 1.0);
        Assertions.assertEquals((Object)expected, (Object)b1.calculateIntersection(b2));
        b2 = new BBox(100.0, 200.0, 100.0, 200.0);
        Assertions.assertNull((Object)b1.calculateIntersection(b2));
        b1 = new BBox(8.8591, 9.9111, 48.3145, 48.8518);
        b2 = new BBox(5.8524, 17.1483, 46.3786, 55.0653);
        Assertions.assertEquals((Object)b1, (Object)b1.calculateIntersection(b2));
    }

    @Test
    public void testParseTwoPoints() {
        Assertions.assertEquals((Object)new BBox(2.0, 4.0, 1.0, 3.0), (Object)BBox.parseTwoPoints((String)"1,2,3,4"));
        Assertions.assertEquals((Object)new BBox(2.0, 4.0, 1.0, 3.0), (Object)BBox.parseTwoPoints((String)"3,2,1,4"));
    }

    @Test
    public void testParseBBoxString() {
        Assertions.assertEquals((Object)new BBox(2.0, 4.0, 1.0, 3.0), (Object)BBox.parseBBoxString((String)"2,4,1,3"));
    }
}

