/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.shapes;

import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Circle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CircleTest {
    @Test
    public void testIntersectCircleBBox() {
        Assertions.assertTrue((boolean)new Circle(10.0, 10.0, 120000.0).intersects(new BBox(9.0, 11.0, 8.0, 9.0)));
        Assertions.assertFalse((boolean)new Circle(10.0, 10.0, 110000.0).intersects(new BBox(9.0, 11.0, 8.0, 9.0)));
    }

    @Test
    public void testIntersectPointList() {
        Circle circle = new Circle(1.5, 0.3, DistanceCalcEarth.DIST_EARTH.calcDist(0.0, 0.0, 0.0, 0.7));
        PointList pointList = new PointList();
        pointList.add(5.0, 5.0);
        pointList.add(5.0, 0.0);
        Assertions.assertFalse((boolean)circle.intersects(pointList));
        pointList.add(-5.0, 0.0);
        Assertions.assertTrue((boolean)circle.intersects(pointList));
        pointList = new PointList();
        pointList.add(5.0, 1.0);
        pointList.add(-1.0, 0.0);
        Assertions.assertTrue((boolean)circle.intersects(pointList));
        pointList = new PointList();
        pointList.add(5.0, 0.0);
        pointList.add(-1.0, 3.0);
        Assertions.assertFalse((boolean)circle.intersects(pointList));
        pointList = new PointList();
        pointList.add(5.0, 0.0);
        pointList.add(2.0, 0.0);
        Assertions.assertTrue((boolean)circle.intersects(pointList));
        pointList = new PointList();
        pointList.add(1.5, -2.0);
        pointList.add(1.5, 2.0);
        Assertions.assertTrue((boolean)circle.intersects(pointList));
    }

    @Test
    public void testContains() {
        Circle c = new Circle(10.0, 10.0, 120000.0);
        Assertions.assertTrue((boolean)c.contains(new BBox(9.0, 11.0, 10.0, 10.1)));
        Assertions.assertFalse((boolean)c.contains(new BBox(9.0, 11.0, 8.0, 9.0)));
        Assertions.assertFalse((boolean)c.contains(new BBox(9.0, 12.0, 10.0, 10.1)));
    }

    @Test
    public void testContainsCircle() {
        Circle c = new Circle(10.0, 10.0, 120000.0);
        Assertions.assertTrue((boolean)c.contains(new Circle(9.9, 10.2, 90000.0)));
        Assertions.assertFalse((boolean)c.contains(new Circle(10.0, 10.4, 90000.0)));
    }
}

