/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.sorting.IndirectSort;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopperConfig;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.reader.dem.CGIARProvider;
import com.graphhopper.reader.dem.EdgeElevationInterpolator;
import com.graphhopper.reader.dem.ElevationProvider;
import com.graphhopper.reader.dem.GMTEDProvider;
import com.graphhopper.reader.dem.HGTProvider;
import com.graphhopper.reader.dem.MultiSourceElevationProvider;
import com.graphhopper.reader.dem.SRTMGL1Provider;
import com.graphhopper.reader.dem.SRTMProvider;
import com.graphhopper.reader.dem.SkadiProvider;
import com.graphhopper.reader.dem.TileBasedElevationProvider;
import com.graphhopper.reader.osm.OSMReader;
import com.graphhopper.reader.osm.RestrictionTagParser;
import com.graphhopper.routing.DefaultWeightingFactory;
import com.graphhopper.routing.OSMReaderConfig;
import com.graphhopper.routing.Router;
import com.graphhopper.routing.RouterConfig;
import com.graphhopper.routing.WeightingFactory;
import com.graphhopper.routing.ch.CHPreparationHandler;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DefaultImportRegistry;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.ImportRegistry;
import com.graphhopper.routing.ev.ImportUnit;
import com.graphhopper.routing.ev.ImportUnitSorter;
import com.graphhopper.routing.ev.MtbNetwork;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.ev.TurnRestriction;
import com.graphhopper.routing.ev.UrbanDensity;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.lm.LMConfig;
import com.graphhopper.routing.lm.LMPreparationHandler;
import com.graphhopper.routing.lm.LandmarkStorage;
import com.graphhopper.routing.lm.PrepareLandmarks;
import com.graphhopper.routing.subnetwork.PrepareRoutingSubnetworks;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.AreaIndex;
import com.graphhopper.routing.util.CustomArea;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.MaxSpeedCalculator;
import com.graphhopper.routing.util.OSMParsers;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.UrbanDensityCalculator;
import com.graphhopper.routing.util.countryrules.CountryRuleFactory;
import com.graphhopper.routing.util.parsers.OSMBikeNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMFootNetworkTagParser;
import com.graphhopper.routing.util.parsers.OSMMtbNetworkTagParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.NameValidator;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.DAType;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHDirectory;
import com.graphhopper.storage.GHLock;
import com.graphhopper.storage.LockFactory;
import com.graphhopper.storage.NativeFSLockFactory;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.SimpleFSLockFactory;
import com.graphhopper.storage.StorableProperties;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.util.ArrayUtil;
import com.graphhopper.util.Constants;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeatureCollection;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import com.graphhopper.util.TranslationMap;
import com.graphhopper.util.Unzipper;
import com.graphhopper.util.details.PathDetailsBuilderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHopper {
    private static final Logger logger = LoggerFactory.getLogger(GraphHopper.class);
    private MaxSpeedCalculator maxSpeedCalculator;
    private final Map<String, Profile> profilesByName = new LinkedHashMap<String, Profile>();
    private final String fileLockName = "gh.lock";
    private final TranslationMap trMap = new TranslationMap().doImport();
    boolean removeZipped = true;
    boolean calcChecksums = false;
    private CountryRuleFactory countryRuleFactory = null;
    private String customAreasDirectory = "";
    private BaseGraph baseGraph;
    private StorableProperties properties;
    protected EncodingManager encodingManager;
    private OSMParsers osmParsers;
    private int defaultSegmentSize = -1;
    private String ghLocation = "";
    private DAType dataAccessDefaultType = DAType.RAM_STORE;
    private final LinkedHashMap<String, String> dataAccessConfig = new LinkedHashMap();
    private boolean sortGraph = true;
    private boolean elevation = false;
    private LockFactory lockFactory = new NativeFSLockFactory();
    private boolean allowWrites = true;
    private boolean fullyLoaded = false;
    private final OSMReaderConfig osmReaderConfig = new OSMReaderConfig();
    private final RouterConfig routerConfig = new RouterConfig();
    private LocationIndex locationIndex;
    private int preciseIndexResolution = 300;
    private int maxRegionSearch = 4;
    private int minNetworkSize = 200;
    private int subnetworksThreads = 1;
    private double residentialAreaRadius = 400.0;
    private double residentialAreaSensitivity = 6000.0;
    private double cityAreaRadius = 1500.0;
    private double cityAreaSensitivity = 1000.0;
    private int urbanDensityCalculationThreads = 0;
    private final LMPreparationHandler lmPreparationHandler = new LMPreparationHandler();
    private final CHPreparationHandler chPreparationHandler = new CHPreparationHandler();
    private Map<String, RoutingCHGraph> chGraphs = Collections.emptyMap();
    private Map<String, LandmarkStorage> landmarks = Collections.emptyMap();
    private String osmFile;
    private ElevationProvider eleProvider = ElevationProvider.NOOP;
    private ImportRegistry importRegistry = new DefaultImportRegistry();
    private PathDetailsBuilderFactory pathBuilderFactory = new PathDetailsBuilderFactory();
    private String dateRangeParserString = "";
    private String encodedValuesString = "";
    private Supplier<OSMParsers> osmParsersSupplier = OSMParsers::new;
    private OSMReader.Builder<OSMReader> osmReaderSupplier = (baseGraph, osmParsers, config) -> new OSMReader(baseGraph, osmParsers, config);

    public GraphHopper setOsmParsersSupplier(Supplier<OSMParsers> supplier) {
        this.osmParsersSupplier = supplier;
        return this;
    }

    public GraphHopper setOsmReaderSupplier(OSMReader.Builder<OSMReader> supplier) {
        this.osmReaderSupplier = supplier;
        return this;
    }

    public GraphHopper setEncodedValuesString(String encodedValuesString) {
        this.encodedValuesString = encodedValuesString;
        return this;
    }

    public String getEncodedValuesString() {
        return this.encodedValuesString;
    }

    public EncodingManager getEncodingManager() {
        if (this.encodingManager == null) {
            throw new IllegalStateException("EncodingManager not yet built");
        }
        return this.encodingManager;
    }

    public OSMParsers getOSMParsers() {
        if (this.osmParsers == null) {
            throw new IllegalStateException("OSMParsers not yet built");
        }
        return this.osmParsers;
    }

    public ElevationProvider getElevationProvider() {
        return this.eleProvider;
    }

    public GraphHopper setElevationProvider(ElevationProvider eleProvider) {
        if (eleProvider == null || eleProvider == ElevationProvider.NOOP) {
            this.setElevation(false);
        } else {
            this.setElevation(true);
        }
        this.eleProvider = eleProvider;
        return this;
    }

    public GraphHopper setPathDetailsBuilderFactory(PathDetailsBuilderFactory pathBuilderFactory) {
        this.pathBuilderFactory = pathBuilderFactory;
        return this;
    }

    public PathDetailsBuilderFactory getPathDetailsBuilderFactory() {
        return this.pathBuilderFactory;
    }

    public GraphHopper setPreciseIndexResolution(int precision) {
        this.ensureNotLoaded();
        this.preciseIndexResolution = precision;
        return this;
    }

    public int getMinNetworkSize() {
        return this.minNetworkSize;
    }

    public GraphHopper setMinNetworkSize(int minNetworkSize) {
        this.ensureNotLoaded();
        this.minNetworkSize = minNetworkSize;
        return this;
    }

    public GraphHopper setUrbanDensityCalculation(double residentialAreaRadius, double residentialAreaSensitivity, double cityAreaRadius, double cityAreaSensitivity, int threads) {
        this.ensureNotLoaded();
        this.residentialAreaRadius = residentialAreaRadius;
        this.residentialAreaSensitivity = residentialAreaSensitivity;
        this.cityAreaRadius = cityAreaRadius;
        this.cityAreaSensitivity = cityAreaSensitivity;
        this.urbanDensityCalculationThreads = threads;
        return this;
    }

    public GraphHopper setStoreOnFlush(boolean storeOnFlush) {
        this.ensureNotLoaded();
        this.dataAccessDefaultType = storeOnFlush ? DAType.RAM_STORE : DAType.RAM;
        return this;
    }

    public GraphHopper setProfiles(Profile ... profiles) {
        return this.setProfiles(Arrays.asList(profiles));
    }

    public GraphHopper setProfiles(List<Profile> profiles) {
        if (!this.profilesByName.isEmpty()) {
            throw new IllegalArgumentException("Cannot initialize profiles multiple times");
        }
        if (this.encodingManager != null) {
            throw new IllegalArgumentException("Cannot set profiles after EncodingManager was built");
        }
        for (Profile profile : profiles) {
            Profile previous = this.profilesByName.put(profile.getName(), profile);
            if (previous == null) continue;
            throw new IllegalArgumentException("Profile names must be unique. Duplicate name: '" + profile.getName() + "'");
        }
        return this;
    }

    public List<Profile> getProfiles() {
        return new ArrayList<Profile>(this.profilesByName.values());
    }

    public Profile getProfile(String profileName) {
        return this.profilesByName.get(profileName);
    }

    public TransportationMode getNavigationMode(String profileName) {
        Profile profile = this.profilesByName.get(profileName);
        if (profile == null) {
            return TransportationMode.CAR;
        }
        try {
            return TransportationMode.valueOf(profile.getHints().getString("navigation_mode", profileName).toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return TransportationMode.CAR;
        }
    }

    public boolean hasElevation() {
        return this.elevation;
    }

    public GraphHopper setElevation(boolean includeElevation) {
        this.elevation = includeElevation;
        return this;
    }

    public String getGraphHopperLocation() {
        return this.ghLocation;
    }

    public GraphHopper setGraphHopperLocation(String ghLocation) {
        this.ensureNotLoaded();
        if (ghLocation == null) {
            throw new IllegalArgumentException("graphhopper location cannot be null");
        }
        this.ghLocation = ghLocation;
        return this;
    }

    public String getOSMFile() {
        return this.osmFile;
    }

    public GraphHopper setOSMFile(String osmFile) {
        this.ensureNotLoaded();
        if (Helper.isEmpty((String)osmFile)) {
            throw new IllegalArgumentException("OSM file cannot be empty.");
        }
        this.osmFile = osmFile;
        return this;
    }

    public GraphHopper setMaxSpeedCalculator(MaxSpeedCalculator maxSpeedCalculator) {
        this.maxSpeedCalculator = maxSpeedCalculator;
        return this;
    }

    public GraphHopper setSortGraph(boolean sortGraph) {
        this.sortGraph = sortGraph;
        return this;
    }

    public BaseGraph getBaseGraph() {
        if (this.baseGraph == null) {
            throw new IllegalStateException("GraphHopper storage not initialized");
        }
        return this.baseGraph;
    }

    public void setBaseGraph(BaseGraph baseGraph) {
        this.baseGraph = baseGraph;
        this.setFullyLoaded();
    }

    public StorableProperties getProperties() {
        return this.properties;
    }

    public Map<String, RoutingCHGraph> getCHGraphs() {
        return this.chGraphs;
    }

    public Map<String, LandmarkStorage> getLandmarks() {
        return this.landmarks;
    }

    public LocationIndex getLocationIndex() {
        if (this.locationIndex == null) {
            throw new IllegalStateException("LocationIndex not initialized");
        }
        return this.locationIndex;
    }

    protected void setLocationIndex(LocationIndex locationIndex) {
        this.locationIndex = locationIndex;
    }

    public boolean isAllowWrites() {
        return this.allowWrites;
    }

    public GraphHopper setAllowWrites(boolean allowWrites) {
        this.allowWrites = allowWrites;
        return this;
    }

    public TranslationMap getTranslationMap() {
        return this.trMap;
    }

    public GraphHopper setImportRegistry(ImportRegistry importRegistry) {
        this.importRegistry = importRegistry;
        return this;
    }

    public ImportRegistry getImportRegistry() {
        return this.importRegistry;
    }

    public GraphHopper setCustomAreasDirectory(String customAreasDirectory) {
        this.customAreasDirectory = customAreasDirectory;
        return this;
    }

    public String getCustomAreasDirectory() {
        return this.customAreasDirectory;
    }

    public GraphHopper setCountryRuleFactory(CountryRuleFactory countryRuleFactory) {
        this.countryRuleFactory = countryRuleFactory;
        return this;
    }

    public CountryRuleFactory getCountryRuleFactory() {
        return this.countryRuleFactory;
    }

    public GraphHopper init(GraphHopperConfig ghConfig) {
        Object graphHopperFolder;
        this.ensureNotLoaded();
        if (ghConfig.has("routing.ch.disabling_allowed")) {
            throw new IllegalArgumentException("The 'routing.ch.disabling_allowed' configuration option is no longer supported");
        }
        if (ghConfig.has("routing.lm.disabling_allowed")) {
            throw new IllegalArgumentException("The 'routing.lm.disabling_allowed' configuration option is no longer supported");
        }
        if (ghConfig.has("osmreader.osm")) {
            throw new IllegalArgumentException("Instead of osmreader.osm use datareader.file, for other changes see CHANGELOG.md");
        }
        String tmpOsmFile = ghConfig.getString("datareader.file", "");
        if (!Helper.isEmpty((String)tmpOsmFile)) {
            this.osmFile = tmpOsmFile;
        }
        if (Helper.isEmpty((String)(graphHopperFolder = ghConfig.getString("graph.location", ""))) && Helper.isEmpty((String)this.ghLocation)) {
            if (Helper.isEmpty((String)this.osmFile)) {
                throw new IllegalArgumentException("If no graph.location is provided you need to specify an OSM file.");
            }
            graphHopperFolder = Helper.pruneFileEnd((String)this.osmFile) + "-gh";
        }
        this.ghLocation = graphHopperFolder;
        this.countryRuleFactory = ghConfig.getBool("country_rules.enabled", false) ? new CountryRuleFactory() : null;
        this.customAreasDirectory = ghConfig.getString("custom_areas.directory", this.customAreasDirectory);
        this.defaultSegmentSize = ghConfig.getInt("graph.dataaccess.segment_size", this.defaultSegmentSize);
        String daTypeString = ghConfig.getString("graph.dataaccess.default_type", ghConfig.getString("graph.dataaccess", "RAM_STORE"));
        this.dataAccessDefaultType = DAType.fromString(daTypeString);
        for (Map.Entry entry : ghConfig.asPMap().toMap().entrySet()) {
            if (((String)entry.getKey()).startsWith("graph.dataaccess.type.")) {
                this.dataAccessConfig.put(((String)entry.getKey()).substring("graph.dataaccess.type.".length()), entry.getValue().toString());
            }
            if (!((String)entry.getKey()).startsWith("graph.dataaccess.mmap.preload.")) continue;
            this.dataAccessConfig.put(((String)entry.getKey()).substring("graph.dataaccess.mmap.".length()), entry.getValue().toString());
        }
        this.sortGraph = ghConfig.getBool("graph.sort", this.sortGraph);
        if (ghConfig.getBool("max_speed_calculator.enabled", false)) {
            this.maxSpeedCalculator = new MaxSpeedCalculator(MaxSpeedCalculator.createLegalDefaultSpeeds());
        }
        this.removeZipped = ghConfig.getBool("graph.remove_zipped", this.removeZipped);
        if (!ghConfig.getString("spatial_rules.location", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.location has been deprecated. Please use custom_areas.directory instead and read the documentation for custom areas.");
        }
        if (!ghConfig.getString("spatial_rules.borders_directory", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.borders_directory has been deprecated. Please use custom_areas.directory instead and read the documentation for custom areas.");
        }
        if (!ghConfig.getString("spatial_rules.max_bbox", "").isEmpty()) {
            throw new IllegalArgumentException("spatial_rules.max_bbox has been deprecated. There is no replacement, all custom areas will be considered.");
        }
        String customAreasDirectory = ghConfig.getString("custom_areas.directory", "");
        JsonFeatureCollection globalAreas = GraphHopper.resolveCustomAreas(customAreasDirectory);
        String customModelFolder = ghConfig.getString("custom_models.directory", ghConfig.getString("custom_model_folder", ""));
        this.setProfiles(GraphHopper.resolveCustomModelFiles(customModelFolder, ghConfig.getProfiles(), globalAreas));
        if (ghConfig.has("graph.vehicles")) {
            throw new IllegalArgumentException("The option graph.vehicles is no longer supported. Use the appropriate turn_costs and custom_model instead, see docs/migration/config-migration-08-09.md");
        }
        if (ghConfig.has("graph.flag_encoders")) {
            throw new IllegalArgumentException("The option graph.flag_encoders is no longer supported.");
        }
        this.encodedValuesString = ghConfig.getString("graph.encoded_values", this.encodedValuesString);
        this.dateRangeParserString = ghConfig.getString("datareader.date_range_parser_day", this.dateRangeParserString);
        this.lockFactory = ghConfig.getString("graph.locktype", "native").equals("simple") ? new SimpleFSLockFactory() : new NativeFSLockFactory();
        if (ghConfig.has("graph.elevation.smoothing")) {
            throw new IllegalArgumentException("Use 'graph.elevation.edge_smoothing: moving_average' or the new 'graph.elevation.edge_smoothing: ramer'. See #2634.");
        }
        this.osmReaderConfig.setElevationSmoothing(ghConfig.getString("graph.elevation.edge_smoothing", this.osmReaderConfig.getElevationSmoothing()));
        this.osmReaderConfig.setSmoothElevationAverageWindowSize(ghConfig.getDouble("graph.elevation.edge_smoothing.moving_average.window_size", this.osmReaderConfig.getSmoothElevationAverageWindowSize()));
        this.osmReaderConfig.setElevationSmoothingRamerMax(ghConfig.getInt("graph.elevation.edge_smoothing.ramer.max_elevation", this.osmReaderConfig.getElevationSmoothingRamerMax()));
        this.osmReaderConfig.setLongEdgeSamplingDistance(ghConfig.getDouble("graph.elevation.long_edge_sampling_distance", this.osmReaderConfig.getLongEdgeSamplingDistance()));
        this.osmReaderConfig.setElevationMaxWayPointDistance(ghConfig.getDouble("graph.elevation.way_point_max_distance", this.osmReaderConfig.getElevationMaxWayPointDistance()));
        this.routerConfig.setElevationWayPointMaxDistance(ghConfig.getDouble("graph.elevation.way_point_max_distance", this.routerConfig.getElevationWayPointMaxDistance()));
        ElevationProvider elevationProvider = GraphHopper.createElevationProvider(ghConfig);
        this.setElevationProvider(elevationProvider);
        if (this.osmReaderConfig.getLongEdgeSamplingDistance() < Double.MAX_VALUE && !elevationProvider.canInterpolate()) {
            logger.warn("Long edge sampling enabled, but bilinear interpolation disabled. See #1953");
        }
        this.minNetworkSize = ghConfig.getInt("prepare.min_network_size", this.minNetworkSize);
        this.subnetworksThreads = ghConfig.getInt("prepare.subnetworks.threads", this.subnetworksThreads);
        this.chPreparationHandler.init(ghConfig);
        this.lmPreparationHandler.init(ghConfig);
        if (!ghConfig.has("import.osm.ignored_highways")) {
            throw new IllegalArgumentException("Missing 'import.osm.ignored_highways'. Not using this parameter can decrease performance, see config-example.yml for more details");
        }
        String ignoredHighwaysString = ghConfig.getString("import.osm.ignored_highways", "");
        if ((ignoredHighwaysString.contains("footway") || ignoredHighwaysString.contains("path")) && ghConfig.getProfiles().stream().map(Profile::getName).anyMatch(p -> p.contains("foot") || p.contains("hike"))) {
            throw new IllegalArgumentException("You should not use import.osm.ignored_highways=footway or =path in conjunction with pedestrian profiles. This is probably an error in your configuration.");
        }
        if ((ignoredHighwaysString.contains("cycleway") || ignoredHighwaysString.contains("path")) && ghConfig.getProfiles().stream().map(Profile::getName).anyMatch(p -> p.contains("mtb") || p.contains("bike"))) {
            throw new IllegalArgumentException("You should not use import.osm.ignored_highways=cycleway or =path in conjunction with bicycle profiles. This is probably an error in your configuration");
        }
        this.osmReaderConfig.setIgnoredHighways(Arrays.stream(ghConfig.getString("import.osm.ignored_highways", String.join((CharSequence)",", this.osmReaderConfig.getIgnoredHighways())).split(",")).map(String::trim).collect(Collectors.toList()));
        this.osmReaderConfig.setParseWayNames(ghConfig.getBool("datareader.instructions", this.osmReaderConfig.isParseWayNames()));
        this.osmReaderConfig.setPreferredLanguage(ghConfig.getString("datareader.preferred_language", this.osmReaderConfig.getPreferredLanguage()));
        this.osmReaderConfig.setMaxWayPointDistance(ghConfig.getDouble("routing.way_point_max_distance", this.osmReaderConfig.getMaxWayPointDistance()));
        this.osmReaderConfig.setWorkerThreads(ghConfig.getInt("datareader.worker_threads", this.osmReaderConfig.getWorkerThreads()));
        this.preciseIndexResolution = ghConfig.getInt("index.high_resolution", this.preciseIndexResolution);
        this.maxRegionSearch = ghConfig.getInt("index.max_region_search", this.maxRegionSearch);
        this.residentialAreaRadius = ghConfig.getDouble("graph.urban_density.residential_radius", this.residentialAreaRadius);
        this.residentialAreaSensitivity = ghConfig.getDouble("graph.urban_density.residential_sensitivity", this.residentialAreaSensitivity);
        this.cityAreaRadius = ghConfig.getDouble("graph.urban_density.city_radius", this.cityAreaRadius);
        this.cityAreaSensitivity = ghConfig.getDouble("graph.urban_density.city_sensitivity", this.cityAreaSensitivity);
        this.urbanDensityCalculationThreads = ghConfig.getInt("graph.urban_density.threads", this.urbanDensityCalculationThreads);
        this.routerConfig.setMaxVisitedNodes(ghConfig.getInt("routing.max_visited_nodes", this.routerConfig.getMaxVisitedNodes()));
        this.routerConfig.setTimeoutMillis(ghConfig.getLong("routing.timeout_ms", this.routerConfig.getTimeoutMillis()));
        this.routerConfig.setMaxRoundTripRetries(ghConfig.getInt("routing.round_trip.max_retries", this.routerConfig.getMaxRoundTripRetries()));
        this.routerConfig.setNonChMaxWaypointDistance(ghConfig.getInt("routing.non_ch.max_waypoint_distance", this.routerConfig.getNonChMaxWaypointDistance()));
        this.routerConfig.setInstructionsEnabled(ghConfig.getBool("routing.instructions", this.routerConfig.isInstructionsEnabled()));
        int activeLandmarkCount = ghConfig.getInt("routing.lm.active_landmarks", Math.min(8, this.lmPreparationHandler.getLandmarks()));
        if (activeLandmarkCount > this.lmPreparationHandler.getLandmarks()) {
            throw new IllegalArgumentException("Default value for active landmarks " + activeLandmarkCount + " should be less or equal to landmark count of " + this.lmPreparationHandler.getLandmarks());
        }
        this.routerConfig.setActiveLandmarkCount(activeLandmarkCount);
        this.calcChecksums = ghConfig.getBool("graph.calc_checksums", false);
        return this;
    }

    protected EncodingManager buildEncodingManager(Map<String, PMap> encodedValuesWithProps, Map<String, ImportUnit> activeImportUnits, Map<String, List<String>> restrictionVehicleTypesByProfile) {
        ArrayList<EncodedValue> encodedValues = new ArrayList<EncodedValue>(activeImportUnits.entrySet().stream().map(e -> {
            Function<PMap, EncodedValue> f = ((ImportUnit)e.getValue()).getCreateEncodedValue();
            return f == null ? null : f.apply(encodedValuesWithProps.getOrDefault(e.getKey(), new PMap()));
        }).filter(Objects::nonNull).toList());
        encodedValues.addAll(this.createSubnetworkEncodedValues());
        List<String> sortedEVs = this.getEVSortIndex(this.profilesByName);
        encodedValues.sort(Comparator.comparingInt(ev -> sortedEVs.indexOf(ev.getName())));
        EncodingManager.Builder emBuilder = new EncodingManager.Builder();
        encodedValues.forEach(emBuilder::add);
        restrictionVehicleTypesByProfile.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty()).forEach(e -> emBuilder.addTurnCostEncodedValue(TurnRestriction.create((String)e.getKey())));
        return emBuilder.build();
    }

    protected List<BooleanEncodedValue> createSubnetworkEncodedValues() {
        return this.profilesByName.values().stream().map(profile -> Subnetwork.create(profile.getName())).toList();
    }

    protected List<String> getEVSortIndex(Map<String, Profile> profilesByName) {
        return Collections.emptyList();
    }

    protected OSMParsers buildOSMParsers(Map<String, PMap> encodedValuesWithProps, Map<String, ImportUnit> activeImportUnits, Map<String, List<String>> restrictionVehicleTypesByProfile, List<String> ignoredHighways) {
        ImportUnitSorter sorter = new ImportUnitSorter(activeImportUnits);
        LinkedHashMap<String, ImportUnit> sortedImportUnits = new LinkedHashMap<String, ImportUnit>();
        sorter.sort().forEach(name -> sortedImportUnits.put((String)name, (ImportUnit)activeImportUnits.get(name)));
        ArrayList sortedParsers = new ArrayList();
        sortedImportUnits.forEach((name, importUnit) -> {
            BiFunction<EncodedValueLookup, PMap, TagParser> createTagParser = importUnit.getCreateTagParser();
            if (createTagParser != null) {
                PMap pmap = encodedValuesWithProps.getOrDefault(name, new PMap());
                if (!pmap.has("date_range_parser_day")) {
                    pmap.putObject("date_range_parser_day", (Object)this.dateRangeParserString);
                }
                sortedParsers.add(createTagParser.apply(this.encodingManager, pmap));
            }
        });
        OSMParsers osmParsers = this.osmParsersSupplier.get();
        ignoredHighways.forEach(osmParsers::addIgnoredHighway);
        sortedParsers.forEach(osmParsers::addWayTagParser);
        if (this.maxSpeedCalculator != null) {
            this.maxSpeedCalculator.checkEncodedValues(this.encodingManager);
            osmParsers.addWayTagParser(this.maxSpeedCalculator.getParser());
        }
        if (this.encodingManager.hasEncodedValue(BikeNetwork.KEY)) {
            osmParsers.addRelationTagParser(relConfig -> new OSMBikeNetworkTagParser(this.encodingManager.getEnumEncodedValue(BikeNetwork.KEY, RouteNetwork.class), (EncodedValue.InitializerConfig)relConfig));
        }
        if (this.encodingManager.hasEncodedValue(MtbNetwork.KEY)) {
            osmParsers.addRelationTagParser(relConfig -> new OSMMtbNetworkTagParser(this.encodingManager.getEnumEncodedValue(MtbNetwork.KEY, RouteNetwork.class), (EncodedValue.InitializerConfig)relConfig));
        }
        if (this.encodingManager.hasEncodedValue(FootNetwork.KEY)) {
            osmParsers.addRelationTagParser(relConfig -> new OSMFootNetworkTagParser(this.encodingManager.getEnumEncodedValue(FootNetwork.KEY, RouteNetwork.class), (EncodedValue.InitializerConfig)relConfig));
        }
        restrictionVehicleTypesByProfile.forEach((profile, restrictionVehicleTypes) -> osmParsers.addRestrictionTagParser(new RestrictionTagParser((List<String>)restrictionVehicleTypes, this.encodingManager.getTurnBooleanEncodedValue(TurnRestriction.key(profile)))));
        return osmParsers;
    }

    public static Map<String, PMap> parseEncodedValueString(String encodedValuesStr) {
        LinkedHashMap<String, PMap> encodedValuesWithProps = new LinkedHashMap<String, PMap>();
        Arrays.stream(encodedValuesStr.split(",")).filter(evStr -> !evStr.isBlank()).forEach(evStr -> {
            String key = evStr.trim().split("\\|")[0];
            if (encodedValuesWithProps.put(key, new PMap(evStr)) != null) {
                throw new IllegalArgumentException("duplicate encoded value in config graph.encoded_values: " + key);
            }
        });
        return encodedValuesWithProps;
    }

    private static Map<String, List<String>> getRestrictionVehicleTypesByProfile(Collection<Profile> profiles) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        for (Profile profile : profiles) {
            if (!profile.hasTurnCosts()) continue;
            result.put(profile.getName(), profile.getTurnCostsConfig().getVehicleTypes());
        }
        return result;
    }

    private static ElevationProvider createElevationProvider(GraphHopperConfig ghConfig) {
        String eleProviderStr = Helper.toLowerCase((String)ghConfig.getString("graph.elevation.provider", "noop"));
        if (ghConfig.has("graph.elevation.calcmean")) {
            throw new IllegalArgumentException("graph.elevation.calcmean is deprecated, use graph.elevation.interpolate");
        }
        String cacheDirStr = ghConfig.getString("graph.elevation.cache_dir", "");
        if (cacheDirStr.isEmpty() && ghConfig.has("graph.elevation.cachedir")) {
            throw new IllegalArgumentException("use graph.elevation.cache_dir not cachedir in configuration");
        }
        ElevationProvider elevationProvider = ElevationProvider.NOOP;
        if (eleProviderStr.equalsIgnoreCase("hgt")) {
            elevationProvider = new HGTProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("srtm")) {
            elevationProvider = new SRTMProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("cgiar")) {
            elevationProvider = new CGIARProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("gmted")) {
            elevationProvider = new GMTEDProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("srtmgl1")) {
            elevationProvider = new SRTMGL1Provider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("multi")) {
            elevationProvider = new MultiSourceElevationProvider(cacheDirStr);
        } else if (eleProviderStr.equalsIgnoreCase("skadi")) {
            elevationProvider = new SkadiProvider(cacheDirStr);
        }
        if (elevationProvider instanceof TileBasedElevationProvider) {
            TileBasedElevationProvider provider = (TileBasedElevationProvider)elevationProvider;
            String baseURL = ghConfig.getString("graph.elevation.base_url", "");
            if (baseURL.isEmpty() && ghConfig.has("graph.elevation.baseurl")) {
                throw new IllegalArgumentException("use graph.elevation.base_url not baseurl in configuration");
            }
            DAType elevationDAType = DAType.fromString(ghConfig.getString("graph.elevation.dataaccess", "MMAP"));
            boolean interpolate = ghConfig.has("graph.elevation.interpolate") ? "bilinear".equals(ghConfig.getString("graph.elevation.interpolate", "none")) : ghConfig.getBool("graph.elevation.calc_mean", false);
            boolean removeTempElevationFiles = ghConfig.getBool("graph.elevation.cgiar.clear", true);
            removeTempElevationFiles = ghConfig.getBool("graph.elevation.clear", removeTempElevationFiles);
            provider.setAutoRemoveTemporaryFiles(removeTempElevationFiles).setInterpolate(interpolate).setDAType(elevationDAType);
            if (!baseURL.isEmpty()) {
                provider.setBaseURL(baseURL);
            }
        }
        return elevationProvider;
    }

    private void printInfo() {
        logger.info("version " + Constants.VERSION + "|" + Constants.BUILD_DATE + " (" + Constants.getVersions() + ")");
        if (this.baseGraph != null) {
            logger.info("graph " + this.getBaseGraphString() + ", details:" + this.baseGraph.toDetailsString());
        }
    }

    private String getBaseGraphString() {
        return String.valueOf(this.encodingManager) + "|" + String.valueOf(this.baseGraph.getDirectory().getDefaultType()) + "|" + this.baseGraph.getNodeAccess().getDimension() + "D|" + String.valueOf(this.baseGraph.getTurnCostStorage() != null ? this.baseGraph.getTurnCostStorage() : "no_turn_cost") + "|" + this.getVersionsString();
    }

    private String getVersionsString() {
        return "nodes:9,edges:24,geometry:7,location_index:5,string_index:2,nodesCH:0,shortcuts:9";
    }

    public GraphHopper importOrLoad() {
        if (!this.load()) {
            this.printInfo();
            this.process(false);
        } else {
            this.printInfo();
        }
        return this;
    }

    public void importAndClose() {
        if (!this.load()) {
            this.printInfo();
            this.process(true);
        } else {
            this.printInfo();
            logger.info("Graph already imported into " + this.ghLocation);
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(boolean closeEarly) {
        this.prepareImport();
        if (this.encodingManager == null) {
            throw new IllegalStateException("The EncodingManager must be created in `prepareImport()`");
        }
        GHDirectory directory = new GHDirectory(this.ghLocation, this.dataAccessDefaultType);
        directory.configure(this.dataAccessConfig);
        this.baseGraph = new BaseGraph.Builder(this.getEncodingManager()).setDir(directory).set3D(this.hasElevation()).withTurnCosts(this.encodingManager.needsTurnCostsSupport()).setSegmentSize(this.defaultSegmentSize).build();
        this.properties = new StorableProperties(directory);
        this.checkProfilesConsistency();
        GHLock lock = null;
        try {
            if (directory.getDefaultType().isStoring()) {
                this.lockFactory.setLockDir(new File(this.ghLocation));
                lock = this.lockFactory.create("gh.lock", true);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid multiple writers we need to obtain a write lock but it failed. In " + this.ghLocation, lock.getObtainFailedReason());
                }
            }
            this.ensureWriteAccess();
            this.importOSM();
            this.postImportOSM();
            this.cleanUp();
            this.properties.put("profiles", this.getProfilesString());
            this.writeEncodingManagerToProperties();
            this.postProcessing(closeEarly);
            this.flush();
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    protected void prepareImport() {
        Map<String, PMap> encodedValuesWithProps = GraphHopper.parseEncodedValueString(this.encodedValuesString);
        NameValidator nameValidator = s -> this.importRegistry.createImportUnit(s) != null;
        LinkedHashSet missing = new LinkedHashSet();
        this.profilesByName.values().forEach(profile -> CustomModelParser.findVariablesForEncodedValuesString(profile.getCustomModel(), nameValidator, s -> "").forEach(var -> {
            if (!encodedValuesWithProps.containsKey(var)) {
                missing.add(var);
            }
            encodedValuesWithProps.putIfAbsent((String)var, new PMap());
        }));
        if (!missing.isEmpty()) {
            String encodedValuesString = encodedValuesWithProps.entrySet().stream().map(e -> (String)e.getKey() + (String)(((PMap)e.getValue()).isEmpty() ? "" : "|" + ((PMap)e.getValue()).toMap().entrySet().stream().map(p -> (String)p.getKey() + "=" + String.valueOf(p.getValue())).collect(Collectors.joining("|")))).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Encoded values missing: " + String.join((CharSequence)", ", missing) + ".\nTo avoid that certain encoded values are automatically removed when you change the custom model later, you need to set the encoded values manually:\ngraph.encoded_values: " + encodedValuesString);
        }
        encodedValuesWithProps.putIfAbsent("road_class", new PMap());
        encodedValuesWithProps.putIfAbsent("road_environment", new PMap());
        encodedValuesWithProps.putIfAbsent("roundabout", new PMap());
        encodedValuesWithProps.putIfAbsent(VehicleAccess.key("car"), new PMap());
        encodedValuesWithProps.putIfAbsent("road_class_link", new PMap());
        encodedValuesWithProps.putIfAbsent("max_speed", new PMap());
        Map<String, List<String>> restrictionVehicleTypesByProfile = GraphHopper.getRestrictionVehicleTypesByProfile(this.profilesByName.values());
        if (this.urbanDensityCalculationThreads > 0) {
            encodedValuesWithProps.put("urban_density", new PMap());
        }
        if (this.maxSpeedCalculator != null) {
            if (this.urbanDensityCalculationThreads <= 0) {
                throw new IllegalArgumentException("For max_speed_calculator the urban density calculation needs to be enabled (e.g. graph.urban_density.threads: 1)");
            }
            encodedValuesWithProps.put("max_speed_estimated", new PMap());
        }
        LinkedHashMap<String, ImportUnit> activeImportUnits = new LinkedHashMap<String, ImportUnit>();
        ArrayDeque<String> deque = new ArrayDeque<String>(encodedValuesWithProps.keySet());
        while (!deque.isEmpty()) {
            String ev = deque.removeFirst();
            ImportUnit importUnit = this.importRegistry.createImportUnit(ev);
            if (importUnit == null) {
                throw new IllegalArgumentException("Unknown encoded value: " + ev);
            }
            if (activeImportUnits.put(ev, importUnit) != null) continue;
            deque.addAll(importUnit.getRequiredImportUnits());
        }
        this.encodingManager = this.buildEncodingManager(encodedValuesWithProps, activeImportUnits, restrictionVehicleTypesByProfile);
        this.osmParsers = this.buildOSMParsers(encodedValuesWithProps, activeImportUnits, restrictionVehicleTypesByProfile, this.osmReaderConfig.getIgnoredHighways());
    }

    protected void postImportOSM() {
        this.calculateUrbanDensity();
        if (this.maxSpeedCalculator != null) {
            this.maxSpeedCalculator.fillMaxSpeed(this.getBaseGraph(), this.encodingManager);
            this.maxSpeedCalculator.close();
        }
        if (this.hasElevation()) {
            this.interpolateBridgesTunnelsAndFerries();
        }
        if (this.sortGraph) {
            GraphHopper.sortGraphAlongHilbertCurve(this.baseGraph);
        }
    }

    protected void importOSM() {
        if (this.osmFile == null) {
            throw new IllegalStateException("Couldn't load from existing folder: " + this.ghLocation + " but also cannot use file for DataReader as it wasn't specified!");
        }
        List<CustomArea> customAreas = GHUtility.readCountries();
        if (Helper.isEmpty((String)this.customAreasDirectory)) {
            logger.info("No custom areas are used, custom_areas.directory not given");
        } else {
            logger.info("Creating custom area index, reading custom areas from: '" + this.customAreasDirectory + "'");
            customAreas.addAll(this.readCustomAreas());
        }
        AreaIndex<CustomArea> areaIndex = new AreaIndex<CustomArea>(customAreas);
        if (this.countryRuleFactory == null || this.countryRuleFactory.getCountryToRuleMap().isEmpty()) {
            logger.info("No country rules available");
        } else {
            logger.info("Applying rules for the following countries: {}", this.countryRuleFactory.getCountryToRuleMap().keySet());
        }
        logger.info("start creating graph from " + this.osmFile);
        OSMReader reader = this.osmReaderSupplier.apply(this.baseGraph.getBaseGraph(), this.osmParsers, this.osmReaderConfig).setFile(this._getOSMFile()).setAreaIndex(areaIndex).setElevationProvider(this.eleProvider).setCountryRuleFactory(this.countryRuleFactory);
        logger.info("using " + this.getBaseGraphString() + ", memory:" + Helper.getMemInfo());
        this.createBaseGraphAndProperties();
        try {
            reader.readGraph();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot read file " + this.getOSMFile(), ex);
        }
        DateFormat f = Helper.createFormatter();
        this.properties.put("datareader.import.date", f.format(new Date()));
        if (reader.getDataDate() != null) {
            this.properties.put("datareader.data.date", f.format(reader.getDataDate()));
        }
    }

    protected void createBaseGraphAndProperties() {
        this.baseGraph.getDirectory().create();
        this.baseGraph.create(100L);
        this.properties.create(100L);
        if (this.maxSpeedCalculator != null) {
            this.maxSpeedCalculator.createDataAccessForParser(this.baseGraph.getDirectory());
        }
    }

    public static void sortGraphAlongHilbertCurve(BaseGraph graph) {
        logger.info("sorting graph along Hilbert curve...");
        StopWatch sw = StopWatch.started();
        NodeAccess na = graph.getNodeAccess();
        int order = 31;
        LongArrayList sortIndices = new LongArrayList();
        for (int node = 0; node < graph.getNodes(); ++node) {
            sortIndices.add(GraphHopper.latLonToHilbertIndex(na.getLat(node), na.getLon(node), 31));
        }
        int[] nodeOrder = IndirectSort.mergesort((int)0, (int)graph.getNodes(), (nodeA, nodeB) -> Long.compare(sortIndices.get(nodeA), sortIndices.get(nodeB)));
        EdgeExplorer explorer = graph.createEdgeExplorer();
        int edges = graph.getEdges();
        IntArrayList edgeOrder = new IntArrayList();
        BitSet edgesFound = new BitSet((long)edges);
        for (int node : nodeOrder) {
            EdgeIterator iter = explorer.setBaseNode(node);
            while (iter.next()) {
                if (edgesFound.get(iter.getEdge())) continue;
                edgeOrder.add(iter.getEdge());
                edgesFound.set((long)iter.getEdge());
            }
        }
        IntArrayList newEdgesByOldEdges = ArrayUtil.invert(edgeOrder);
        IntArrayList newNodesByOldNodes = IntArrayList.from((int[])ArrayUtil.invert(nodeOrder));
        logger.info("calculating sort order took: " + sw.stop().getTimeString());
        GraphHopper.sortGraphForGivenOrdering(graph, newNodesByOldNodes, newEdgesByOldEdges);
    }

    public static void sortGraphForGivenOrdering(BaseGraph baseGraph, IntArrayList newNodesByOldNodes, IntArrayList newEdgesByOldEdges) {
        if (!ArrayUtil.isPermutation(newEdgesByOldEdges)) {
            throw new IllegalStateException("New edges: not a permutation");
        }
        if (!ArrayUtil.isPermutation(newNodesByOldNodes)) {
            throw new IllegalStateException("New nodes: not a permutation");
        }
        logger.info("sort graph for fixed ordering...");
        StopWatch sw = new StopWatch().start();
        baseGraph.sortEdges(arg_0 -> ((IntArrayList)newEdgesByOldEdges).get(arg_0));
        logger.info("sorting {} edges took: {}", (Object)Helper.nf((long)newEdgesByOldEdges.size()), (Object)sw.stop().getTimeString());
        sw = new StopWatch().start();
        baseGraph.relabelNodes(arg_0 -> ((IntArrayList)newNodesByOldNodes).get(arg_0));
        logger.info("sorting {} nodes took: {}", (Object)Helper.nf((long)newNodesByOldNodes.size()), (Object)sw.stop().getTimeString());
    }

    public static long latLonToHilbertIndex(double lat, double lon, int order) {
        double nx = (lon + 180.0) / 360.0;
        double ny = (90.0 - lat) / 180.0;
        long size = 1L << order;
        long x = (long)(nx * (double)size);
        long y = (long)(ny * (double)size);
        x = Math.max(0L, Math.min(size - 1L, x));
        y = Math.max(0L, Math.min(size - 1L, y));
        return GraphHopper.xy2d(order, x, y);
    }

    public static long xy2d(int n, long x, long y) {
        long d = 0L;
        for (long s = 1L << n - 1; s > 0L; s >>= 1) {
            int rx = (x & s) > 0L ? 1 : 0;
            int ry = (y & s) > 0L ? 1 : 0;
            d += s * s * (long)(3 * rx ^ ry);
            if (ry != 0) continue;
            if (rx == 1) {
                x = s - 1L - x;
                y = s - 1L - y;
            }
            long tmp = x;
            x = y;
            y = tmp;
        }
        return d;
    }

    private void calculateUrbanDensity() {
        if (this.encodingManager.hasEncodedValue("urban_density")) {
            EnumEncodedValue<UrbanDensity> urbanDensityEnc = this.encodingManager.getEnumEncodedValue("urban_density", UrbanDensity.class);
            if (!this.encodingManager.hasEncodedValue("road_class")) {
                throw new IllegalArgumentException("Urban density calculation requires road_class");
            }
            if (!this.encodingManager.hasEncodedValue("road_class_link")) {
                throw new IllegalArgumentException("Urban density calculation requires road_class_link");
            }
            EnumEncodedValue<RoadClass> roadClassEnc = this.encodingManager.getEnumEncodedValue("road_class", RoadClass.class);
            BooleanEncodedValue roadClassLinkEnc = this.encodingManager.getBooleanEncodedValue("road_class_link");
            UrbanDensityCalculator.calcUrbanDensity(this.baseGraph, urbanDensityEnc, roadClassEnc, roadClassLinkEnc, this.residentialAreaRadius, this.residentialAreaSensitivity, this.cityAreaRadius, this.cityAreaSensitivity, this.urbanDensityCalculationThreads);
        }
    }

    private void writeEncodingManagerToProperties() {
        EncodingManager.putEncodingManagerIntoProperties(this.encodingManager, this.properties);
    }

    private List<CustomArea> readCustomAreas() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JtsModule());
        Path bordersDirectory = Paths.get(this.customAreasDirectory, new String[0]);
        ArrayList<JsonFeatureCollection> jsonFeatureCollections = new ArrayList<JsonFeatureCollection>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(bordersDirectory, "*.{geojson,json}");){
            for (Path borderFile : stream) {
                BufferedReader reader = Files.newBufferedReader(borderFile, StandardCharsets.UTF_8);
                try {
                    JsonFeatureCollection jsonFeatureCollection = (JsonFeatureCollection)objectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
                    jsonFeatureCollections.add(jsonFeatureCollection);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return jsonFeatureCollections.stream().flatMap(j -> j.getFeatures().stream()).map(CustomArea::fromJsonFeature).collect(Collectors.toList());
    }

    protected File _getOSMFile() {
        return new File(this.osmFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        if (Helper.isEmpty((String)this.ghLocation)) {
            throw new IllegalStateException("GraphHopperLocation is not specified. Call setGraphHopperLocation or init before");
        }
        if (this.fullyLoaded) {
            throw new IllegalStateException("graph is already successfully loaded");
        }
        File tmpFileOrFolder = new File(this.ghLocation);
        if (!tmpFileOrFolder.isDirectory() && tmpFileOrFolder.exists()) {
            throw new IllegalArgumentException("GraphHopperLocation cannot be an existing file. Has to be either non-existing or a folder.");
        }
        File compressed = new File(this.ghLocation + ".ghz");
        if (compressed.exists() && !compressed.isDirectory()) {
            try {
                new Unzipper().unzip(compressed.getAbsolutePath(), this.ghLocation, this.removeZipped);
            }
            catch (IOException ex) {
                throw new RuntimeException("Couldn't extract file " + compressed.getAbsolutePath() + " to " + this.ghLocation, ex);
            }
        }
        if (!this.allowWrites && this.dataAccessDefaultType.isMMap()) {
            this.dataAccessDefaultType = DAType.MMAP_RO;
        }
        if (!new File(this.ghLocation).exists()) {
            return false;
        }
        GHDirectory directory = new GHDirectory(this.ghLocation, this.dataAccessDefaultType);
        directory.configure(this.dataAccessConfig);
        GHLock lock = null;
        try {
            if (directory.getDefaultType().isStoring() && this.isAllowWrites()) {
                this.lockFactory.setLockDir(new File(this.ghLocation));
                lock = this.lockFactory.create("gh.lock", false);
                if (!lock.tryLock()) {
                    throw new RuntimeException("To avoid reading partial data we need to obtain the read lock but it failed. In " + this.ghLocation, lock.getObtainFailedReason());
                }
            }
            this.properties = new StorableProperties(directory);
            if (!this.properties.loadExisting()) {
                boolean bl = false;
                return bl;
            }
            this.encodingManager = EncodingManager.fromProperties(this.properties);
            this.baseGraph = new BaseGraph.Builder(this.encodingManager).setDir(directory).set3D(this.hasElevation()).withTurnCosts(this.encodingManager.needsTurnCostsSupport()).setSegmentSize(this.defaultSegmentSize).build();
            this.checkProfilesConsistency();
            this.baseGraph.loadExisting();
            String storedProfiles = this.properties.get("profiles");
            String configuredProfiles = this.getProfilesString();
            if (!storedProfiles.equals(configuredProfiles)) {
                throw new IllegalStateException("Profiles do not match:\nGraphhopper config: " + configuredProfiles + "\nGraph: " + storedProfiles + "\nChange configuration to match the graph or delete " + this.baseGraph.getDirectory().getLocation());
            }
            this.postProcessing(false);
            directory.loadMMap();
            this.setFullyLoaded();
            boolean bl = true;
            return bl;
        }
        finally {
            if (lock != null) {
                lock.release();
            }
        }
    }

    protected int getProfileHash(Profile profile) {
        return profile.getVersion();
    }

    private String getProfilesString() {
        return this.profilesByName.values().stream().map(p -> p.getName() + "|" + this.getProfileHash((Profile)p)).collect(Collectors.joining(","));
    }

    public void checkProfilesConsistency() {
        if (this.profilesByName.isEmpty()) {
            throw new IllegalArgumentException("There has to be at least one profile");
        }
        for (Profile profile : this.profilesByName.values()) {
            try {
                this.createWeighting(profile, new PMap());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not create weighting for profile: '" + profile.getName() + "'.\nProfile: " + String.valueOf(profile) + "\nError: " + e.getMessage());
            }
            if ("custom".equals(profile.getWeighting()) && profile.getCustomModel() == null) {
                throw new IllegalArgumentException("custom model for profile '" + profile.getName() + "' was empty");
            }
            if ("custom".equals(profile.getWeighting()) || profile.getCustomModel() == null) continue;
            throw new IllegalArgumentException("profile '" + profile.getName() + "' has a custom model but weighting=" + profile.getWeighting() + " was defined");
        }
        LinkedHashSet<String> chProfileSet = new LinkedHashSet<String>(this.chPreparationHandler.getCHProfiles().size());
        for (CHProfile chProfile : this.chPreparationHandler.getCHProfiles()) {
            boolean added = chProfileSet.add(chProfile.getProfile());
            if (!added) {
                throw new IllegalArgumentException("Duplicate CH reference to profile '" + chProfile.getProfile() + "'");
            }
            if (this.profilesByName.containsKey(chProfile.getProfile())) continue;
            throw new IllegalArgumentException("CH profile references unknown profile '" + chProfile.getProfile() + "'");
        }
        LinkedHashMap<String, LMProfile> linkedHashMap = new LinkedHashMap<String, LMProfile>(this.lmPreparationHandler.getLMProfiles().size());
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            LMProfile previous = linkedHashMap.put(lmProfile.getProfile(), lmProfile);
            if (previous != null) {
                throw new IllegalArgumentException("Multiple LM profiles are using the same profile '" + lmProfile.getProfile() + "'");
            }
            if (!this.profilesByName.containsKey(lmProfile.getProfile())) {
                throw new IllegalArgumentException("LM profile references unknown profile '" + lmProfile.getProfile() + "'");
            }
            if (!lmProfile.usesOtherPreparation() || this.profilesByName.containsKey(lmProfile.getPreparationProfile())) continue;
            throw new IllegalArgumentException("LM profile references unknown preparation profile '" + lmProfile.getPreparationProfile() + "'");
        }
        for (LMProfile lmProfile : this.lmPreparationHandler.getLMProfiles()) {
            if (lmProfile.usesOtherPreparation() && !linkedHashMap.containsKey(lmProfile.getPreparationProfile())) {
                throw new IllegalArgumentException("Unknown LM preparation profile '" + lmProfile.getPreparationProfile() + "' in LM profile '" + lmProfile.getProfile() + "' cannot be used as preparation_profile");
            }
            if (!lmProfile.usesOtherPreparation() || !((LMProfile)linkedHashMap.get(lmProfile.getPreparationProfile())).usesOtherPreparation()) continue;
            throw new IllegalArgumentException("Cannot use '" + lmProfile.getPreparationProfile() + "' as preparation_profile for LM profile '" + lmProfile.getProfile() + "', because it uses another profile for preparation itself.");
        }
    }

    public final CHPreparationHandler getCHPreparationHandler() {
        return this.chPreparationHandler;
    }

    private List<CHConfig> createCHConfigs(List<CHProfile> chProfiles) {
        ArrayList<CHConfig> chConfigs = new ArrayList<CHConfig>();
        for (CHProfile chProfile : chProfiles) {
            Profile profile = this.profilesByName.get(chProfile.getProfile());
            if (profile.hasTurnCosts()) {
                chConfigs.add(CHConfig.edgeBased(profile.getName(), this.createWeighting(profile, new PMap())));
                continue;
            }
            chConfigs.add(CHConfig.nodeBased(profile.getName(), this.createWeighting(profile, new PMap())));
        }
        return chConfigs;
    }

    public final LMPreparationHandler getLMPreparationHandler() {
        return this.lmPreparationHandler;
    }

    private List<LMConfig> createLMConfigs(List<LMProfile> lmProfiles) {
        ArrayList<LMConfig> lmConfigs = new ArrayList<LMConfig>();
        for (LMProfile lmProfile : lmProfiles) {
            if (lmProfile.usesOtherPreparation()) continue;
            Profile profile = this.profilesByName.get(lmProfile.getProfile());
            Weighting weighting = this.createWeighting(profile, new PMap(), true);
            lmConfigs.add(new LMConfig(profile.getName(), weighting));
        }
        return lmConfigs;
    }

    protected void postProcessing(boolean closeEarly) {
        boolean includesCustomProfiles;
        this.calcChecksums();
        this.initLocationIndex();
        this.importPublicTransit();
        if (closeEarly && !(includesCustomProfiles = this.profilesByName.values().stream().anyMatch(p -> "custom".equals(p.getWeighting())))) {
            this.baseGraph.flushAndCloseGeometryAndNameStorage();
        }
        if (this.lmPreparationHandler.isEnabled()) {
            this.loadOrPrepareLM(closeEarly);
        }
        if (closeEarly) {
            this.locationIndex.close();
        }
        if (this.chPreparationHandler.isEnabled()) {
            this.loadOrPrepareCH(closeEarly);
        }
    }

    protected void importPublicTransit() {
    }

    void interpolateBridgesTunnelsAndFerries() {
        if (this.encodingManager.hasEncodedValue("road_environment")) {
            EnumEncodedValue<RoadEnvironment> roadEnvEnc = this.encodingManager.getEnumEncodedValue("road_environment", RoadEnvironment.class);
            StopWatch sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.baseGraph.getBaseGraph(), roadEnvEnc, RoadEnvironment.TUNNEL).execute();
            float tunnel = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.baseGraph.getBaseGraph(), roadEnvEnc, RoadEnvironment.BRIDGE).execute();
            float bridge = sw.stop().getSeconds();
            sw = new StopWatch().start();
            new EdgeElevationInterpolator(this.baseGraph.getBaseGraph(), roadEnvEnc, RoadEnvironment.FERRY).execute();
            logger.info("Bridge interpolation " + (int)bridge + "s, tunnel interpolation " + (int)tunnel + "s, ferry interpolation " + (int)sw.stop().getSeconds() + "s");
        }
    }

    public final Weighting createWeighting(Profile profile, PMap hints) {
        return this.createWeighting(profile, hints, false);
    }

    public final Weighting createWeighting(Profile profile, PMap hints, boolean disableTurnCosts) {
        return this.createWeightingFactory().createWeighting(profile, hints, disableTurnCosts);
    }

    protected WeightingFactory createWeightingFactory() {
        return new DefaultWeightingFactory(this.baseGraph.getBaseGraph(), this.getEncodingManager());
    }

    public GHResponse route(GHRequest request) {
        return this.createRouter().route(request);
    }

    public Router createRouter() {
        if (this.baseGraph == null || !this.fullyLoaded) {
            throw new IllegalStateException("Do a successful call to load or importOrLoad before routing");
        }
        if (this.baseGraph.isClosed()) {
            throw new IllegalStateException("You need to create a new GraphHopper instance as it is already closed");
        }
        if (this.locationIndex == null) {
            throw new IllegalStateException("Location index not initialized");
        }
        return this.doCreateRouter(this.baseGraph, this.encodingManager, this.locationIndex, this.profilesByName, this.pathBuilderFactory, this.trMap, this.routerConfig, this.createWeightingFactory(), this.chGraphs, this.landmarks);
    }

    protected Router doCreateRouter(BaseGraph baseGraph, EncodingManager encodingManager, LocationIndex locationIndex, Map<String, Profile> profilesByName, PathDetailsBuilderFactory pathBuilderFactory, TranslationMap trMap, RouterConfig routerConfig, WeightingFactory weightingFactory, Map<String, RoutingCHGraph> chGraphs, Map<String, LandmarkStorage> landmarks) {
        return new Router(baseGraph, encodingManager, locationIndex, profilesByName, pathBuilderFactory, trMap, routerConfig, weightingFactory, chGraphs, landmarks);
    }

    protected LocationIndex createLocationIndex(Directory dir) {
        LocationIndexTree tmpIndex = new LocationIndexTree(this.baseGraph, dir);
        tmpIndex.setResolution(this.preciseIndexResolution);
        tmpIndex.setMaxRegionSearch(this.maxRegionSearch);
        if (!tmpIndex.loadExisting()) {
            this.ensureWriteAccess();
            tmpIndex.prepareIndex();
        }
        return tmpIndex;
    }

    private void calcChecksums() {
        if (!this.calcChecksums) {
            return;
        }
        logger.info("Calculating checksums for {} profiles", (Object)this.profilesByName.size());
        StopWatch sw = StopWatch.started();
        double[] checksums_fwd = new double[this.profilesByName.size()];
        double[] checksums_bwd = new double[this.profilesByName.size()];
        List<Weighting> weightings = this.profilesByName.values().stream().map(profile -> this.createWeighting((Profile)profile, new PMap())).toList();
        AllEdgesIterator edge = this.baseGraph.getAllEdges();
        while (edge.next()) {
            int i = 0;
            while (i < this.profilesByName.size()) {
                double weightFwd = weightings.get(i).calcEdgeWeight(edge, false);
                if (Double.isInfinite(weightFwd)) {
                    weightFwd = -1.0;
                }
                weightFwd *= i % 2 == 0 ? -1.0 : 1.0;
                double weightBwd = weightings.get(i).calcEdgeWeight(edge, true);
                if (Double.isInfinite(weightBwd)) {
                    weightBwd = -1.0;
                }
                double d = i % 2 == 0 ? -1.0 : 1.0;
                int n = i;
                checksums_fwd[n] = checksums_fwd[n] + weightFwd;
                int n2 = i++;
                checksums_bwd[n2] = checksums_bwd[n2] + (weightBwd *= d);
            }
        }
        int index = 0;
        for (Profile profile2 : this.profilesByName.values()) {
            this.properties.put("checksum.fwd." + profile2.getName(), checksums_fwd[index]);
            this.properties.put("checksum.bwd." + profile2.getName(), checksums_bwd[index]);
            logger.info("checksum.fwd." + profile2.getName() + ": " + checksums_fwd[index]);
            logger.info("checksum.bwd." + profile2.getName() + ": " + checksums_bwd[index]);
            ++index;
        }
        logger.info("Calculating checksums took: " + sw.stop().getTimeString());
    }

    protected void initLocationIndex() {
        if (this.locationIndex != null) {
            throw new IllegalStateException("Cannot initialize locationIndex twice!");
        }
        this.locationIndex = this.createLocationIndex(this.baseGraph.getDirectory());
    }

    private String getCHProfileVersion(String profile) {
        return this.properties.get("graph.profiles.ch." + profile + ".version");
    }

    private void setCHProfileVersion(String profile, int version) {
        this.properties.put("graph.profiles.ch." + profile + ".version", version);
    }

    private String getLMProfileVersion(String profile) {
        return this.properties.get("graph.profiles.lm." + profile + ".version");
    }

    private void setLMProfileVersion(String profile, int version) {
        this.properties.put("graph.profiles.lm." + profile + ".version", version);
    }

    protected void loadOrPrepareCH(boolean closeEarly) {
        for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
            if (this.getCHProfileVersion(profile.getProfile()).isEmpty() || this.getCHProfileVersion(profile.getProfile()).equals("" + this.getProfileHash(this.profilesByName.get(profile.getProfile())))) continue;
            throw new IllegalArgumentException("CH preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
        }
        List<CHConfig> chConfigs = this.createCHConfigs(this.chPreparationHandler.getCHProfiles());
        Map<String, RoutingCHGraph> loaded = this.chPreparationHandler.load(this.baseGraph.getBaseGraph(), chConfigs);
        List<CHConfig> configsToPrepare = chConfigs.stream().filter(c -> !loaded.containsKey(c.getName())).collect(Collectors.toList());
        Map<String, PrepareContractionHierarchies.Result> prepared = this.prepareCH(closeEarly, configsToPrepare);
        this.chGraphs = new LinkedHashMap<String, RoutingCHGraph>();
        for (CHProfile profile : this.chPreparationHandler.getCHProfiles()) {
            if (loaded.containsKey(profile.getProfile()) && prepared.containsKey(profile.getProfile())) {
                throw new IllegalStateException("CH graph should be either loaded or prepared, but not both: " + profile.getProfile());
            }
            if (prepared.containsKey(profile.getProfile())) {
                this.setCHProfileVersion(profile.getProfile(), this.getProfileHash(this.profilesByName.get(profile.getProfile())));
                PrepareContractionHierarchies.Result res = prepared.get(profile.getProfile());
                this.chGraphs.put(profile.getProfile(), RoutingCHGraphImpl.fromGraph(this.baseGraph.getBaseGraph(), res.getCHStorage(), res.getCHConfig()));
                continue;
            }
            if (loaded.containsKey(profile.getProfile())) {
                this.chGraphs.put(profile.getProfile(), loaded.get(profile.getProfile()));
                continue;
            }
            throw new IllegalStateException("CH graph should be either loaded or prepared: " + profile.getProfile());
        }
    }

    protected Map<String, PrepareContractionHierarchies.Result> prepareCH(boolean closeEarly, List<CHConfig> configsToPrepare) {
        if (!configsToPrepare.isEmpty()) {
            this.ensureWriteAccess();
        }
        if (!this.baseGraph.isFrozen()) {
            this.baseGraph.freeze();
        }
        return this.chPreparationHandler.prepare(this.baseGraph, this.properties, configsToPrepare, closeEarly);
    }

    protected void loadOrPrepareLM(boolean closeEarly) {
        for (LMProfile profile : this.lmPreparationHandler.getLMProfiles()) {
            if (this.getLMProfileVersion(profile.getProfile()).isEmpty() || this.getLMProfileVersion(profile.getProfile()).equals("" + this.getProfileHash(this.profilesByName.get(profile.getProfile())))) continue;
            throw new IllegalArgumentException("LM preparation of " + profile.getProfile() + " already exists in storage and doesn't match configuration");
        }
        List<LMConfig> lmConfigs = this.createLMConfigs(this.lmPreparationHandler.getLMProfiles());
        List<LandmarkStorage> loaded = this.lmPreparationHandler.load(lmConfigs, this.baseGraph, this.encodingManager);
        List<LMConfig> loadedConfigs = loaded.stream().map(LandmarkStorage::getLMConfig).toList();
        List<LMConfig> configsToPrepare = lmConfigs.stream().filter(c -> !loadedConfigs.contains(c)).collect(Collectors.toList());
        List<PrepareLandmarks> prepared = this.prepareLM(closeEarly, configsToPrepare);
        this.landmarks = new LinkedHashMap<String, LandmarkStorage>();
        for (LMProfile lmp : this.lmPreparationHandler.getLMProfiles()) {
            String prepProfile = lmp.usesOtherPreparation() ? lmp.getPreparationProfile() : lmp.getProfile();
            Optional<LandmarkStorage> loadedLMS = loaded.stream().filter(lms -> lms.getLMConfig().getName().equals(prepProfile)).findFirst();
            Optional<PrepareLandmarks> preparedLMS = prepared.stream().filter(pl -> pl.getLandmarkStorage().getLMConfig().getName().equals(prepProfile)).findFirst();
            if (loadedLMS.isPresent() && preparedLMS.isPresent()) {
                throw new IllegalStateException("LM should be either loaded or prepared, but not both: " + prepProfile);
            }
            if (preparedLMS.isPresent()) {
                this.setLMProfileVersion(lmp.getProfile(), this.getProfileHash(this.profilesByName.get(lmp.getProfile())));
                this.landmarks.put(lmp.getProfile(), preparedLMS.get().getLandmarkStorage());
                continue;
            }
            loadedLMS.ifPresent(landmarkStorage -> this.landmarks.put(lmp.getProfile(), (LandmarkStorage)landmarkStorage));
        }
    }

    protected List<PrepareLandmarks> prepareLM(boolean closeEarly, List<LMConfig> configsToPrepare) {
        if (!configsToPrepare.isEmpty()) {
            this.ensureWriteAccess();
        }
        if (!this.baseGraph.isFrozen()) {
            this.baseGraph.freeze();
        }
        return this.lmPreparationHandler.prepare(configsToPrepare, this.baseGraph, this.encodingManager, this.properties, this.locationIndex, closeEarly);
    }

    protected void cleanUp() {
        PrepareRoutingSubnetworks preparation = new PrepareRoutingSubnetworks(this.baseGraph.getBaseGraph(), this.buildSubnetworkRemovalJobs());
        preparation.setMinNetworkSize(this.minNetworkSize);
        preparation.setThreads(this.subnetworksThreads);
        preparation.doWork();
        logger.info("nodes: " + Helper.nf((long)this.baseGraph.getNodes()) + ", edges: " + Helper.nf((long)this.baseGraph.getEdges()));
    }

    protected List<PrepareRoutingSubnetworks.PrepareJob> buildSubnetworkRemovalJobs() {
        ArrayList<PrepareRoutingSubnetworks.PrepareJob> jobs = new ArrayList<PrepareRoutingSubnetworks.PrepareJob>();
        for (Profile profile : this.profilesByName.values()) {
            Weighting weighting = this.createWeighting(profile, new PMap().putObject("u_turn_costs", (Object)0));
            jobs.add(new PrepareRoutingSubnetworks.PrepareJob(this.encodingManager.getBooleanEncodedValue(Subnetwork.key(profile.getName())), weighting));
        }
        return jobs;
    }

    protected void flush() {
        logger.info("flushing graph " + this.getBaseGraphString() + ", details:" + this.baseGraph.toDetailsString() + ", " + Helper.getMemInfo() + ")");
        this.baseGraph.flush();
        this.properties.flush();
        logger.info("flushed graph " + Helper.getMemInfo() + ")");
        this.setFullyLoaded();
    }

    public void close() {
        if (this.baseGraph != null) {
            this.baseGraph.close();
        }
        if (this.properties != null) {
            this.properties.close();
        }
        this.chGraphs.values().forEach(RoutingCHGraph::close);
        this.landmarks.values().forEach(LandmarkStorage::close);
        if (this.locationIndex != null) {
            this.locationIndex.close();
        }
        try {
            this.lockFactory.forceRemove("gh.lock", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clean() {
        if (this.getGraphHopperLocation().isEmpty()) {
            throw new IllegalStateException("Cannot clean GraphHopper without specified graphHopperLocation");
        }
        File folder = new File(this.getGraphHopperLocation());
        Helper.removeDir((File)folder);
    }

    protected void ensureNotLoaded() {
        if (this.fullyLoaded) {
            throw new IllegalStateException("No configuration changes are possible after loading the graph");
        }
    }

    protected void ensureWriteAccess() {
        if (!this.allowWrites) {
            throw new IllegalStateException("Writes are not allowed!");
        }
    }

    private void setFullyLoaded() {
        this.fullyLoaded = true;
    }

    public boolean getFullyLoaded() {
        return this.fullyLoaded;
    }

    public RouterConfig getRouterConfig() {
        return this.routerConfig;
    }

    public OSMReaderConfig getReaderConfig() {
        return this.osmReaderConfig;
    }

    public static JsonFeatureCollection resolveCustomAreas(String customAreasDirectory) {
        JsonFeatureCollection globalAreas = new JsonFeatureCollection();
        if (!customAreasDirectory.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper().registerModule((Module)new JtsModule());
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(customAreasDirectory, new String[0]), "*.{geojson,json}");){
                StreamSupport.stream(stream.spliterator(), false).sorted(Comparator.comparing(Path::toString)).forEach(customAreaFile -> {
                    try (BufferedReader reader = Files.newBufferedReader(customAreaFile, StandardCharsets.UTF_8);){
                        globalAreas.getFeatures().addAll(((JsonFeatureCollection)mapper.readValue((Reader)reader, JsonFeatureCollection.class)).getFeatures());
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
                logger.info("Will make " + globalAreas.getFeatures().size() + " areas available to all custom profiles. Found in " + customAreasDirectory);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return globalAreas;
    }

    public static List<Profile> resolveCustomModelFiles(String customModelFolder, List<Profile> profiles, JsonFeatureCollection globalAreas) {
        ObjectMapper jsonOM = Jackson.newObjectMapper();
        ArrayList<Profile> newProfiles = new ArrayList<Profile>();
        for (Profile profile : profiles) {
            CustomModel customModel;
            if (!"custom".equals(profile.getWeighting())) {
                newProfiles.add(profile);
                continue;
            }
            Object cm = profile.getHints().getObject("custom_model", null);
            if (cm != null) {
                if (!((List)profile.getHints().getObject("custom_model_files", Collections.emptyList())).isEmpty()) {
                    throw new IllegalArgumentException("Do not use custom_model_files and custom_model together");
                }
                try {
                    customModel = (CustomModel)jsonOM.readValue(jsonOM.writeValueAsBytes(cm), CustomModel.class);
                    newProfiles.add(profile.setCustomModel(customModel));
                }
                catch (Exception ex) {
                    throw new RuntimeException("Cannot load custom_model from " + String.valueOf(cm) + " for profile " + profile.getName() + ". If you are trying to load from a file, use 'custom_model_files' instead.", ex);
                }
            } else {
                if (!profile.getHints().getString("custom_model_file", "").isEmpty()) {
                    throw new IllegalArgumentException("Since 8.0 you must use a custom_model_files array instead of custom_model_file string");
                }
                List customModelFileNames = (List)profile.getHints().getObject("custom_model_files", null);
                if (customModelFileNames == null) {
                    throw new IllegalArgumentException("Missing 'custom_model' or 'custom_model_files' field in profile '" + profile.getName() + "'. To use default specify custom_model_files: []");
                }
                if (customModelFileNames.isEmpty()) {
                    customModel = new CustomModel();
                    newProfiles.add(profile.setCustomModel(customModel));
                } else {
                    customModel = new CustomModel();
                    for (String file : customModelFileNames) {
                        if (file.contains(File.separator)) {
                            throw new IllegalArgumentException("Use custom_models.directory for the custom_model_files parent");
                        }
                        if (!file.endsWith(".json")) {
                            throw new IllegalArgumentException("Yaml is no longer supported, see #2672. Use JSON with optional comments //");
                        }
                        try {
                            String string;
                            InputStream is = GHUtility.class.getResourceAsStream("/com/graphhopper/custom_models/" + file);
                            Path customModelFile = Paths.get(customModelFolder, new String[0]).resolve(file);
                            if (is != null) {
                                if (Files.exists(customModelFile, new LinkOption[0])) {
                                    throw new RuntimeException("Custom model file name '" + file + "' is already used for built-in profiles. Use another name");
                                }
                                string = Helper.readJSONFileWithoutComments((InputStreamReader)new InputStreamReader(is));
                            } else {
                                string = Helper.readJSONFileWithoutComments((String)customModelFile.toFile().getAbsolutePath());
                            }
                            customModel = CustomModel.merge((CustomModel)customModel, (CustomModel)((CustomModel)jsonOM.readValue(string, CustomModel.class)));
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Cannot load custom_model from location " + file + ", profile:" + profile.getName(), ex);
                        }
                    }
                    newProfiles.add(profile.setCustomModel(customModel));
                }
            }
            customModel.addAreas(globalAreas);
        }
        return newProfiles;
    }
}

