/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.coll;

import com.graphhopper.coll.LongLongMap;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHLongLongBTree
implements LongLongMap {
    private static final Logger logger = LoggerFactory.getLogger(GHLongLongBTree.class);
    private final long emptyValue;
    private final int maxLeafEntries;
    private final int initLeafSize;
    private final int splitIndex;
    private final float factor;
    private long size;
    private int height;
    private BTreeEntry root;
    private final int bytesPerValue;
    private final long maxValue;

    public GHLongLongBTree(int maxLeafEntries, int bytesPerValue, long emptyValue) {
        this.maxLeafEntries = maxLeafEntries;
        this.bytesPerValue = bytesPerValue;
        if (bytesPerValue > 8) {
            throw new IllegalArgumentException("Values can have 8 bytes maximum but requested was " + bytesPerValue);
        }
        this.emptyValue = emptyValue;
        this.maxValue = (1L << bytesPerValue * 8 - 1) - 1L;
        if (maxLeafEntries < 1) {
            throw new IllegalArgumentException("illegal maxLeafEntries:" + maxLeafEntries);
        }
        if (maxLeafEntries % 2 == 0) {
            ++maxLeafEntries;
        }
        this.splitIndex = maxLeafEntries / 2;
        if (maxLeafEntries < 10) {
            this.factor = 2.0f;
            this.initLeafSize = 1;
        } else if (maxLeafEntries < 20) {
            this.factor = 2.0f;
            this.initLeafSize = 4;
        } else {
            this.factor = 1.7f;
            this.initLeafSize = maxLeafEntries / 10;
        }
        this.clear();
    }

    static int binarySearch(long[] keys, int start, int len, long key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = high + low >>> 1;
            long guessedKey = keys[guess];
            if (guessedKey < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        long highKey = keys[high];
        if (highKey == key) {
            return high;
        }
        return ~high;
    }

    @Override
    public long put(long key, long value) {
        if (value > this.maxValue) {
            throw new IllegalArgumentException("Value " + value + " exceeded max value: " + this.maxValue + ". Increase bytesPerValue (" + this.bytesPerValue + ")");
        }
        if (value == this.emptyValue) {
            throw new IllegalArgumentException("Value cannot be the 'empty value' " + this.emptyValue);
        }
        ReturnValue rv = this.root.put(key, value);
        if (rv.tree != null) {
            ++this.height;
            this.root = rv.tree;
        }
        if (rv.oldValue == null) {
            ++this.size;
            if (this.size % 1000000L == 0L) {
                this.optimize();
            }
        }
        return rv.oldValue == null ? this.emptyValue : this.toLong(rv.oldValue);
    }

    @Override
    public long get(long key) {
        return this.root.get(key);
    }

    int height() {
        return this.height;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public int getMemoryUsage() {
        return Math.round(this.root.getCapacity() / 0x100000L);
    }

    @Override
    public void clear() {
        this.size = 0L;
        this.height = 1;
        this.root = new BTreeEntry(this.initLeafSize, true);
    }

    public long getEmptyValue() {
        return this.emptyValue;
    }

    private int getEntries() {
        return this.root.getEntries();
    }

    @Override
    public void optimize() {
        if (this.getSize() > 10000L) {
            this.root.compact();
        }
    }

    public String toString() {
        return "Height:" + this.height() + ", entries:" + this.getEntries();
    }

    @Override
    public long getMaxValue() {
        return this.maxValue;
    }

    void print() {
        logger.info(this.root.toString(1));
    }

    long toLong(byte[] b) {
        return this.toLong(b, 0);
    }

    long toLong(byte[] bytes, int offset) {
        long res = 0L;
        if (this.bytesPerValue == 8) {
            res |= (long)bytes[offset + 7] << 56;
        } else if (this.bytesPerValue > 7) {
            res |= (long)bytes[offset + 7] << 56;
        }
        if (this.bytesPerValue == 7) {
            res |= (long)bytes[offset + 6] << 48;
        } else if (this.bytesPerValue > 6) {
            res |= ((long)bytes[offset + 6] & 0xFFL) << 48;
        }
        if (this.bytesPerValue == 6) {
            res |= (long)bytes[offset + 5] << 40;
        } else if (this.bytesPerValue > 5) {
            res |= ((long)bytes[offset + 5] & 0xFFL) << 40;
        }
        if (this.bytesPerValue == 5) {
            res |= (long)bytes[offset + 4] << 32;
        } else if (this.bytesPerValue > 4) {
            res |= ((long)bytes[offset + 4] & 0xFFL) << 32;
        }
        if (this.bytesPerValue == 4) {
            res |= (long)bytes[offset + 3] << 24;
        } else if (this.bytesPerValue > 3) {
            res |= ((long)bytes[offset + 3] & 0xFFL) << 24;
        }
        if (this.bytesPerValue == 3) {
            res |= (long)bytes[offset + 2] << 16;
        } else if (this.bytesPerValue > 2) {
            res |= ((long)bytes[offset + 2] & 0xFFL) << 16;
        }
        if (this.bytesPerValue == 2) {
            res |= (long)bytes[offset + 1] << 8;
        } else if (this.bytesPerValue > 1) {
            res |= ((long)bytes[offset + 1] & 0xFFL) << 8;
        }
        return res |= (long)bytes[offset] & 0xFFL;
    }

    final byte[] fromLong(long value) {
        byte[] bytes = new byte[this.bytesPerValue];
        this.fromLong(bytes, value, 0);
        return bytes;
    }

    final void fromLong(byte[] bytes, long value, int offset) {
        if (this.bytesPerValue > 7) {
            bytes[offset + 7] = (byte)(value >> 56);
        }
        if (this.bytesPerValue > 6) {
            bytes[offset + 6] = (byte)(value >> 48);
        }
        if (this.bytesPerValue > 5) {
            bytes[offset + 5] = (byte)(value >> 40);
        }
        if (this.bytesPerValue > 4) {
            bytes[offset + 4] = (byte)(value >> 32);
        }
        if (this.bytesPerValue > 3) {
            bytes[offset + 3] = (byte)(value >> 24);
        }
        if (this.bytesPerValue > 2) {
            bytes[offset + 2] = (byte)(value >> 16);
        }
        if (this.bytesPerValue > 1) {
            bytes[offset + 1] = (byte)(value >> 8);
        }
        bytes[offset] = (byte)value;
    }

    class BTreeEntry {
        int entrySize;
        long[] keys;
        byte[] values;
        BTreeEntry[] children;
        boolean isLeaf;

        public BTreeEntry(int tmpSize, boolean leaf) {
            this.isLeaf = leaf;
            this.keys = new long[tmpSize];
            this.values = new byte[tmpSize * GHLongLongBTree.this.bytesPerValue];
            if (!this.isLeaf) {
                this.children = new BTreeEntry[tmpSize + 1];
            }
        }

        ReturnValue put(long key, long newValue) {
            int index = GHLongLongBTree.binarySearch(this.keys, 0, this.entrySize, key);
            if (index >= 0) {
                byte[] oldValue = new byte[GHLongLongBTree.this.bytesPerValue];
                System.arraycopy(this.values, index * GHLongLongBTree.this.bytesPerValue, oldValue, 0, GHLongLongBTree.this.bytesPerValue);
                GHLongLongBTree.this.fromLong(this.values, newValue, index * GHLongLongBTree.this.bytesPerValue);
                return new ReturnValue(oldValue);
            }
            if (this.isLeaf || this.children[index ^= 0xFFFFFFFF] == null) {
                ReturnValue downTreeRV = new ReturnValue(null);
                downTreeRV.tree = this.checkSplitEntry();
                if (downTreeRV.tree == null) {
                    this.insertKeyValue(index, key, GHLongLongBTree.this.fromLong(newValue));
                } else if (index <= GHLongLongBTree.this.splitIndex) {
                    downTreeRV.tree.children[0].insertKeyValue(index, key, GHLongLongBTree.this.fromLong(newValue));
                } else {
                    downTreeRV.tree.children[1].insertKeyValue(index - GHLongLongBTree.this.splitIndex - 1, key, GHLongLongBTree.this.fromLong(newValue));
                }
                return downTreeRV;
            }
            ReturnValue downTreeRV = this.children[index].put(key, newValue);
            if (downTreeRV.oldValue != null) {
                return downTreeRV;
            }
            if (downTreeRV.tree != null) {
                BTreeEntry returnTree = this.checkSplitEntry();
                BTreeEntry downTree = returnTree;
                if (downTree == null) {
                    this.insertTree(index, downTreeRV.tree);
                } else if (index <= GHLongLongBTree.this.splitIndex) {
                    downTree.children[0].insertTree(index, downTreeRV.tree);
                } else {
                    downTree.children[1].insertTree(index - GHLongLongBTree.this.splitIndex - 1, downTreeRV.tree);
                }
                downTreeRV.tree = returnTree;
            }
            return downTreeRV;
        }

        BTreeEntry checkSplitEntry() {
            if (this.entrySize < GHLongLongBTree.this.maxLeafEntries) {
                return null;
            }
            int count = this.entrySize - GHLongLongBTree.this.splitIndex - 1;
            BTreeEntry newRightChild = new BTreeEntry(Math.max(GHLongLongBTree.this.initLeafSize, count), this.isLeaf);
            this.copy(this, newRightChild, GHLongLongBTree.this.splitIndex + 1, count);
            BTreeEntry newLeftChild = new BTreeEntry(Math.max(GHLongLongBTree.this.initLeafSize, GHLongLongBTree.this.splitIndex), this.isLeaf);
            this.copy(this, newLeftChild, 0, GHLongLongBTree.this.splitIndex);
            BTreeEntry newTree = new BTreeEntry(1, false);
            newTree.entrySize = 1;
            newTree.keys[0] = this.keys[GHLongLongBTree.this.splitIndex];
            System.arraycopy(this.values, GHLongLongBTree.this.splitIndex * GHLongLongBTree.this.bytesPerValue, newTree.values, 0, GHLongLongBTree.this.bytesPerValue);
            newTree.children[0] = newLeftChild;
            newTree.children[1] = newRightChild;
            return newTree;
        }

        void copy(BTreeEntry fromChild, BTreeEntry toChild, int from, int count) {
            System.arraycopy(fromChild.keys, from, toChild.keys, 0, count);
            System.arraycopy(fromChild.values, from * GHLongLongBTree.this.bytesPerValue, toChild.values, 0, count * GHLongLongBTree.this.bytesPerValue);
            if (!fromChild.isLeaf) {
                System.arraycopy(fromChild.children, from, toChild.children, 0, count + 1);
            }
            toChild.entrySize = count;
        }

        void insertKeyValue(int index, long key, byte[] newValueFromIdx0) {
            this.ensureSize(this.entrySize + 1);
            int count = this.entrySize - index;
            if (count > 0) {
                System.arraycopy(this.keys, index, this.keys, index + 1, count);
                System.arraycopy(this.values, index * GHLongLongBTree.this.bytesPerValue, this.values, index * GHLongLongBTree.this.bytesPerValue + GHLongLongBTree.this.bytesPerValue, count * GHLongLongBTree.this.bytesPerValue);
                if (!this.isLeaf) {
                    System.arraycopy(this.children, index + 1, this.children, index + 2, count);
                }
            }
            this.keys[index] = key;
            System.arraycopy(newValueFromIdx0, 0, this.values, index * GHLongLongBTree.this.bytesPerValue, GHLongLongBTree.this.bytesPerValue);
            ++this.entrySize;
        }

        void insertTree(int index, BTreeEntry tree) {
            this.insertKeyValue(index, tree.keys[0], tree.values);
            if (!this.isLeaf) {
                this.children[index] = tree.children[0];
                this.children[index + 1] = tree.children[1];
            }
        }

        long get(long key) {
            int index = GHLongLongBTree.binarySearch(this.keys, 0, this.entrySize, key);
            if (index >= 0) {
                return GHLongLongBTree.this.toLong(this.values, index * GHLongLongBTree.this.bytesPerValue);
            }
            if (this.isLeaf || this.children[index ^= 0xFFFFFFFF] == null) {
                return GHLongLongBTree.this.emptyValue;
            }
            return this.children[index].get(key);
        }

        long getCapacity() {
            long cap = this.keys.length * 12 + 36 + 4 + 1;
            if (!this.isLeaf) {
                cap += (long)(this.children.length * 4);
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) continue;
                    cap += this.children[i].getCapacity();
                }
            }
            return cap;
        }

        int getEntries() {
            int entries = 1;
            if (!this.isLeaf) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) continue;
                    entries += this.children[i].getEntries();
                }
            }
            return entries;
        }

        void ensureSize(int size) {
            if (size <= this.keys.length) {
                return;
            }
            int newSize = Math.min(GHLongLongBTree.this.maxLeafEntries, Math.max(size + 1, Math.round((float)size * GHLongLongBTree.this.factor)));
            this.keys = Arrays.copyOf(this.keys, newSize);
            this.values = Arrays.copyOf(this.values, newSize * GHLongLongBTree.this.bytesPerValue);
            if (!this.isLeaf) {
                this.children = Arrays.copyOf(this.children, newSize + 1);
            }
        }

        void compact() {
            int tolerance = 1;
            if (this.entrySize + tolerance < this.keys.length) {
                this.keys = Arrays.copyOf(this.keys, this.entrySize);
                this.values = Arrays.copyOf(this.values, this.entrySize * GHLongLongBTree.this.bytesPerValue);
                if (!this.isLeaf) {
                    this.children = Arrays.copyOf(this.children, this.entrySize + 1);
                }
            }
            if (!this.isLeaf) {
                for (int i = 0; i < this.children.length; ++i) {
                    if (this.children[i] == null) continue;
                    this.children[i].compact();
                }
            }
        }

        String toString(int height) {
            int i;
            String str = height + ": ";
            for (i = 0; i < this.entrySize; ++i) {
                if (i > 0) {
                    str = str + ",";
                }
                str = str + this.keys[i];
            }
            str = str + "\n";
            if (!this.isLeaf) {
                for (i = 0; i < this.entrySize + 1; ++i) {
                    if (this.children[i] == null) continue;
                    str = str + this.children[i].toString(height + 1) + "| ";
                }
            }
            return str;
        }
    }

    static class ReturnValue {
        byte[] oldValue;
        BTreeEntry tree;

        public ReturnValue(byte[] oldValue) {
            this.oldValue = oldValue;
        }
    }
}

