/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.reader.dem.HeightTile;
import com.graphhopper.reader.dem.TileBasedElevationProvider;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.util.Downloader;
import com.graphhopper.util.Helper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.SocketTimeoutException;

public abstract class AbstractSRTMElevationProvider
extends TileBasedElevationProvider {
    private final int DEFAULT_WIDTH;
    private final int MIN_LAT;
    private final int MAX_LAT;
    private final int WIDTH_BYTE_INDEX = 0;
    private final int DEGREE = 1;
    private final GHIntObjectHashMap<HeightTile> cacheData = new GHIntObjectHashMap();
    private final double precision = 1.0E7;
    private final double invPrecision = 1.0E-7;

    public AbstractSRTMElevationProvider(String baseUrl, String cacheDir, String downloaderName, int minLat, int maxLat, int defaultWidth) {
        super(cacheDir);
        this.baseUrl = baseUrl;
        this.downloader = new Downloader(downloaderName).setTimeout(10000);
        this.DEFAULT_WIDTH = defaultWidth;
        this.MIN_LAT = minLat;
        this.MAX_LAT = maxLat;
    }

    int calcIntKey(double lat, double lon) {
        return (this.down(lat) + 90) * 1000 + this.down(lon) + 180;
    }

    @Override
    public void release() {
        this.cacheData.clear();
        if (this.dir != null) {
            if (this.autoRemoveTemporary) {
                this.dir.clear();
            } else {
                this.dir.close();
            }
        }
    }

    int down(double val) {
        int intVal = (int)val;
        if (val >= 0.0 || (double)intVal - val < 1.0E-7) {
            return intVal;
        }
        return intVal - 1;
    }

    @Override
    public double getEle(double lat, double lon) {
        if (lat >= (double)this.MAX_LAT || lat <= (double)this.MIN_LAT) {
            return 0.0;
        }
        int intKey = this.calcIntKey(lat = (double)((int)(lat * 1.0E7)) / 1.0E7, lon = (double)((int)(lon * 1.0E7)) / 1.0E7);
        HeightTile demProvider = (HeightTile)this.cacheData.get(intKey);
        if (demProvider == null) {
            int width;
            if (!this.cacheDir.exists()) {
                this.cacheDir.mkdirs();
            }
            int minLat = this.down(lat);
            int minLon = this.down(lon);
            String fileName = this.getFileName(lat, lon);
            if (fileName == null || Helper.isEmpty((String)this.baseUrl) && !new File(fileName).exists()) {
                return 0.0;
            }
            DataAccess heights = this.getDirectory().create("dem" + intKey);
            boolean loadExisting = false;
            try {
                loadExisting = heights.loadExisting();
            }
            catch (Exception ex) {
                this.logger.warn("cannot load dem" + intKey + ", error:" + ex.getMessage());
            }
            if (!loadExisting) {
                try {
                    this.updateHeightsFromFile(lat, lon, heights);
                }
                catch (FileNotFoundException ex) {
                    demProvider = new HeightTile(minLat, minLon, this.DEFAULT_WIDTH, this.DEFAULT_WIDTH, 1.0E7, 1, 1);
                    this.cacheData.put(intKey, demProvider);
                    demProvider.setHeights(heights);
                    demProvider.setSeaLevel(true);
                    heights.create(10L).flush();
                    return 0.0;
                }
            }
            if ((width = (int)(Math.sqrt(heights.getHeader(0)) + 0.5)) == 0) {
                width = this.DEFAULT_WIDTH;
            }
            demProvider = new HeightTile(minLat, minLon, width, width, 1.0E7, 1, 1);
            this.cacheData.put(intKey, demProvider);
            demProvider.setInterpolate(this.interpolate);
            demProvider.setHeights(heights);
        }
        if (demProvider.isSeaLevel()) {
            return 0.0;
        }
        return demProvider.getHeight(lat, lon);
    }

    private void updateHeightsFromFile(double lat, double lon, DataAccess heights) throws FileNotFoundException {
        try {
            String zippedURL = this.baseUrl + this.getDownloadURL(lat, lon);
            File zipFile = new File(this.cacheDir, new File(zippedURL).getName());
            if (!zipFile.exists()) {
                this.downloadToFile(zipFile, zippedURL);
            }
            byte[] bytes = this.readFile(zipFile);
            heights.create(bytes.length);
            for (int bytePos = 0; bytePos < bytes.length; bytePos += 2) {
                short val = this.toShort(bytes, bytePos);
                if (val < -1000 || val > 12000) {
                    val = Short.MIN_VALUE;
                }
                heights.setShort(bytePos, val);
            }
            heights.setHeader(0, bytes.length / 2);
            heights.flush();
        }
        catch (FileNotFoundException ex) {
            this.logger.warn("File not found " + String.valueOf(heights) + " for the coordinates " + lat + "," + lon);
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("There was an issue with " + String.valueOf(heights) + " looking up the coordinates " + lat + "," + lon, ex);
        }
    }

    final short toShort(byte[] b, int offset) {
        return (short)((b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF);
    }

    private void downloadToFile(File file, String zippedURL) throws InterruptedException, IOException {
        for (int i = 0; i < 3; ++i) {
            try {
                this.downloader.downloadFile(zippedURL, file.getAbsolutePath());
                break;
            }
            catch (SocketTimeoutException ex) {
                Thread.sleep(2000L);
                continue;
            }
            catch (FileNotFoundException ex) {
                if (zippedURL.contains(".hgt.zip")) {
                    zippedURL = zippedURL.replace(".hgt.zip", "hgt.zip");
                    continue;
                }
                throw ex;
            }
        }
    }

    protected String getPaddedLonString(int lonInt) {
        Object lonString;
        Object object = lonString = (lonInt = Math.abs(lonInt)) < 100 ? "0" : "";
        if (lonInt < 10) {
            lonString = (String)lonString + "0";
        }
        lonString = (String)lonString + lonInt;
        return lonString;
    }

    protected String getPaddedLatString(int latInt) {
        Object latString = (latInt = Math.abs(latInt)) < 10 ? "0" : "";
        latString = (String)latString + latInt;
        return latString;
    }

    abstract byte[] readFile(File var1) throws IOException;

    abstract String getFileName(double var1, double var3);

    abstract String getDownloadURL(double var1, double var3);
}

