/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PointList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeElevationSmoothingRamer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeElevationSmoothingRamer.class);

    public static void smooth(PointList pointList, double maxElevationDelta) {
        EdgeElevationSmoothingRamer.internSmooth(pointList, 0, pointList.size() - 1, maxElevationDelta, DistanceCalcEarth.calcDistance(pointList, false), 0);
    }

    static void internSmooth(PointList pointList, int fromIndex, int lastIndex, double maxElevationDelta, double fullDist2D, int depth) {
        double lon;
        double lat;
        int i;
        if (lastIndex - fromIndex < 2) {
            return;
        }
        if (depth > 1000) {
            LOGGER.warn("max recursion depth reached, remaining point list: " + String.valueOf(pointList));
            return;
        }
        double prevLat = pointList.getLat(fromIndex);
        double prevLon = pointList.getLon(fromIndex);
        double averageSlope = fullDist2D == 0.0 ? 0.0 : (pointList.getEle(lastIndex) - pointList.getEle(fromIndex)) / fullDist2D;
        double prevAverageSlopeEle = pointList.getEle(fromIndex);
        double startDist = 0.0;
        double maxEleDelta = -1.0;
        int indexWithMaxDelta = -1;
        for (i = fromIndex + 1; i < lastIndex; ++i) {
            lat = pointList.getLat(i);
            lon = pointList.getLon(i);
            double ele = pointList.getEle(i);
            double tmpDist2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon, lat, lon);
            startDist += tmpDist2D;
            double eleFromAverageSlope = averageSlope * tmpDist2D + prevAverageSlopeEle;
            double tmpEleDelta = Math.abs(ele - eleFromAverageSlope);
            if (maxEleDelta < tmpEleDelta) {
                indexWithMaxDelta = i;
                maxEleDelta = tmpEleDelta;
            }
            prevAverageSlopeEle = eleFromAverageSlope;
            prevLat = lat;
            prevLon = lon;
        }
        if (indexWithMaxDelta < 0 || maxElevationDelta > maxEleDelta) {
            prevLat = pointList.getLat(fromIndex);
            prevLon = pointList.getLon(fromIndex);
            prevAverageSlopeEle = pointList.getEle(fromIndex);
            for (i = fromIndex + 1; i < lastIndex; ++i) {
                lat = pointList.getLat(i);
                lon = pointList.getLon(i);
                double tmpDist2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon, lat, lon);
                double eleFromAverageSlope = averageSlope * tmpDist2D + prevAverageSlopeEle;
                pointList.setElevation(i, eleFromAverageSlope);
                prevAverageSlopeEle = eleFromAverageSlope;
                prevLat = lat;
                prevLon = lon;
            }
        } else {
            EdgeElevationSmoothingRamer.internSmooth(pointList, fromIndex, indexWithMaxDelta, maxElevationDelta, startDist, depth + 1);
            EdgeElevationSmoothingRamer.internSmooth(pointList, indexWithMaxDelta, lastIndex, maxElevationDelta, Math.max(0.0, fullDist2D - startDist), depth + 1);
        }
    }
}

