/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.dem;

import com.graphhopper.reader.dem.AbstractSRTMElevationProvider;
import com.graphhopper.util.Helper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipInputStream;

public class HGTProvider
extends AbstractSRTMElevationProvider {
    public HGTProvider(String dir) {
        super("", dir, "", Integer.MIN_VALUE, Integer.MAX_VALUE, 3601);
    }

    @Override
    byte[] readFile(File file) throws IOException {
        int len;
        InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
        ZipInputStream zis = new ZipInputStream(is);
        zis.getNextEntry();
        BufferedInputStream buff = new BufferedInputStream(zis);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[65535];
        while ((len = buff.read(buffer)) > 0) {
            os.write(buffer, 0, len);
        }
        os.flush();
        Helper.close((Closeable)buff);
        return os.toByteArray();
    }

    @Override
    String getFileName(double lat, double lon) {
        int latInt = (int)Math.floor(lat);
        int lonInt = (int)Math.floor(lon);
        return String.valueOf(this.cacheDir) + "/" + (lat > 0.0 ? "N" : "S") + this.getPaddedLatString(latInt) + (lon > 0.0 ? "E" : "W") + this.getPaddedLonString(lonInt) + ".hgt.zip";
    }

    @Override
    String getDownloadURL(double lat, double lon) {
        return this.getFileName(lat, lon);
    }
}

