/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.LongScatterSet;
import com.carrotsearch.hppc.LongSet;
import com.graphhopper.coll.GHLongLongBTree;
import com.graphhopper.coll.LongLongMap;
import com.graphhopper.reader.ReaderNode;
import com.graphhopper.reader.osm.PillarInfo;
import com.graphhopper.reader.osm.SegmentNode;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.Directory;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint3D;
import java.util.Collections;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;

public class OSMNodeData {
    static final long JUNCTION_NODE = -2L;
    static final long EMPTY_NODE = -1L;
    static final long END_NODE = 0L;
    static final long INTERMEDIATE_NODE = 1L;
    static final long CONNECTION_NODE = 2L;
    private final LongLongMap idsByOsmNodeIds = new GHLongLongBTree(200, 5, -1L);
    private final PillarInfo pillarNodes;
    private final PointAccess towerNodes;
    private final LongLongMap nodeTagIndicesByOsmNodeIds;
    private final KVStorage nodeKVStorage;
    private final LongSet nodesToBeSplit;
    private int nextTowerId = 0;
    private long nextPillarId = 0L;
    private long nextArtificialOSMNodeId = -9223372036854775807L;

    public OSMNodeData(PointAccess nodeAccess, Directory directory) {
        this.towerNodes = nodeAccess;
        this.pillarNodes = new PillarInfo(this.towerNodes.is3D(), directory);
        this.nodeTagIndicesByOsmNodeIds = new GHLongLongBTree(200, 4, -1L);
        this.nodesToBeSplit = new LongScatterSet();
        this.nodeKVStorage = new KVStorage(directory, false).create(100L);
    }

    public boolean is3D() {
        return this.towerNodes.is3D();
    }

    public long getId(long osmNodeId) {
        return this.idsByOsmNodeIds.get(osmNodeId);
    }

    public static boolean isTowerNode(long id) {
        return id < -2L;
    }

    public static boolean isPillarNode(long id) {
        return id > 2L;
    }

    public static boolean isNodeId(long id) {
        return id > 2L || id < -2L;
    }

    public void setOrUpdateNodeType(long osmNodeId, long newNodeType, LongUnaryOperator nodeTypeUpdate) {
        long curr = this.idsByOsmNodeIds.get(osmNodeId);
        if (curr == -1L) {
            this.idsByOsmNodeIds.put(osmNodeId, newNodeType);
        } else {
            this.idsByOsmNodeIds.put(osmNodeId, nodeTypeUpdate.applyAsLong(curr));
        }
    }

    public long getNodeCount() {
        return this.idsByOsmNodeIds.getSize();
    }

    public long getTaggedNodeCount() {
        return this.nodeTagIndicesByOsmNodeIds.getSize();
    }

    public long getNodeTagCapacity() {
        return this.nodeKVStorage.getCapacity();
    }

    public long addCoordinatesIfMapped(long osmNodeId, double lat, double lon, DoubleSupplier getEle) {
        long nodeType = this.idsByOsmNodeIds.get(osmNodeId);
        if (nodeType == -1L) {
            return nodeType;
        }
        if (nodeType == -2L || nodeType == 2L) {
            this.addTowerNode(osmNodeId, lat, lon, getEle.getAsDouble());
        } else if (nodeType == 1L || nodeType == 0L) {
            this.addPillarNode(osmNodeId, lat, lon, getEle.getAsDouble());
        } else {
            throw new IllegalStateException("Unknown node type: " + nodeType + ", or coordinates already set. Possibly duplicate OSM node ID: " + osmNodeId);
        }
        return nodeType;
    }

    private long addTowerNode(long osmId, double lat, double lon, double ele) {
        this.towerNodes.setNode(this.nextTowerId, lat, lon, ele);
        long id = OSMNodeData.towerNodeToId(this.nextTowerId);
        this.idsByOsmNodeIds.put(osmId, id);
        ++this.nextTowerId;
        if (this.nextTowerId == Integer.MAX_VALUE) {
            throw new IllegalStateException("Tower node id overflow, too many tower nodes");
        }
        return id;
    }

    private long addPillarNode(long osmId, double lat, double lon, double ele) {
        long id = this.pillarNodeToId(this.nextPillarId);
        if (id > this.idsByOsmNodeIds.getMaxValue()) {
            throw new IllegalStateException("id for pillar node cannot be bigger than " + this.idsByOsmNodeIds.getMaxValue());
        }
        this.pillarNodes.setNode(this.nextPillarId, lat, lon, ele);
        this.idsByOsmNodeIds.put(osmId, id);
        ++this.nextPillarId;
        return id;
    }

    SegmentNode addCopyOfNode(SegmentNode node) {
        long newOsmId;
        GHPoint3D point = this.getCoordinates(node.id);
        if (point == null) {
            throw new IllegalStateException("Cannot copy node : " + node.osmNodeId + ", because it is missing");
        }
        if (this.idsByOsmNodeIds.put(newOsmId = this.nextArtificialOSMNodeId++, 1L) != -1L) {
            throw new IllegalStateException("Artificial osm node id already exists: " + newOsmId);
        }
        long id = this.addPillarNode(newOsmId, point.getLat(), point.getLon(), point.getEle());
        return new SegmentNode(newOsmId, id, node.tags);
    }

    long convertPillarToTowerNode(long id, long osmNodeId) {
        if (!OSMNodeData.isPillarNode(id)) {
            throw new IllegalArgumentException("Not a pillar node: " + id);
        }
        long pillar = this.idToPillarNode(id);
        double lat = this.pillarNodes.getLat(pillar);
        double lon = this.pillarNodes.getLon(pillar);
        double ele = this.pillarNodes.getEle(pillar);
        if (lat == Double.MAX_VALUE || lon == Double.MAX_VALUE) {
            throw new IllegalStateException("Pillar node was already converted to tower node: " + id);
        }
        this.pillarNodes.setNode(pillar, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        return this.addTowerNode(osmNodeId, lat, lon, ele);
    }

    public GHPoint3D getCoordinates(long id) {
        if (OSMNodeData.isTowerNode(id)) {
            int tower = this.idToTowerNode(id);
            return this.towerNodes.is3D() ? new GHPoint3D(this.towerNodes.getLat(tower), this.towerNodes.getLon(tower), this.towerNodes.getEle(tower)) : new GHPoint3D(this.towerNodes.getLat(tower), this.towerNodes.getLon(tower), Double.NaN);
        }
        if (OSMNodeData.isPillarNode(id)) {
            long pillar = this.idToPillarNode(id);
            return this.pillarNodes.is3D() ? new GHPoint3D(this.pillarNodes.getLat(pillar), this.pillarNodes.getLon(pillar), this.pillarNodes.getEle(pillar)) : new GHPoint3D(this.pillarNodes.getLat(pillar), this.pillarNodes.getLon(pillar), Double.NaN);
        }
        return null;
    }

    public void addCoordinatesToPointList(long id, PointList pointList) {
        double lon;
        double lat;
        double ele = Double.NaN;
        if (OSMNodeData.isTowerNode(id)) {
            int tower = this.idToTowerNode(id);
            lat = this.towerNodes.getLat(tower);
            lon = this.towerNodes.getLon(tower);
            if (this.towerNodes.is3D()) {
                ele = this.towerNodes.getEle(tower);
            }
        } else if (OSMNodeData.isPillarNode(id)) {
            long pillar = this.idToPillarNode(id);
            lat = this.pillarNodes.getLat(pillar);
            lon = this.pillarNodes.getLon(pillar);
            if (this.pillarNodes.is3D()) {
                ele = this.pillarNodes.getEle(pillar);
            }
        } else {
            throw new IllegalArgumentException();
        }
        pointList.add(lat, lon, ele);
    }

    public void setTags(ReaderNode node) {
        long pointer;
        int tagIndex = Math.toIntExact(this.nodeTagIndicesByOsmNodeIds.get(node.getId()));
        if (tagIndex == -1) {
            pointer = this.nodeKVStorage.add(node.getTags().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new KVStorage.KValue(e.getValue() instanceof String ? KVStorage.cutString((String)e.getValue()) : e.getValue()))));
            if (pointer > Integer.MAX_VALUE) {
                throw new IllegalStateException("Too many key value pairs are stored in node tags, was " + pointer);
            }
        } else {
            throw new IllegalStateException("Cannot add tags twice, duplicate node OSM ID: " + node.getId());
        }
        this.nodeTagIndicesByOsmNodeIds.put(node.getId(), (int)pointer);
    }

    public Map<String, Object> getTags(long osmNodeId) {
        int tagIndex = Math.toIntExact(this.nodeTagIndicesByOsmNodeIds.get(osmNodeId));
        if (tagIndex < 0) {
            return Collections.emptyMap();
        }
        return this.nodeKVStorage.getMap(tagIndex);
    }

    public void release() {
        this.idsByOsmNodeIds.clear();
        this.pillarNodes.clear();
        this.nodeTagIndicesByOsmNodeIds.clear();
        this.nodeKVStorage.clear();
        this.nodesToBeSplit.clear();
    }

    public static long towerNodeToId(int towerId) {
        return -towerId - 3;
    }

    public int idToTowerNode(long id) {
        if (-id - 3L > Integer.MAX_VALUE) {
            throw new IllegalStateException("Invalid tower node id: " + id + ", limit exceeded");
        }
        return Math.toIntExact(-id - 3L);
    }

    public long pillarNodeToId(long pillarId) {
        return pillarId + 3L;
    }

    public long idToPillarNode(long id) {
        return id - 3L;
    }

    public boolean setSplitNode(long osmNodeId) {
        return this.nodesToBeSplit.add(osmNodeId);
    }

    public void unsetSplitNode(long osmNodeId) {
        int removed = this.nodesToBeSplit.removeAll(osmNodeId);
        if (removed == 0) {
            throw new IllegalStateException("Node " + osmNodeId + " was not a split node");
        }
    }

    public boolean isSplitNode(long osmNodeId) {
        return this.nodesToBeSplit.contains(osmNodeId);
    }
}

