/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.reader.osm;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongContainer;

public class RestrictionMembers {
    private final boolean isViaWay;
    private final long viaOSMNode;
    private final LongArrayList fromWays;
    private final LongArrayList viaWays;
    private final LongArrayList toWays;

    public static RestrictionMembers viaNode(long viaOSMNode, LongArrayList fromWays, LongArrayList toWays) {
        return new RestrictionMembers(false, viaOSMNode, fromWays, null, toWays);
    }

    public static RestrictionMembers viaWay(LongArrayList fromWays, LongArrayList viaWays, LongArrayList toWays) {
        return new RestrictionMembers(true, -1L, fromWays, viaWays, toWays);
    }

    private RestrictionMembers(boolean isViaWay, long viaOSMNode, LongArrayList fromWays, LongArrayList viaWays, LongArrayList toWays) {
        this.isViaWay = isViaWay;
        this.viaOSMNode = viaOSMNode;
        this.fromWays = fromWays;
        this.viaWays = viaWays;
        this.toWays = toWays;
    }

    public boolean isViaWay() {
        return this.isViaWay;
    }

    public long getViaOSMNode() {
        return this.viaOSMNode;
    }

    public LongArrayList getFromWays() {
        return this.fromWays;
    }

    public LongArrayList getViaWays() {
        return this.viaWays;
    }

    public LongArrayList getToWays() {
        return this.toWays;
    }

    public LongArrayList getAllWays() {
        LongArrayList result = new LongArrayList(this.fromWays.size() + this.toWays.size() + (this.isViaWay ? this.viaWays.size() : 0));
        result.addAll((LongContainer)this.fromWays);
        if (this.isViaWay) {
            result.addAll((LongContainer)this.viaWays);
        }
        result.addAll((LongContainer)this.toWays);
        return result;
    }
}

