/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.coll.GHIntObjectHashMap;
import com.graphhopper.routing.AStarBidirection;
import com.graphhopper.routing.DefaultBidirPathExtractor;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.RoutingAlgorithm;
import com.graphhopper.routing.SPTEntry;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class AlternativeRoute
extends AStarBidirection
implements RoutingAlgorithm {
    private static final Comparator<AlternativeInfo> ALT_COMPARATOR = Comparator.comparingDouble(o -> o.sortBy);
    private final int maxPaths;
    private final double explorationFactor;
    private final double maxWeightFactor;
    private final double maxShareFactor;
    private final double minPlateauFactor;

    public AlternativeRoute(Graph graph, Weighting weighting, TraversalMode traversalMode, PMap hints) {
        super(graph, weighting, traversalMode);
        if (weighting.hasTurnCosts() && !traversalMode.isEdgeBased()) {
            throw new IllegalStateException("Weightings supporting turn costs cannot be used with node-based traversal mode");
        }
        this.maxPaths = hints.getInt("alternative_route.max_paths", 2);
        if (this.maxPaths < 2) {
            throw new IllegalArgumentException("Use normal algorithm with less overhead instead if no alternatives are required");
        }
        this.explorationFactor = hints.getDouble("alternative_route.max_exploration_factor", 1.12);
        this.maxWeightFactor = hints.getDouble("alternative_route.max_weight_factor", 1.25);
        this.maxShareFactor = hints.getDouble("alternative_route.max_share_factor", 0.6);
        this.minPlateauFactor = hints.getDouble("alternative_route.min_plateau_factor", 0.1);
    }

    static List<String> getAltNames(Graph graph, SPTEntry ee) {
        if (ee == null || !EdgeIterator.Edge.isValid(ee.edge)) {
            return Collections.emptyList();
        }
        EdgeIteratorState iter = graph.getEdgeIteratorState(ee.edge, Integer.MIN_VALUE);
        if (iter == null) {
            return Collections.emptyList();
        }
        String str = iter.getName();
        if (str.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(str);
    }

    static double calcSortBy(double weightInfluence, double weight, double shareInfluence, double shareWeight, double plateauInfluence, double plateauWeight) {
        return weightInfluence * weight + shareInfluence * shareWeight + plateauInfluence * plateauWeight;
    }

    public List<AlternativeInfo> calcAlternatives(int from, int to) {
        Path bestPath = this.searchBest(from, to);
        return this.calcAlternatives(bestPath, this.maxPaths, this.maxWeightFactor, 7.0, this.maxShareFactor, 0.8, this.minPlateauFactor, -0.2);
    }

    @Override
    public List<Path> calcPaths(int from, int to) {
        this.checkAlreadyRun();
        this.setupFinishTime();
        List<AlternativeInfo> alternatives = this.calcAlternatives(from, to);
        ArrayList<Path> paths = new ArrayList<Path>(alternatives.size());
        for (AlternativeInfo a : alternatives) {
            paths.add(a.getPath());
        }
        return paths;
    }

    @Override
    public String getName() {
        return "alternative_route";
    }

    @Override
    public boolean finished() {
        if (this.finishedFrom && this.finishedTo) {
            return true;
        }
        if (this.isMaxVisitedNodesExceeded() || this.isTimeoutExceeded()) {
            return true;
        }
        if (this.finishedFrom || this.finishedTo) {
            return true;
        }
        return this.currFrom.weight + this.currTo.weight > this.explorationFactor * (this.bestWeight + this.stoppingCriterionOffset);
    }

    public Path searchBest(int from, int to) {
        this.init(from, 0.0, to, 0.0);
        this.runAlgo();
        return this.extractPath();
    }

    public List<AlternativeInfo> calcAlternatives(Path bestPath, final int maxPaths, double maxWeightFactor, final double weightInfluence, final double maxShareFactor, final double shareInfluence, final double minPlateauFactor, final double plateauInfluence) {
        final double maxWeight = maxWeightFactor * this.bestWeight;
        final GHIntObjectHashMap<IntSet> traversalIdMap = new GHIntObjectHashMap<IntSet>();
        final AtomicInteger startTID = this.addToMap(traversalIdMap, bestPath);
        final ArrayList<AlternativeInfo> alternatives = new ArrayList<AlternativeInfo>(maxPaths);
        double bestPlateau = this.bestWeight;
        double bestShare = 0.0;
        double sortBy = AlternativeRoute.calcSortBy(weightInfluence, this.bestWeight, shareInfluence, bestShare, plateauInfluence, bestPlateau);
        final AlternativeInfo bestAlt = new AlternativeInfo(sortBy, bestPath, this.bestFwdEntry, this.bestBwdEntry, bestShare, AlternativeRoute.getAltNames(this.graph, this.bestFwdEntry));
        alternatives.add(bestAlt);
        final AtomicReference bestEntry = new AtomicReference();
        this.bestWeightMapFrom.forEach((IntObjectPredicate)new IntObjectPredicate<SPTEntry>(){

            public boolean apply(int traversalId, SPTEntry fromSPTEntry) {
                boolean smallShare;
                int nextFromTraversalId;
                SPTEntry otherFromEntry;
                SPTEntry tmpFromEntry;
                SPTEntry toSPTEntry = (SPTEntry)AlternativeRoute.this.bestWeightMapTo.get(traversalId);
                if (toSPTEntry == null) {
                    return true;
                }
                if (AlternativeRoute.this.traversalMode.isEdgeBased() && toSPTEntry.parent != null) {
                    toSPTEntry = toSPTEntry.parent;
                }
                if (fromSPTEntry.edge == toSPTEntry.edge) {
                    return true;
                }
                double weight = fromSPTEntry.getWeightOfVisitedPath() + toSPTEntry.getWeightOfVisitedPath() + AlternativeRoute.this.weighting.calcTurnWeight(fromSPTEntry.edge, fromSPTEntry.adjNode, toSPTEntry.edge);
                if (weight > maxWeight) {
                    return true;
                }
                if (this.isBestPath(fromSPTEntry)) {
                    return true;
                }
                SPTEntry sPTEntry = tmpFromEntry = AlternativeRoute.this.traversalMode.isEdgeBased() ? fromSPTEntry.parent : fromSPTEntry;
                if (tmpFromEntry == null || tmpFromEntry.parent == null) {
                    assert (AlternativeRoute.this.traversalMode.isEdgeBased());
                } else {
                    int nextToTraversalId = AlternativeRoute.this.traversalMode.createTraversalId(AlternativeRoute.this.graph.getEdgeIteratorState(tmpFromEntry.edge, tmpFromEntry.parent.adjNode), true);
                    SPTEntry correspondingToEntry = (SPTEntry)AlternativeRoute.this.bestWeightMapTo.get(nextToTraversalId);
                    if (correspondingToEntry != null) {
                        if (AlternativeRoute.this.traversalMode.isEdgeBased()) {
                            correspondingToEntry = correspondingToEntry.parent;
                        }
                        if (correspondingToEntry.edge == fromSPTEntry.edge) {
                            return true;
                        }
                    }
                }
                double plateauWeight = 0.0;
                SPTEntry prevToSPTEntry = toSPTEntry;
                SPTEntry prevFrom = fromSPTEntry;
                while (prevToSPTEntry.parent != null && (otherFromEntry = (SPTEntry)AlternativeRoute.this.bestWeightMapFrom.get(nextFromTraversalId = AlternativeRoute.this.traversalMode.createTraversalId(AlternativeRoute.this.graph.getEdgeIteratorState(prevToSPTEntry.edge, prevToSPTEntry.parent.adjNode), false))) != null && otherFromEntry.parent == prevFrom && otherFromEntry.edge == prevToSPTEntry.edge) {
                    prevFrom = otherFromEntry;
                    plateauWeight += prevToSPTEntry.getWeightOfVisitedPath() - prevToSPTEntry.parent.getWeightOfVisitedPath();
                    prevToSPTEntry = prevToSPTEntry.parent;
                }
                if (plateauWeight <= 0.0 || plateauWeight / weight < minPlateauFactor) {
                    return true;
                }
                if (fromSPTEntry.parent == null) {
                    throw new IllegalStateException("not implemented yet. in case of an edge based traversal the parent of fromSPTEntry could be null");
                }
                SPTEntry fromEE = this.getFirstShareEE(fromSPTEntry.parent, true);
                SPTEntry toEE = this.getFirstShareEE(toSPTEntry.parent, false);
                double shareWeight = fromEE.getWeightOfVisitedPath() + toEE.getWeightOfVisitedPath();
                boolean bl = smallShare = shareWeight / AlternativeRoute.this.bestWeight < maxShareFactor;
                if (smallShare) {
                    double worstSortBy;
                    List<String> altNames = AlternativeRoute.getAltNames(AlternativeRoute.this.graph, fromSPTEntry);
                    double sortBy = AlternativeRoute.calcSortBy(weightInfluence, weight, shareInfluence, shareWeight, plateauInfluence, plateauWeight);
                    if (sortBy < (worstSortBy = this.getWorstSortBy()) || alternatives.size() < maxPaths) {
                        Path path = DefaultBidirPathExtractor.extractPath(AlternativeRoute.this.graph, AlternativeRoute.this.weighting, fromSPTEntry, toSPTEntry, weight);
                        alternatives.add(new AlternativeInfo(sortBy, path, fromEE, toEE, shareWeight, altNames));
                        Collections.sort(alternatives, ALT_COMPARATOR);
                        if (alternatives.get(0) != bestAlt) {
                            throw new IllegalStateException("best path should be always first entry " + bestAlt.path.getWeight() + " vs " + ((AlternativeInfo)alternatives.get((int)0)).path.getWeight());
                        }
                        if (alternatives.size() > maxPaths) {
                            alternatives.subList(maxPaths, alternatives.size()).clear();
                        }
                    }
                }
                return true;
            }

            SPTEntry getFirstShareEE(SPTEntry startEE, boolean reverse) {
                while (startEE.parent != null) {
                    int tid = AlternativeRoute.this.traversalMode.createTraversalId(AlternativeRoute.this.graph.getEdgeIteratorState(startEE.edge, startEE.parent.adjNode), reverse);
                    if (this.isAlreadyExisting(tid)) {
                        return startEE;
                    }
                    startEE = startEE.parent;
                }
                return startEE;
            }

            boolean isAlreadyExisting(final int tid) {
                final AtomicBoolean exists = new AtomicBoolean(false);
                traversalIdMap.forEach((IntObjectPredicate)new IntObjectPredicate<IntSet>(){

                    public boolean apply(int key, IntSet set) {
                        if (set.contains(tid)) {
                            exists.set(true);
                            return false;
                        }
                        return true;
                    }
                });
                return exists.get();
            }

            double getWorstSortBy() {
                if (alternatives.isEmpty()) {
                    throw new IllegalStateException("Empty alternative list cannot happen");
                }
                return ((AlternativeInfo)alternatives.get((int)(alternatives.size() - 1))).sortBy;
            }

            boolean isBestPath(SPTEntry fromSPTEntry) {
                if (AlternativeRoute.this.traversalMode.isEdgeBased()) {
                    if (GHUtility.getEdgeFromEdgeKey(startTID.get()) == fromSPTEntry.edge) {
                        if (fromSPTEntry.parent == null) {
                            throw new IllegalStateException("best path must have no parent but was non-null: " + String.valueOf(fromSPTEntry));
                        }
                        if (bestEntry.get() != null && ((SPTEntry)bestEntry.get()).edge != fromSPTEntry.edge) {
                            throw new IllegalStateException("there can be only one best entry but was " + String.valueOf(fromSPTEntry) + " vs old: " + String.valueOf(bestEntry.get()) + " " + String.valueOf(AlternativeRoute.this.graph.getEdgeIteratorState(fromSPTEntry.edge, fromSPTEntry.adjNode).fetchWayGeometry(FetchMode.ALL)));
                        }
                        bestEntry.set(fromSPTEntry);
                        return true;
                    }
                } else if (fromSPTEntry.parent == null) {
                    if (startTID.get() != fromSPTEntry.adjNode) {
                        throw new IllegalStateException("Start traversal ID has to be identical to root edge entry which is the plateau start of the best path but was: " + String.valueOf(startTID) + " vs. adjNode: " + fromSPTEntry.adjNode);
                    }
                    if (bestEntry.get() != null) {
                        throw new IllegalStateException("there can be only one best entry but was " + String.valueOf(fromSPTEntry) + " vs old: " + String.valueOf(bestEntry.get()) + " " + String.valueOf(AlternativeRoute.this.graph.getEdgeIteratorState(fromSPTEntry.edge, fromSPTEntry.adjNode).fetchWayGeometry(FetchMode.ALL)));
                    }
                    bestEntry.set(fromSPTEntry);
                    return true;
                }
                return false;
            }
        });
        return alternatives;
    }

    AtomicInteger addToMap(GHIntObjectHashMap<IntSet> map, Path path) {
        GHIntHashSet set = new GHIntHashSet();
        AtomicInteger startTID = new AtomicInteger(-1);
        for (EdgeIteratorState iterState : path.calcEdges()) {
            int tid = this.traversalMode.createTraversalId(iterState, false);
            set.add(tid);
            if (startTID.get() >= 0) continue;
            if (!this.traversalMode.isEdgeBased()) {
                tid = iterState.getBaseNode();
                set.add(tid);
            }
            startTID.set(tid);
        }
        map.put(startTID.get(), (Object)set);
        return startTID;
    }

    public static class AlternativeInfo {
        private final double sortBy;
        private final Path path;
        private final SPTEntry shareStart;
        private final SPTEntry shareEnd;
        private final double shareWeight;
        private final List<String> names;

        public AlternativeInfo(double sortBy, Path path, SPTEntry shareStart, SPTEntry shareEnd, double shareWeight, List<String> altNames) {
            this.names = altNames;
            this.sortBy = sortBy;
            this.path = path;
            this.path.setDescription(this.names);
            this.shareStart = shareStart;
            this.shareEnd = shareEnd;
            this.shareWeight = shareWeight;
        }

        public Path getPath() {
            return this.path;
        }

        public SPTEntry getShareStart() {
            return this.shareStart;
        }

        public SPTEntry getShareEnd() {
            return this.shareEnd;
        }

        public double getShareWeight() {
            return this.shareWeight;
        }

        public double getSortBy() {
            return this.sortBy;
        }

        public String toString() {
            return String.valueOf(this.names) + ", sortBy:" + this.sortBy + ", shareWeight:" + this.shareWeight + ", " + String.valueOf(this.path);
        }
    }
}

