/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing;

import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.util.AngleCalc;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.GHPoint;

class InstructionsHelper {
    InstructionsHelper() {
    }

    static double calculateOrientationDelta(double prevLatitude, double prevLongitude, double latitude, double longitude, double prevOrientation) {
        double orientation = AngleCalc.ANGLE_CALC.calcOrientation(prevLatitude, prevLongitude, latitude, longitude, false);
        orientation = AngleCalc.ANGLE_CALC.alignOrientation(prevOrientation, orientation);
        return orientation - prevOrientation;
    }

    static int calculateSign(double prevLatitude, double prevLongitude, double latitude, double longitude, double prevOrientation) {
        double delta = InstructionsHelper.calculateOrientationDelta(prevLatitude, prevLongitude, latitude, longitude, prevOrientation);
        double absDelta = Math.abs(delta);
        if (absDelta < 0.2) {
            return 0;
        }
        if (absDelta < 0.8) {
            if (delta > 0.0) {
                return -1;
            }
            return 1;
        }
        if (absDelta < 1.8) {
            if (delta > 0.0) {
                return -2;
            }
            return 2;
        }
        if (delta > 0.0) {
            return -3;
        }
        return 3;
    }

    static boolean isSameName(String name1, String name2) {
        if (name1 == null || name2 == null || name1.isEmpty() || name2.isEmpty()) {
            return false;
        }
        return name1.equals(name2);
    }

    static GHPoint getPointForOrientationCalculation(EdgeIteratorState edgeIteratorState, NodeAccess nodeAccess) {
        double tmpLon;
        double tmpLat;
        PointList tmpWayGeo = edgeIteratorState.fetchWayGeometry(FetchMode.ALL);
        if (tmpWayGeo.size() <= 2) {
            tmpLat = nodeAccess.getLat(edgeIteratorState.getAdjNode());
            tmpLon = nodeAccess.getLon(edgeIteratorState.getAdjNode());
        } else {
            tmpLat = tmpWayGeo.getLat(1);
            tmpLon = tmpWayGeo.getLon(1);
        }
        return new GHPoint(tmpLat, tmpLon);
    }

    static boolean isToFerry(RoadEnvironment re, RoadEnvironment prev) {
        return re == RoadEnvironment.FERRY && re != prev;
    }

    static boolean isFromFerry(RoadEnvironment re, RoadEnvironment prev) {
        return prev == RoadEnvironment.FERRY && re != prev;
    }

    static String createFerryInfo(RoadEnvironment re, RoadEnvironment prev) {
        if (re == prev) {
            return null;
        }
        if (re == RoadEnvironment.FERRY) {
            return "board_ferry";
        }
        if (prev == RoadEnvironment.FERRY) {
            return "leave_ferry";
        }
        return null;
    }
}

