/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.graphhopper.routing.AStarBidirectionCH;
import com.graphhopper.routing.AStarBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.AlternativeRouteCH;
import com.graphhopper.routing.AlternativeRouteEdgeCH;
import com.graphhopper.routing.DijkstraBidirectionCH;
import com.graphhopper.routing.DijkstraBidirectionCHNoSOD;
import com.graphhopper.routing.DijkstraBidirectionEdgeCHNoSOD;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.RoutingAlgorithmFactorySimple;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.querygraph.QueryRoutingCHGraph;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class CHRoutingAlgorithmFactory {
    private final RoutingCHGraph routingCHGraph;

    public CHRoutingAlgorithmFactory(RoutingCHGraph routingCHGraph, QueryGraph queryGraph) {
        this(new QueryRoutingCHGraph(routingCHGraph, queryGraph));
    }

    public CHRoutingAlgorithmFactory(RoutingCHGraph routingCHGraph) {
        this.routingCHGraph = routingCHGraph;
    }

    public EdgeToEdgeRoutingAlgorithm createAlgo(PMap opts) {
        EdgeToEdgeRoutingAlgorithm algo;
        EdgeToEdgeRoutingAlgorithm edgeToEdgeRoutingAlgorithm = algo = this.routingCHGraph.isEdgeBased() ? this.createAlgoEdgeBased(this.routingCHGraph, opts) : this.createAlgoNodeBased(this.routingCHGraph, opts);
        if (opts.has("max_visited_nodes")) {
            algo.setMaxVisitedNodes(opts.getInt("max_visited_nodes", Integer.MAX_VALUE));
        }
        if (opts.has("timeout_ms")) {
            algo.setTimeoutMillis(opts.getLong("timeout_ms", Long.MAX_VALUE));
        }
        return algo;
    }

    private EdgeToEdgeRoutingAlgorithm createAlgoEdgeBased(RoutingCHGraph g, PMap opts) {
        String defaultAlgo = "astarbi";
        String algo = opts.getString("algorithm", defaultAlgo);
        if (Helper.isEmpty((String)algo)) {
            algo = defaultAlgo;
        }
        if ("astarbi".equals(algo)) {
            return new AStarBidirectionEdgeCHNoSOD(g).setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts, this.getWeighting(), g.getBaseGraph().getNodeAccess()));
        }
        if ("dijkstrabi".equals(algo)) {
            return new DijkstraBidirectionEdgeCHNoSOD(g);
        }
        if ("alternative_route".equalsIgnoreCase(algo)) {
            return new AlternativeRouteEdgeCH(g, opts);
        }
        throw new IllegalArgumentException("Algorithm " + algo + " not supported for edge-based Contraction Hierarchies. Try with ch.disable=true");
    }

    private EdgeToEdgeRoutingAlgorithm createAlgoNodeBased(RoutingCHGraph g, PMap opts) {
        String defaultAlgo = "dijkstrabi";
        String algo = opts.getString("algorithm", defaultAlgo);
        if (Helper.isEmpty((String)algo)) {
            algo = defaultAlgo;
        }
        if ("astarbi".equals(algo)) {
            return new AStarBidirectionCH(g).setApproximation(RoutingAlgorithmFactorySimple.getApproximation("astarbi", opts, this.getWeighting(), g.getBaseGraph().getNodeAccess()));
        }
        if ("dijkstrabi".equals(algo) || Helper.isEmpty((String)algo)) {
            if (opts.getBool("stall_on_demand", true)) {
                return new DijkstraBidirectionCH(g);
            }
            return new DijkstraBidirectionCHNoSOD(g);
        }
        if ("alternative_route".equalsIgnoreCase(algo)) {
            return new AlternativeRouteCH(g, opts);
        }
        throw new IllegalArgumentException("Algorithm " + algo + " not supported for node-based Contraction Hierarchies. Try with ch.disable=true");
    }

    private Weighting getWeighting() {
        return this.routingCHGraph.getWeighting();
    }
}

