/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ch;

import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.graphhopper.routing.ch.BridgePathFinder;
import com.graphhopper.routing.ch.CHPreparationGraph;
import com.graphhopper.routing.ch.EdgeBasedWitnessPathSearcher;
import com.graphhopper.routing.ch.NodeContractor;
import com.graphhopper.routing.ch.PrepareCHEntry;
import com.graphhopper.routing.ch.PrepareEncoder;
import com.graphhopper.routing.ch.PrepareGraphEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphEdgeIterator;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeExplorer;
import com.graphhopper.routing.ch.PrepareGraphOrigEdgeIterator;
import com.graphhopper.storage.CHStorageBuilder;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;
import com.graphhopper.util.StopWatch;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EdgeBasedNodeContractor
implements NodeContractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdgeBasedNodeContractor.class);
    private final CHPreparationGraph prepareGraph;
    private PrepareGraphEdgeExplorer inEdgeExplorer;
    private PrepareGraphEdgeExplorer outEdgeExplorer;
    private PrepareGraphEdgeExplorer existingShortcutExplorer;
    private PrepareGraphOrigEdgeExplorer sourceNodeOrigInEdgeExplorer;
    private CHStorageBuilder chBuilder;
    private final Params params = new Params();
    private final StopWatch dijkstraSW = new StopWatch();
    private final IntSet sourceNodes = new IntHashSet(10);
    private final IntSet targetNodes = new IntHashSet(10);
    private final LongSet addedShortcuts = new LongHashSet();
    private final Stats addingStats = new Stats();
    private final Stats countingStats = new Stats();
    private Stats activeStats;
    private int[] hierarchyDepths;
    private EdgeBasedWitnessPathSearcher witnessPathSearcher;
    private BridgePathFinder bridgePathFinder;
    private final EdgeBasedWitnessPathSearcher.Stats wpsStatsHeur = new EdgeBasedWitnessPathSearcher.Stats();
    private final EdgeBasedWitnessPathSearcher.Stats wpsStatsContr = new EdgeBasedWitnessPathSearcher.Stats();
    private int addedShortcutsCount;
    private int numShortcuts;
    private int numPrevEdges;
    private int numOrigEdges;
    private int numPrevOrigEdges;
    private int numAllEdges;
    private double meanDegree;

    public EdgeBasedNodeContractor(CHPreparationGraph prepareGraph, CHStorageBuilder chBuilder, PMap pMap) {
        this.prepareGraph = prepareGraph;
        this.chBuilder = chBuilder;
        this.extractParams(pMap);
    }

    private void extractParams(PMap pMap) {
        this.params.edgeQuotientWeight = pMap.getFloat("prepare.ch.edge.edge_quotient_weight", this.params.edgeQuotientWeight);
        this.params.originalEdgeQuotientWeight = pMap.getFloat("prepare.ch.edge.original_edge_quotient_weight", this.params.originalEdgeQuotientWeight);
        this.params.hierarchyDepthWeight = pMap.getFloat("prepare.ch.edge.hierarchy_depth_weight", this.params.hierarchyDepthWeight);
        this.params.maxPollFactorHeuristic = pMap.getDouble("prepare.ch.edge.max_poll_factor_heuristic", this.params.maxPollFactorHeuristic);
        this.params.maxPollFactorContraction = pMap.getDouble("prepare.ch.edge.max_poll_factor_contraction", this.params.maxPollFactorContraction);
    }

    @Override
    public void initFromGraph() {
        this.inEdgeExplorer = this.prepareGraph.createInEdgeExplorer();
        this.outEdgeExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.existingShortcutExplorer = this.prepareGraph.createOutEdgeExplorer();
        this.sourceNodeOrigInEdgeExplorer = this.prepareGraph.createInOrigEdgeExplorer();
        this.hierarchyDepths = new int[this.prepareGraph.getNodes()];
        this.witnessPathSearcher = new EdgeBasedWitnessPathSearcher(this.prepareGraph);
        this.bridgePathFinder = new BridgePathFinder(this.prepareGraph);
        this.meanDegree = (double)this.prepareGraph.getOriginalEdges() * 1.0 / (double)this.prepareGraph.getNodes();
    }

    @Override
    public float calculatePriority(int node) {
        this.activeStats = this.countingStats;
        this.resetEdgeCounters();
        this.countPreviousEdges(node);
        if (this.numAllEdges == 0) {
            return Float.NEGATIVE_INFINITY;
        }
        this.stats().stopWatch.start();
        this.findAndHandlePrepareShortcuts(node, this::countShortcuts, (int)(this.meanDegree * this.params.maxPollFactorHeuristic), this.wpsStatsHeur);
        this.stats().stopWatch.stop();
        float edgeQuotient = (float)this.numShortcuts / (float)this.prepareGraph.getDegree(node);
        float origEdgeQuotient = (float)this.numOrigEdges / (float)this.numPrevOrigEdges;
        int hierarchyDepth = this.hierarchyDepths[node];
        float priority = this.params.edgeQuotientWeight * edgeQuotient + this.params.originalEdgeQuotientWeight * origEdgeQuotient + this.params.hierarchyDepthWeight * (float)hierarchyDepth;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("node: {}, eq: {} / {} = {}, oeq: {} / {} = {}, depth: {} --> {}", new Object[]{node, this.numShortcuts, this.numPrevEdges, Float.valueOf(edgeQuotient), this.numOrigEdges, this.numPrevOrigEdges, Float.valueOf(origEdgeQuotient), hierarchyDepth, Float.valueOf(priority)});
        }
        return priority;
    }

    @Override
    public IntContainer contractNode(int node) {
        this.activeStats = this.addingStats;
        this.stats().stopWatch.start();
        this.findAndHandlePrepareShortcuts(node, this::addShortcutsToPrepareGraph, (int)(this.meanDegree * this.params.maxPollFactorContraction), this.wpsStatsContr);
        this.insertShortcuts(node);
        IntContainer neighbors = this.prepareGraph.disconnect(node);
        this.meanDegree = (this.meanDegree * 2.0 + (double)neighbors.size()) / 3.0;
        this.updateHierarchyDepthsOfNeighbors(node, neighbors);
        this.stats().stopWatch.stop();
        return neighbors;
    }

    @Override
    public void finishContraction() {
        this.chBuilder.replaceSkippedEdges(this.prepareGraph::getShortcutForPrepareEdge);
    }

    @Override
    public long getAddedShortcutsCount() {
        return this.addedShortcutsCount;
    }

    @Override
    public float getDijkstraSeconds() {
        return this.dijkstraSW.getCurrentSeconds();
    }

    @Override
    public String getStatisticsString() {
        return String.format(Locale.ROOT, "degree_approx: %3.1f", this.meanDegree) + ", priority   : " + String.valueOf(this.countingStats) + ", " + String.valueOf(this.wpsStatsHeur) + ", contraction: " + String.valueOf(this.addingStats) + ", " + String.valueOf(this.wpsStatsContr);
    }

    private void findAndHandlePrepareShortcuts(int node, PrepareShortcutHandler shortcutHandler, int maxPolls, EdgeBasedWitnessPathSearcher.Stats wpsStats) {
        ++this.stats().nodes;
        this.addedShortcuts.clear();
        this.sourceNodes.clear();
        PrepareGraphEdgeIterator incomingEdges = this.inEdgeExplorer.setBaseNode(node);
        while (incomingEdges.next()) {
            int sourceNode = incomingEdges.getAdjNode();
            if (sourceNode == node || !this.sourceNodes.add(sourceNode)) continue;
            PrepareGraphOrigEdgeIterator origInIter = this.sourceNodeOrigInEdgeExplorer.setBaseNode(sourceNode);
            while (origInIter.next()) {
                int origInKey = GHUtility.reverseEdgeKey(origInIter.getOrigEdgeKeyLast());
                IntObjectMap<BridgePathFinder.BridePathEntry> bridgePaths = this.bridgePathFinder.find(origInKey, sourceNode, node);
                if (bridgePaths.isEmpty()) continue;
                this.witnessPathSearcher.initSearch(origInKey, sourceNode, node, wpsStats);
                for (IntObjectCursor bridgePath : bridgePaths) {
                    if (!Double.isFinite(((BridgePathFinder.BridePathEntry)bridgePath.value).weight)) {
                        throw new IllegalStateException("Bridge entry weights should always be finite");
                    }
                    int targetEdgeKey = bridgePath.key;
                    this.dijkstraSW.start();
                    double weight = this.witnessPathSearcher.runSearch(((BridgePathFinder.BridePathEntry)bridgePath.value).chEntry.adjNode, targetEdgeKey, ((BridgePathFinder.BridePathEntry)bridgePath.value).weight, maxPolls);
                    this.dijkstraSW.stop();
                    if (weight <= ((BridgePathFinder.BridePathEntry)bridgePath.value).weight) continue;
                    PrepareCHEntry root = ((BridgePathFinder.BridePathEntry)bridgePath.value).chEntry;
                    while (EdgeIterator.Edge.isValid(root.parent.prepareEdge)) {
                        root = root.getParent();
                    }
                    long addedShortcutKey = BitUtil.LITTLE.toLong(root.firstEdgeKey, ((BridgePathFinder.BridePathEntry)bridgePath.value).chEntry.incEdgeKey);
                    if (!this.addedShortcuts.add(addedShortcutKey)) continue;
                    double initialTurnCost = this.prepareGraph.getTurnWeight(origInKey, sourceNode, root.firstEdgeKey);
                    ((BridgePathFinder.BridePathEntry)bridgePath.value).chEntry.weight -= initialTurnCost;
                    LOGGER.trace("Adding shortcuts for target entry {}", (Object)((BridgePathFinder.BridePathEntry)bridgePath.value).chEntry);
                    shortcutHandler.handleShortcut(root, ((BridgePathFinder.BridePathEntry)bridgePath.value).chEntry, ((BridgePathFinder.BridePathEntry)bridgePath.value).chEntry.origEdges);
                }
                this.witnessPathSearcher.finishSearch();
            }
        }
    }

    private void insertShortcuts(int node) {
        this.insertOutShortcuts(node);
        this.insertInShortcuts(node);
    }

    private void insertOutShortcuts(int node) {
        PrepareGraphEdgeIterator iter = this.outEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (!iter.isShortcut()) continue;
            int shortcut = this.chBuilder.addShortcutEdgeBased(node, iter.getAdjNode(), PrepareEncoder.getScFwdDir(), iter.getWeight(), iter.getSkipped1(), iter.getSkipped2(), iter.getOrigEdgeKeyFirst(), iter.getOrigEdgeKeyLast());
            this.prepareGraph.setShortcutForPrepareEdge(iter.getPrepareEdge(), this.prepareGraph.getOriginalEdges() + shortcut);
            ++this.addedShortcutsCount;
        }
    }

    private void insertInShortcuts(int node) {
        PrepareGraphEdgeIterator iter = this.inEdgeExplorer.setBaseNode(node);
        while (iter.next()) {
            if (!iter.isShortcut() || iter.getAdjNode() == node) continue;
            int shortcut = this.chBuilder.addShortcutEdgeBased(node, iter.getAdjNode(), PrepareEncoder.getScBwdDir(), iter.getWeight(), iter.getSkipped1(), iter.getSkipped2(), iter.getOrigEdgeKeyFirst(), iter.getOrigEdgeKeyLast());
            this.prepareGraph.setShortcutForPrepareEdge(iter.getPrepareEdge(), this.prepareGraph.getOriginalEdges() + shortcut);
            ++this.addedShortcutsCount;
        }
    }

    private void countPreviousEdges(int node) {
        PrepareGraphEdgeIterator outIter = this.outEdgeExplorer.setBaseNode(node);
        while (outIter.next()) {
            ++this.numAllEdges;
            ++this.numPrevEdges;
            this.numPrevOrigEdges += outIter.getOrigEdgeCount();
        }
        PrepareGraphEdgeIterator inIter = this.inEdgeExplorer.setBaseNode(node);
        while (inIter.next()) {
            ++this.numAllEdges;
            if (inIter.getBaseNode() == inIter.getAdjNode()) continue;
            ++this.numPrevEdges;
            this.numPrevOrigEdges += inIter.getOrigEdgeCount();
        }
    }

    private void updateHierarchyDepthsOfNeighbors(int node, IntContainer neighbors) {
        int level = this.hierarchyDepths[node];
        for (IntCursor n : neighbors) {
            if (n.value == node) continue;
            this.hierarchyDepths[n.value] = Math.max(this.hierarchyDepths[n.value], level + 1);
        }
    }

    private PrepareCHEntry addShortcutsToPrepareGraph(PrepareCHEntry edgeFrom, PrepareCHEntry edgeTo, int origEdgeCount) {
        if (edgeTo.parent.prepareEdge != edgeFrom.prepareEdge) {
            PrepareCHEntry prev = this.addShortcutsToPrepareGraph(edgeFrom, edgeTo.getParent(), origEdgeCount);
            return this.doAddShortcut(prev, edgeTo, origEdgeCount);
        }
        return this.doAddShortcut(edgeFrom, edgeTo, origEdgeCount);
    }

    private PrepareCHEntry doAddShortcut(PrepareCHEntry edgeFrom, PrepareCHEntry edgeTo, int origEdgeCount) {
        int from = edgeFrom.parent.adjNode;
        int adjNode = edgeTo.adjNode;
        PrepareGraphEdgeIterator iter = this.existingShortcutExplorer.setBaseNode(from);
        while (iter.next()) {
            if (!this.isSameShortcut(iter, adjNode, edgeFrom.firstEdgeKey, edgeTo.incEdgeKey)) continue;
            double existingWeight = iter.getWeight();
            if (existingWeight <= edgeTo.weight) {
                PrepareCHEntry entry = new PrepareCHEntry(iter.getPrepareEdge(), iter.getOrigEdgeKeyFirst(), iter.getOrigEdgeKeyLast(), adjNode, existingWeight, origEdgeCount);
                entry.parent = edgeFrom.parent;
                return entry;
            }
            iter.setSkippedEdges(edgeFrom.prepareEdge, edgeTo.prepareEdge);
            iter.setWeight(edgeTo.weight);
            iter.setOrigEdgeCount(origEdgeCount);
            PrepareCHEntry entry = new PrepareCHEntry(iter.getPrepareEdge(), iter.getOrigEdgeKeyFirst(), iter.getOrigEdgeKeyLast(), adjNode, edgeTo.weight, origEdgeCount);
            entry.parent = edgeFrom.parent;
            return entry;
        }
        int origFirstKey = edgeFrom.firstEdgeKey;
        LOGGER.trace("Adding shortcut from {} to {}, weight: {}, firstOrigEdgeKey: {}, lastOrigEdgeKey: {}", new Object[]{from, adjNode, edgeTo.weight, origFirstKey, edgeTo.incEdgeKey});
        int prepareEdge = this.prepareGraph.addShortcut(from, adjNode, origFirstKey, edgeTo.incEdgeKey, edgeFrom.prepareEdge, edgeTo.prepareEdge, edgeTo.weight, origEdgeCount);
        int incEdgeKey = -1;
        PrepareCHEntry entry = new PrepareCHEntry(prepareEdge, origFirstKey, incEdgeKey, edgeTo.adjNode, edgeTo.weight, origEdgeCount);
        entry.parent = edgeFrom.parent;
        return entry;
    }

    private boolean isSameShortcut(PrepareGraphEdgeIterator iter, int adjNode, int firstOrigEdgeKey, int lastOrigEdgeKey) {
        return iter.isShortcut() && iter.getAdjNode() == adjNode && iter.getOrigEdgeKeyFirst() == firstOrigEdgeKey && iter.getOrigEdgeKeyLast() == lastOrigEdgeKey;
    }

    private void resetEdgeCounters() {
        this.numShortcuts = 0;
        this.numPrevEdges = 0;
        this.numOrigEdges = 0;
        this.numPrevOrigEdges = 0;
        this.numAllEdges = 0;
    }

    @Override
    public void close() {
        this.prepareGraph.close();
        this.inEdgeExplorer = null;
        this.outEdgeExplorer = null;
        this.existingShortcutExplorer = null;
        this.sourceNodeOrigInEdgeExplorer = null;
        this.chBuilder = null;
        this.witnessPathSearcher.close();
        this.sourceNodes.release();
        this.targetNodes.release();
        this.addedShortcuts.release();
        this.hierarchyDepths = null;
    }

    private Stats stats() {
        return this.activeStats;
    }

    private void countShortcuts(PrepareCHEntry edgeFrom, PrepareCHEntry edgeTo, int origEdgeCount) {
        int fromNode = edgeFrom.parent.adjNode;
        int toNode = edgeTo.adjNode;
        int firstOrigEdgeKey = edgeFrom.firstEdgeKey;
        int lastOrigEdgeKey = edgeTo.incEdgeKey;
        PrepareGraphEdgeIterator iter = this.existingShortcutExplorer.setBaseNode(fromNode);
        while (iter.next()) {
            if (!this.isSameShortcut(iter, toNode, firstOrigEdgeKey, lastOrigEdgeKey)) continue;
            return;
        }
        while (edgeTo != edgeFrom) {
            ++this.numShortcuts;
            edgeTo = edgeTo.parent;
        }
        this.numOrigEdges += origEdgeCount;
    }

    long getNumPolledEdges() {
        return this.wpsStatsContr.numPolls + this.wpsStatsHeur.numPolls;
    }

    public static class Params {
        private float edgeQuotientWeight = 100.0f;
        private float originalEdgeQuotientWeight = 100.0f;
        private float hierarchyDepthWeight = 20.0f;
        private double maxPollFactorHeuristic = 4.0;
        private double maxPollFactorContraction = 200.0;
    }

    private static class Stats {
        int nodes;
        StopWatch stopWatch = new StopWatch();

        private Stats() {
        }

        public String toString() {
            return String.format(Locale.ROOT, "time: %7.2fs, nodes: %10s", Float.valueOf(this.stopWatch.getCurrentSeconds()), Helper.nf((long)this.nodes));
        }
    }

    @FunctionalInterface
    private static interface PrepareShortcutHandler {
        public void handleShortcut(PrepareCHEntry var1, PrepareCHEntry var2, int var3);
    }
}

