/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.AverageSlope;
import com.graphhopper.routing.ev.BikeNetwork;
import com.graphhopper.routing.ev.BikeRoadAccess;
import com.graphhopper.routing.ev.BikeTemporalAccess;
import com.graphhopper.routing.ev.BusAccess;
import com.graphhopper.routing.ev.CarTemporalAccess;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.Crossing;
import com.graphhopper.routing.ev.Curvature;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.FerrySpeed;
import com.graphhopper.routing.ev.FootNetwork;
import com.graphhopper.routing.ev.FootRoadAccess;
import com.graphhopper.routing.ev.FootTemporalAccess;
import com.graphhopper.routing.ev.Footway;
import com.graphhopper.routing.ev.GetOffBike;
import com.graphhopper.routing.ev.Hazmat;
import com.graphhopper.routing.ev.HazmatTunnel;
import com.graphhopper.routing.ev.HazmatWater;
import com.graphhopper.routing.ev.Hgv;
import com.graphhopper.routing.ev.HikeRating;
import com.graphhopper.routing.ev.HorseRating;
import com.graphhopper.routing.ev.HovAccess;
import com.graphhopper.routing.ev.ImportRegistry;
import com.graphhopper.routing.ev.ImportUnit;
import com.graphhopper.routing.ev.Lanes;
import com.graphhopper.routing.ev.MaxAxleLoad;
import com.graphhopper.routing.ev.MaxHeight;
import com.graphhopper.routing.ev.MaxLength;
import com.graphhopper.routing.ev.MaxSlope;
import com.graphhopper.routing.ev.MaxSpeed;
import com.graphhopper.routing.ev.MaxSpeedEstimated;
import com.graphhopper.routing.ev.MaxWeight;
import com.graphhopper.routing.ev.MaxWeightExcept;
import com.graphhopper.routing.ev.MaxWidth;
import com.graphhopper.routing.ev.MtbNetwork;
import com.graphhopper.routing.ev.MtbRating;
import com.graphhopper.routing.ev.OSMWayID;
import com.graphhopper.routing.ev.Orientation;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.ev.RoadClassLink;
import com.graphhopper.routing.ev.RoadEnvironment;
import com.graphhopper.routing.ev.Roundabout;
import com.graphhopper.routing.ev.RouteNetwork;
import com.graphhopper.routing.ev.Smoothness;
import com.graphhopper.routing.ev.State;
import com.graphhopper.routing.ev.Surface;
import com.graphhopper.routing.ev.Toll;
import com.graphhopper.routing.ev.TrackType;
import com.graphhopper.routing.ev.UrbanDensity;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehiclePriority;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.CurvatureCalculator;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.PriorityCode;
import com.graphhopper.routing.util.SlopeCalculator;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.parsers.BikeAccessParser;
import com.graphhopper.routing.util.parsers.BikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.BikePriorityParser;
import com.graphhopper.routing.util.parsers.CarAccessParser;
import com.graphhopper.routing.util.parsers.CarAverageSpeedParser;
import com.graphhopper.routing.util.parsers.CountryParser;
import com.graphhopper.routing.util.parsers.FootAccessParser;
import com.graphhopper.routing.util.parsers.FootAverageSpeedParser;
import com.graphhopper.routing.util.parsers.FootPriorityParser;
import com.graphhopper.routing.util.parsers.MaxWeightExceptParser;
import com.graphhopper.routing.util.parsers.ModeAccessParser;
import com.graphhopper.routing.util.parsers.MountainBikeAccessParser;
import com.graphhopper.routing.util.parsers.MountainBikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.MountainBikePriorityParser;
import com.graphhopper.routing.util.parsers.OSMCrossingParser;
import com.graphhopper.routing.util.parsers.OSMFootwayParser;
import com.graphhopper.routing.util.parsers.OSMGetOffBikeParser;
import com.graphhopper.routing.util.parsers.OSMHazmatParser;
import com.graphhopper.routing.util.parsers.OSMHazmatTunnelParser;
import com.graphhopper.routing.util.parsers.OSMHazmatWaterParser;
import com.graphhopper.routing.util.parsers.OSMHgvParser;
import com.graphhopper.routing.util.parsers.OSMHikeRatingParser;
import com.graphhopper.routing.util.parsers.OSMHorseRatingParser;
import com.graphhopper.routing.util.parsers.OSMLanesParser;
import com.graphhopper.routing.util.parsers.OSMMaxAxleLoadParser;
import com.graphhopper.routing.util.parsers.OSMMaxHeightParser;
import com.graphhopper.routing.util.parsers.OSMMaxLengthParser;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.OSMMaxWeightParser;
import com.graphhopper.routing.util.parsers.OSMMaxWidthParser;
import com.graphhopper.routing.util.parsers.OSMMtbRatingParser;
import com.graphhopper.routing.util.parsers.OSMRoadAccessParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassLinkParser;
import com.graphhopper.routing.util.parsers.OSMRoadClassParser;
import com.graphhopper.routing.util.parsers.OSMRoadEnvironmentParser;
import com.graphhopper.routing.util.parsers.OSMRoundaboutParser;
import com.graphhopper.routing.util.parsers.OSMSmoothnessParser;
import com.graphhopper.routing.util.parsers.OSMSurfaceParser;
import com.graphhopper.routing.util.parsers.OSMTemporalAccessParser;
import com.graphhopper.routing.util.parsers.OSMTollParser;
import com.graphhopper.routing.util.parsers.OSMTrackTypeParser;
import com.graphhopper.routing.util.parsers.OSMWayIDParser;
import com.graphhopper.routing.util.parsers.OrientationCalculator;
import com.graphhopper.routing.util.parsers.RacingBikeAccessParser;
import com.graphhopper.routing.util.parsers.RacingBikeAverageSpeedParser;
import com.graphhopper.routing.util.parsers.RacingBikePriorityParser;
import com.graphhopper.routing.util.parsers.StateParser;
import com.graphhopper.util.PMap;

public class DefaultImportRegistry
implements ImportRegistry {
    @Override
    public ImportUnit createImportUnit(String name) {
        if ("roundabout".equals(name)) {
            return ImportUnit.create(name, props -> Roundabout.create(), (lookup, props) -> new OSMRoundaboutParser(lookup.getBooleanEncodedValue("roundabout")), new String[0]);
        }
        if ("get_off_bike".equals(name)) {
            return ImportUnit.create(name, props -> GetOffBike.create(), (lookup, pros) -> new OSMGetOffBikeParser(lookup.getBooleanEncodedValue("get_off_bike"), lookup.getBooleanEncodedValue("bike_access")), "bike_access");
        }
        if ("road_class".equals(name)) {
            return ImportUnit.create(name, props -> RoadClass.create(), (lookup, props) -> new OSMRoadClassParser(lookup.getEnumEncodedValue("road_class", RoadClass.class)), new String[0]);
        }
        if ("road_class_link".equals(name)) {
            return ImportUnit.create(name, props -> RoadClassLink.create(), (lookup, props) -> new OSMRoadClassLinkParser(lookup.getBooleanEncodedValue("road_class_link")), new String[0]);
        }
        if ("road_environment".equals(name)) {
            return ImportUnit.create(name, props -> RoadEnvironment.create(), (lookup, props) -> new OSMRoadEnvironmentParser(lookup.getEnumEncodedValue("road_environment", RoadEnvironment.class)), new String[0]);
        }
        if ("foot_road_access".equals(name)) {
            return ImportUnit.create(name, props -> FootRoadAccess.create(), (lookup, props) -> new OSMRoadAccessParser<FootRoadAccess>(lookup.getEnumEncodedValue("foot_road_access", FootRoadAccess.class), OSMRoadAccessParser.toOSMRestrictions(TransportationMode.FOOT), (readerWay, accessValue) -> accessValue, FootRoadAccess::find), new String[0]);
        }
        if ("bike_road_access".equals(name)) {
            return ImportUnit.create(name, props -> BikeRoadAccess.create(), (lookup, props) -> new OSMRoadAccessParser<BikeRoadAccess>(lookup.getEnumEncodedValue("bike_road_access", BikeRoadAccess.class), OSMRoadAccessParser.toOSMRestrictions(TransportationMode.BIKE), (readerWay, accessValue) -> accessValue, BikeRoadAccess::find), new String[0]);
        }
        if ("road_access".equals(name)) {
            return ImportUnit.create(name, props -> RoadAccess.create(), (lookup, props) -> new OSMRoadAccessParser<RoadAccess>(lookup.getEnumEncodedValue("road_access", RoadAccess.class), OSMRoadAccessParser.toOSMRestrictions(TransportationMode.CAR), RoadAccess::countryHook, RoadAccess::find), new String[0]);
        }
        if ("max_speed".equals(name)) {
            return ImportUnit.create(name, props -> MaxSpeed.create(), (lookup, props) -> new OSMMaxSpeedParser(lookup.getDecimalEncodedValue("max_speed")), new String[0]);
        }
        if ("max_speed_estimated".equals(name)) {
            return ImportUnit.create(name, props -> MaxSpeedEstimated.create(), null, "country", "urban_density");
        }
        if ("urban_density".equals(name)) {
            return ImportUnit.create(name, props -> UrbanDensity.create(), null, new String[0]);
        }
        if ("max_weight".equals(name)) {
            return ImportUnit.create(name, props -> MaxWeight.create(), (lookup, props) -> new OSMMaxWeightParser(lookup.getDecimalEncodedValue("max_weight")), new String[0]);
        }
        if ("max_weight_except".equals(name)) {
            return ImportUnit.create(name, props -> MaxWeightExcept.create(), (lookup, props) -> new MaxWeightExceptParser(lookup.getEnumEncodedValue("max_weight_except", MaxWeightExcept.class)), new String[0]);
        }
        if ("max_height".equals(name)) {
            return ImportUnit.create(name, props -> MaxHeight.create(), (lookup, props) -> new OSMMaxHeightParser(lookup.getDecimalEncodedValue("max_height")), new String[0]);
        }
        if ("max_width".equals(name)) {
            return ImportUnit.create(name, props -> MaxWidth.create(), (lookup, props) -> new OSMMaxWidthParser(lookup.getDecimalEncodedValue("max_width")), new String[0]);
        }
        if ("max_axle_load".equals(name)) {
            return ImportUnit.create(name, props -> MaxAxleLoad.create(), (lookup, props) -> new OSMMaxAxleLoadParser(lookup.getDecimalEncodedValue("max_axle_load")), new String[0]);
        }
        if ("max_length".equals(name)) {
            return ImportUnit.create(name, props -> MaxLength.create(), (lookup, props) -> new OSMMaxLengthParser(lookup.getDecimalEncodedValue("max_length")), new String[0]);
        }
        if ("orientation".equals(name)) {
            return ImportUnit.create(name, props -> Orientation.create(), (lookup, props) -> new OrientationCalculator(lookup.getDecimalEncodedValue("orientation")), new String[0]);
        }
        if ("surface".equals(name)) {
            return ImportUnit.create(name, props -> Surface.create(), (lookup, props) -> new OSMSurfaceParser(lookup.getEnumEncodedValue("surface", Surface.class)), new String[0]);
        }
        if ("smoothness".equals(name)) {
            return ImportUnit.create(name, props -> Smoothness.create(), (lookup, props) -> new OSMSmoothnessParser(lookup.getEnumEncodedValue("smoothness", Smoothness.class)), new String[0]);
        }
        if ("hgv".equals(name)) {
            return ImportUnit.create(name, props -> Hgv.create(), (lookup, props) -> new OSMHgvParser(lookup.getEnumEncodedValue("hgv", Hgv.class)), new String[0]);
        }
        if ("toll".equals(name)) {
            return ImportUnit.create(name, props -> Toll.create(), (lookup, props) -> new OSMTollParser(lookup.getEnumEncodedValue("toll", Toll.class)), new String[0]);
        }
        if ("track_type".equals(name)) {
            return ImportUnit.create(name, props -> TrackType.create(), (lookup, props) -> new OSMTrackTypeParser(lookup.getEnumEncodedValue("track_type", TrackType.class)), new String[0]);
        }
        if ("hazmat".equals(name)) {
            return ImportUnit.create(name, props -> Hazmat.create(), (lookup, props) -> new OSMHazmatParser(lookup.getEnumEncodedValue("hazmat", Hazmat.class)), new String[0]);
        }
        if ("hazmat_tunnel".equals(name)) {
            return ImportUnit.create(name, props -> HazmatTunnel.create(), (lookup, props) -> new OSMHazmatTunnelParser(lookup.getEnumEncodedValue("hazmat_tunnel", HazmatTunnel.class)), new String[0]);
        }
        if ("hazmat_water".equals(name)) {
            return ImportUnit.create(name, props -> HazmatWater.create(), (lookup, props) -> new OSMHazmatWaterParser(lookup.getEnumEncodedValue("hazmat_water", HazmatWater.class)), new String[0]);
        }
        if ("lanes".equals(name)) {
            return ImportUnit.create(name, props -> Lanes.create(), (lookup, props) -> new OSMLanesParser(lookup.getIntEncodedValue("lanes")), new String[0]);
        }
        if ("footway".equals(name)) {
            return ImportUnit.create(name, props -> Footway.create(), (lookup, props) -> new OSMFootwayParser(lookup.getEnumEncodedValue("footway", Footway.class)), new String[0]);
        }
        if ("osm_way_id".equals(name)) {
            return ImportUnit.create(name, props -> OSMWayID.create(), (lookup, props) -> new OSMWayIDParser(lookup.getIntEncodedValue("osm_way_id")), new String[0]);
        }
        if ("mtb_rating".equals(name)) {
            return ImportUnit.create(name, props -> MtbRating.create(), (lookup, props) -> new OSMMtbRatingParser(lookup.getIntEncodedValue("mtb_rating")), new String[0]);
        }
        if ("hike_rating".equals(name)) {
            return ImportUnit.create(name, props -> HikeRating.create(), (lookup, props) -> new OSMHikeRatingParser(lookup.getIntEncodedValue("hike_rating")), new String[0]);
        }
        if ("horse_rating".equals(name)) {
            return ImportUnit.create(name, props -> HorseRating.create(), (lookup, props) -> new OSMHorseRatingParser(lookup.getIntEncodedValue("horse_rating")), new String[0]);
        }
        if ("country".equals(name)) {
            return ImportUnit.create(name, props -> Country.create(), (lookup, props) -> new CountryParser(lookup.getEnumEncodedValue("country", Country.class)), new String[0]);
        }
        if ("state".equals(name)) {
            return ImportUnit.create(name, props -> State.create(), (lookup, props) -> new StateParser(lookup.getEnumEncodedValue("state", State.class)), new String[0]);
        }
        if ("crossing".equals(name)) {
            return ImportUnit.create(name, props -> Crossing.create(), (lookup, props) -> new OSMCrossingParser(lookup.getEnumEncodedValue("crossing", Crossing.class)), new String[0]);
        }
        if ("ferry_speed".equals(name)) {
            return ImportUnit.create(name, props -> FerrySpeed.create(), (lookup, props) -> new FerrySpeedCalculator(lookup.getDecimalEncodedValue("ferry_speed")), new String[0]);
        }
        if ("curvature".equals(name)) {
            return ImportUnit.create(name, props -> Curvature.create(), (lookup, props) -> new CurvatureCalculator(lookup.getDecimalEncodedValue("curvature")), new String[0]);
        }
        if ("average_slope".equals(name)) {
            return ImportUnit.create(name, props -> AverageSlope.create(), null, "slope_calculator");
        }
        if ("max_slope".equals(name)) {
            return ImportUnit.create(name, props -> MaxSlope.create(), null, "slope_calculator");
        }
        if ("slope_calculator".equals(name)) {
            return ImportUnit.create(name, null, (lookup, props) -> new SlopeCalculator(lookup.hasEncodedValue("max_slope") ? lookup.getDecimalEncodedValue("max_slope") : null, lookup.hasEncodedValue("average_slope") ? lookup.getDecimalEncodedValue("average_slope") : null), new String[0]);
        }
        if (BikeNetwork.KEY.equals(name) || MtbNetwork.KEY.equals(name) || FootNetwork.KEY.equals(name)) {
            return ImportUnit.create(name, props -> RouteNetwork.create(name), null, new String[0]);
        }
        if ("bus_access".equals(name)) {
            return ImportUnit.create(name, props -> BusAccess.create(), (lookup, props) -> new ModeAccessParser(OSMRoadAccessParser.toOSMRestrictions(TransportationMode.BUS), lookup.getBooleanEncodedValue(name), true, lookup.getBooleanEncodedValue("roundabout"), PMap.toSet((String)props.getString("restrictions", "")), PMap.toSet((String)props.getString("barriers", ""))), "roundabout");
        }
        if ("hov_access".equals(name)) {
            return ImportUnit.create(name, props -> HovAccess.create(), (lookup, props) -> new ModeAccessParser(OSMRoadAccessParser.toOSMRestrictions(TransportationMode.HOV), lookup.getBooleanEncodedValue(name), true, lookup.getBooleanEncodedValue("roundabout"), PMap.toSet((String)props.getString("restrictions", "")), PMap.toSet((String)props.getString("barriers", ""))), "roundabout");
        }
        if ("foot_temporal_access".equals(name)) {
            return ImportUnit.create(name, props -> FootTemporalAccess.create(), (lookup, props) -> {
                EnumEncodedValue<FootTemporalAccess> enc = lookup.getEnumEncodedValue("foot_temporal_access", FootTemporalAccess.class);
                OSMTemporalAccessParser.Setter fct = (edgeId, edgeIntAccess, b) -> enc.setEnum(false, edgeId, edgeIntAccess, b ? FootTemporalAccess.YES : FootTemporalAccess.NO);
                return new OSMTemporalAccessParser(FootTemporalAccess.CONDITIONALS, fct, props.getString("date_range_parser_day", ""));
            }, new String[0]);
        }
        if ("bike_temporal_access".equals(name)) {
            return ImportUnit.create(name, props -> BikeTemporalAccess.create(), (lookup, props) -> {
                EnumEncodedValue<BikeTemporalAccess> enc = lookup.getEnumEncodedValue("bike_temporal_access", BikeTemporalAccess.class);
                OSMTemporalAccessParser.Setter fct = (edgeId, edgeIntAccess, b) -> enc.setEnum(false, edgeId, edgeIntAccess, b ? BikeTemporalAccess.YES : BikeTemporalAccess.NO);
                return new OSMTemporalAccessParser(BikeTemporalAccess.CONDITIONALS, fct, props.getString("date_range_parser_day", ""));
            }, new String[0]);
        }
        if ("car_temporal_access".equals(name)) {
            return ImportUnit.create(name, props -> CarTemporalAccess.create(), (lookup, props) -> {
                EnumEncodedValue<CarTemporalAccess> enc = lookup.getEnumEncodedValue("car_temporal_access", CarTemporalAccess.class);
                OSMTemporalAccessParser.Setter fct = (edgeId, edgeIntAccess, b) -> enc.setEnum(false, edgeId, edgeIntAccess, b ? CarTemporalAccess.YES : CarTemporalAccess.NO);
                return new OSMTemporalAccessParser(CarTemporalAccess.CONDITIONALS, fct, props.getString("date_range_parser_day", ""));
            }, new String[0]);
        }
        if (VehicleAccess.key("car").equals(name)) {
            return ImportUnit.create(name, props -> VehicleAccess.create("car"), CarAccessParser::new, "roundabout");
        }
        if (VehicleAccess.key("roads").equals(name)) {
            throw new IllegalArgumentException("roads_access parser no longer necessary, see docs/migration/config-migration-08-09.md");
        }
        if (VehicleAccess.key("bike").equals(name)) {
            return ImportUnit.create(name, props -> VehicleAccess.create("bike"), BikeAccessParser::new, "roundabout");
        }
        if (VehicleAccess.key("racingbike").equals(name)) {
            return ImportUnit.create(name, props -> VehicleAccess.create("racingbike"), RacingBikeAccessParser::new, "roundabout");
        }
        if (VehicleAccess.key("mtb").equals(name)) {
            return ImportUnit.create(name, props -> VehicleAccess.create("mtb"), MountainBikeAccessParser::new, "roundabout");
        }
        if (VehicleAccess.key("foot").equals(name)) {
            return ImportUnit.create(name, props -> VehicleAccess.create("foot"), FootAccessParser::new, new String[0]);
        }
        if (VehicleSpeed.key("car").equals(name)) {
            return ImportUnit.create(name, props -> new DecimalEncodedValueImpl(name, props.getInt("speed_bits", 7), props.getDouble("speed_factor", 2.0), true), (lookup, props) -> new CarAverageSpeedParser((EncodedValueLookup)lookup), "ferry_speed");
        }
        if (VehicleSpeed.key("roads").equals(name)) {
            throw new IllegalArgumentException("roads_average_speed parser no longer necessary, see docs/migration/config-migration-08-09.md");
        }
        if (VehicleSpeed.key("bike").equals(name)) {
            return ImportUnit.create(name, props -> new DecimalEncodedValueImpl(name, props.getInt("speed_bits", 4), props.getDouble("speed_factor", 2.0), false), (lookup, props) -> new BikeAverageSpeedParser((EncodedValueLookup)lookup), "ferry_speed", "smoothness");
        }
        if (VehicleSpeed.key("racingbike").equals(name)) {
            return ImportUnit.create(name, props -> new DecimalEncodedValueImpl(name, props.getInt("speed_bits", 4), props.getDouble("speed_factor", 2.0), false), (lookup, props) -> new RacingBikeAverageSpeedParser((EncodedValueLookup)lookup), "ferry_speed", "smoothness");
        }
        if (VehicleSpeed.key("mtb").equals(name)) {
            return ImportUnit.create(name, props -> new DecimalEncodedValueImpl(name, props.getInt("speed_bits", 4), props.getDouble("speed_factor", 2.0), false), (lookup, props) -> new MountainBikeAverageSpeedParser((EncodedValueLookup)lookup), "ferry_speed", "smoothness");
        }
        if (VehicleSpeed.key("foot").equals(name)) {
            return ImportUnit.create(name, props -> new DecimalEncodedValueImpl(name, props.getInt("speed_bits", 4), props.getDouble("speed_factor", 1.0), false), (lookup, props) -> new FootAverageSpeedParser((EncodedValueLookup)lookup), "ferry_speed");
        }
        if (VehiclePriority.key("foot").equals(name)) {
            return ImportUnit.create(name, props -> VehiclePriority.create("foot", 4, PriorityCode.getFactor(1), false), (lookup, props) -> new FootPriorityParser((EncodedValueLookup)lookup), RouteNetwork.key("foot"));
        }
        if (VehiclePriority.key("bike").equals(name)) {
            return ImportUnit.create(name, props -> VehiclePriority.create("bike", 4, PriorityCode.getFactor(1), false), (lookup, props) -> new BikePriorityParser((EncodedValueLookup)lookup), VehicleSpeed.key("bike"), BikeNetwork.KEY);
        }
        if (VehiclePriority.key("racingbike").equals(name)) {
            return ImportUnit.create(name, props -> VehiclePriority.create("racingbike", 4, PriorityCode.getFactor(1), false), (lookup, props) -> new RacingBikePriorityParser((EncodedValueLookup)lookup), VehicleSpeed.key("racingbike"), BikeNetwork.KEY);
        }
        if (VehiclePriority.key("mtb").equals(name)) {
            return ImportUnit.create(name, props -> VehiclePriority.create("mtb", 4, PriorityCode.getFactor(1), false), (lookup, props) -> new MountainBikePriorityParser((EncodedValueLookup)lookup), VehicleSpeed.key("mtb"), BikeNetwork.KEY);
        }
        return null;
    }
}

