/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.ev;

import com.graphhopper.routing.ev.EnumEncodedValue;
import java.util.HashMap;
import java.util.Map;

public enum State {
    MISSING("-"),
    AU_ACT("AU-ACT"),
    AU_NSW("AU-NSW"),
    AU_NT("AU-NT"),
    AU_QLD("AU-QLD"),
    AU_SA("AU-SA"),
    AU_TAS("AU-TAS"),
    AU_VIC("AU-VIC"),
    AU_WA("AU-WA"),
    CA_AB("CA-AB"),
    CA_BC("CA-BC"),
    CA_MB("CA-MB"),
    CA_NB("CA-NB"),
    CA_NL("CA-NL"),
    CA_NS("CA-NS"),
    CA_NT("CA-NT"),
    CA_NU("CA-NU"),
    CA_ON("CA-ON"),
    CA_PE("CA-PE"),
    CA_QC("CA-QC"),
    CA_SK("CA-SK"),
    CA_YT("CA-YT"),
    FM_KSA("FM-KSA"),
    FM_PNI("FM-PNI"),
    FM_TRK("FM-TRK"),
    FM_YAP("FM-YAP"),
    US_AL("US-AL"),
    US_AK("US-AK"),
    US_AZ("US-AZ"),
    US_AR("US-AR"),
    US_CA("US-CA"),
    US_CO("US-CO"),
    US_CT("US-CT"),
    US_DE("US-DE"),
    US_DC("US-DC"),
    US_FL("US-FL"),
    US_GA("US-GA"),
    US_HI("US-HI"),
    US_ID("US-ID"),
    US_IL("US-IL"),
    US_IN("US-IN"),
    US_IA("US-IA"),
    US_KS("US-KS"),
    US_KY("US-KY"),
    US_LA("US-LA"),
    US_ME("US-ME"),
    US_MD("US-MD"),
    US_MA("US-MA"),
    US_MI("US-MI"),
    US_MN("US-MN"),
    US_MS("US-MS"),
    US_MO("US-MO"),
    US_MT("US-MT"),
    US_NE("US-NE"),
    US_NV("US-NV"),
    US_NH("US-NH"),
    US_NJ("US-NJ"),
    US_NM("US-NM"),
    US_NY("US-NY"),
    US_NC("US-NC"),
    US_ND("US-ND"),
    US_OH("US-OH"),
    US_OK("US-OK"),
    US_OR("US-OR"),
    US_PA("US-PA"),
    US_RI("US-RI"),
    US_SC("US-SC"),
    US_SD("US-SD"),
    US_TN("US-TN"),
    US_TX("US-TX"),
    US_UT("US-UT"),
    US_VT("US-VT"),
    US_VA("US-VA"),
    US_WA("US-WA"),
    US_WV("US-WV"),
    US_WI("US-WI"),
    US_WY("US-WY");

    public static final String KEY = "state";
    public static final String ISO_3166_2 = "ISO3166-2";
    private static final Map<String, State> STATE_BY_CODE;
    private final String stateCode;

    private State(String isoCodeOfSubdivision) {
        this.stateCode = isoCodeOfSubdivision;
    }

    public static State find(String iso) {
        return STATE_BY_CODE.getOrDefault(iso, MISSING);
    }

    public String getStateCode() {
        return this.stateCode;
    }

    public String toString() {
        return this.stateCode;
    }

    public static EnumEncodedValue<State> create() {
        return new EnumEncodedValue<State>(KEY, State.class);
    }

    static {
        HashMap<String, State> map = new HashMap<String, State>();
        for (State state : State.values()) {
            map.put(state.stateCode, state);
        }
        STATE_BY_CODE = Map.copyOf(map);
    }
}

