/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.querygraph;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.graphhopper.coll.GHIntHashSet;
import com.graphhopper.routing.querygraph.QueryOverlay;
import com.graphhopper.routing.querygraph.VirtualEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;
import java.util.List;

class EdgeChangeBuilder {
    private final IntArrayList closestEdges;
    private final List<VirtualEdgeIteratorState> virtualEdges;
    private final IntObjectMap<QueryOverlay.EdgeChanges> edgeChangesAtRealNodes;
    private final int firstVirtualNodeId;

    static void build(IntArrayList closestEdges, List<VirtualEdgeIteratorState> virtualEdges, int firstVirtualNodeId, IntObjectMap<QueryOverlay.EdgeChanges> edgeChangesAtRealNodes) {
        new EdgeChangeBuilder(closestEdges, virtualEdges, firstVirtualNodeId, edgeChangesAtRealNodes).build();
    }

    private EdgeChangeBuilder(IntArrayList closestEdges, List<VirtualEdgeIteratorState> virtualEdges, int firstVirtualNodeId, IntObjectMap<QueryOverlay.EdgeChanges> edgeChangesAtRealNodes) {
        this.closestEdges = closestEdges;
        this.virtualEdges = virtualEdges;
        this.firstVirtualNodeId = firstVirtualNodeId;
        if (!edgeChangesAtRealNodes.isEmpty()) {
            throw new IllegalArgumentException("real node modifications need to be empty");
        }
        this.edgeChangesAtRealNodes = edgeChangesAtRealNodes;
    }

    private void build() {
        GHIntHashSet towerNodesToChange = new GHIntHashSet(this.getNumVirtualNodes());
        for (int i = 0; i < this.getNumVirtualNodes(); ++i) {
            VirtualEdgeIteratorState adjEdge;
            VirtualEdgeIteratorState baseRevEdge = this.getVirtualEdge(i * 4 + 1);
            int towerNode = baseRevEdge.getAdjNode();
            if (!this.isVirtualNode(towerNode)) {
                towerNodesToChange.add(towerNode);
                this.addVirtualEdges(true, towerNode, i);
            }
            if (this.isVirtualNode(towerNode = (adjEdge = this.getVirtualEdge(i * 4 + 2)).getAdjNode())) continue;
            towerNodesToChange.add(towerNode);
            this.addVirtualEdges(false, towerNode, i);
        }
        towerNodesToChange.forEach(new IntProcedure(){

            public void apply(int value) {
                EdgeChangeBuilder.this.addRemovedEdges(value);
            }
        });
    }

    private void addVirtualEdges(boolean base, int node, int virtNode) {
        QueryOverlay.EdgeChanges edgeChanges = (QueryOverlay.EdgeChanges)this.edgeChangesAtRealNodes.get(node);
        if (edgeChanges == null) {
            edgeChanges = new QueryOverlay.EdgeChanges(2, 2);
            this.edgeChangesAtRealNodes.put(node, (Object)edgeChanges);
        }
        VirtualEdgeIteratorState edge = base ? this.getVirtualEdge(virtNode * 4 + 0) : this.getVirtualEdge(virtNode * 4 + 3);
        edgeChanges.getAdditionalEdges().add(edge);
    }

    private void addRemovedEdges(int towerNode) {
        if (this.isVirtualNode(towerNode)) {
            throw new IllegalStateException("Node should not be virtual:" + towerNode + ", " + String.valueOf(this.edgeChangesAtRealNodes));
        }
        QueryOverlay.EdgeChanges edgeChanges = (QueryOverlay.EdgeChanges)this.edgeChangesAtRealNodes.get(towerNode);
        List<EdgeIteratorState> existingEdges = edgeChanges.getAdditionalEdges();
        IntArrayList removedEdges = edgeChanges.getRemovedEdges();
        for (EdgeIteratorState existingEdge : existingEdges) {
            removedEdges.add(this.getClosestEdge(existingEdge.getAdjNode()));
        }
    }

    private boolean isVirtualNode(int nodeId) {
        return nodeId >= this.firstVirtualNodeId;
    }

    private int getNumVirtualNodes() {
        return this.closestEdges.size();
    }

    private int getClosestEdge(int node) {
        return this.closestEdges.get(node - this.firstVirtualNodeId);
    }

    private VirtualEdgeIteratorState getVirtualEdge(int virtualEdgeId) {
        return this.virtualEdges.get(virtualEdgeId);
    }
}

