/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.subnetwork;

import com.graphhopper.storage.DataAccess;

public class SubnetworkStorage {
    final DataAccess da;

    public SubnetworkStorage(DataAccess da) {
        this.da = da;
    }

    public int getSubnetwork(int nodeId) {
        return this.da.getByte(nodeId);
    }

    public void setSubnetwork(int nodeId, int subnetwork) {
        if (subnetwork > 127) {
            throw new IllegalArgumentException("Number of subnetworks is currently limited to 127 but requested " + subnetwork);
        }
        this.da.setByte(nodeId, (byte)subnetwork);
    }

    public boolean loadExisting() {
        return this.da.loadExisting();
    }

    public SubnetworkStorage create(long byteCount) {
        this.da.create(2000L);
        this.da.ensureCapacity(byteCount);
        return this;
    }

    public void flush() {
        this.da.flush();
    }

    public void close() {
        this.da.close();
    }

    public boolean isClosed() {
        return this.da.isClosed();
    }

    public long getCapacity() {
        return this.da.getCapacity();
    }
}

