/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.index.strtree.STRtree;

public class AreaIndex<T extends Area> {
    private final GeometryFactory gf = new GeometryFactory();
    private final STRtree index = new STRtree();

    public AreaIndex(List<T> areas) {
        PreparedGeometryFactory pgf = new PreparedGeometryFactory();
        for (Area area : areas) {
            for (Polygon border : area.getBorders()) {
                IndexedCustomArea<Area> indexedCustomArea = new IndexedCustomArea<Area>(area, pgf.create((Geometry)border));
                this.index.insert(border.getEnvelopeInternal(), indexedCustomArea);
            }
        }
        this.index.build();
    }

    public List<T> query(double lat, double lon) {
        Envelope searchEnv = new Envelope(lon, lon, lat, lat);
        List result = this.index.query(searchEnv);
        Point point = this.gf.createPoint(new Coordinate(lon, lat));
        return result.stream().filter(c -> c.intersects(point)).map(c -> c.area).collect(Collectors.toList());
    }

    public static interface Area {
        public List<Polygon> getBorders();
    }

    private static class IndexedCustomArea<T extends Area> {
        final T area;
        final PreparedGeometry preparedGeometry;

        IndexedCustomArea(T area, PreparedGeometry preparedGeometry) {
            this.area = area;
            this.preparedGeometry = preparedGeometry;
        }

        boolean intersects(Point point) {
            return this.preparedGeometry.intersects((Geometry)point);
        }
    }
}

