/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EncodedValueSerializer;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.StorableProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class EncodingManager
implements EncodedValueLookup {
    private final LinkedHashMap<String, EncodedValue> encodedValueMap;
    private final LinkedHashMap<String, EncodedValue> turnEncodedValueMap;
    private int bytesForFlags;
    private int intsForTurnCostFlags;

    public static void putEncodingManagerIntoProperties(EncodingManager encodingManager, StorableProperties properties) {
        properties.put("graph.em.version", 4);
        properties.put("graph.em.bytes_for_flags", encodingManager.bytesForFlags);
        properties.put("graph.em.ints_for_turn_cost_flags", encodingManager.intsForTurnCostFlags);
        properties.put("graph.encoded_values", encodingManager.toEncodedValuesAsString());
        properties.put("graph.turn_encoded_values", encodingManager.toTurnEncodedValuesAsString());
    }

    public static EncodingManager fromProperties(StorableProperties properties) {
        if (properties.containsVersion()) {
            throw new IllegalStateException("The GraphHopper file format is not compatible with the data you are trying to load. You either need to use an older version of GraphHopper or run a new import");
        }
        String versionStr = properties.get("graph.em.version");
        if (versionStr.isEmpty() || !String.valueOf(4).equals(versionStr)) {
            throw new IllegalStateException("Incompatible encoding version. You need to use the same GraphHopper version you used to import the graph in '" + properties.getDirectory().getLocation() + "', delete the folder, or run a new import with another location.  Stored encoding version: " + (versionStr.isEmpty() ? "missing" : versionStr) + ", used encoding version: 4");
        }
        String encodedValueStr = properties.get("graph.encoded_values");
        ArrayNode evList = EncodingManager.deserializeEncodedValueList(encodedValueStr);
        LinkedHashMap<String, EncodedValue> encodedValues = new LinkedHashMap<String, EncodedValue>();
        evList.forEach(serializedEV -> {
            EncodedValue encodedValue = EncodedValueSerializer.deserializeEncodedValue(serializedEV.textValue());
            if (encodedValues.put(encodedValue.getName(), encodedValue) != null) {
                throw new IllegalStateException("Duplicate encoded value name: " + encodedValue.getName() + " in: graph.encoded_values=" + encodedValueStr);
            }
        });
        String turnEncodedValueStr = properties.get("graph.turn_encoded_values");
        ArrayNode tevList = EncodingManager.deserializeEncodedValueList(turnEncodedValueStr);
        LinkedHashMap<String, EncodedValue> turnEncodedValues = new LinkedHashMap<String, EncodedValue>();
        tevList.forEach(serializedEV -> {
            EncodedValue encodedValue = EncodedValueSerializer.deserializeEncodedValue(serializedEV.textValue());
            if (turnEncodedValues.put(encodedValue.getName(), encodedValue) != null) {
                throw new IllegalStateException("Duplicate turn encoded value name: " + encodedValue.getName() + " in: graph.turn_encoded_values=" + turnEncodedValueStr);
            }
        });
        return new EncodingManager(EncodingManager.getIntegerProperty(properties, "graph.em.bytes_for_flags"), EncodingManager.getIntegerProperty(properties, "graph.em.ints_for_turn_cost_flags"), encodedValues, turnEncodedValues);
    }

    private static int getIntegerProperty(StorableProperties properties, String key) {
        String str = properties.get(key);
        if (str.isEmpty()) {
            throw new IllegalStateException("Missing EncodingManager property: '" + key + "'");
        }
        return Integer.parseInt(str);
    }

    private static ArrayNode deserializeEncodedValueList(String encodedValueStr) {
        try {
            return (ArrayNode)Jackson.newObjectMapper().readValue(encodedValueStr, ArrayNode.class);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static Builder start() {
        return new Builder();
    }

    public EncodingManager(int bytesForFlags, int intsForTurnCostFlags, LinkedHashMap<String, EncodedValue> encodedValueMap, LinkedHashMap<String, EncodedValue> turnEncodedValueMap) {
        this.encodedValueMap = encodedValueMap;
        this.turnEncodedValueMap = turnEncodedValueMap;
        this.bytesForFlags = bytesForFlags;
        this.intsForTurnCostFlags = intsForTurnCostFlags;
    }

    private EncodingManager() {
        this(0, 0, new LinkedHashMap<String, EncodedValue>(), new LinkedHashMap<String, EncodedValue>());
    }

    public int getBytesForFlags() {
        return this.bytesForFlags;
    }

    @Override
    public boolean hasEncodedValue(String key) {
        return this.encodedValueMap.get(key) != null;
    }

    public boolean hasTurnEncodedValue(String key) {
        return this.turnEncodedValueMap.get(key) != null;
    }

    public List<String> getVehicles() {
        return this.getEncodedValues().stream().filter(ev -> ev.getName().endsWith("_access")).map(ev -> ev.getName().replaceAll("_access", "")).filter(v -> this.getEncodedValues().stream().anyMatch(ev -> ev.getName().contains(VehicleSpeed.key(v)))).collect(Collectors.toList());
    }

    public String toEncodedValuesAsString() {
        List serializedEVsList = this.encodedValueMap.values().stream().map(EncodedValueSerializer::serializeEncodedValue).collect(Collectors.toList());
        try {
            return Jackson.newObjectMapper().writeValueAsString(serializedEVsList);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public String toString() {
        return String.join((CharSequence)",", this.getVehicles());
    }

    public IntsRef createEdgeFlags() {
        return new IntsRef((int)Math.ceil((double)this.getBytesForFlags() / 4.0));
    }

    public IntsRef createRelationFlags() {
        return new IntsRef(2);
    }

    public boolean needsTurnCostsSupport() {
        return this.intsForTurnCostFlags > 0;
    }

    @Override
    public List<EncodedValue> getEncodedValues() {
        return Collections.unmodifiableList(new ArrayList<EncodedValue>(this.encodedValueMap.values()));
    }

    @Override
    public BooleanEncodedValue getBooleanEncodedValue(String key) {
        return this.getEncodedValue(key, BooleanEncodedValue.class);
    }

    @Override
    public IntEncodedValue getIntEncodedValue(String key) {
        return this.getEncodedValue(key, IntEncodedValue.class);
    }

    @Override
    public DecimalEncodedValue getDecimalEncodedValue(String key) {
        return this.getEncodedValue(key, DecimalEncodedValue.class);
    }

    @Override
    public <T extends Enum<?>> EnumEncodedValue<T> getEnumEncodedValue(String key, Class<T> type) {
        return this.getEncodedValue(key, EnumEncodedValue.class);
    }

    @Override
    public StringEncodedValue getStringEncodedValue(String key) {
        return this.getEncodedValue(key, StringEncodedValue.class);
    }

    @Override
    public <T extends EncodedValue> T getEncodedValue(String key, Class<T> encodedValueType) {
        EncodedValue ev = this.encodedValueMap.get(key);
        if (ev == null) {
            throw new IllegalArgumentException("Cannot find EncodedValue '" + key + "' in collection: " + String.valueOf(this.encodedValueMap.keySet()));
        }
        return (T)ev;
    }

    public List<EncodedValue> getTurnEncodedValues() {
        return Collections.unmodifiableList(new ArrayList<EncodedValue>(this.turnEncodedValueMap.values()));
    }

    public DecimalEncodedValue getTurnDecimalEncodedValue(String key) {
        return this.getTurnEncodedValue(key, DecimalEncodedValue.class);
    }

    public BooleanEncodedValue getTurnBooleanEncodedValue(String key) {
        return this.getTurnEncodedValue(key, BooleanEncodedValue.class);
    }

    public <T extends EncodedValue> T getTurnEncodedValue(String key, Class<T> encodedValueType) {
        EncodedValue ev = this.turnEncodedValueMap.get(key);
        if (ev == null) {
            throw new IllegalArgumentException("Cannot find Turn-EncodedValue " + key + " in collection: " + String.valueOf(this.encodedValueMap.keySet()));
        }
        return (T)ev;
    }

    private String toTurnEncodedValuesAsString() {
        List serializedEVsList = this.turnEncodedValueMap.values().stream().map(EncodedValueSerializer::serializeEncodedValue).collect(Collectors.toList());
        try {
            return Jackson.newObjectMapper().writeValueAsString(serializedEVsList);
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    public static String getKey(String prefix, String str) {
        return prefix + "_" + str;
    }

    public static class Builder {
        private final EncodedValue.InitializerConfig edgeConfig = new EncodedValue.InitializerConfig();
        private final EncodedValue.InitializerConfig turnCostConfig = new EncodedValue.InitializerConfig();
        private EncodingManager em = new EncodingManager();

        public Builder add(EncodedValue encodedValue) {
            this.checkNotBuiltAlready();
            if (this.em.hasEncodedValue(encodedValue.getName())) {
                throw new IllegalArgumentException("EncodedValue already exists: " + encodedValue.getName());
            }
            if (this.em.hasTurnEncodedValue(encodedValue.getName())) {
                throw new IllegalArgumentException("Already defined as 'turn'-EncodedValue: " + encodedValue.getName());
            }
            encodedValue.init(this.edgeConfig);
            this.em.encodedValueMap.put(encodedValue.getName(), encodedValue);
            return this;
        }

        public Builder addTurnCostEncodedValue(EncodedValue turnCostEnc) {
            this.checkNotBuiltAlready();
            if (this.em.hasTurnEncodedValue(turnCostEnc.getName())) {
                throw new IllegalArgumentException("Already defined: " + turnCostEnc.getName());
            }
            if (this.em.hasEncodedValue(turnCostEnc.getName())) {
                throw new IllegalArgumentException("Already defined as EncodedValue: " + turnCostEnc.getName());
            }
            turnCostEnc.init(this.turnCostConfig);
            this.em.turnEncodedValueMap.put(turnCostEnc.getName(), turnCostEnc);
            return this;
        }

        private void checkNotBuiltAlready() {
            if (this.em == null) {
                throw new IllegalStateException("Cannot call method after Builder.build() was called");
            }
        }

        public EncodingManager build() {
            this.checkNotBuiltAlready();
            this.em.bytesForFlags = this.edgeConfig.getRequiredBytes();
            this.em.intsForTurnCostFlags = this.turnCostConfig.getRequiredInts();
            EncodingManager result = this.em;
            this.em = null;
            return result;
        }
    }
}

