/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValueImpl;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.UrbanDensity;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.parsers.DefaultMaxSpeedParser;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.StopWatch;
import de.westnordost.osm_legal_default_speeds.LegalDefaultSpeeds;
import de.westnordost.osm_legal_default_speeds.RoadType;
import de.westnordost.osm_legal_default_speeds.RoadTypeFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.LoggerFactory;

public class MaxSpeedCalculator {
    private final DefaultMaxSpeedParser parser;
    private final LegalDefaultSpeeds defaultSpeeds;
    private EdgeIntAccess internalMaxSpeedStorage;
    private DecimalEncodedValue ruralMaxSpeedEnc;
    private DecimalEncodedValue urbanMaxSpeedEnc;
    private DataAccess dataAccess;

    public MaxSpeedCalculator(LegalDefaultSpeeds defaultSpeeds) {
        this.defaultSpeeds = defaultSpeeds;
        this.parser = new DefaultMaxSpeedParser(defaultSpeeds);
    }

    DecimalEncodedValue getRuralMaxSpeedEnc() {
        return this.ruralMaxSpeedEnc;
    }

    public DecimalEncodedValue getUrbanMaxSpeedEnc() {
        return this.urbanMaxSpeedEnc;
    }

    EdgeIntAccess getInternalMaxSpeedStorage() {
        return this.internalMaxSpeedStorage;
    }

    public LegalDefaultSpeeds getDefaultSpeeds() {
        return this.defaultSpeeds;
    }

    public static LegalDefaultSpeeds createLegalDefaultSpeeds() {
        SpeedLimitsJson data;
        try {
            data = (SpeedLimitsJson)new ObjectMapper().readValue(MaxSpeedCalculator.class.getResource("legal_default_speeds.json"), SpeedLimitsJson.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        MaxSpeedCalculator.convertMaxspeed(data.speedLimitsByCountryCode.entrySet());
        LegalDefaultSpeeds speeds = new LegalDefaultSpeeds(data.roadTypesByName, data.speedLimitsByCountryCode);
        return speeds;
    }

    private static void convertMaxspeed(Set<Map.Entry<String, List<RoadTypeImpl>>> entrySet) {
        for (Map.Entry<String, List<RoadTypeImpl>> entry : entrySet) {
            for (RoadTypeImpl roadType : entry.getValue()) {
                HashMap<String, String> newTags = new HashMap<String, String>(roadType.getTags().size());
                for (Map.Entry<String, String> tags : roadType.getTags().entrySet()) {
                    if (!"maxspeed".equals(tags.getKey()) && !"maxspeed:advisory".equals(tags.getKey())) continue;
                    double tmp = OSMMaxSpeedParser.parseMaxspeedString(tags.getValue());
                    if (tmp == Double.POSITIVE_INFINITY || tmp == -1.0) {
                        throw new IllegalStateException("illegal maxspeed " + tags.getValue());
                    }
                    newTags.put(tags.getKey(), "" + Math.round(tmp));
                }
                roadType.setTags(newTags);
            }
        }
    }

    private EdgeIntAccess createMaxSpeedStorage(final DataAccess dataAccess) {
        return new EdgeIntAccess(){

            @Override
            public int getInt(int edgeId, int index) {
                dataAccess.ensureCapacity((long)edgeId * 2L + 2L);
                return dataAccess.getShort((long)edgeId * 2L);
            }

            @Override
            public void setInt(int edgeId, int index, int value) {
                dataAccess.ensureCapacity((long)edgeId * 2L + 2L);
                if (value > Short.MAX_VALUE) {
                    throw new IllegalStateException("value too large for short: " + value);
                }
                dataAccess.setShort((long)edgeId * 2L, (short)value);
            }
        };
    }

    public TagParser getParser() {
        return this.parser;
    }

    public void createDataAccessForParser(Directory directory) {
        this.dataAccess = directory.create("max_speed_storage_tmp").create(1000L);
        this.internalMaxSpeedStorage = this.createMaxSpeedStorage(this.dataAccess);
        this.ruralMaxSpeedEnc = new DecimalEncodedValueImpl("tmp_rural", 7, 0.0, 2.0, false, false, true);
        this.urbanMaxSpeedEnc = new DecimalEncodedValueImpl("tmp_urban", 7, 0.0, 2.0, false, false, true);
        EncodedValue.InitializerConfig config = new EncodedValue.InitializerConfig();
        this.ruralMaxSpeedEnc.init(config);
        this.urbanMaxSpeedEnc.init(config);
        if (config.getRequiredBytes() > 2) {
            throw new IllegalStateException("bytes are not sufficient " + config.getRequiredBytes());
        }
        this.parser.init(this.ruralMaxSpeedEnc, this.urbanMaxSpeedEnc, this.internalMaxSpeedStorage);
    }

    public void fillMaxSpeed(Graph graph, EncodingManager em) {
        EnumEncodedValue<UrbanDensity> udEnc = em.getEnumEncodedValue("urban_density", UrbanDensity.class);
        this.fillMaxSpeed(graph, em, edge -> edge.get(udEnc) != UrbanDensity.RURAL);
    }

    public void fillMaxSpeed(Graph graph, EncodingManager em, Function<EdgeIteratorState, Boolean> isUrbanDensityFun) {
        DecimalEncodedValue maxSpeedEnc = em.getDecimalEncodedValue("max_speed");
        BooleanEncodedValue maxSpeedEstEnc = em.getBooleanEncodedValue("max_speed_estimated");
        StopWatch sw = new StopWatch().start();
        AllEdgesIterator iter = graph.getAllEdges();
        while (iter.next()) {
            double maxSpeed;
            double fwdMaxSpeedPureOSM = iter.get(maxSpeedEnc);
            double bwdMaxSpeedPureOSM = iter.getReverse(maxSpeedEnc);
            if (fwdMaxSpeedPureOSM != Double.POSITIVE_INFINITY && bwdMaxSpeedPureOSM != Double.POSITIVE_INFINITY || (maxSpeed = isUrbanDensityFun.apply(iter) != false ? this.urbanMaxSpeedEnc.getDecimal(false, iter.getEdge(), this.internalMaxSpeedStorage) : this.ruralMaxSpeedEnc.getDecimal(false, iter.getEdge(), this.internalMaxSpeedStorage)) == Double.POSITIVE_INFINITY) continue;
            if (maxSpeed == 0.0) {
                iter.set(maxSpeedEnc, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
                continue;
            }
            iter.set(maxSpeedEnc, fwdMaxSpeedPureOSM == Double.POSITIVE_INFINITY ? maxSpeed : fwdMaxSpeedPureOSM, bwdMaxSpeedPureOSM == Double.POSITIVE_INFINITY ? maxSpeed : bwdMaxSpeedPureOSM);
            iter.set(maxSpeedEstEnc, true);
        }
        LoggerFactory.getLogger(this.getClass()).info("max_speed_calculator took: " + sw.stop().getSeconds());
    }

    public void close() {
        this.dataAccess.close();
    }

    public void checkEncodedValues(EncodingManager encodingManager) {
        if (!encodingManager.hasEncodedValue("country")) {
            throw new IllegalArgumentException("max_speed_calculator needs country");
        }
        if (!encodingManager.hasEncodedValue("urban_density")) {
            throw new IllegalArgumentException("max_speed_calculator needs urban_density");
        }
    }

    static class SpeedLimitsJson {
        @JsonProperty
        private Map<String, String> meta;
        @JsonProperty
        private Map<String, RoadTypeFilterImpl> roadTypesByName;
        @JsonProperty
        private Map<String, List<RoadTypeImpl>> speedLimitsByCountryCode;
        @JsonProperty
        private List<String> warnings;

        SpeedLimitsJson() {
        }
    }

    static class RoadTypeImpl
    implements RoadType {
        private String name;
        private Map<String, String> tags;

        RoadTypeImpl() {
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTags(Map<String, String> tags) {
            this.tags = tags;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getTags() {
            return this.tags;
        }
    }

    static class RoadTypeFilterImpl
    implements RoadTypeFilter {
        private String filter;
        private String fuzzyFilter;
        private String relationFilter;

        RoadTypeFilterImpl() {
        }

        public void setFilter(String filter) {
            this.filter = filter;
        }

        public void setFuzzyFilter(String fuzzyFilter) {
            this.fuzzyFilter = fuzzyFilter;
        }

        public void setRelationFilter(String relationFilter) {
            this.relationFilter = relationFilter;
        }

        public String getFilter() {
            return this.filter;
        }

        public String getFuzzyFilter() {
            return this.fuzzyFilter;
        }

        public String getRelationFilter() {
            return this.relationFilter;
        }
    }
}

