/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.PointList;

public class SlopeCalculator
implements TagParser {
    private final DecimalEncodedValue maxSlopeEnc;
    private final DecimalEncodedValue averageSlopeEnc;
    private static final double MIN_LENGTH = 8.0;

    public SlopeCalculator(DecimalEncodedValue max, DecimalEncodedValue averageEnc) {
        this.maxSlopeEnc = max;
        this.averageSlopeEnc = averageEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        PointList pointList = way.getTag("point_list", null);
        if (pointList != null) {
            if (pointList.isEmpty() || !pointList.is3D()) {
                if (this.maxSlopeEnc != null) {
                    this.maxSlopeEnc.setDecimal(false, edgeId, edgeIntAccess, 0.0);
                }
                if (this.averageSlopeEnc != null) {
                    this.averageSlopeEnc.setDecimal(false, edgeId, edgeIntAccess, 0.0);
                }
                return;
            }
            double distance2D = DistanceCalcEarth.calcDistance(pointList, false);
            if (distance2D < 8.0) {
                if (this.averageSlopeEnc != null) {
                    this.averageSlopeEnc.setDecimal(false, edgeId, edgeIntAccess, 0.0);
                }
                return;
            }
            double towerNodeSlope = SlopeCalculator.calcSlope(pointList.getEle(pointList.size() - 1) - pointList.getEle(0), distance2D);
            if (Double.isNaN(towerNodeSlope)) {
                throw new IllegalArgumentException("average_slope was NaN for OSM way ID " + way.getId());
            }
            if (this.averageSlopeEnc != null) {
                if (towerNodeSlope >= 0.0) {
                    this.averageSlopeEnc.setDecimal(false, edgeId, edgeIntAccess, Math.min(towerNodeSlope, this.averageSlopeEnc.getMaxStorableDecimal()));
                } else {
                    this.averageSlopeEnc.setDecimal(true, edgeId, edgeIntAccess, Math.min(Math.abs(towerNodeSlope), this.averageSlopeEnc.getMaxStorableDecimal()));
                }
            }
            if (this.maxSlopeEnc != null) {
                double maxSlope = 0.0;
                double prevDist = 0.0;
                double prevLat = pointList.getLat(0);
                double prevLon = pointList.getLon(0);
                for (int i = 1; i < pointList.size(); ++i) {
                    double pillarDistance2D = DistanceCalcEarth.DIST_EARTH.calcDist(prevLat, prevLon, pointList.getLat(i), pointList.getLon(i));
                    if (i > 1 && prevDist > 8.0) {
                        double averagedPrevEle = (pointList.getEle(i - 1) + pointList.getEle(i - 2)) / 2.0;
                        double tmpSlope = SlopeCalculator.calcSlope(pointList.getEle(i) - averagedPrevEle, pillarDistance2D + prevDist / 2.0);
                        maxSlope = Math.abs(tmpSlope) > Math.abs(maxSlope) ? tmpSlope : maxSlope;
                    }
                    prevDist = pillarDistance2D;
                    prevLat = pointList.getLat(i);
                    prevLon = pointList.getLon(i);
                }
                if (way.hasTag("tunnel", (Object)"yes") || way.hasTag("bridge", (Object)"yes") || way.hasTag("highway", (Object)"steps")) {
                    maxSlope = towerNodeSlope;
                } else {
                    double d = maxSlope = Math.abs(towerNodeSlope) > Math.abs(maxSlope) ? towerNodeSlope : maxSlope;
                }
                if (Double.isNaN(maxSlope)) {
                    throw new IllegalArgumentException("max_slope was NaN for OSM way ID " + way.getId());
                }
                double val = Math.max(maxSlope, this.maxSlopeEnc.getMinStorableDecimal());
                this.maxSlopeEnc.setDecimal(false, edgeId, edgeIntAccess, Math.min(this.maxSlopeEnc.getMaxStorableDecimal(), val));
            }
        }
    }

    static double calcSlope(double eleDelta, double distance2D) {
        return eleDelta * 100.0 / distance2D;
    }
}

