/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util;

import com.graphhopper.storage.RoutingCHEdgeIteratorState;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;

public enum TraversalMode {
    NODE_BASED(false),
    EDGE_BASED(true);

    private final boolean edgeBased;

    private TraversalMode(boolean edgeBased) {
        this.edgeBased = edgeBased;
    }

    public final int createTraversalId(EdgeIteratorState edgeState, boolean reverse) {
        if (this.edgeBased) {
            return reverse ? edgeState.getReverseEdgeKey() : edgeState.getEdgeKey();
        }
        return edgeState.getAdjNode();
    }

    public final int createTraversalId(RoutingCHEdgeIteratorState chEdgeState, boolean reverse) {
        if (this.edgeBased) {
            int key;
            int n = key = reverse ? chEdgeState.getOrigEdgeKeyFirst() : chEdgeState.getOrigEdgeKeyLast();
            if (reverse && !chEdgeState.isShortcut() && chEdgeState.getBaseNode() != chEdgeState.getAdjNode()) {
                key = GHUtility.reverseEdgeKey(key);
            }
            return key;
        }
        return chEdgeState.getAdjNode();
    }

    public boolean isEdgeBased() {
        return this.edgeBased;
    }
}

