/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.countryrules.europe;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.RoadAccess;
import com.graphhopper.routing.ev.RoadClass;
import com.graphhopper.routing.util.TransportationMode;
import com.graphhopper.routing.util.countryrules.CountryRule;

public class AustriaCountryRule
implements CountryRule {
    @Override
    public RoadAccess getAccess(ReaderWay readerWay, TransportationMode transportationMode, RoadAccess currentRoadAccess) {
        if (currentRoadAccess != RoadAccess.YES) {
            return currentRoadAccess;
        }
        if (!transportationMode.isMotorVehicle()) {
            return RoadAccess.YES;
        }
        RoadClass roadClass = RoadClass.find(readerWay.getTag("highway", ""));
        switch (roadClass) {
            case LIVING_STREET: {
                return RoadAccess.DESTINATION;
            }
            case TRACK: {
                return RoadAccess.FORESTRY;
            }
            case PATH: 
            case BRIDLEWAY: 
            case CYCLEWAY: 
            case FOOTWAY: 
            case PEDESTRIAN: {
                return RoadAccess.NO;
            }
        }
        return RoadAccess.YES;
    }
}

