/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.util.FerrySpeedCalculator;
import com.graphhopper.routing.util.parsers.AbstractAverageSpeedParser;
import com.graphhopper.routing.util.parsers.OSMMaxSpeedParser;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.util.Helper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CarAverageSpeedParser
extends AbstractAverageSpeedParser
implements TagParser {
    protected final Map<String, Integer> trackTypeSpeedMap = new HashMap<String, Integer>();
    protected final Set<String> badSurfaceSpeedMap = new HashSet<String>();
    private final int badSurfaceSpeed;
    protected final Map<String, Integer> defaultSpeedMap = new HashMap<String, Integer>();

    public CarAverageSpeedParser(EncodedValueLookup lookup) {
        this(lookup.getDecimalEncodedValue(VehicleSpeed.key("car")), lookup.getDecimalEncodedValue("ferry_speed"));
    }

    public CarAverageSpeedParser(DecimalEncodedValue speedEnc, DecimalEncodedValue ferrySpeed) {
        super(speedEnc, ferrySpeed);
        this.badSurfaceSpeedMap.add("cobblestone");
        this.badSurfaceSpeedMap.add("unhewn_cobblestone");
        this.badSurfaceSpeedMap.add("sett");
        this.badSurfaceSpeedMap.add("grass_paver");
        this.badSurfaceSpeedMap.add("gravel");
        this.badSurfaceSpeedMap.add("fine_gravel");
        this.badSurfaceSpeedMap.add("pebblestone");
        this.badSurfaceSpeedMap.add("sand");
        this.badSurfaceSpeedMap.add("paving_stones");
        this.badSurfaceSpeedMap.add("dirt");
        this.badSurfaceSpeedMap.add("earth");
        this.badSurfaceSpeedMap.add("ground");
        this.badSurfaceSpeedMap.add("wood");
        this.badSurfaceSpeedMap.add("grass");
        this.badSurfaceSpeedMap.add("unpaved");
        this.badSurfaceSpeedMap.add("compacted");
        this.defaultSpeedMap.put("motorway", 100);
        this.defaultSpeedMap.put("motorway_link", 70);
        this.defaultSpeedMap.put("trunk", 70);
        this.defaultSpeedMap.put("trunk_link", 65);
        this.defaultSpeedMap.put("primary", 65);
        this.defaultSpeedMap.put("primary_link", 60);
        this.defaultSpeedMap.put("secondary", 60);
        this.defaultSpeedMap.put("secondary_link", 50);
        this.defaultSpeedMap.put("tertiary", 50);
        this.defaultSpeedMap.put("tertiary_link", 40);
        this.defaultSpeedMap.put("unclassified", 30);
        this.defaultSpeedMap.put("residential", 30);
        this.defaultSpeedMap.put("living_street", 6);
        this.defaultSpeedMap.put("pedestrian", 6);
        this.defaultSpeedMap.put("service", 20);
        this.defaultSpeedMap.put("road", 20);
        this.defaultSpeedMap.put("track", 15);
        this.trackTypeSpeedMap.put("grade1", 20);
        this.trackTypeSpeedMap.put("grade2", 15);
        this.trackTypeSpeedMap.put("grade3", 10);
        this.trackTypeSpeedMap.put(null, this.defaultSpeedMap.get("track"));
        this.badSurfaceSpeed = 30;
    }

    protected double getSpeed(ReaderWay way) {
        Integer tInt;
        String tt;
        String highwayValue = way.getTag("highway", "");
        Integer speed = this.defaultSpeedMap.get(highwayValue);
        if (speed == null) {
            speed = 10;
        }
        if (highwayValue.equals("track") && !Helper.isEmpty((String)(tt = way.getTag("tracktype"))) && (tInt = this.trackTypeSpeedMap.get(tt)) != null) {
            speed = tInt;
        }
        return speed.intValue();
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way) {
        if (FerrySpeedCalculator.isFerry(way)) {
            double ferrySpeed = FerrySpeedCalculator.minmax(this.ferrySpeedEnc.getDecimal(false, edgeId, edgeIntAccess), this.avgSpeedEnc);
            this.setSpeed(false, edgeId, edgeIntAccess, ferrySpeed);
            if (this.avgSpeedEnc.isStoreTwoDirections()) {
                this.setSpeed(true, edgeId, edgeIntAccess, ferrySpeed);
            }
            return;
        }
        double speed = this.getSpeed(way);
        speed = this.applyBadSurfaceSpeed(way, speed);
        this.setSpeed(false, edgeId, edgeIntAccess, this.applyMaxSpeed(way, speed, false));
        this.setSpeed(true, edgeId, edgeIntAccess, this.applyMaxSpeed(way, speed, true));
    }

    protected double applyMaxSpeed(ReaderWay way, double speed, boolean bwd) {
        double maxSpeed = OSMMaxSpeedParser.parseMaxSpeed(way, bwd);
        return maxSpeed != Double.POSITIVE_INFINITY ? Math.max(1.0, maxSpeed * 0.9) : speed;
    }

    protected double applyBadSurfaceSpeed(ReaderWay way, double speed) {
        if (this.badSurfaceSpeed > 0 && speed > (double)this.badSurfaceSpeed) {
            String surface = way.getTag("surface", "");
            int colonIndex = surface.indexOf(":");
            if (colonIndex != -1) {
                surface = surface.substring(0, colonIndex);
            }
            if (this.badSurfaceSpeedMap.contains(surface)) {
                speed = this.badSurfaceSpeed;
            }
        }
        return speed;
    }
}

