/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.util.parsers;

import com.graphhopper.reader.ReaderWay;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.util.parsers.TagParser;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.util.Helper;

public class OSMMaxSpeedParser
implements TagParser {
    public static final double MAXSPEED_NONE = -1.0;
    private final DecimalEncodedValue carMaxSpeedEnc;

    public OSMMaxSpeedParser(DecimalEncodedValue carMaxSpeedEnc) {
        if (!carMaxSpeedEnc.isStoreTwoDirections()) {
            throw new IllegalArgumentException("EncodedValue for maxSpeed must be able to store two directions");
        }
        this.carMaxSpeedEnc = carMaxSpeedEnc;
    }

    @Override
    public void handleWayTags(int edgeId, EdgeIntAccess edgeIntAccess, ReaderWay way, IntsRef relationFlags) {
        this.carMaxSpeedEnc.setDecimal(false, edgeId, edgeIntAccess, OSMMaxSpeedParser.parseMaxSpeed(way, false));
        this.carMaxSpeedEnc.setDecimal(true, edgeId, edgeIntAccess, OSMMaxSpeedParser.parseMaxSpeed(way, true));
    }

    public static double parseMaxSpeed(ReaderWay way, boolean reverse) {
        double directedMaxSpeed = OSMMaxSpeedParser.parseMaxSpeedTag(way, reverse ? "maxspeed:backward" : "maxspeed:forward");
        if (directedMaxSpeed != Double.POSITIVE_INFINITY) {
            return directedMaxSpeed;
        }
        return OSMMaxSpeedParser.parseMaxSpeedTag(way, "maxspeed");
    }

    private static double parseMaxSpeedTag(ReaderWay way, String tag) {
        double maxSpeed = OSMMaxSpeedParser.parseMaxspeedString(way.getTag(tag));
        if (maxSpeed != Double.POSITIVE_INFINITY && maxSpeed != -1.0) {
            return Math.min(150.0, maxSpeed);
        }
        if (maxSpeed == -1.0 && way.hasTag("highway", "motorway", "motorway_link", "trunk", "trunk_link", "primary")) {
            return 150.0;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static double parseMaxspeedString(String str) {
        double value;
        double factor;
        if (Helper.isEmpty((String)str)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("walk".equals(str.trim())) {
            return 6.0;
        }
        if ("none".equals(str.trim())) {
            return -1.0;
        }
        int mpInteger = str.indexOf("mp");
        int knotInteger = str.indexOf("knots");
        int kmInteger = str.indexOf("km");
        int kphInteger = str.indexOf("kph");
        if (mpInteger > 0) {
            str = str.substring(0, mpInteger).trim();
            factor = 1.609344;
        } else if (knotInteger > 0) {
            str = str.substring(0, knotInteger).trim();
            factor = 1.852;
        } else {
            if (kmInteger > 0) {
                str = str.substring(0, kmInteger).trim();
            } else if (kphInteger > 0) {
                str = str.substring(0, kphInteger).trim();
            }
            factor = 1.0;
        }
        try {
            value = Double.parseDouble(str) * factor;
        }
        catch (Exception ex) {
            return Double.POSITIVE_INFINITY;
        }
        if (value < 4.8) {
            return Double.POSITIVE_INFINITY;
        }
        return value;
    }
}

