/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.TurnCostsConfig;

public class DefaultTurnCostProvider
implements TurnCostProvider {
    private final BooleanEncodedValue turnRestrictionEnc;
    private final TurnCostStorage turnCostStorage;
    private final int uTurnCostsInt;
    private final double uTurnCosts;
    private final boolean uTurnTimesEnabled;
    private final BaseGraph graph;
    private final EdgeIntAccess edgeIntAccess;
    private final CustomWeighting.TurnPenaltyMapping turnPenaltyMapping;

    public DefaultTurnCostProvider(BooleanEncodedValue turnRestrictionEnc, Graph graph, TurnCostsConfig tcConfig, CustomWeighting.TurnPenaltyMapping turnPenaltyMapping) {
        this.uTurnCostsInt = tcConfig.getUTurnCosts();
        if (this.uTurnCostsInt < 0 && this.uTurnCostsInt != -1) {
            throw new IllegalArgumentException("u-turn costs must be positive, or equal to -1 (=infinite costs)");
        }
        this.uTurnCosts = this.uTurnCostsInt < 0 ? Double.POSITIVE_INFINITY : (double)this.uTurnCostsInt;
        this.uTurnTimesEnabled = tcConfig.getEnableUTurnTimes();
        if (graph.getTurnCostStorage() == null) {
            throw new IllegalArgumentException("No storage set to calculate turn weight");
        }
        this.turnRestrictionEnc = turnRestrictionEnc;
        this.turnCostStorage = graph.getTurnCostStorage();
        this.graph = graph.getBaseGraph();
        this.edgeIntAccess = graph.getBaseGraph().getEdgeAccess();
        this.turnPenaltyMapping = turnPenaltyMapping;
    }

    private boolean isUTurn(int inEdge, int outEdge) {
        return inEdge == outEdge;
    }

    @Override
    public double calcTurnWeight(int inEdge, int viaNode, int outEdge) {
        if (!EdgeIterator.Edge.isValid(inEdge) || !EdgeIterator.Edge.isValid(outEdge)) {
            return 0.0;
        }
        if (inEdge == outEdge) {
            return this.uTurnCosts;
        }
        if (this.turnRestrictionEnc != null && this.turnCostStorage.get(this.turnRestrictionEnc, inEdge, viaNode, outEdge)) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.turnPenaltyMapping != null) {
            return this.turnPenaltyMapping.get(this.graph, this.edgeIntAccess, inEdge, viaNode, outEdge);
        }
        return 0.0;
    }

    @Override
    public long calcTurnMillis(int inEdge, int viaNode, int outEdge) {
        if (this.uTurnTimesEnabled && this.isUTurn(inEdge, outEdge)) {
            return (long)(1000.0 * this.uTurnCosts);
        }
        return 0L;
    }

    public String toString() {
        return "default_tcp_" + this.uTurnCostsInt;
    }
}

