/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.custom.ClassHelper;
import com.graphhopper.routing.weighting.custom.ConditionalExpressionVisitor;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.routing.weighting.custom.CustomWeightingHelper;
import com.graphhopper.routing.weighting.custom.NameValidator;
import com.graphhopper.routing.weighting.custom.ParseResult;
import com.graphhopper.routing.weighting.custom.ValueExpressionVisitor;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.JsonFeatureCollection;
import com.graphhopper.util.shapes.BBox;
import com.graphhopper.util.shapes.Polygon;
import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.Location;
import org.codehaus.commons.compiler.io.Readers;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.SimpleCompiler;
import org.codehaus.janino.Unparser;
import org.codehaus.janino.util.DeepCopier;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.slf4j.LoggerFactory;

public class CustomModelParser {
    private static final AtomicLong longVal = new AtomicLong(1L);
    static final String IN_AREA_PREFIX = "in_";
    static final String BACKWARD_PREFIX = "backward_";
    static final String PREV_PREFIX = "prev_";
    static final String CHANGE_ANGLE = "change_angle";
    private static final boolean JANINO_DEBUG = Boolean.getBoolean("org.codehaus.janino.source_debugging.enable");
    private static final String SCRIPT_FILE_DIR = System.getProperty("org.codehaus.janino.source_debugging.dir", "./src/main/java/com/graphhopper/routing/weighting/custom");
    private static final int CACHE_SIZE = Integer.getInteger("graphhopper.custom_weighting.cache_size", 1000);
    private static final Map<String, Class<?>> CACHE = Collections.synchronizedMap(new LinkedHashMap<String, Class<?>>(CACHE_SIZE, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > CACHE_SIZE;
        }
    });
    private static final Map<String, Class<?>> INTERNAL_CACHE = Collections.synchronizedMap(new HashMap());

    private CustomModelParser() {
    }

    public static CustomWeighting createWeighting(EncodedValueLookup lookup, TurnCostProvider turnCostProvider, CustomModel customModel) {
        if (customModel == null) {
            throw new IllegalStateException("CustomModel cannot be null");
        }
        CustomWeighting.Parameters parameters = CustomModelParser.createWeightingParameters(customModel, lookup);
        return new CustomWeighting(turnCostProvider, parameters);
    }

    public static CustomWeighting.Parameters createWeightingParameters(CustomModel customModel, EncodedValueLookup lookup) {
        Class<?> clazz;
        String key = customModel.toString();
        Class<?> clazz2 = clazz = customModel.isInternal() ? INTERNAL_CACHE.get(key) : null;
        if (CACHE_SIZE > 0 && clazz == null) {
            clazz = CACHE.get(key);
        }
        if (clazz == null) {
            clazz = CustomModelParser.createClazz(customModel, lookup);
            if (customModel.isInternal()) {
                INTERNAL_CACHE.put(key, clazz);
                if (INTERNAL_CACHE.size() > 100) {
                    CACHE.putAll(INTERNAL_CACHE);
                    INTERNAL_CACHE.clear();
                    LoggerFactory.getLogger(CustomModelParser.class).warn("Internal cache must stay small but was " + INTERNAL_CACHE.size() + ". Cleared it. Misuse of CustomModel::internal?");
                }
            } else if (CACHE_SIZE > 0) {
                CACHE.put(key, clazz);
            }
        }
        try {
            CustomWeightingHelper prio = (CustomWeightingHelper)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            prio.init(customModel, lookup, CustomModel.getAreasAsMap((JsonFeatureCollection)customModel.getAreas()));
            return new CustomWeighting.Parameters(prio::getSpeed, prio::calcMaxSpeed, prio::getPriority, prio::calcMaxPriority, prio::getTurnPenalty, customModel.getDistanceInfluence() == null ? 0.0 : customModel.getDistanceInfluence(), customModel.getHeadingPenalty() == null ? 300.0 : customModel.getHeadingPenalty());
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalArgumentException("Cannot compile expression " + ex.getMessage(), ex);
        }
    }

    private static Class<?> createClazz(CustomModel customModel, EncodedValueLookup lookup) {
        try {
            Set<String> priorityVariables = ValueExpressionVisitor.findVariables(customModel.getPriority(), lookup);
            List<Java.BlockStatement> priorityStatements = CustomModelParser.createGetPriorityStatements(priorityVariables, customModel, lookup);
            if (customModel.getSpeed().isEmpty()) {
                throw new IllegalArgumentException("At least one initial statement under 'speed' is required.");
            }
            List<Statement> firstGroup = CustomModelParser.splitIntoGroup(customModel.getSpeed()).get(0);
            if (firstGroup.size() > 1) {
                Statement lastSt = firstGroup.get(firstGroup.size() - 1);
                if (lastSt.operation() != Statement.Op.LIMIT || lastSt.keyword() != Statement.Keyword.ELSE) {
                    throw new IllegalArgumentException("The first group needs to end with an 'else' (or contain a single unconditional 'if' statement).");
                }
            } else {
                Statement firstSt = firstGroup.get(0);
                if (!"true".equals(firstSt.condition()) || firstSt.operation() != Statement.Op.LIMIT || firstSt.keyword() != Statement.Keyword.IF) {
                    throw new IllegalArgumentException("The first group needs to contain a single unconditional 'if' statement (or end with an 'else').");
                }
            }
            Set<String> speedVariables = ValueExpressionVisitor.findVariables(customModel.getSpeed(), lookup);
            List<Java.BlockStatement> speedStatements = CustomModelParser.createGetSpeedStatements(speedVariables, customModel, lookup);
            Set<String> turnPenaltyVariables = ValueExpressionVisitor.findVariables(customModel.getTurnPenalty(), lookup);
            List<Java.BlockStatement> turnPenaltyStatements = CustomModelParser.createGetTurnPenaltyStatements(turnPenaltyVariables, customModel, lookup);
            long counter = longVal.incrementAndGet();
            String classTemplate = CustomModelParser.createClassTemplate(counter, priorityVariables, speedVariables, turnPenaltyVariables, lookup, CustomModel.getAreasAsMap((JsonFeatureCollection)customModel.getAreas()));
            Java.CompilationUnit cu = (Java.CompilationUnit)new Parser(new Scanner("source", (Reader)new StringReader(classTemplate))).parseAbstractCompilationUnit();
            cu = CustomModelParser.injectStatements(priorityStatements, speedStatements, turnPenaltyStatements, cu);
            SimpleCompiler sc = CustomModelParser.createCompiler(counter, (Java.AbstractCompilationUnit)cu);
            return sc.getClassLoader().loadClass("com.graphhopper.routing.weighting.custom.JaninoCustomWeightingHelperSubclass" + counter);
        }
        catch (Exception ex) {
            String errString = "Cannot compile expression";
            throw new IllegalArgumentException(errString + ": " + ex.getMessage(), ex);
        }
    }

    public static List<String> findVariablesForEncodedValuesString(CustomModel model, NameValidator nameValidator, ClassHelper classHelper) {
        LinkedHashSet variables = new LinkedHashSet();
        NameValidator nameValidatorIntern = s -> {
            if (Character.isUpperCase(s.charAt(0)) || s.startsWith(IN_AREA_PREFIX)) {
                return true;
            }
            if (nameValidator.isValid(s)) {
                variables.add(s);
                return true;
            }
            return false;
        };
        CustomModelParser.findVariablesForEncodedValuesString(model.getPriority(), nameValidatorIntern, classHelper);
        CustomModelParser.findVariablesForEncodedValuesString(model.getSpeed(), nameValidatorIntern, classHelper);
        return new ArrayList<String>(variables);
    }

    private static void findVariablesForEncodedValuesString(List<Statement> statements, NameValidator nameValidator, ClassHelper classHelper) {
        List<List<Statement>> groups = CustomModelParser.splitIntoGroup(statements);
        for (List<Statement> group : groups) {
            for (Statement statement : group) {
                if (statement.isBlock()) {
                    CustomModelParser.findVariablesForEncodedValuesString(statement.doBlock(), nameValidator, classHelper);
                    continue;
                }
                ConditionalExpressionVisitor.parse(statement.condition(), nameValidator, classHelper);
                ValueExpressionVisitor.parse(statement.value(), nameValidator);
            }
        }
    }

    static List<List<Statement>> splitIntoGroup(List<Statement> statements) {
        ArrayList<List<Statement>> result = new ArrayList<List<Statement>>();
        ArrayList<Statement> group = null;
        for (Statement st : statements) {
            if (Statement.Keyword.IF.equals((Object)st.keyword())) {
                group = new ArrayList<Statement>();
                result.add(group);
            }
            if (group == null) {
                throw new IllegalArgumentException("Every group must start with an if-statement");
            }
            group.add(st);
        }
        return result;
    }

    private static List<Java.BlockStatement> createGetSpeedStatements(Set<String> speedVariables, CustomModel customModel, EncodedValueLookup lookup) throws Exception {
        ArrayList<Java.BlockStatement> speedStatements = new ArrayList<Java.BlockStatement>(CustomModelParser.verifyExpressions(new StringBuilder(), "speed entry", speedVariables, customModel.getSpeed(), lookup));
        String speedMethodStartBlock = "double value = " + CustomWeightingHelper.GLOBAL_MAX_SPEED + ";\n";
        for (String arg : speedVariables) {
            speedMethodStartBlock = speedMethodStartBlock + CustomModelParser.getVariableDeclaration(lookup, arg);
        }
        speedStatements.addAll(0, new Parser(new Scanner("getSpeed", (Reader)new StringReader(speedMethodStartBlock))).parseBlockStatements());
        return speedStatements;
    }

    private static List<Java.BlockStatement> createGetPriorityStatements(Set<String> priorityVariables, CustomModel customModel, EncodedValueLookup lookup) throws Exception {
        for (Statement s : customModel.getPriority()) {
            if (s.operation() != Statement.Op.ADD) continue;
            throw new IllegalArgumentException("'priority' statement must not have the operation 'add'");
        }
        ArrayList<Java.BlockStatement> priorityStatements = new ArrayList<Java.BlockStatement>(CustomModelParser.verifyExpressions(new StringBuilder(), "priority entry", priorityVariables, customModel.getPriority(), lookup));
        String priorityMethodStartBlock = "double value = " + CustomWeightingHelper.GLOBAL_PRIORITY + ";\n";
        for (String arg : priorityVariables) {
            priorityMethodStartBlock = priorityMethodStartBlock + CustomModelParser.getVariableDeclaration(lookup, arg);
        }
        priorityStatements.addAll(0, new Parser(new Scanner("getPriority", (Reader)new StringReader(priorityMethodStartBlock))).parseBlockStatements());
        return priorityStatements;
    }

    private static List<Java.BlockStatement> createGetTurnPenaltyStatements(Set<String> turnPenaltyVariables, CustomModel customModel, EncodedValueLookup lookup) throws Exception {
        for (Statement s : customModel.getTurnPenalty()) {
            if (s.operation() == Statement.Op.ADD && s.value().trim().startsWith("-")) {
                throw new IllegalArgumentException("The value for the 'add' operation must be positive, but was: " + s.value());
            }
            if (s.isBlock()) {
                throw new IllegalArgumentException("'turn_penalty' statement cannot be a block (not yet implemented)");
            }
            if (s.operation() == Statement.Op.ADD) continue;
            throw new IllegalArgumentException("'turn_penalty' statement must have the operation 'add' but was: " + String.valueOf(s.operation()) + " (not yet implemented)");
        }
        ArrayList<Java.BlockStatement> turnPenaltyStatements = new ArrayList<Java.BlockStatement>(CustomModelParser.verifyExpressions(new StringBuilder(), "turn_penalty entry", turnPenaltyVariables, customModel.getTurnPenalty(), lookup));
        boolean needTwoDirections = false;
        Function<String, EncodedValue> fct = CustomModelParser.createSimplifiedLookup(lookup);
        for (String ttv : turnPenaltyVariables) {
            EncodedValue ev = fct.apply(ttv);
            if ((ev == null || !ev.isStoreTwoDirections()) && !ttv.equals(CHANGE_ANGLE)) continue;
            needTwoDirections = true;
            break;
        }
        Object turnPenaltyMethodStartBlock = "double value = 0;\n";
        if (needTwoDirections) {
            turnPenaltyMethodStartBlock = (String)turnPenaltyMethodStartBlock + "boolean inEdgeReverse = !graph.isAdjNode(inEdge, viaNode);\nboolean outEdgeReverse = !graph.isAdjNode(outEdge, viaNode);\n";
        }
        for (String arg : turnPenaltyVariables) {
            turnPenaltyMethodStartBlock = (String)turnPenaltyMethodStartBlock + CustomModelParser.getTurnPenaltyVariableDeclaration(lookup, arg, needTwoDirections);
        }
        if (turnPenaltyVariables.contains(CHANGE_ANGLE)) {
            turnPenaltyVariables.remove(CHANGE_ANGLE);
            turnPenaltyVariables.add("orientation");
        }
        turnPenaltyStatements.addAll(0, new Parser(new Scanner("getTurnPenalty", (Reader)new StringReader((String)turnPenaltyMethodStartBlock))).parseBlockStatements());
        return turnPenaltyStatements;
    }

    private static String getVariableDeclaration(EncodedValueLookup lookup, String arg) {
        if (lookup.hasEncodedValue(arg)) {
            EncodedValue enc = lookup.getEncodedValue(arg, EncodedValue.class);
            return CustomModelParser.getReturnType(enc) + " " + arg + " = (" + CustomModelParser.getReturnType(enc) + ") (reverse ? edge.getReverse((" + CustomModelParser.getInterface(enc) + ") this." + arg + "_enc) : edge.get((" + CustomModelParser.getInterface(enc) + ") this." + arg + "_enc));\n";
        }
        if (arg.startsWith(BACKWARD_PREFIX)) {
            String argSubstr = arg.substring(BACKWARD_PREFIX.length());
            if (lookup.hasEncodedValue(argSubstr)) {
                EncodedValue enc = lookup.getEncodedValue(argSubstr, EncodedValue.class);
                return CustomModelParser.getReturnType(enc) + " " + arg + " = (" + CustomModelParser.getReturnType(enc) + ") (reverse ? edge.get((" + CustomModelParser.getInterface(enc) + ") this." + argSubstr + "_enc) : edge.getReverse((" + CustomModelParser.getInterface(enc) + ") this." + argSubstr + "_enc));\n";
            }
            throw new IllegalArgumentException("Not supported for backward: " + argSubstr);
        }
        if (arg.startsWith(IN_AREA_PREFIX)) {
            return "";
        }
        throw new IllegalArgumentException("Not supported " + arg);
    }

    private static String getTurnPenaltyVariableDeclaration(EncodedValueLookup lookup, String arg, boolean needTwoDirections) {
        if (arg.equals(CHANGE_ANGLE)) {
            return "double change_angle = CustomWeightingHelper.calcChangeAngle(edgeIntAccess, this.orientation_enc, inEdge, inEdgeReverse, outEdge, outEdgeReverse);\n";
        }
        if (lookup.hasEncodedValue(arg)) {
            EncodedValue enc = lookup.getEncodedValue(arg, EncodedValue.class);
            if (!(enc instanceof EnumEncodedValue)) {
                throw new IllegalArgumentException("Currently only EnumEncodedValues are supported: " + arg);
            }
            return CustomModelParser.getReturnType(enc) + " " + arg + " = (" + CustomModelParser.getReturnType(enc) + ") this." + arg + "_enc.getEnum(" + (needTwoDirections ? "outEdgeReverse" : "false") + ", outEdge, edgeIntAccess);\n";
        }
        if (arg.startsWith(PREV_PREFIX)) {
            String argSubstr = arg.substring(PREV_PREFIX.length());
            if (lookup.hasEncodedValue(argSubstr)) {
                EncodedValue enc = lookup.getEncodedValue(argSubstr, EncodedValue.class);
                if (!(enc instanceof EnumEncodedValue)) {
                    throw new IllegalArgumentException("Currently only EnumEncodedValues are supported: " + arg);
                }
                return CustomModelParser.getReturnType(enc) + " " + arg + " = (" + CustomModelParser.getReturnType(enc) + ") this." + argSubstr + "_enc.getEnum(" + (needTwoDirections ? "inEdgeReverse" : "false") + ", inEdge, edgeIntAccess);\n";
            }
            throw new IllegalArgumentException("Not supported for prev: " + argSubstr);
        }
        throw new IllegalArgumentException("Not supported for turn_penalty: " + arg);
    }

    private static String getInterface(EncodedValue enc) {
        if (enc instanceof StringEncodedValue) {
            return IntEncodedValue.class.getSimpleName();
        }
        if (enc.getClass().getInterfaces().length == 0) {
            return enc.getClass().getSimpleName();
        }
        return enc.getClass().getInterfaces()[0].getSimpleName();
    }

    private static String getReturnType(EncodedValue encodedValue) {
        if (encodedValue instanceof EnumEncodedValue) {
            Class cl = ((EnumEncodedValue)encodedValue).getEnumType();
            return cl.getPackage().equals(EnumEncodedValue.class.getPackage()) ? cl.getSimpleName() : cl.getName();
        }
        if (encodedValue instanceof StringEncodedValue) {
            return "int";
        }
        if (encodedValue instanceof DecimalEncodedValue) {
            return "double";
        }
        if (encodedValue instanceof BooleanEncodedValue) {
            return "boolean";
        }
        if (encodedValue instanceof IntEncodedValue) {
            return "int";
        }
        throw new IllegalArgumentException("Unsupported EncodedValue: " + String.valueOf(encodedValue.getClass()));
    }

    private static String createClassTemplate(long counter, Set<String> priorityVariables, Set<String> speedVariables, Set<String> turnPenaltyVariables, EncodedValueLookup lookup, Map<String, JsonFeature> areas) {
        StringBuilder importSourceCode = new StringBuilder("import com.graphhopper.routing.ev.*;\n");
        importSourceCode.append("import java.util.Map;\n");
        importSourceCode.append("import " + CustomModel.class.getName() + ";\n");
        importSourceCode.append("import " + BaseGraph.class.getName() + ";\n");
        importSourceCode.append("import " + EdgeIntAccess.class.getName() + ";\n");
        StringBuilder classSourceCode = new StringBuilder(100);
        boolean includedAreaImports = false;
        StringBuilder initSourceCode = new StringBuilder("this.lookup = lookup;\n");
        initSourceCode.append("this.customModel = customModel;\n");
        HashSet<String> set = new HashSet<String>();
        for (String prioVar : priorityVariables) {
            set.add(prioVar.startsWith(BACKWARD_PREFIX) ? prioVar.substring(BACKWARD_PREFIX.length()) : prioVar);
        }
        for (String speedVar : speedVariables) {
            set.add(speedVar.startsWith(BACKWARD_PREFIX) ? speedVar.substring(BACKWARD_PREFIX.length()) : speedVar);
        }
        for (String speedVar : turnPenaltyVariables) {
            set.add(speedVar.startsWith(PREV_PREFIX) ? speedVar.substring(PREV_PREFIX.length()) : speedVar);
        }
        for (String arg : set) {
            if (lookup.hasEncodedValue(arg)) {
                EncodedValue enc = lookup.getEncodedValue(arg, EncodedValue.class);
                classSourceCode.append("protected " + CustomModelParser.getInterface(enc) + " " + arg + "_enc;\n");
                initSourceCode.append("this." + arg + "_enc = (" + CustomModelParser.getInterface(enc) + ") lookup.getEncodedValue(\"" + arg + "\", EncodedValue.class);\n");
                continue;
            }
            if (arg.startsWith(IN_AREA_PREFIX)) {
                if (!includedAreaImports) {
                    importSourceCode.append("import " + BBox.class.getName() + ";\n");
                    importSourceCode.append("import " + GHUtility.class.getName() + ";\n");
                    importSourceCode.append("import " + PreparedPolygon.class.getName() + ";\n");
                    importSourceCode.append("import " + Polygonal.class.getName() + ";\n");
                    importSourceCode.append("import " + JsonFeature.class.getName() + ";\n");
                    importSourceCode.append("import " + Polygon.class.getName() + ";\n");
                    includedAreaImports = true;
                }
                if (!JsonFeature.isValidId((String)arg)) {
                    throw new IllegalArgumentException("Area has invalid name: " + arg);
                }
                String id = arg.substring(IN_AREA_PREFIX.length());
                JsonFeature feature = areas.get(id);
                if (feature == null) {
                    throw new IllegalArgumentException("Area '" + id + "' wasn't found");
                }
                if (feature.getGeometry() == null) {
                    throw new IllegalArgumentException("Area '" + id + "' does not contain a geometry");
                }
                if (!(feature.getGeometry() instanceof Polygonal)) {
                    throw new IllegalArgumentException("Currently only type=Polygon is supported for areas but was " + feature.getGeometry().getGeometryType());
                }
                if (feature.getBBox() != null) {
                    throw new IllegalArgumentException("Bounding box of area " + id + " must be empty");
                }
                classSourceCode.append("protected " + Polygon.class.getSimpleName() + " " + arg + ";\n");
                initSourceCode.append("JsonFeature feature_" + id + " = (JsonFeature) areas.get(\"" + id + "\");\n");
                initSourceCode.append("this." + arg + " = new Polygon(new PreparedPolygon((Polygonal) feature_" + id + ".getGeometry()));\n");
                continue;
            }
            if (arg.startsWith(IN_AREA_PREFIX)) continue;
            throw new IllegalArgumentException("Variable not supported: " + arg);
        }
        return "package com.graphhopper.routing.weighting.custom;\nimport " + CustomWeightingHelper.class.getName() + ";\nimport " + EncodedValueLookup.class.getName() + ";\nimport " + EdgeIteratorState.class.getName() + ";\n" + String.valueOf(importSourceCode) + "\npublic class JaninoCustomWeightingHelperSubclass" + counter + " extends " + CustomWeightingHelper.class.getSimpleName() + " {\n" + String.valueOf(classSourceCode) + "   @Override\n   public void init(CustomModel customModel, EncodedValueLookup lookup, Map<String, " + JsonFeature.class.getName() + "> areas) {\n" + String.valueOf(initSourceCode) + "   }\n\n   @Override\n   public double getPriority(EdgeIteratorState edge, boolean reverse) {\n      return 1; //will be overwritten by code injected in DeepCopier\n   }\n   @Override\n   public double getSpeed(EdgeIteratorState edge, boolean reverse) {\n      return 1; //will be overwritten by code injected in DeepCopier\n   }\n   @Override\n   public double getTurnPenalty(BaseGraph graph, EdgeIntAccess edgeIntAccess, int inEdge, int viaNode, int outEdge) {\n      return 1; //will be overwritten by code injected in DeepCopier\n   }\n}";
    }

    private static List<Java.BlockStatement> verifyExpressions(StringBuilder expressions, String info, Set<String> createObjects, List<Statement> list, EncodedValueLookup lookup) throws Exception {
        NameValidator nameInConditionValidator = name -> lookup.hasEncodedValue(name) || name.toUpperCase(Locale.ROOT).equals(name) || name.startsWith(IN_AREA_PREFIX) || name.equals(CHANGE_ANGLE) || name.startsWith(BACKWARD_PREFIX) && lookup.hasEncodedValue(name.substring(BACKWARD_PREFIX.length())) || name.startsWith(PREV_PREFIX) && lookup.hasEncodedValue(name.substring(PREV_PREFIX.length()));
        Function<String, EncodedValue> fct = CustomModelParser.createSimplifiedLookup(lookup);
        ClassHelper helper = key -> {
            EncodedValue ev = (EncodedValue)fct.apply(key);
            if (ev == null) {
                throw new IllegalArgumentException("Couldn't find class for " + key);
            }
            return CustomModelParser.getReturnType(ev);
        };
        CustomModelParser.parseExpressions(expressions, nameInConditionValidator, info, createObjects, list, helper, "");
        expressions.append("return value;\n");
        return new Parser(new Scanner(info, (Reader)new StringReader(expressions.toString()))).parseBlockStatements();
    }

    private static Function<String, EncodedValue> createSimplifiedLookup(EncodedValueLookup lookup) {
        return key -> {
            if (key.startsWith(BACKWARD_PREFIX)) {
                return lookup.getEncodedValue(key.substring(BACKWARD_PREFIX.length()), EncodedValue.class);
            }
            if (key.startsWith(PREV_PREFIX)) {
                return lookup.getEncodedValue(key.substring(PREV_PREFIX.length()), EncodedValue.class);
            }
            if (lookup.hasEncodedValue((String)key)) {
                return lookup.getEncodedValue((String)key, EncodedValue.class);
            }
            return null;
        };
    }

    static void parseExpressions(StringBuilder expressions, NameValidator nameInConditionValidator, String exceptionInfo, Set<String> createObjects, List<Statement> list, ClassHelper classHelper, String indentation) {
        for (Statement statement : list) {
            if (statement.keyword() == Statement.Keyword.ELSE) {
                if (!Helper.isEmpty((String)statement.condition())) {
                    throw new IllegalArgumentException("condition must be empty but was " + statement.condition());
                }
                expressions.append(indentation);
                if (statement.isBlock()) {
                    expressions.append("else {");
                    CustomModelParser.parseExpressions(expressions, nameInConditionValidator, exceptionInfo, createObjects, statement.doBlock(), classHelper, indentation + "  ");
                    expressions.append(indentation).append("}\n");
                    continue;
                }
                expressions.append("else {").append(statement.operation().build(statement.value())).append("; }\n");
                continue;
            }
            if (statement.keyword() == Statement.Keyword.ELSEIF || statement.keyword() == Statement.Keyword.IF) {
                ParseResult parseResult = ConditionalExpressionVisitor.parse(statement.condition(), nameInConditionValidator, classHelper);
                if (!parseResult.ok) {
                    throw new IllegalArgumentException(exceptionInfo + " invalid condition \"" + statement.condition() + "\"" + (String)(parseResult.invalidMessage == null ? "" : ": " + parseResult.invalidMessage));
                }
                createObjects.addAll(parseResult.guessedVariables);
                if (statement.keyword() == Statement.Keyword.ELSEIF) {
                    expressions.append(indentation).append("else ");
                }
                expressions.append(indentation);
                if (statement.isBlock()) {
                    expressions.append("if (").append((CharSequence)parseResult.converted).append(") {\n");
                    CustomModelParser.parseExpressions(expressions, nameInConditionValidator, exceptionInfo, createObjects, statement.doBlock(), classHelper, indentation + "  ");
                    expressions.append(indentation).append("}\n");
                    continue;
                }
                expressions.append("if (").append((CharSequence)parseResult.converted).append(") {").append(statement.operation().build(statement.value())).append(";}\n");
                continue;
            }
            throw new IllegalArgumentException("The statement must be either 'if', 'else_if' or 'else'");
        }
    }

    private static Java.CompilationUnit injectStatements(final List<Java.BlockStatement> priorityStatements, final List<Java.BlockStatement> speedStatements, final List<Java.BlockStatement> turnPenaltyStatements, Java.CompilationUnit cu) throws CompileException {
        cu = new DeepCopier(){
            boolean speedInjected = false;
            boolean priorityInjected = false;
            boolean turnPenaltyInjected = false;

            public Java.MethodDeclarator copyMethodDeclarator(Java.MethodDeclarator subject) throws CompileException {
                if (subject.name.equals("getSpeed") && !speedStatements.isEmpty() && !this.speedInjected) {
                    this.speedInjected = true;
                    return CustomModelParser.injectStatements(subject, this, speedStatements);
                }
                if (subject.name.equals("getPriority") && !priorityStatements.isEmpty() && !this.priorityInjected) {
                    this.priorityInjected = true;
                    return CustomModelParser.injectStatements(subject, this, priorityStatements);
                }
                if (subject.name.equals("getTurnPenalty") && !turnPenaltyStatements.isEmpty() && !this.turnPenaltyInjected) {
                    this.turnPenaltyInjected = true;
                    return CustomModelParser.injectStatements(subject, this, turnPenaltyStatements);
                }
                return super.copyMethodDeclarator(subject);
            }
        }.copyCompilationUnit(cu);
        return cu;
    }

    private static Java.MethodDeclarator injectStatements(Java.MethodDeclarator subject, DeepCopier deepCopier, List<Java.BlockStatement> statements) {
        try {
            if (statements.isEmpty()) {
                throw new IllegalArgumentException("Statements cannot be empty when copying method");
            }
            Java.MethodDeclarator methodDecl = new Java.MethodDeclarator(new Location("m1", 1, 1), subject.getDocComment(), deepCopier.copyModifiers(subject.getModifiers()), deepCopier.copyOptionalTypeParameters(subject.typeParameters), deepCopier.copyType(subject.type), subject.name, deepCopier.copyFormalParameters(subject.formalParameters), deepCopier.copyTypes(subject.thrownExceptions), deepCopier.copyOptionalElementValue(subject.defaultValue), deepCopier.copyOptionalStatements(statements));
            statements.forEach(st -> st.setEnclosingScope((Java.Scope)methodDecl));
            return methodDecl;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static SimpleCompiler createCompiler(long counter, Java.AbstractCompilationUnit cu) throws CompileException {
        if (JANINO_DEBUG) {
            try {
                StringWriter sw = new StringWriter();
                Unparser.unparse((Java.AbstractCompilationUnit)cu, (Writer)sw);
                File dir = new File(SCRIPT_FILE_DIR);
                File temporaryFile = new File(dir, "JaninoCustomWeightingHelperSubclass" + counter + ".java");
                Reader reader = Readers.teeReader((Reader)new StringReader(sw.toString()), (Writer)new FileWriter(temporaryFile), (boolean)true);
                return new SimpleCompiler(temporaryFile.getAbsolutePath(), reader);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        SimpleCompiler compiler = new SimpleCompiler();
        compiler.cook(cu);
        return compiler;
    }
}

