/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.routing.weighting.custom;

import com.graphhopper.json.MinMax;
import com.graphhopper.json.Statement;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.ValueExpressionVisitor;
import com.graphhopper.util.CustomModel;
import java.util.List;

public class FindMinMax {
    public static void checkLMConstraints(CustomModel baseModel, CustomModel queryModel, EncodedValueLookup lookup) {
        if (queryModel.getDistanceInfluence() != null) {
            double bmDI;
            double d = bmDI = baseModel.getDistanceInfluence() == null ? 0.0 : baseModel.getDistanceInfluence();
            if (queryModel.getDistanceInfluence() < bmDI) {
                throw new IllegalArgumentException("CustomModel in query can only use distance_influence bigger or equal to " + bmDI + ", but was: " + queryModel.getDistanceInfluence());
            }
        }
        FindMinMax.checkMultiplyValue(queryModel.getPriority(), lookup);
        FindMinMax.checkMultiplyValue(queryModel.getSpeed(), lookup);
    }

    private static void checkMultiplyValue(List<Statement> list, EncodedValueLookup lookup) {
        for (Statement statement : list) {
            if (statement.operation() != Statement.Op.MULTIPLY) continue;
            MinMax minMax = ValueExpressionVisitor.findMinMax(statement.value(), lookup);
            if (minMax.max > 1.0) {
                throw new IllegalArgumentException("maximum of value '" + statement.value() + "' cannot be larger than 1, but was: " + minMax.max);
            }
            if (!(minMax.min < 0.0)) continue;
            throw new IllegalArgumentException("minimum of value '" + statement.value() + "' cannot be smaller than 0, but was: " + minMax.min);
        }
    }

    static MinMax findMinMax(MinMax minMax, List<Statement> statements, EncodedValueLookup lookup) {
        List<List<Statement>> groups = CustomModelParser.splitIntoGroup(statements);
        for (List<Statement> group : groups) {
            FindMinMax.findMinMaxForGroup(minMax, group, lookup);
        }
        return minMax;
    }

    private static void findMinMaxForGroup(MinMax minMax, List<Statement> group, EncodedValueLookup lookup) {
        MinMax minMaxGroup;
        if (group.isEmpty() || !Statement.Keyword.IF.equals((Object)group.get(0).keyword())) {
            throw new IllegalArgumentException("Every group must start with an if-statement");
        }
        Statement first = group.get(0);
        if (first.condition().trim().equals("true")) {
            if (first.isBlock()) {
                for (List<Statement> subGroup : CustomModelParser.splitIntoGroup(first.doBlock())) {
                    FindMinMax.findMinMaxForGroup(minMax, subGroup, lookup);
                }
                return;
            }
            minMaxGroup = first.operation().apply(minMax, ValueExpressionVisitor.findMinMax(first.value(), lookup));
            if (minMaxGroup.max < 0.0) {
                throw new IllegalArgumentException("statement resulted in negative value: " + String.valueOf(first));
            }
        } else {
            minMaxGroup = new MinMax(Double.MAX_VALUE, 0.0);
            boolean foundElse = false;
            for (Statement s : group) {
                MinMax tmp;
                if (s.keyword() == Statement.Keyword.ELSE) {
                    foundElse = true;
                }
                if (s.isBlock()) {
                    tmp = new MinMax(minMax.min, minMax.max);
                    for (List<Statement> subGroup : CustomModelParser.splitIntoGroup(s.doBlock())) {
                        FindMinMax.findMinMaxForGroup(tmp, subGroup, lookup);
                    }
                } else {
                    tmp = s.operation().apply(minMax, ValueExpressionVisitor.findMinMax(s.value(), lookup));
                    if (tmp.max < 0.0) {
                        throw new IllegalArgumentException("statement resulted in negative value: " + String.valueOf(s));
                    }
                }
                minMaxGroup.min = Math.min(minMaxGroup.min, tmp.min);
                minMaxGroup.max = Math.max(minMaxGroup.max, tmp.max);
            }
            if (!foundElse) {
                minMaxGroup.min = Math.min(minMaxGroup.min, minMax.min);
                minMaxGroup.max = Math.max(minMaxGroup.max, minMax.max);
            }
        }
        minMax.min = minMaxGroup.min;
        minMax.max = minMaxGroup.max;
    }
}

