/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.storage;

import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EdgeIntAccess;
import com.graphhopper.routing.ev.EnumEncodedValue;
import com.graphhopper.routing.ev.IntEncodedValue;
import com.graphhopper.routing.ev.StringEncodedValue;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.search.KVStorage;
import com.graphhopper.storage.BaseGraphNodesAndEdges;
import com.graphhopper.storage.DataAccess;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.GHNodeAccess;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.IntsRef;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.util.BitUtil;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PointAccess;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.io.Closeable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntUnaryOperator;

public class BaseGraph
implements Graph,
Closeable {
    static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    final BaseGraphNodesAndEdges store;
    final NodeAccess nodeAccess;
    final KVStorage edgeKVStorage;
    final TurnCostStorage turnCostStorage;
    final BitUtil bitUtil;
    private final DataAccess wayGeometry;
    private final Directory dir;
    private final int segmentSize;
    private boolean initialized = false;
    private long minGeoRef;
    private long maxGeoRef;
    private final int eleBytesPerCoord;

    public BaseGraph(Directory dir, boolean withElevation, boolean withTurnCosts, int segmentSize, int bytesForFlags) {
        this.dir = dir;
        this.bitUtil = BitUtil.LITTLE;
        this.wayGeometry = dir.create("geometry", segmentSize);
        this.edgeKVStorage = new KVStorage(dir, true);
        this.store = new BaseGraphNodesAndEdges(dir, withElevation, withTurnCosts, segmentSize, bytesForFlags);
        this.nodeAccess = new GHNodeAccess(this.store);
        this.segmentSize = segmentSize;
        this.turnCostStorage = withTurnCosts ? new TurnCostStorage(this, dir.create("turn_costs", dir.getDefaultType("turn_costs", true), segmentSize)) : null;
        this.eleBytesPerCoord = this.nodeAccess.getDimension() == 3 ? 3 : 0;
    }

    BaseGraphNodesAndEdges getStore() {
        return this.store;
    }

    private int getOtherNode(int nodeThis, long edgePointer) {
        int nodeA = this.store.getNodeA(edgePointer);
        return nodeThis == nodeA ? this.store.getNodeB(edgePointer) : nodeA;
    }

    private boolean isAdjacentToNode(int node, long edgePointer) {
        return this.store.getNodeA(edgePointer) == node || this.store.getNodeB(edgePointer) == node;
    }

    private static boolean isTestingEnabled() {
        boolean enableIfAssert = false;
        if (!$assertionsDisabled) {
            enableIfAssert = true;
            if (!true) {
                throw new AssertionError(true);
            }
        }
        return enableIfAssert;
    }

    public void debugPrint() {
        this.store.debugPrint();
    }

    @Override
    public BaseGraph getBaseGraph() {
        return this;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("You cannot configure this BaseGraph after calling create or loadExisting. Calling one of the methods twice is also not allowed.");
        }
    }

    private void loadWayGeometryHeader() {
        int geometryVersion = this.wayGeometry.getHeader(0);
        GHUtility.checkDAVersion(this.wayGeometry.getName(), 7, geometryVersion);
        this.minGeoRef = this.bitUtil.toLong(this.wayGeometry.getHeader(4), this.wayGeometry.getHeader(8));
        this.maxGeoRef = this.bitUtil.toLong(this.wayGeometry.getHeader(12), this.wayGeometry.getHeader(16));
    }

    private void setWayGeometryHeader() {
        this.wayGeometry.setHeader(0, 7);
        this.wayGeometry.setHeader(4, this.bitUtil.getIntLow(this.minGeoRef));
        this.wayGeometry.setHeader(8, this.bitUtil.getIntHigh(this.minGeoRef));
        this.wayGeometry.setHeader(12, this.bitUtil.getIntLow(this.maxGeoRef));
        this.wayGeometry.setHeader(16, this.bitUtil.getIntHigh(this.maxGeoRef));
    }

    private void setInitialized() {
        this.initialized = true;
    }

    boolean supportsTurnCosts() {
        return this.turnCostStorage != null;
    }

    @Override
    public int getNodes() {
        return this.store.getNodes();
    }

    @Override
    public int getEdges() {
        return this.store.getEdges();
    }

    @Override
    public NodeAccess getNodeAccess() {
        return this.nodeAccess;
    }

    @Override
    public BBox getBounds() {
        return this.store.getBounds();
    }

    public synchronized void freeze() {
        if (this.isFrozen()) {
            throw new IllegalStateException("base graph already frozen");
        }
        this.store.setFrozen(true);
    }

    public synchronized boolean isFrozen() {
        return this.store.getFrozen();
    }

    public BaseGraph create(long initSize) {
        this.checkNotInitialized();
        this.dir.create();
        this.store.create(initSize);
        initSize = Math.min(initSize, 2000L);
        this.wayGeometry.create(initSize);
        this.edgeKVStorage.create(initSize);
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.create(initSize);
        }
        this.setInitialized();
        this.minGeoRef = -1L;
        this.maxGeoRef = 1L;
        return this;
    }

    public String toDetailsString() {
        return this.store.toDetailsString() + ", name:(" + this.edgeKVStorage.getCapacity() / 0x100000L + "MB), geo:" + Helper.nf((long)this.maxGeoRef) + "/" + Helper.nf((long)this.minGeoRef) + "(" + this.wayGeometry.getCapacity() / 0x100000L + "MB)";
    }

    public void flushAndCloseGeometryAndNameStorage() {
        this.setWayGeometryHeader();
        this.wayGeometry.flush();
        this.wayGeometry.close();
        this.edgeKVStorage.flush();
        this.edgeKVStorage.close();
    }

    public void flush() {
        if (!this.wayGeometry.isClosed()) {
            this.setWayGeometryHeader();
            this.wayGeometry.flush();
        }
        if (!this.edgeKVStorage.isClosed()) {
            this.edgeKVStorage.flush();
        }
        this.store.flush();
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.flush();
        }
    }

    @Override
    public void close() {
        if (!this.wayGeometry.isClosed()) {
            this.wayGeometry.close();
        }
        if (!this.edgeKVStorage.isClosed()) {
            this.edgeKVStorage.close();
        }
        this.store.close();
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.close();
        }
    }

    public long getCapacity() {
        return this.store.getCapacity() + this.edgeKVStorage.getCapacity() + this.wayGeometry.getCapacity() + (this.supportsTurnCosts() ? this.turnCostStorage.getCapacity() : 0L);
    }

    long getMaxGeoRef() {
        return this.maxGeoRef;
    }

    public boolean loadExisting() {
        this.checkNotInitialized();
        if (!this.store.loadExisting()) {
            return false;
        }
        if (!this.wayGeometry.loadExisting()) {
            return false;
        }
        if (!this.edgeKVStorage.loadExisting()) {
            return false;
        }
        if (this.supportsTurnCosts() && !this.turnCostStorage.loadExisting()) {
            return false;
        }
        this.setInitialized();
        this.loadWayGeometryHeader();
        return true;
    }

    EdgeIteratorState copyProperties(EdgeIteratorState from, EdgeIteratorStateImpl to) {
        long edgePointer = this.store.toEdgePointer(to.getEdge());
        this.store.writeFlags(edgePointer, from.getFlags());
        to.setDistance(from.getDistance()).setKeyValues(from.getKeyValues()).setWayGeometry(from.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        return to;
    }

    @Override
    public EdgeIteratorState edge(int nodeA, int nodeB) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot create edge if graph is already frozen");
        }
        if (nodeA == nodeB) {
            throw new IllegalArgumentException("Loop edges are not supported, got: " + nodeA + " - " + nodeB);
        }
        int edgeId = this.store.edge(nodeA, nodeB);
        EdgeIteratorStateImpl edge = new EdgeIteratorStateImpl(this);
        boolean valid = edge.init(edgeId, nodeB);
        assert (valid);
        return edge;
    }

    public EdgeIteratorState copyEdge(int edge, boolean reuseGeometry) {
        EdgeIteratorStateImpl edgeState = (EdgeIteratorStateImpl)this.getEdgeIteratorState(edge, Integer.MIN_VALUE);
        EdgeIteratorStateImpl newEdge = (EdgeIteratorStateImpl)this.edge(edgeState.getBaseNode(), edgeState.getAdjNode()).setFlags(edgeState.getFlags()).setDistance(edgeState.getDistance()).setKeyValues(edgeState.getKeyValues());
        if (reuseGeometry) {
            long edgePointer = edgeState.edgePointer;
            long geoRef = this.store.getGeoRef(edgePointer);
            if (geoRef == 0L) {
                geoRef = this.minGeoRef--;
                this.store.setGeoRef(edgePointer, geoRef);
            }
            this.store.setGeoRef(newEdge.edgePointer, geoRef);
        } else {
            newEdge.setWayGeometry(edgeState.fetchWayGeometry(FetchMode.PILLAR_ONLY));
        }
        return newEdge;
    }

    public void forEdgeAndCopiesOfEdge(EdgeExplorer explorer, EdgeIteratorState edge, Consumer<EdgeIteratorState> consumer) {
        long geoRef = this.store.getGeoRef(((EdgeIteratorStateImpl)edge).edgePointer);
        if (geoRef == 0L) {
            consumer.accept(edge);
            return;
        }
        EdgeIterator iter = explorer.setBaseNode(edge.getBaseNode());
        while (iter.next()) {
            long geoRefBefore = this.store.getGeoRef(((EdgeIteratorStateImpl)((Object)iter)).edgePointer);
            if (geoRefBefore == geoRef) {
                consumer.accept(iter);
            }
            if (this.store.getGeoRef(((EdgeIteratorStateImpl)((Object)iter)).edgePointer) == geoRefBefore) continue;
            throw new IllegalStateException("The consumer must not change the geo ref");
        }
    }

    public void forEdgeAndCopiesOfEdge(EdgeExplorer explorer, int node, int edge, IntConsumer consumer) {
        long geoRef = this.store.getGeoRef(this.store.toEdgePointer(edge));
        if (geoRef == 0L) {
            consumer.accept(edge);
            return;
        }
        EdgeIterator iter = explorer.setBaseNode(node);
        while (iter.next()) {
            long geoRefBefore = this.store.getGeoRef(((EdgeIteratorStateImpl)((Object)iter)).edgePointer);
            if (geoRefBefore != geoRef) continue;
            consumer.accept(iter.getEdge());
        }
    }

    public void sortEdges(IntUnaryOperator getNewEdgeForOldEdge) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot sort edges if graph is already frozen");
        }
        this.store.sortEdges(getNewEdgeForOldEdge);
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.sortEdges(getNewEdgeForOldEdge);
        }
    }

    public void relabelNodes(IntUnaryOperator getNewNodeForOldNode) {
        if (this.isFrozen()) {
            throw new IllegalStateException("Cannot relabel nodes if graph is already frozen");
        }
        this.store.relabelNodes(getNewNodeForOldNode);
        if (this.supportsTurnCosts()) {
            this.turnCostStorage.sortNodes();
        }
    }

    @Override
    public EdgeIteratorState getEdgeIteratorState(int edgeId, int adjNode) {
        EdgeIteratorStateImpl edge = new EdgeIteratorStateImpl(this);
        if (edge.init(edgeId, adjNode)) {
            return edge;
        }
        return null;
    }

    @Override
    public EdgeIteratorState getEdgeIteratorStateForKey(int edgeKey) {
        EdgeIteratorStateImpl edge = new EdgeIteratorStateImpl(this);
        edge.init(edgeKey);
        return edge;
    }

    @Override
    public EdgeExplorer createEdgeExplorer(EdgeFilter filter) {
        return new EdgeIteratorImpl(this, filter);
    }

    @Override
    public EdgeExplorer createEdgeExplorer() {
        return this.createEdgeExplorer(EdgeFilter.ALL_EDGES);
    }

    @Override
    public AllEdgesIterator getAllEdges() {
        return new AllEdgeIterator(this);
    }

    @Override
    public TurnCostStorage getTurnCostStorage() {
        return this.turnCostStorage;
    }

    @Override
    public Weighting wrapWeighting(Weighting weighting) {
        return weighting;
    }

    @Override
    public int getOtherNode(int edge, int node) {
        long edgePointer = this.store.toEdgePointer(edge);
        return this.getOtherNode(node, edgePointer);
    }

    @Override
    public boolean isAdjacentToNode(int edge, int node) {
        long edgePointer = this.store.toEdgePointer(edge);
        return this.isAdjacentToNode(node, edgePointer);
    }

    public boolean isAdjNode(int edge, int node) {
        long edgePointer = this.store.toEdgePointer(edge);
        return node == this.store.getNodeB(edgePointer);
    }

    private void setWayGeometry_(PointList pillarNodes, long edgePointer, boolean reverse) {
        if (pillarNodes != null && !pillarNodes.isEmpty()) {
            if (pillarNodes.getDimension() != this.nodeAccess.getDimension()) {
                throw new IllegalArgumentException("Cannot use pointlist which is " + pillarNodes.getDimension() + "D for graph which is " + this.nodeAccess.getDimension() + "D");
            }
            long existingGeoRef = this.store.getGeoRef(edgePointer);
            if (existingGeoRef < 0L) {
                throw new IllegalStateException("This edge has already been copied so we can no longer change the geometry, pointer=" + edgePointer);
            }
            int len = pillarNodes.size();
            if (existingGeoRef > 0L) {
                int count = this.getPillarCount(existingGeoRef);
                if (len <= count) {
                    this.setWayGeometryAtGeoRef(pillarNodes, edgePointer, reverse, existingGeoRef);
                    return;
                }
                throw new IllegalStateException("This edge already has a way geometry so it cannot be changed to a bigger geometry, pointer=" + edgePointer);
            }
            long nextGeoRef = this.nextGeoRef(3 + len * (8 + this.eleBytesPerCoord));
            this.setWayGeometryAtGeoRef(pillarNodes, edgePointer, reverse, nextGeoRef);
        } else {
            this.store.setGeoRef(edgePointer, 0L);
        }
    }

    public EdgeIntAccess getEdgeAccess() {
        return this.store;
    }

    private void setWayGeometryAtGeoRef(PointList pillarNodes, long edgePointer, boolean reverse, long geoRef) {
        byte[] wayGeometryBytes = this.createWayGeometryBytes(pillarNodes, reverse);
        this.wayGeometry.ensureCapacity(geoRef + (long)wayGeometryBytes.length);
        this.wayGeometry.setBytes(geoRef, wayGeometryBytes, wayGeometryBytes.length);
        this.store.setGeoRef(edgePointer, geoRef);
    }

    private byte[] createWayGeometryBytes(PointList pillarNodes, boolean reverse) {
        int len = pillarNodes.size();
        int totalLen = 3 + len * (8 + this.eleBytesPerCoord);
        if ((totalLen & 0xFF000000) != 0) {
            throw new IllegalArgumentException("too long way geometry " + totalLen + ", " + len);
        }
        byte[] bytes = new byte[totalLen];
        this.bitUtil.fromUInt3(bytes, len, 0);
        if (reverse) {
            pillarNodes.reverse();
        }
        int tmpOffset = 3;
        boolean is3D = this.nodeAccess.is3D();
        for (int i = 0; i < len; ++i) {
            double lat = pillarNodes.getLat(i);
            this.bitUtil.fromInt(bytes, Helper.degreeToInt((double)lat), tmpOffset);
            this.bitUtil.fromInt(bytes, Helper.degreeToInt((double)pillarNodes.getLon(i)), tmpOffset += 4);
            tmpOffset += 4;
            if (!is3D) continue;
            this.bitUtil.fromUInt3(bytes, Helper.eleToUInt((double)pillarNodes.getEle(i)), tmpOffset);
            tmpOffset += 3;
        }
        return bytes;
    }

    private int getPillarCount(long geoRef) {
        return this.wayGeometry.getByte(geoRef + 2L) & 0xFF0000 | this.wayGeometry.getShort(geoRef);
    }

    private PointList fetchWayGeometry_(long edgePointer, boolean reverse, FetchMode mode, int baseNode, int adjNode) {
        if (mode == FetchMode.TOWER_ONLY) {
            PointList pillarNodes = new PointList(2, this.nodeAccess.is3D());
            pillarNodes.add((PointAccess)this.nodeAccess, baseNode);
            pillarNodes.add((PointAccess)this.nodeAccess, adjNode);
            return pillarNodes;
        }
        long geoRef = this.store.getGeoRef(edgePointer);
        int count = 0;
        byte[] bytes = null;
        if (geoRef > 0L) {
            count = this.getPillarCount(geoRef);
            bytes = new byte[count * (8 + this.eleBytesPerCoord)];
            this.wayGeometry.getBytes(geoRef += 3L, bytes, bytes.length);
        } else if (mode == FetchMode.PILLAR_ONLY) {
            return PointList.EMPTY;
        }
        PointList pillarNodes = new PointList(BaseGraph.getPointListLength(count, mode), this.nodeAccess.is3D());
        if (reverse) {
            if (mode == FetchMode.ALL || mode == FetchMode.PILLAR_AND_ADJ) {
                pillarNodes.add((PointAccess)this.nodeAccess, adjNode);
            }
        } else if (mode == FetchMode.ALL || mode == FetchMode.BASE_AND_PILLAR) {
            pillarNodes.add((PointAccess)this.nodeAccess, baseNode);
        }
        int index = 0;
        for (int i = 0; i < count; ++i) {
            double lat = Helper.intToDegree((int)this.bitUtil.toInt(bytes, index));
            double lon = Helper.intToDegree((int)this.bitUtil.toInt(bytes, index += 4));
            index += 4;
            if (this.nodeAccess.is3D()) {
                pillarNodes.add(lat, lon, Helper.uIntToEle((int)this.bitUtil.toUInt3(bytes, index)));
                index += 3;
                continue;
            }
            pillarNodes.add(lat, lon);
        }
        if (reverse) {
            if (mode == FetchMode.ALL || mode == FetchMode.BASE_AND_PILLAR) {
                pillarNodes.add((PointAccess)this.nodeAccess, baseNode);
            }
            pillarNodes.reverse();
        } else if (mode == FetchMode.ALL || mode == FetchMode.PILLAR_AND_ADJ) {
            pillarNodes.add((PointAccess)this.nodeAccess, adjNode);
        }
        return pillarNodes;
    }

    static int getPointListLength(int pillarNodes, FetchMode mode) {
        switch (mode) {
            case TOWER_ONLY: {
                return 2;
            }
            case PILLAR_ONLY: {
                return pillarNodes;
            }
            case BASE_AND_PILLAR: 
            case PILLAR_AND_ADJ: {
                return pillarNodes + 1;
            }
            case ALL: {
                return pillarNodes + 2;
            }
        }
        throw new IllegalArgumentException("Mode isn't handled " + String.valueOf((Object)mode));
    }

    private long nextGeoRef(int bytes) {
        long tmp = this.maxGeoRef;
        this.maxGeoRef += (long)bytes;
        return tmp;
    }

    public boolean isClosed() {
        return this.store.isClosed();
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public int getSegmentSize() {
        return this.segmentSize;
    }

    static class EdgeIteratorStateImpl
    implements EdgeIteratorState {
        final BaseGraph baseGraph;
        final BaseGraphNodesAndEdges store;
        long edgePointer = -1L;
        int baseNode;
        int adjNode;
        boolean reverse = false;
        int edgeId = -1;
        private final EdgeIntAccess edgeIntAccess;

        public EdgeIteratorStateImpl(BaseGraph baseGraph) {
            this.baseGraph = baseGraph;
            this.edgeIntAccess = baseGraph.getEdgeAccess();
            this.store = baseGraph.store;
        }

        final boolean init(int edgeId, int expectedAdjNode) {
            if (edgeId < 0 || edgeId >= this.store.getEdges()) {
                throw new IllegalArgumentException("edge: " + edgeId + " out of bounds: [0," + this.store.getEdges() + "[");
            }
            this.edgeId = edgeId;
            this.edgePointer = this.store.toEdgePointer(edgeId);
            this.baseNode = this.store.getNodeA(this.edgePointer);
            this.adjNode = this.store.getNodeB(this.edgePointer);
            if (expectedAdjNode == this.adjNode || expectedAdjNode == Integer.MIN_VALUE) {
                this.reverse = false;
                return true;
            }
            if (expectedAdjNode == this.baseNode) {
                this.reverse = true;
                this.baseNode = this.adjNode;
                this.adjNode = expectedAdjNode;
                return true;
            }
            return false;
        }

        final void init(int edgeKey) {
            if (edgeKey < 0) {
                throw new IllegalArgumentException("edge keys must not be negative, given: " + edgeKey);
            }
            this.edgeId = GHUtility.getEdgeFromEdgeKey(edgeKey);
            this.edgePointer = this.store.toEdgePointer(this.edgeId);
            this.baseNode = this.store.getNodeA(this.edgePointer);
            this.adjNode = this.store.getNodeB(this.edgePointer);
            if (edgeKey % 2 == 0) {
                this.reverse = false;
            } else {
                this.reverse = true;
                int tmp = this.baseNode;
                this.baseNode = this.adjNode;
                this.adjNode = tmp;
            }
        }

        @Override
        public final int getBaseNode() {
            return this.baseNode;
        }

        @Override
        public final int getAdjNode() {
            return this.adjNode;
        }

        @Override
        public double getDistance() {
            return this.store.getDist(this.edgePointer);
        }

        @Override
        public EdgeIteratorState setDistance(double dist) {
            this.store.setDist(this.edgePointer, dist);
            return this;
        }

        @Override
        public IntsRef getFlags() {
            IntsRef edgeFlags = this.store.createEdgeFlags();
            this.store.readFlags(this.edgePointer, edgeFlags);
            return edgeFlags;
        }

        @Override
        public final EdgeIteratorState setFlags(IntsRef edgeFlags) {
            assert (this.edgeId < this.store.getEdges()) : "must be edge but was shortcut: " + this.edgeId + " >= " + this.store.getEdges() + ". Use setFlagsAndWeight";
            this.store.writeFlags(this.edgePointer, edgeFlags);
            return this;
        }

        @Override
        public boolean get(BooleanEncodedValue property) {
            return property.getBool(this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean value) {
            property.setBool(this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public boolean getReverse(BooleanEncodedValue property) {
            return property.getBool(!this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public EdgeIteratorState setReverse(BooleanEncodedValue property, boolean value) {
            property.setBool(!this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public EdgeIteratorState set(BooleanEncodedValue property, boolean fwd, boolean bwd) {
            if (!property.isStoreTwoDirections()) {
                throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
            }
            property.setBool(this.reverse, this.edgeId, this.edgeIntAccess, fwd);
            property.setBool(!this.reverse, this.edgeId, this.edgeIntAccess, bwd);
            return this;
        }

        @Override
        public int get(IntEncodedValue property) {
            return property.getInt(this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int value) {
            property.setInt(this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public int getReverse(IntEncodedValue property) {
            return property.getInt(!this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public EdgeIteratorState setReverse(IntEncodedValue property, int value) {
            property.setInt(!this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public EdgeIteratorState set(IntEncodedValue property, int fwd, int bwd) {
            if (!property.isStoreTwoDirections()) {
                throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
            }
            property.setInt(this.reverse, this.edgeId, this.edgeIntAccess, fwd);
            property.setInt(!this.reverse, this.edgeId, this.edgeIntAccess, bwd);
            return this;
        }

        @Override
        public double get(DecimalEncodedValue property) {
            return property.getDecimal(this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double value) {
            property.setDecimal(this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public double getReverse(DecimalEncodedValue property) {
            return property.getDecimal(!this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public EdgeIteratorState setReverse(DecimalEncodedValue property, double value) {
            property.setDecimal(!this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public EdgeIteratorState set(DecimalEncodedValue property, double fwd, double bwd) {
            if (!property.isStoreTwoDirections()) {
                throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
            }
            property.setDecimal(this.reverse, this.edgeId, this.edgeIntAccess, fwd);
            property.setDecimal(!this.reverse, this.edgeId, this.edgeIntAccess, bwd);
            return this;
        }

        @Override
        public <T extends Enum<?>> T get(EnumEncodedValue<T> property) {
            return property.getEnum(this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T value) {
            property.setEnum(this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public <T extends Enum<?>> T getReverse(EnumEncodedValue<T> property) {
            return property.getEnum(!this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState setReverse(EnumEncodedValue<T> property, T value) {
            property.setEnum(!this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public <T extends Enum<?>> EdgeIteratorState set(EnumEncodedValue<T> property, T fwd, T bwd) {
            if (!property.isStoreTwoDirections()) {
                throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
            }
            property.setEnum(this.reverse, this.edgeId, this.edgeIntAccess, fwd);
            property.setEnum(!this.reverse, this.edgeId, this.edgeIntAccess, bwd);
            return this;
        }

        @Override
        public String get(StringEncodedValue property) {
            return property.getString(this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public EdgeIteratorState set(StringEncodedValue property, String value) {
            property.setString(this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public String getReverse(StringEncodedValue property) {
            return property.getString(!this.reverse, this.edgeId, this.edgeIntAccess);
        }

        @Override
        public EdgeIteratorState setReverse(StringEncodedValue property, String value) {
            property.setString(!this.reverse, this.edgeId, this.edgeIntAccess, value);
            return this;
        }

        @Override
        public EdgeIteratorState set(StringEncodedValue property, String fwd, String bwd) {
            if (!property.isStoreTwoDirections()) {
                throw new IllegalArgumentException("EncodedValue " + property.getName() + " supports only one direction");
            }
            property.setString(this.reverse, this.edgeId, this.edgeIntAccess, fwd);
            property.setString(!this.reverse, this.edgeId, this.edgeIntAccess, bwd);
            return this;
        }

        @Override
        public final EdgeIteratorState copyPropertiesFrom(EdgeIteratorState edge) {
            return this.baseGraph.copyProperties(edge, this);
        }

        @Override
        public EdgeIteratorState setWayGeometry(PointList pillarNodes) {
            this.baseGraph.setWayGeometry_(pillarNodes, this.edgePointer, this.reverse);
            return this;
        }

        @Override
        public PointList fetchWayGeometry(FetchMode mode) {
            return this.baseGraph.fetchWayGeometry_(this.edgePointer, this.reverse, mode, this.getBaseNode(), this.getAdjNode());
        }

        @Override
        public int getEdge() {
            return this.edgeId;
        }

        @Override
        public int getEdgeKey() {
            return GHUtility.createEdgeKey(this.edgeId, this.reverse);
        }

        @Override
        public int getReverseEdgeKey() {
            return GHUtility.reverseEdgeKey(this.getEdgeKey());
        }

        @Override
        public EdgeIteratorState setKeyValues(Map<String, KVStorage.KValue> entries) {
            long pointer = this.baseGraph.edgeKVStorage.add(entries);
            if (pointer > 0xFFFFFFFFL) {
                throw new IllegalStateException("Too many key value pairs are stored, currently limited to 4294967295 was " + pointer);
            }
            this.store.setKeyValuesRef(this.edgePointer, BitUtil.toSignedInt(pointer));
            return this;
        }

        @Override
        public Map<String, KVStorage.KValue> getKeyValues() {
            long kvEntryRef = Integer.toUnsignedLong(this.store.getKeyValuesRef(this.edgePointer));
            return this.baseGraph.edgeKVStorage.getAll(kvEntryRef);
        }

        @Override
        public Object getValue(String key) {
            long kvEntryRef = Integer.toUnsignedLong(this.store.getKeyValuesRef(this.edgePointer));
            return this.baseGraph.edgeKVStorage.get(kvEntryRef, key, this.reverse);
        }

        @Override
        public String getName() {
            String name = (String)this.getValue("street_name");
            return name == null ? "" : name;
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            if (!EdgeIterator.Edge.isValid(this.edgeId)) {
                throw new IllegalStateException("call setEdgeId before detaching (edgeId:" + this.edgeId + ")");
            }
            EdgeIteratorStateImpl edge = new EdgeIteratorStateImpl(this.baseGraph);
            boolean valid = edge.init(this.edgeId, reverseArg ? this.baseNode : this.adjNode);
            assert (valid);
            if (reverseArg) {
                edge.reverse = !this.reverse;
            }
            return edge;
        }

        public final String toString() {
            return this.getEdge() + " " + this.getBaseNode() + "-" + this.getAdjNode();
        }
    }

    protected static class EdgeIteratorImpl
    extends EdgeIteratorStateImpl
    implements EdgeExplorer,
    EdgeIterator {
        final EdgeFilter filter;
        int nextEdgeId;

        public EdgeIteratorImpl(BaseGraph baseGraph, EdgeFilter filter) {
            super(baseGraph);
            if (filter == null) {
                throw new IllegalArgumentException("Instead null filter use EdgeFilter.ALL_EDGES");
            }
            this.filter = filter;
        }

        @Override
        public EdgeIterator setBaseNode(int baseNode) {
            this.nextEdgeId = this.edgeId = this.store.getEdgeRef(this.store.toNodePointer(baseNode));
            this.baseNode = baseNode;
            return this;
        }

        @Override
        public final boolean next() {
            while (EdgeIterator.Edge.isValid(this.nextEdgeId)) {
                this.goToNext();
                if (!this.filter.accept(this)) continue;
                return true;
            }
            return false;
        }

        void goToNext() {
            this.edgePointer = this.store.toEdgePointer(this.nextEdgeId);
            this.edgeId = this.nextEdgeId;
            int nodeA = this.store.getNodeA(this.edgePointer);
            boolean baseNodeIsNodeA = this.baseNode == nodeA;
            this.adjNode = baseNodeIsNodeA ? this.store.getNodeB(this.edgePointer) : nodeA;
            this.reverse = !baseNodeIsNodeA;
            int n = this.nextEdgeId = baseNodeIsNodeA ? this.store.getLinkA(this.edgePointer) : this.store.getLinkB(this.edgePointer);
            assert (this.nextEdgeId != this.edgeId) : "endless loop detected for base node: " + this.baseNode + ", adj node: " + this.adjNode + ", edge pointer: " + this.edgePointer + ", edge: " + this.edgeId;
        }

        @Override
        public EdgeIteratorState detach(boolean reverseArg) {
            if (this.edgeId == this.nextEdgeId) {
                throw new IllegalStateException("call next before detaching (edgeId:" + this.edgeId + " vs. next " + this.nextEdgeId + ")");
            }
            return super.detach(reverseArg);
        }
    }

    protected static class AllEdgeIterator
    extends EdgeIteratorStateImpl
    implements AllEdgesIterator {
        public AllEdgeIterator(BaseGraph baseGraph) {
            super(baseGraph);
        }

        @Override
        public int length() {
            return this.store.getEdges();
        }

        @Override
        public boolean next() {
            ++this.edgeId;
            if (this.edgeId >= this.store.getEdges()) {
                return false;
            }
            this.edgePointer = this.store.toEdgePointer(this.edgeId);
            this.baseNode = this.store.getNodeA(this.edgePointer);
            this.adjNode = this.store.getNodeB(this.edgePointer);
            this.reverse = false;
            return true;
        }

        @Override
        public final EdgeIteratorState detach(boolean reverseArg) {
            if (this.edgePointer < 0L) {
                throw new IllegalStateException("call next before detaching");
            }
            AllEdgeIterator iter = new AllEdgeIterator(this.baseGraph);
            iter.edgeId = this.edgeId;
            iter.edgePointer = this.edgePointer;
            if (reverseArg) {
                iter.reverse = !this.reverse;
                iter.baseNode = this.adjNode;
                iter.adjNode = this.baseNode;
            } else {
                iter.reverse = this.reverse;
                iter.baseNode = this.baseNode;
                iter.adjNode = this.adjNode;
            }
            return iter;
        }
    }

    public static class Builder {
        private final int bytesForFlags;
        private Directory directory = new RAMDirectory();
        private boolean withElevation = false;
        private boolean withTurnCosts = false;
        private long bytes = 100L;
        private int segmentSize = -1;

        public Builder(EncodingManager em) {
            this(em.getBytesForFlags());
            this.withTurnCosts(em.needsTurnCostsSupport());
        }

        public Builder(int bytesForFlags) {
            this.bytesForFlags = bytesForFlags;
        }

        public Builder setDir(Directory directory) {
            this.directory = directory;
            return this;
        }

        public Builder set3D(boolean withElevation) {
            this.withElevation = withElevation;
            return this;
        }

        public Builder withTurnCosts(boolean withTurnCosts) {
            this.withTurnCosts = withTurnCosts;
            return this;
        }

        public Builder setSegmentSize(int segmentSize) {
            this.segmentSize = segmentSize;
            return this;
        }

        public Builder setBytes(long bytes) {
            this.bytes = bytes;
            return this;
        }

        public BaseGraph build() {
            return new BaseGraph(this.directory, this.withElevation, this.withTurnCosts, this.segmentSize, this.bytesForFlags);
        }

        public BaseGraph create() {
            BaseGraph baseGraph = this.build();
            baseGraph.create(this.bytes);
            return baseGraph;
        }
    }
}

