/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.graphhopper.GraphHopper;
import com.graphhopper.util.GitInfo;
import com.graphhopper.util.Helper;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.StringTokenizer;

public class Constants {
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean LINUX = OS_NAME.startsWith("Linux");
    public static final boolean WINDOWS = OS_NAME.startsWith("Windows");
    public static final boolean MAC_OS_X = OS_NAME.startsWith("Mac OS X");
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final String JAVA_VENDOR = System.getProperty("java.vendor");
    public static final String JVM_SPEC_VERSION = System.getProperty("java.specification.version");
    public static final boolean JRE_IS_MINIMUM_JAVA9;
    private static final int JVM_MAJOR_VERSION;
    private static final int JVM_MINOR_VERSION;
    public static final int VERSION_NODE = 9;
    public static final int VERSION_EDGE = 24;
    public static final int VERSION_EM = 4;
    public static final int VERSION_SHORTCUT = 9;
    public static final int VERSION_NODE_CH = 0;
    public static final int VERSION_GEOMETRY = 7;
    public static final int VERSION_TURN_COSTS = 0;
    public static final int VERSION_LOCATION_IDX = 5;
    public static final int VERSION_KV_STORAGE = 2;
    public static final String VERSION;
    public static final String BUILD_DATE;
    public static final GitInfo GIT_INFO;
    public static final boolean SNAPSHOT;

    public static String getVersions() {
        return "9,24,7,5,2,9";
    }

    public static String getMajorVersion() {
        int firstIdx = VERSION.indexOf(".");
        if (firstIdx < 0) {
            throw new IllegalStateException("Cannot extract major version from version " + VERSION);
        }
        int sndIdx = VERSION.indexOf(".", firstIdx + 1);
        if (sndIdx < 0) {
            return VERSION;
        }
        return VERSION.substring(0, sndIdx);
    }

    static {
        StringTokenizer st = new StringTokenizer(JVM_SPEC_VERSION, ".");
        JVM_MAJOR_VERSION = Integer.parseInt(st.nextToken());
        JVM_MINOR_VERSION = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 0;
        JRE_IS_MINIMUM_JAVA9 = JVM_MAJOR_VERSION > 1 || JVM_MAJOR_VERSION == 1 && JVM_MINOR_VERSION >= 9;
        String version = "0.0";
        try {
            List v = Helper.readFile((Reader)new InputStreamReader(GraphHopper.class.getResourceAsStream("version"), Helper.UTF_CS));
            version = (String)v.get(0);
        }
        catch (Exception ex) {
            System.err.println("GraphHopper Initialization ERROR: cannot read version!? " + ex.getMessage());
        }
        int indexM = version.indexOf("-");
        if ("${project.version}".equals(version)) {
            VERSION = "0.0";
            SNAPSHOT = true;
            System.err.println("GraphHopper Initialization WARNING: maven did not preprocess the version file! Do not use the jar for a release!");
        } else if ("0.0".equals(version)) {
            VERSION = "0.0";
            SNAPSHOT = true;
            System.err.println("GraphHopper Initialization WARNING: cannot get version!?");
        } else {
            String tmp = version;
            if (indexM >= 0) {
                tmp = version.substring(0, indexM);
            }
            SNAPSHOT = Helper.toLowerCase((String)version).contains("-snapshot");
            VERSION = tmp;
        }
        String buildDate = "";
        try {
            List v = Helper.readFile((Reader)new InputStreamReader(GraphHopper.class.getResourceAsStream("builddate"), Helper.UTF_CS));
            buildDate = (String)v.get(0);
        }
        catch (Exception v) {
            // empty catch block
        }
        BUILD_DATE = buildDate;
        List gitInfos = null;
        try {
            gitInfos = Helper.readFile((Reader)new InputStreamReader(GraphHopper.class.getResourceAsStream("gitinfo"), Helper.UTF_CS));
            if (gitInfos.size() != 6) {
                System.err.println("GraphHopper Initialization WARNING: unexpected git info: " + gitInfos.toString());
                gitInfos = null;
            } else if (((String)gitInfos.get(1)).startsWith("$")) {
                gitInfos = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GIT_INFO = gitInfos == null ? null : new GitInfo((String)gitInfos.get(1), (String)gitInfos.get(2), (String)gitInfos.get(3), (String)gitInfos.get(4), Boolean.parseBoolean((String)gitInfos.get(5)));
    }
}

