/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntIndexedContainer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.graphhopper.jackson.Jackson;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.Country;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.State;
import com.graphhopper.routing.util.AccessFilter;
import com.graphhopper.routing.util.AllEdgesIterator;
import com.graphhopper.routing.util.CustomArea;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RoutingCHEdgeIterator;
import com.graphhopper.storage.TurnCostStorage;
import com.graphhopper.storage.index.LocationIndex;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.DistanceCalcEarth;
import com.graphhopper.util.DistancePlaneProjection;
import com.graphhopper.util.EdgeExplorer;
import com.graphhopper.util.EdgeIterator;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.FetchMode;
import com.graphhopper.util.Helper;
import com.graphhopper.util.JsonFeature;
import com.graphhopper.util.JsonFeatureCollection;
import com.graphhopper.util.PointList;
import com.graphhopper.util.shapes.BBox;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GHUtility {
    public static final Logger OSM_WARNING_LOGGER = LoggerFactory.getLogger((String)"com.graphhopper.osm_warnings");
    private static final Logger LOGGER = LoggerFactory.getLogger(GHUtility.class);

    public static List<String> getProblems(Graph g) {
        int nodeIndex;
        ArrayList<String> problems = new ArrayList<String>();
        int nodes = g.getNodes();
        NodeAccess na = g.getNodeAccess();
        try {
            EdgeExplorer explorer = g.createEdgeExplorer();
            for (nodeIndex = 0; nodeIndex < nodes; ++nodeIndex) {
                double lon;
                double lat = na.getLat(nodeIndex);
                if (lat > 90.0 || lat < -90.0) {
                    problems.add("latitude is not within its bounds " + lat);
                }
                if ((lon = na.getLon(nodeIndex)) > 180.0 || lon < -180.0) {
                    problems.add("longitude is not within its bounds " + lon);
                }
                EdgeIterator iter = explorer.setBaseNode(nodeIndex);
                while (iter.next()) {
                    if (iter.getAdjNode() >= nodes) {
                        problems.add("edge of " + nodeIndex + " has a node " + iter.getAdjNode() + " greater or equal to getNodes");
                    }
                    if (iter.getAdjNode() >= 0) continue;
                    problems.add("edge of " + nodeIndex + " has a negative node " + iter.getAdjNode());
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("problem with node " + nodeIndex, ex);
        }
        return problems;
    }

    public static int count(EdgeIterator iter) {
        int counter = 0;
        while (iter.next()) {
            ++counter;
        }
        return counter;
    }

    public static int count(RoutingCHEdgeIterator iter) {
        int counter = 0;
        while (iter.next()) {
            ++counter;
        }
        return counter;
    }

    public static Set<Integer> asSet(int ... values) {
        HashSet<Integer> s = new HashSet<Integer>();
        for (int v : values) {
            s.add(v);
        }
        return s;
    }

    public static Set<Integer> getNeighbors(RoutingCHEdgeIterator iter) {
        LinkedHashSet<Integer> list = new LinkedHashSet<Integer>();
        while (iter.next()) {
            list.add(iter.getAdjNode());
        }
        return list;
    }

    public static Set<Integer> getNeighbors(EdgeIterator iter) {
        LinkedHashSet<Integer> list = new LinkedHashSet<Integer>();
        while (iter.next()) {
            list.add(iter.getAdjNode());
        }
        return list;
    }

    public static List<Integer> getEdgeIds(EdgeIterator iter) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (iter.next()) {
            list.add(iter.getEdge());
        }
        return list;
    }

    public static void printGraphForUnitTest(Graph g, DecimalEncodedValue speedEnc) {
        GHUtility.printGraphForUnitTest(g, speedEnc, new BBox(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY));
    }

    public static void printGraphForUnitTest(Graph g, DecimalEncodedValue speedEnc, BBox bBox) {
        NodeAccess na = g.getNodeAccess();
        for (int node = 0; node < g.getNodes(); ++node) {
            if (!bBox.contains(na.getLat(node), na.getLon(node))) continue;
            System.out.printf(Locale.ROOT, "na.setNode(%d, %f, %f);\n", node, na.getLat(node), na.getLon(node));
        }
        AllEdgesIterator iter = g.getAllEdges();
        while (iter.next()) {
            if (!bBox.contains(na.getLat(iter.getBaseNode()), na.getLon(iter.getBaseNode())) || !bBox.contains(na.getLat(iter.getAdjNode()), na.getLon(iter.getAdjNode()))) continue;
            GHUtility.printUnitTestEdge(speedEnc, iter);
        }
    }

    private static void printUnitTestEdge(DecimalEncodedValue speedEnc, EdgeIteratorState edge) {
        boolean fwd = edge.get(speedEnc) > 0.0;
        int from = fwd ? edge.getBaseNode() : edge.getAdjNode();
        int to = fwd ? edge.getAdjNode() : edge.getBaseNode();
        System.out.printf(Locale.ROOT, "graph.edge(%d, %d).setDistance(%f).set(speedEnc, %f, %f); // edgeId=%s\n", from, to, edge.getDistance(), edge.get(speedEnc), edge.getReverse(speedEnc), edge.getEdge());
    }

    public static void buildRandomGraph(Graph graph, Random random, int numNodes, double meanDegree, boolean allowZeroDistance, DecimalEncodedValue speedEnc, Double speed, double pBothDir, double pRandomDistanceOffset) {
        if (numNodes < 2 || meanDegree < 1.0) {
            throw new IllegalArgumentException("numNodes must be >= 2, meanDegree >= 1");
        }
        for (int i = 0; i < numNodes; ++i) {
            double lat = 49.4 + random.nextDouble() * 0.01;
            double lon = 9.7 + random.nextDouble() * 0.01;
            graph.getNodeAccess().setNode(i, lat, lon);
        }
        double minDist = Double.MAX_VALUE;
        double maxDist = Double.MIN_VALUE;
        int totalNumEdges = (int)(0.5 * meanDegree * (double)numNodes);
        int numEdges = 0;
        while (numEdges < totalNumEdges) {
            int to;
            int from = random.nextInt(numNodes);
            if (from == (to = random.nextInt(numNodes))) continue;
            double distance = GHUtility.getDistance(from, to, graph.getNodeAccess());
            if (!allowZeroDistance) {
                distance = Math.max(0.001, distance);
            }
            if (random.nextDouble() < pRandomDistanceOffset) {
                distance += random.nextDouble() * distance * 0.01;
            }
            minDist = Math.min(minDist, distance);
            maxDist = Math.max(maxDist, distance);
            boolean bothDirections = random.nextDouble() < pBothDir;
            EdgeIteratorState edge = graph.edge(from, to).setDistance(distance);
            double fwdSpeed = 10.0 + random.nextDouble() * 110.0;
            double bwdSpeed = 10.0 + random.nextDouble() * 110.0;
            if (speed != null) {
                fwdSpeed = bwdSpeed = speed.doubleValue();
            }
            if (speedEnc != null) {
                edge.set(speedEnc, fwdSpeed);
                if (speedEnc.isStoreTwoDirections()) {
                    edge.setReverse(speedEnc, !bothDirections ? 0.0 : bwdSpeed);
                }
            }
            ++numEdges;
        }
        LOGGER.debug(String.format(Locale.ROOT, "Finished building random graph, nodes: %d, edges: %d , min distance: %.2f, max distance: %.2f\n", graph.getNodes(), graph.getEdges(), minDist, maxDist));
    }

    public static double getDistance(int from, int to, NodeAccess nodeAccess) {
        double fromLat = nodeAccess.getLat(from);
        double fromLon = nodeAccess.getLon(from);
        double toLat = nodeAccess.getLat(to);
        double toLon = nodeAccess.getLon(to);
        return DistancePlaneProjection.DIST_PLANE.calcDist(fromLat, fromLon, toLat, toLon);
    }

    public static void addRandomTurnCosts(Graph graph, long seed, BooleanEncodedValue accessEnc, DecimalEncodedValue turnCostEnc, int maxTurnCost, TurnCostStorage turnCostStorage) {
        Random random = new Random(seed);
        double pNodeHasTurnCosts = 0.3;
        double pEdgePairHasTurnCosts = 0.6;
        double pCostIsRestriction = 0.1;
        EdgeExplorer inExplorer = graph.createEdgeExplorer(accessEnc == null ? edge -> true : AccessFilter.inEdges(accessEnc));
        EdgeExplorer outExplorer = graph.createEdgeExplorer(accessEnc == null ? edge -> true : AccessFilter.outEdges(accessEnc));
        for (int node = 0; node < graph.getNodes(); ++node) {
            if (!(random.nextDouble() < pNodeHasTurnCosts)) continue;
            EdgeIterator inIter = inExplorer.setBaseNode(node);
            while (inIter.next()) {
                EdgeIterator outIter = outExplorer.setBaseNode(node);
                while (outIter.next()) {
                    if (inIter.getEdge() == outIter.getEdge() || !(random.nextDouble() < pEdgePairHasTurnCosts)) continue;
                    double cost = random.nextDouble() < pCostIsRestriction ? Double.POSITIVE_INFINITY : random.nextDouble() * (double)maxTurnCost;
                    turnCostStorage.set(turnCostEnc, inIter.getEdge(), node, outIter.getEdge(), cost);
                }
            }
        }
    }

    public static List<Snap> createRandomSnaps(BBox bbox, LocationIndex locationIndex, Random rnd, int numPoints, boolean acceptTower, EdgeFilter filter) {
        int maxTries = numPoints * 100;
        int tries = 0;
        ArrayList<Snap> snaps = new ArrayList<Snap>(numPoints);
        while (snaps.size() < numPoints) {
            if (tries > maxTries) {
                throw new IllegalArgumentException("Could not create " + numPoints + " random points. tries: " + tries + ", maxTries: " + maxTries);
            }
            Snap snap = GHUtility.getRandomSnap(locationIndex, rnd, bbox, filter);
            boolean accepted = snap.isValid();
            if (!acceptTower) {
                boolean bl = accepted = accepted && !snap.getSnappedPosition().equals((Object)Snap.Position.TOWER);
            }
            if (accepted) {
                snaps.add(snap);
            }
            ++tries;
        }
        return snaps;
    }

    public static Snap getRandomSnap(LocationIndex locationIndex, Random rnd, BBox bbox, EdgeFilter filter) {
        return locationIndex.findClosest(GHUtility.randomDoubleInRange(rnd, bbox.minLat, bbox.maxLat), GHUtility.randomDoubleInRange(rnd, bbox.minLon, bbox.maxLon), filter);
    }

    public static double randomDoubleInRange(Random rnd, double min, double max) {
        return min + rnd.nextDouble() * (max - min);
    }

    public static int getAdjNode(Graph g, int edge, int adjNode) {
        if (EdgeIterator.Edge.isValid(edge)) {
            EdgeIteratorState iterTo = g.getEdgeIteratorState(edge, adjNode);
            return iterTo.getAdjNode();
        }
        return adjNode;
    }

    public static void checkDAVersion(String name, int expectedVersion, int version) {
        if (version != expectedVersion) {
            throw new IllegalStateException("Unexpected version for '" + name + "'. Got: " + version + ", expected: " + expectedVersion + ". Make sure you are using the same GraphHopper version for reading the files that was used for creating them. See https://discuss.graphhopper.com/t/722");
        }
    }

    public static EdgeIteratorState getEdge(Graph graph, int base, int adj) {
        EdgeExplorer explorer = graph.createEdgeExplorer();
        int count = GHUtility.count(explorer.setBaseNode(base), adj);
        if (count > 1) {
            throw new IllegalArgumentException("There are multiple edges between nodes " + base + " and " + adj);
        }
        if (count == 0) {
            return null;
        }
        EdgeIterator iter = explorer.setBaseNode(base);
        while (iter.next()) {
            if (iter.getAdjNode() != adj) continue;
            return iter;
        }
        throw new IllegalStateException("There should be an edge");
    }

    public static int count(EdgeIterator iterator, int adj) {
        int count = 0;
        while (iterator.next()) {
            if (iterator.getAdjNode() != adj) continue;
            ++count;
        }
        return count;
    }

    public static int createEdgeKey(int edgeId, boolean reverse) {
        return (edgeId << 1) + (reverse ? 1 : 0);
    }

    public static int reverseEdgeKey(int edgeKey) {
        return edgeKey % 2 == 0 ? edgeKey + 1 : edgeKey - 1;
    }

    public static int getEdgeFromEdgeKey(int edgeKey) {
        return edgeKey / 2;
    }

    public static int getCommonNode(BaseGraph baseGraph, int edge1, int edge2) {
        EdgeIteratorState e1 = baseGraph.getEdgeIteratorState(edge1, Integer.MIN_VALUE);
        EdgeIteratorState e2 = baseGraph.getEdgeIteratorState(edge2, Integer.MIN_VALUE);
        if (e1.getBaseNode() == e1.getAdjNode()) {
            throw new IllegalArgumentException("edge1: " + edge1 + " is a loop at node " + e1.getBaseNode());
        }
        if (e2.getBaseNode() == e2.getAdjNode()) {
            throw new IllegalArgumentException("edge2: " + edge2 + " is a loop at node " + e2.getBaseNode());
        }
        if (e1.getBaseNode() == e2.getBaseNode() && e1.getAdjNode() == e2.getAdjNode() || e1.getBaseNode() == e2.getAdjNode() && e1.getAdjNode() == e2.getBaseNode()) {
            throw new IllegalArgumentException("edge1: " + edge1 + " and edge2: " + edge2 + " form a circle");
        }
        if (e1.getBaseNode() == e2.getBaseNode() || e1.getBaseNode() == e2.getAdjNode()) {
            return e1.getBaseNode();
        }
        if (e1.getAdjNode() == e2.getAdjNode() || e1.getAdjNode() == e2.getBaseNode()) {
            return e1.getAdjNode();
        }
        throw new IllegalArgumentException("edge1: " + edge1 + " and edge2: " + edge2 + " aren't connected");
    }

    public static void setSpeed(double fwdSpeed, double bwdSpeed, BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, EdgeIteratorState ... edges) {
        GHUtility.setSpeed(fwdSpeed, bwdSpeed, accessEnc, speedEnc, Arrays.asList(edges));
    }

    public static void setSpeed(double fwdSpeed, double bwdSpeed, BooleanEncodedValue accessEnc, DecimalEncodedValue speedEnc, Collection<EdgeIteratorState> edges) {
        if (fwdSpeed < 0.0 || bwdSpeed < 0.0) {
            throw new IllegalArgumentException("Speed must be positive but wasn't! fwdSpeed:" + fwdSpeed + ", bwdSpeed:" + bwdSpeed);
        }
        for (EdgeIteratorState edge : edges) {
            edge.set(speedEnc, fwdSpeed);
            if (fwdSpeed > 0.0) {
                edge.set(accessEnc, true);
            }
            if (bwdSpeed > 0.0 && (fwdSpeed != bwdSpeed || speedEnc.isStoreTwoDirections())) {
                if (!speedEnc.isStoreTwoDirections()) {
                    throw new IllegalArgumentException("EncodedValue " + speedEnc.getName() + " supports only one direction but two different speeds were specified " + fwdSpeed + " " + bwdSpeed);
                }
                edge.setReverse(speedEnc, bwdSpeed);
            }
            if (!(bwdSpeed > 0.0)) continue;
            edge.setReverse(accessEnc, true);
        }
    }

    public static EdgeIteratorState setSpeed(double averageSpeed, boolean fwd, boolean bwd, BooleanEncodedValue accessEnc, DecimalEncodedValue avSpeedEnc, EdgeIteratorState edge) {
        if (averageSpeed < 1.0E-4 && (fwd || bwd)) {
            throw new IllegalStateException("Zero speed is only allowed if edge will get inaccessible. Otherwise Weighting can produce inconsistent results");
        }
        edge.set(accessEnc, fwd, bwd);
        if (fwd) {
            edge.set(avSpeedEnc, averageSpeed);
        }
        if (bwd && avSpeedEnc.isStoreTwoDirections()) {
            edge.setReverse(avSpeedEnc, averageSpeed);
        }
        return edge;
    }

    public static void updateDistancesFor(Graph g, int node, double ... latlonele) {
        NodeAccess na = g.getNodeAccess();
        if (latlonele.length == 3) {
            na.setNode(node, latlonele[0], latlonele[1], latlonele[2]);
        } else if (latlonele.length == 2) {
            if (na.is3D()) {
                throw new IllegalArgumentException("graph requires elevation");
            }
            na.setNode(node, latlonele[0], latlonele[1]);
        } else {
            throw new IllegalArgumentException("illegal number of arguments " + latlonele.length);
        }
        EdgeIterator iter = g.createEdgeExplorer().setBaseNode(node);
        while (iter.next()) {
            iter.setDistance(DistanceCalcEarth.DIST_EARTH.calcDistance(iter.fetchWayGeometry(FetchMode.ALL)));
        }
    }

    public static double calcWeightWithTurnWeight(Weighting weighting, EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        double edgeWeight = weighting.calcEdgeWeight(edgeState, reverse);
        if (!EdgeIterator.Edge.isValid(prevOrNextEdgeId)) {
            return edgeWeight;
        }
        double turnWeight = reverse ? weighting.calcTurnWeight(edgeState.getEdge(), edgeState.getBaseNode(), prevOrNextEdgeId) : weighting.calcTurnWeight(prevOrNextEdgeId, edgeState.getBaseNode(), edgeState.getEdge());
        return edgeWeight + turnWeight;
    }

    public static long calcMillisWithTurnMillis(Weighting weighting, EdgeIteratorState edgeState, boolean reverse, int prevOrNextEdgeId) {
        long turnMillis;
        long edgeMillis = weighting.calcEdgeMillis(edgeState, reverse);
        if (edgeMillis == Long.MAX_VALUE) {
            return edgeMillis;
        }
        if (!EdgeIterator.Edge.isValid(prevOrNextEdgeId)) {
            return edgeMillis;
        }
        int origEdgeId = edgeState.getEdge();
        long l = turnMillis = reverse ? weighting.calcTurnMillis(origEdgeId, edgeState.getBaseNode(), prevOrNextEdgeId) : weighting.calcTurnMillis(prevOrNextEdgeId, edgeState.getBaseNode(), origEdgeId);
        if (turnMillis == Long.MAX_VALUE) {
            return turnMillis;
        }
        return edgeMillis + turnMillis;
    }

    public static List<CustomArea> readCountries() {
        List<CustomArea> list;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JtsModule());
        HashSet<String> enumSet = new HashSet<String>(Country.values().length * 2);
        for (Country c : Country.values()) {
            if (c == Country.MISSING) continue;
            if (c.getStates().isEmpty()) {
                enumSet.add(c.getAlpha2());
                continue;
            }
            for (State s : c.getStates()) {
                enumSet.add(s.getStateCode());
            }
        }
        InputStreamReader reader = new InputStreamReader(GHUtility.class.getResourceAsStream("/com/graphhopper/countries/countries.geojson"), StandardCharsets.UTF_8);
        try {
            JsonFeatureCollection jsonFeatureCollection = (JsonFeatureCollection)objectMapper.readValue((Reader)reader, JsonFeatureCollection.class);
            list = jsonFeatureCollection.getFeatures().stream().filter(customArea -> enumSet.contains(GHUtility.getIdOrPropertiesId(customArea))).map(f -> {
                CustomArea ca = CustomArea.fromJsonFeature(f);
                if (f.getId() == null) {
                    f.setId(GHUtility.getIdOrPropertiesId(f));
                }
                ca.getProperties().put("ISO3166-2", f.getId());
                return ca;
            }).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((Reader)reader).close();
        return list;
    }

    private static String getIdOrPropertiesId(JsonFeature feature) {
        if (feature.getId() != null) {
            return feature.getId();
        }
        if (feature.getProperties() != null) {
            return (String)feature.getProperties().get("id");
        }
        return null;
    }

    public static void runConcurrently(Stream<Runnable> runnables, int threads) {
        ForkJoinPool pool = new ForkJoinPool(threads);
        try {
            ((ForkJoinTask)pool.submit(() -> ((Stream)runnables.parallel()).forEach(Runnable::run))).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            pool.shutdown();
        }
    }

    public static BBox createBBox(EdgeIteratorState edgeState) {
        PointList towerNodes = edgeState.fetchWayGeometry(FetchMode.TOWER_ONLY);
        int secondIndex = towerNodes.size() == 1 ? 0 : 1;
        return BBox.fromPoints(towerNodes.getLat(0), towerNodes.getLon(0), towerNodes.getLat(secondIndex), towerNodes.getLon(secondIndex));
    }

    public static JsonFeature createCircle(String id, double centerLat, double centerLon, double radius) {
        int n = 36;
        double delta = 10.0;
        Coordinate[] coordinates = (Coordinate[])IntStream.range(0, 37).mapToObj(i -> DistanceCalcEarth.DIST_EARTH.projectCoordinate(centerLat, centerLon, radius, (double)i * 10.0 % 360.0)).map(p -> new Coordinate(p.lon, p.lat)).toArray(Coordinate[]::new);
        Polygon polygon = new GeometryFactory().createPolygon(coordinates);
        JsonFeature result = new JsonFeature();
        result.setId(id);
        result.setGeometry((Geometry)polygon);
        return result;
    }

    public static JsonFeature createRectangle(String id, double minLat, double minLon, double maxLat, double maxLon) {
        Coordinate[] coordinates = new Coordinate[]{new Coordinate(minLon, minLat), new Coordinate(minLon, maxLat), new Coordinate(maxLon, maxLat), new Coordinate(maxLon, minLat), new Coordinate(minLon, minLat)};
        Polygon polygon = new GeometryFactory().createPolygon(coordinates);
        JsonFeature result = new JsonFeature();
        result.setId(id);
        result.setGeometry((Geometry)polygon);
        return result;
    }

    public static List<String> comparePaths(Path refPath, Path path, int source, int target, long seed) {
        IntIndexedContainer pathNodes;
        IntIndexedContainer refNodes;
        double weight;
        ArrayList<String> strictViolations = new ArrayList<String>();
        double refWeight = refPath.getWeight();
        if (Math.abs(refWeight - (weight = path.getWeight())) > 0.01) {
            LOGGER.warn("expected: " + String.valueOf(refPath.calcNodes()));
            LOGGER.warn("given:    " + String.valueOf(path.calcNodes()));
            LOGGER.warn("seed: " + seed);
            GHUtility.fail("wrong weight: " + source + "->" + target + "\nexpected: " + refWeight + "\ngiven:    " + weight + "\nseed: " + seed);
        }
        if (Math.abs(path.getDistance() - refPath.getDistance()) > 0.1) {
            strictViolations.add("wrong distance " + source + "->" + target + ", expected: " + refPath.getDistance() + ", given: " + path.getDistance());
        }
        if (Math.abs(path.getTime() - refPath.getTime()) > 50L) {
            strictViolations.add("wrong time " + source + "->" + target + ", expected: " + refPath.getTime() + ", given: " + path.getTime());
        }
        if (!(refNodes = refPath.calcNodes()).equals((Object)(pathNodes = path.calcNodes()))) {
            if (path.getGraph() != refPath.getGraph()) {
                GHUtility.fail("path and refPath graphs are different");
            }
            if (!GHUtility.pathsEqualExceptOneEdge(path.getGraph(), refNodes, pathNodes)) {
                strictViolations.add("wrong nodes " + source + "->" + target + "\nexpected: " + String.valueOf(refNodes) + "\ngiven:    " + String.valueOf(pathNodes));
            }
        }
        return strictViolations;
    }

    private static boolean pathsEqualExceptOneEdge(Graph graph, IntIndexedContainer p1, IntIndexedContainer p2) {
        double distAC;
        IntIndexedContainer longerPath;
        if (p1.equals((Object)p2)) {
            throw new IllegalArgumentException("paths are equal");
        }
        if (Math.abs(p1.size() - p2.size()) != 1) {
            return false;
        }
        IntIndexedContainer shorterPath = p1.size() < p2.size() ? p1 : p2;
        IntIndexedContainer intIndexedContainer = longerPath = p1.size() < p2.size() ? p2 : p1;
        if (shorterPath.size() < 2) {
            return false;
        }
        IntArrayList indicesWithDifferentNodes = new IntArrayList();
        for (int i = 1; i < shorterPath.size(); ++i) {
            if (shorterPath.get(i - indicesWithDifferentNodes.size()) == longerPath.get(i)) continue;
            indicesWithDifferentNodes.add(i);
        }
        if (indicesWithDifferentNodes.size() != 1) {
            return false;
        }
        int b = indicesWithDifferentNodes.get(0);
        int a = b - 1;
        int c = b + 1;
        assert (shorterPath.get(a) == longerPath.get(a));
        assert (shorterPath.get(b) != longerPath.get(b));
        if (shorterPath.get(b) != longerPath.get(c)) {
            return false;
        }
        double distABC = GHUtility.getMinDist(graph, longerPath.get(a), longerPath.get(b)) + GHUtility.getMinDist(graph, longerPath.get(b), longerPath.get(c));
        if (Math.abs(distABC - (distAC = GHUtility.getMinDist(graph, shorterPath.get(a), longerPath.get(c)))) > 0.1) {
            return false;
        }
        LOGGER.info("Distance " + shorterPath.get(a) + "-" + longerPath.get(c) + " is the same as distance " + longerPath.get(a) + "-" + longerPath.get(b) + "-" + longerPath.get(c) + " -> there are multiple possibilities for shortest paths");
        return true;
    }

    private static double getMinDist(Graph graph, int p, int q) {
        EdgeExplorer explorer = graph.createEdgeExplorer();
        EdgeIterator iter = explorer.setBaseNode(p);
        double distance = Double.MAX_VALUE;
        while (iter.next()) {
            if (iter.getAdjNode() != q) continue;
            distance = Math.min(distance, iter.getDistance());
        }
        return distance;
    }

    private static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static CustomModel loadCustomModelFromJar(String name) {
        try {
            InputStream is = GHUtility.class.getResourceAsStream("/com/graphhopper/custom_models/" + name);
            if (is == null) {
                throw new IllegalArgumentException("There is no built-in custom model '" + name + "'");
            }
            String json = Helper.readJSONFileWithoutComments((InputStreamReader)new InputStreamReader(is));
            ObjectMapper objectMapper = Jackson.newObjectMapper();
            return (CustomModel)objectMapper.readValue(json, CustomModel.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load built-in custom model '" + name + "'", e);
        }
    }
}

