/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.util.details;

import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.weighting.custom.CustomWeightingHelper;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.details.AbstractPathDetailsBuilder;

public class ChangeAngleDetails
extends AbstractPathDetailsBuilder {
    private final DecimalEncodedValue orientationEv;
    private Double prevAzimuth;
    private Double changeAngle;

    public ChangeAngleDetails(DecimalEncodedValue orientationEv) {
        super("change_angle");
        this.orientationEv = orientationEv;
    }

    @Override
    protected Object getCurrentValue() {
        return this.changeAngle;
    }

    @Override
    public boolean isEdgeDifferentToLastEdge(EdgeIteratorState edge) {
        if (this.prevAzimuth != null) {
            double azimuth = edge.getReverse(this.orientationEv);
            double tmp = CustomWeightingHelper.calcChangeAngle(this.prevAzimuth, azimuth);
            double tmpRound = Math.round(tmp);
            if (this.changeAngle == null || Math.abs(tmpRound - this.changeAngle) > 0.0) {
                this.prevAzimuth = edge.get(this.orientationEv);
                this.changeAngle = tmpRound;
                return true;
            }
        }
        this.prevAzimuth = edge.get(this.orientationEv);
        return this.changeAngle == null;
    }
}

