/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.example;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.json.Statement;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Arrays;

public class HeadingExample {
    public static void main(String[] args) {
        String relDir = args.length == 1 ? args[0] : "";
        GraphHopper hopper = HeadingExample.createGraphHopperInstance(relDir + "core/files/andorra.osm.pbf");
        HeadingExample.without_heading(hopper);
        HeadingExample.with_heading_start(hopper);
        HeadingExample.with_heading_start_stop(hopper);
        HeadingExample.with_heading_stop(hopper);
        HeadingExample.with_heading_start_stop_lower_penalty(hopper);
    }

    static GraphHopper createGraphHopperInstance(String ghLoc) {
        GraphHopper hopper = new GraphHopper();
        hopper.setOSMFile(ghLoc);
        hopper.setGraphHopperLocation("target/heading-graph-cache");
        hopper.setEncodedValuesString("car_access, road_access, car_average_speed");
        hopper.setProfiles(new Profile[]{new Profile("car").setCustomModel(new CustomModel().addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"car_average_speed")).addToPriority(Statement.If((String)"!car_access", (Statement.Op)Statement.Op.MULTIPLY, (String)"0")))});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        hopper.importOrLoad();
        return hopper;
    }

    static void without_heading(GraphHopper hopper) {
        GHRequest request = new GHRequest(new GHPoint(42.566757, 1.597751), new GHPoint(42.567396, 1.597807)).setProfile("car");
        GHResponse response = hopper.route(request);
        if (response.hasErrors()) {
            throw new RuntimeException(response.getErrors().toString());
        }
        assert (Math.round(response.getBest().getDistance()) == 84L);
    }

    static void with_heading_start(GraphHopper hopper) {
        GHRequest request = new GHRequest(new GHPoint(42.566757, 1.597751), new GHPoint(42.567396, 1.597807)).setHeadings(Arrays.asList(270.0)).putHint("ch.disable", (Object)true).setProfile("car");
        GHResponse response = hopper.route(request);
        if (response.hasErrors()) {
            throw new RuntimeException(response.getErrors().toString());
        }
        assert (Math.round(response.getBest().getDistance()) == 264L);
    }

    static void with_heading_start_stop(GraphHopper hopper) {
        GHRequest request = new GHRequest(new GHPoint(42.566757, 1.597751), new GHPoint(42.567396, 1.597807)).setHeadings(Arrays.asList(270.0, 180.0)).putHint("ch.disable", (Object)true).setProfile("car");
        GHResponse response = hopper.route(request);
        if (response.hasErrors()) {
            throw new RuntimeException(response.getErrors().toString());
        }
        assert (Math.round(response.getBest().getDistance()) == 434L);
    }

    static void with_heading_stop(GraphHopper hopper) {
        GHRequest request = new GHRequest(new GHPoint(42.566757, 1.597751), new GHPoint(42.567396, 1.597807)).setHeadings(Arrays.asList(Double.NaN, 180.0)).putHint("ch.disable", (Object)true).setProfile("car");
        GHResponse response = hopper.route(request);
        if (response.hasErrors()) {
            throw new RuntimeException(response.getErrors().toString());
        }
        assert (Math.round(response.getBest().getDistance()) == 201L);
    }

    static void with_heading_start_stop_lower_penalty(GraphHopper hopper) {
        GHRequest request = new GHRequest(new GHPoint(42.566757, 1.597751), new GHPoint(42.567396, 1.597807)).setHeadings(Arrays.asList(270.0, 180.0)).putHint("heading_penalty", (Object)10).putHint("ch.disable", (Object)true).setProfile("car");
        GHResponse response = hopper.route(request);
        if (response.hasErrors()) {
            throw new RuntimeException(response.getErrors().toString());
        }
        assert (Math.round(response.getBest().getDistance()) == 84L);
    }
}

