/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.example;

import com.graphhopper.GraphHopper;
import com.graphhopper.config.Profile;
import com.graphhopper.isochrone.algorithm.ShortestPathTree;
import com.graphhopper.routing.ev.Subnetwork;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.DefaultSnapFilter;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.PMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IsochroneExample {
    public static void main(String[] args) {
        String relDir = args.length == 1 ? args[0] : "";
        GraphHopper hopper = IsochroneExample.createGraphHopperInstance(relDir + "core/files/andorra.osm.pbf");
        EncodingManager encodingManager = hopper.getEncodingManager();
        Weighting weighting = hopper.createWeighting(hopper.getProfile("car"), new PMap());
        Snap snap = hopper.getLocationIndex().findClosest(42.508679, 1.532078, (EdgeFilter)new DefaultSnapFilter(weighting, encodingManager.getBooleanEncodedValue(Subnetwork.key((String)"car"))));
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)hopper.getBaseGraph(), (Snap)snap);
        ShortestPathTree tree = new ShortestPathTree((Graph)queryGraph, weighting, false, TraversalMode.NODE_BASED);
        tree.setTimeLimit(120000.0);
        AtomicInteger counter = new AtomicInteger(0);
        tree.search(snap.getClosestNode(), label -> counter.incrementAndGet());
        assert (counter.get() > 200);
    }

    static GraphHopper createGraphHopperInstance(String ghLoc) {
        GraphHopper hopper = new GraphHopper();
        hopper.setOSMFile(ghLoc);
        hopper.setGraphHopperLocation("target/isochrone-graph-cache");
        hopper.setProfiles(new Profile[]{new Profile("car").setCustomModel(GHUtility.loadCustomModelFromJar((String)"car.json"))});
        hopper.importOrLoad();
        return hopper;
    }
}

