/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.example;

import com.graphhopper.json.Statement;
import com.graphhopper.routing.Dijkstra;
import com.graphhopper.routing.EdgeToEdgeRoutingAlgorithm;
import com.graphhopper.routing.Path;
import com.graphhopper.routing.ch.CHRoutingAlgorithmFactory;
import com.graphhopper.routing.ch.PrepareContractionHierarchies;
import com.graphhopper.routing.ev.BooleanEncodedValue;
import com.graphhopper.routing.ev.DecimalEncodedValue;
import com.graphhopper.routing.ev.EncodedValue;
import com.graphhopper.routing.ev.EncodedValueLookup;
import com.graphhopper.routing.ev.VehicleAccess;
import com.graphhopper.routing.ev.VehicleSpeed;
import com.graphhopper.routing.querygraph.QueryGraph;
import com.graphhopper.routing.util.EdgeFilter;
import com.graphhopper.routing.util.EncodingManager;
import com.graphhopper.routing.util.TraversalMode;
import com.graphhopper.routing.weighting.TurnCostProvider;
import com.graphhopper.routing.weighting.Weighting;
import com.graphhopper.routing.weighting.custom.CustomModelParser;
import com.graphhopper.routing.weighting.custom.CustomWeighting;
import com.graphhopper.storage.BaseGraph;
import com.graphhopper.storage.CHConfig;
import com.graphhopper.storage.CHStorage;
import com.graphhopper.storage.Directory;
import com.graphhopper.storage.Graph;
import com.graphhopper.storage.NodeAccess;
import com.graphhopper.storage.RAMDirectory;
import com.graphhopper.storage.RoutingCHGraph;
import com.graphhopper.storage.RoutingCHGraphImpl;
import com.graphhopper.storage.index.LocationIndexTree;
import com.graphhopper.storage.index.Snap;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.EdgeIteratorState;
import com.graphhopper.util.Helper;
import com.graphhopper.util.PMap;

public class LowLevelAPIExample {
    private static final String graphLocation = "target/lowlevel-graph";

    public static void main(String[] args) {
        LowLevelAPIExample.createAndSaveGraph();
        LowLevelAPIExample.useContractionHierarchiesToMakeQueriesFaster();
    }

    public static void createAndSaveGraph() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)7, (double)2.0, (boolean)false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).setDir((Directory)new RAMDirectory(graphLocation, true)).create();
        EdgeIteratorState edge = graph.edge(0, 1).setDistance(1234.0).set(speedEnc, 50.0);
        NodeAccess na = graph.getNodeAccess();
        graph.edge(0, 1).set(accessEnc, true).set(speedEnc, 10.0).setDistance(1530.0);
        na.setNode(0, 15.15, 20.2);
        na.setNode(1, 15.25, 20.21);
        LocationIndexTree index = new LocationIndexTree((Graph)graph, graph.getDirectory());
        index.prepareIndex();
        graph.flush();
        index.flush();
        graph.close();
        index.close();
        accessEnc = VehicleAccess.create((String)"car");
        speedEnc = VehicleSpeed.create((String)"car", (int)7, (double)2.0, (boolean)false);
        em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        graph = new BaseGraph.Builder(em).setDir((Directory)new RAMDirectory(graphLocation, true)).build();
        graph.loadExisting();
        LocationIndexTree index2 = new LocationIndexTree((Graph)graph.getBaseGraph(), graph.getDirectory());
        if (!index2.loadExisting()) {
            throw new IllegalStateException("location index cannot be loaded!");
        }
        Snap fromSnap = index2.findClosest(15.15, 20.2, EdgeFilter.ALL_EDGES);
        Snap toSnap = index2.findClosest(15.25, 20.21, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)graph, (Snap)fromSnap, (Snap)toSnap);
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)new CustomModel().addToPriority(Statement.If((String)("!" + accessEnc.getName()), (Statement.Op)Statement.Op.MULTIPLY, (String)"0")).addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)speedEnc.getName())));
        Path path = new Dijkstra((Graph)queryGraph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(fromSnap.getClosestNode(), toSnap.getClosestNode());
        assert (Helper.round((double)path.getDistance(), (int)-2) == 1500.0);
        path = new Dijkstra((Graph)graph, (Weighting)weighting, TraversalMode.NODE_BASED).calcPath(0, 1);
        assert (Helper.round((double)path.getDistance(), (int)-2) == 1500.0);
    }

    public static void useContractionHierarchiesToMakeQueriesFaster() {
        BooleanEncodedValue accessEnc = VehicleAccess.create((String)"car");
        DecimalEncodedValue speedEnc = VehicleSpeed.create((String)"car", (int)7, (double)2.0, (boolean)false);
        EncodingManager em = EncodingManager.start().add((EncodedValue)accessEnc).add((EncodedValue)speedEnc).build();
        BaseGraph graph = new BaseGraph.Builder(em).setDir((Directory)new RAMDirectory(graphLocation, true)).create();
        graph.flush();
        CustomWeighting weighting = CustomModelParser.createWeighting((EncodedValueLookup)em, (TurnCostProvider)TurnCostProvider.NO_TURN_COST_PROVIDER, (CustomModel)new CustomModel().addToPriority(Statement.If((String)("!" + accessEnc.getName()), (Statement.Op)Statement.Op.MULTIPLY, (String)"0")).addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)speedEnc.getName())));
        CHConfig chConfig = CHConfig.nodeBased((String)"my_profile", (Weighting)weighting);
        NodeAccess na = graph.getNodeAccess();
        graph.edge(0, 1).set(accessEnc, true).set(speedEnc, 10.0).setDistance(1020.0);
        na.setNode(0, 15.15, 20.2);
        na.setNode(1, 15.25, 20.21);
        graph.freeze();
        PrepareContractionHierarchies pch = PrepareContractionHierarchies.fromGraph((BaseGraph)graph, (CHConfig)chConfig);
        PrepareContractionHierarchies.Result pchRes = pch.doWork();
        RoutingCHGraph chGraph = RoutingCHGraphImpl.fromGraph((BaseGraph)graph, (CHStorage)pchRes.getCHStorage(), (CHConfig)pchRes.getCHConfig());
        LocationIndexTree index = new LocationIndexTree((Graph)graph, graph.getDirectory());
        index.prepareIndex();
        Snap fromSnap = index.findClosest(15.15, 20.2, EdgeFilter.ALL_EDGES);
        Snap toSnap = index.findClosest(15.25, 20.21, EdgeFilter.ALL_EDGES);
        QueryGraph queryGraph = QueryGraph.create((BaseGraph)graph, (Snap)fromSnap, (Snap)toSnap);
        EdgeToEdgeRoutingAlgorithm algo = new CHRoutingAlgorithmFactory(chGraph, queryGraph).createAlgo(new PMap());
        Path path = algo.calcPath(fromSnap.getClosestNode(), toSnap.getClosestNode());
        assert (Helper.round((double)path.getDistance(), (int)-2) == 1000.0);
    }
}

