/*
 * Decompiled with CFR 0.152.
 */
package com.graphhopper.example;

import com.graphhopper.GHRequest;
import com.graphhopper.GHResponse;
import com.graphhopper.GraphHopper;
import com.graphhopper.ResponsePath;
import com.graphhopper.config.CHProfile;
import com.graphhopper.config.LMProfile;
import com.graphhopper.config.Profile;
import com.graphhopper.json.Statement;
import com.graphhopper.util.CustomModel;
import com.graphhopper.util.GHUtility;
import com.graphhopper.util.Helper;
import com.graphhopper.util.Instruction;
import com.graphhopper.util.InstructionList;
import com.graphhopper.util.PointList;
import com.graphhopper.util.Translation;
import com.graphhopper.util.shapes.GHPoint;
import java.util.Locale;

public class RoutingExample {
    public static void main(String[] args) {
        String relDir = args.length == 1 ? args[0] : "";
        GraphHopper hopper = RoutingExample.createGraphHopperInstance(relDir + "core/files/andorra.osm.pbf");
        RoutingExample.routing(hopper);
        RoutingExample.speedModeVersusFlexibleMode(hopper);
        RoutingExample.alternativeRoute(hopper);
        RoutingExample.customizableRouting(relDir + "core/files/andorra.osm.pbf");
        hopper.close();
    }

    static GraphHopper createGraphHopperInstance(String ghLoc) {
        GraphHopper hopper = new GraphHopper();
        hopper.setOSMFile(ghLoc);
        hopper.setGraphHopperLocation("target/routing-graph-cache");
        hopper.setEncodedValuesString("car_access, car_average_speed, road_access");
        hopper.setProfiles(new Profile[]{new Profile("car").setCustomModel(GHUtility.loadCustomModelFromJar((String)"car.json"))});
        hopper.getCHPreparationHandler().setCHProfiles(new CHProfile[]{new CHProfile("car")});
        hopper.importOrLoad();
        return hopper;
    }

    public static void routing(GraphHopper hopper) {
        GHRequest req = new GHRequest(42.508552, 1.532936, 42.507508, 1.528773).setProfile("car").setLocale(Locale.US);
        GHResponse rsp = hopper.route(req);
        if (rsp.hasErrors()) {
            throw new RuntimeException(rsp.getErrors().toString());
        }
        ResponsePath path = rsp.getBest();
        PointList pointList = path.getPoints();
        double distance = path.getDistance();
        long timeInMs = path.getTime();
        Translation tr = hopper.getTranslationMap().getWithFallBack(Locale.UK);
        InstructionList il = path.getInstructions();
        for (Instruction instruction : il) {
        }
        assert (il.size() == 6);
        assert (Helper.round((double)path.getDistance(), (int)-2) == 600.0);
    }

    public static void speedModeVersusFlexibleMode(GraphHopper hopper) {
        GHRequest req = new GHRequest(42.508552, 1.532936, 42.507508, 1.528773).setProfile("car").setAlgorithm("astarbi").putHint("ch.disable", (Object)true);
        GHResponse res = hopper.route(req);
        if (res.hasErrors()) {
            throw new RuntimeException(res.getErrors().toString());
        }
        assert (Helper.round((double)res.getBest().getDistance(), (int)-2) == 600.0);
    }

    public static void alternativeRoute(GraphHopper hopper) {
        GHRequest req = new GHRequest().setProfile("car").addPoint(new GHPoint(42.506701, 1.521668)).addPoint(new GHPoint(42.509533, 1.540185)).setAlgorithm("alternative_route");
        req.getHints().putObject("alternative_route.max_paths", (Object)3);
        GHResponse res = hopper.route(req);
        if (res.hasErrors()) {
            throw new RuntimeException(res.getErrors().toString());
        }
        assert (res.getAll().size() == 2);
        assert (Helper.round((double)res.getBest().getDistance(), (int)-2) == 1800.0);
    }

    public static void customizableRouting(String ghLoc) {
        GraphHopper hopper = new GraphHopper();
        hopper.setOSMFile(ghLoc);
        hopper.setGraphHopperLocation("target/routing-custom-graph-cache");
        hopper.setEncodedValuesString("car_access, car_average_speed, road_access");
        hopper.setProfiles(new Profile[]{new Profile("car_custom").setCustomModel(GHUtility.loadCustomModelFromJar((String)"car.json"))});
        hopper.getLMPreparationHandler().setLMProfiles(new LMProfile[]{new LMProfile("car_custom")});
        hopper.importOrLoad();
        GHRequest req = new GHRequest().setProfile("car_custom").addPoint(new GHPoint(42.506472, 1.522475)).addPoint(new GHPoint(42.513108, 1.536005));
        GHResponse res = hopper.route(req);
        if (res.hasErrors()) {
            throw new RuntimeException(res.getErrors().toString());
        }
        assert (Math.round((double)res.getBest().getTime() / 1000.0) == 94L);
        CustomModel model = new CustomModel();
        model.addToPriority(Statement.If((String)"road_class == SECONDARY", (Statement.Op)Statement.Op.MULTIPLY, (String)"0.5"));
        model.addToSpeed(Statement.If((String)"true", (Statement.Op)Statement.Op.LIMIT, (String)"30"));
        req.setCustomModel(model);
        res = hopper.route(req);
        if (res.hasErrors()) {
            throw new RuntimeException(res.getErrors().toString());
        }
        assert (Math.round((double)res.getBest().getTime() / 1000.0) == 184L);
    }
}

